/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.util.converter.PaddingStringConverter;

public class FLVReader
extends LineNumberReader {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected String encoding;
    protected int[] fieldLength;
    protected PaddingStringConverter[] converters;
    protected boolean isIgnoreEmptyLine;
    protected String commentPrefix;
    protected FLVIterator iterator;
    protected ReaderWrapper readerWrapper;
    static /* synthetic */ Class class$java$nio$CharBuffer;
    static /* synthetic */ Class class$java$io$Reader;

    public FLVReader() {
        this(new ReaderWrapper());
    }

    public FLVReader(int[] fieldLen) {
        this(fieldLen, null);
    }

    public FLVReader(int[] fieldLen, String encoding) {
        this((Reader)new ReaderWrapper(), fieldLen, encoding);
    }

    public FLVReader(int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        this((Reader)new ReaderWrapper(), fieldLen, convs, encoding);
    }

    public FLVReader(Reader reader) {
        this(reader, null);
    }

    public FLVReader(Reader reader, int[] fieldLen) {
        this(reader, fieldLen, null);
    }

    public FLVReader(Reader reader, int[] fieldLen, String encoding) {
        this(reader, fieldLen, null, encoding);
    }

    public FLVReader(Reader reader, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(reader instanceof ReaderWrapper ? reader : new ReaderWrapper(reader));
        this.readerWrapper = (ReaderWrapper)this.lock;
        this.fieldLength = fieldLen;
        this.converters = convs;
        this.encoding = encoding;
    }

    public FLVReader(int size) {
        this(size, null);
    }

    public FLVReader(int size, int[] fieldLen) {
        this(size, fieldLen, null);
    }

    public FLVReader(int size, int[] fieldLen, String encoding) {
        this(size, fieldLen, null, encoding);
    }

    public FLVReader(int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        this(new ReaderWrapper(), size, fieldLen, convs, encoding);
    }

    public FLVReader(Reader reader, int size) {
        this(reader, size, null);
    }

    public FLVReader(Reader reader, int size, int[] fieldLen) {
        this(reader, size, fieldLen, null);
    }

    public FLVReader(Reader reader, int size, int[] fieldLen, String encoding) {
        this(reader, size, fieldLen, null, encoding);
    }

    public FLVReader(Reader reader, int size, int[] fieldLen, PaddingStringConverter[] convs, String encoding) {
        super(reader instanceof ReaderWrapper ? reader : new ReaderWrapper(reader), size);
        this.readerWrapper = (ReaderWrapper)this.lock;
        this.fieldLength = fieldLen;
        this.converters = convs;
        this.encoding = encoding;
    }

    public void setFieldLength(int[] length) {
        this.fieldLength = length;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldPaddingStringConverter(PaddingStringConverter[] convs) {
        this.converters = convs;
    }

    public PaddingStringConverter[] getFieldPaddingStringConverter() {
        return this.converters;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setReader(Reader reader) {
        this.readerWrapper.setReader(reader);
    }

    public void setIgnoreEmptyLine(boolean isIgnore) {
        this.isIgnoreEmptyLine = isIgnore;
    }

    public boolean isIgnoreEmptyLine() {
        return this.isIgnoreEmptyLine;
    }

    public void setCommentPrefix(String value) {
        this.commentPrefix = value;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public long skipLine(long line) throws IOException {
        int result = 0;
        result = 0;
        while ((long)result < line && super.readLine() != null) {
            ++result;
        }
        return result;
    }

    public long skipFLVLine(long line) throws IOException {
        List flv = null;
        int result = 0;
        result = 0;
        while ((long)result < line && (flv = this.readFLVLineList(flv)) != null) {
            ++result;
        }
        return result;
    }

    public String[] readFLVLine() throws IOException {
        List flv = this.readFLVLineList();
        return flv == null ? null : flv.toArray(new String[flv.size()]);
    }

    public List readFLVLineList() throws IOException {
        return this.readFLVLineList(null);
    }

    public List readFLVLineList(List flv) throws IOException {
        String line = null;
        do {
            if ((line = this.readLine()) == null) {
                if (flv != null) {
                    flv.clear();
                }
                return null;
            }
            if ((!this.isIgnoreEmptyLine || line.length() != 0) && (this.commentPrefix == null || !line.startsWith(this.commentPrefix))) continue;
            line = null;
            this.setLineNumber(this.getLineNumber() - 1);
        } while (line == null);
        if (flv == null) {
            flv = new ArrayList<String>();
        } else {
            flv.clear();
        }
        if (line.length() == 0) {
            return flv;
        }
        byte[] bytes = null;
        bytes = this.encoding == null ? line.getBytes() : line.getBytes(this.encoding);
        int offset = 0;
        for (int i = 0; i < this.fieldLength.length; ++i) {
            if (bytes.length < offset + this.fieldLength[i]) {
                throw new EOFException();
            }
            String element = null;
            element = this.encoding == null ? new String(bytes, offset, this.fieldLength[i]) : new String(bytes, offset, this.fieldLength[i], this.encoding);
            if (this.converters != null && this.converters.length != 0 && this.converters[i] != null) {
                element = this.converters[i].parse(element);
            }
            flv.add(element);
            offset += this.fieldLength[i];
        }
        return flv;
    }

    public String readLine() throws IOException {
        if (this.readerWrapper.getReader() instanceof BufferedReader) {
            return ((BufferedReader)this.readerWrapper.getReader()).readLine();
        }
        return super.readLine();
    }

    public FLVIterator iterator() {
        if (this.iterator == null) {
            this.iterator = new FLVIterator();
        }
        return this.iterator;
    }

    public FLVReader cloneReader() {
        return this.cloneReader(new FLVReader());
    }

    protected FLVReader cloneReader(FLVReader clone) {
        clone.encoding = this.encoding;
        clone.fieldLength = this.fieldLength;
        clone.isIgnoreEmptyLine = this.isIgnoreEmptyLine;
        clone.commentPrefix = this.commentPrefix;
        if (this.converters != null && this.converters.length != 0) {
            clone.converters = new PaddingStringConverter[this.converters.length];
            System.arraycopy(this.converters, 0, clone.converters, 0, this.converters.length);
        }
        return clone;
    }

    private static class ReaderWrapper
    extends Reader {
        private Reader realReader;
        private static Method READ_CHARBUFFER_METHOD = null;

        public ReaderWrapper() {
        }

        public ReaderWrapper(Reader reader) {
            this.realReader = reader;
        }

        public Reader getReader() {
            return this.realReader;
        }

        public void setReader(Reader reader) {
            this.realReader = reader;
        }

        public int read(CharBuffer target) throws IOException {
            if (READ_CHARBUFFER_METHOD == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            if (this.realReader == null) {
                return -1;
            }
            try {
                return (Integer)READ_CHARBUFFER_METHOD.invoke((Object)this.realReader, target);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        public int read() throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read();
        }

        public int read(char[] cbuf) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.realReader == null) {
                return -1;
            }
            return this.realReader.read(cbuf, off, len);
        }

        public long skip(long n) throws IOException {
            if (this.realReader == null) {
                return 0L;
            }
            return this.realReader.skip(n);
        }

        public boolean ready() throws IOException {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.ready();
        }

        public boolean markSupported() {
            if (this.realReader == null) {
                return false;
            }
            return this.realReader.markSupported();
        }

        public void mark(int readAheadLimit) throws IOException {
            if (this.realReader == null) {
                throw new IOException("Reader is null.");
            }
            this.realReader.mark(readAheadLimit);
        }

        public void reset() throws IOException {
            if (this.realReader != null) {
                this.realReader.reset();
            }
        }

        public void close() throws IOException {
            if (this.realReader != null) {
                this.realReader.close();
            }
        }

        static {
            try {
                READ_CHARBUFFER_METHOD = (class$java$io$Reader == null ? (class$java$io$Reader = FLVReader.class$("java.io.Reader")) : class$java$io$Reader).getMethod("read", class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = FLVReader.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public class FLVElements
    extends ArrayList {
        private static final long serialVersionUID = 4888164167750345490L;
        private boolean wasNull;

        private FLVElements() {
        }

        public void clear() {
            this.wasNull = false;
            super.clear();
        }

        public boolean wasNull() {
            return this.wasNull;
        }

        public Object get(int index) {
            Object obj = super.get(index);
            this.wasNull = obj == null;
            return obj;
        }

        public String getString(int index) {
            String str = (String)this.get(index);
            this.wasNull = str == null;
            return str;
        }

        public byte getByte(int index) throws NumberFormatException {
            return this.getByte(index, 10);
        }

        public byte getByte(int index, int radix) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Byte.parseByte(str, radix);
        }

        public short getShort(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Short.parseShort(str);
        }

        public char getChar(int index) {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return '\u0000';
            }
            return str.charAt(0);
        }

        public int getInt(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Integer.parseInt(str);
        }

        public long getLong(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0L;
            }
            return Long.parseLong(str);
        }

        public float getFloat(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0f;
            }
            return Float.parseFloat(str);
        }

        public double getDouble(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0;
            }
            return Double.parseDouble(str);
        }

        public boolean getBoolean(int index) {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return false;
            }
            return Boolean.valueOf(str);
        }

        public BigInteger getBigInteger(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigInteger(str);
        }

        public BigDecimal getBigDecimal(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str != null && str.length() == 0) {
                str = str.trim();
            }
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigDecimal(str);
        }
    }

    public class FLVIterator {
        private boolean hasNext = false;
        private FLVElements elements = new FLVElements();

        private FLVIterator() {
        }

        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return this.hasNext;
            }
            List result = FLVReader.this.readFLVLineList(this.elements);
            this.hasNext = result != null;
            return this.hasNext;
        }

        public Object next() throws IOException {
            return this.nextElements();
        }

        public FLVElements nextElements() throws IOException {
            if (!this.hasNext && !this.hasNext()) {
                return null;
            }
            this.hasNext = false;
            return this.elements;
        }
    }
}

