/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.ossc.nimbus.core.AspectTranslator;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.io.RecurciveSearchFile;

public class Compiler
implements Serializable {
    private static final long serialVersionUID = -7456674395942064160L;
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/service/aop/CompilerUsage.txt";
    private static final String CLASS_EXTEND = ".class";
    private String destPath;
    private boolean isVerbose;

    public Compiler() {
    }

    public Compiler(String dest, boolean verbose) {
        this.destPath = dest;
        this.isVerbose = verbose;
    }

    public void setDestinationDirectory(String dest) {
        this.destPath = dest;
    }

    public String getDestinationDirectory() {
        return this.destPath;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public static void loadServices(List servicePaths) {
        if (servicePaths != null) {
            int max = servicePaths.size();
            for (int i = 0; i < max; ++i) {
                ServiceManagerFactory.loadManager((String)servicePaths.get(i));
            }
            ServiceManagerFactory.checkLoadManagerCompleted();
        }
    }

    public static void unloadServices(List servicePaths) {
        if (servicePaths != null) {
            int i = servicePaths.size();
            while (--i >= 0) {
                ServiceManagerFactory.unloadManager((String)servicePaths.get(i));
            }
        }
    }

    public boolean compile(List classNames) throws IOException {
        Iterator names = classNames.iterator();
        boolean result = true;
        while (names.hasNext()) {
            if (this.compile((String)names.next())) continue;
            result = false;
        }
        return result;
    }

    public boolean compile(String className) throws IOException {
        String[] clazz = this.getClassNames(className);
        if (clazz == null || clazz.length == 0) {
            if (this.isVerbose) {
                System.out.println("Class not found. : " + className);
            }
            return false;
        }
        boolean result = true;
        for (int i = 0; i < clazz.length; ++i) {
            if (this.compileInner(clazz[i])) continue;
            result = false;
        }
        return result;
    }

    private String[] getClassNames(String name) throws IOException {
        if (name.endsWith("*")) {
            List classpaths = Compiler.parsePaths(System.getProperty("java.class.path"));
            if (classpaths.size() == 0) {
                classpaths.add(".");
            }
            HashSet classNames = new HashSet();
            int max = classpaths.size();
            for (int i = 0; i < max; ++i) {
                File file = new File((String)classpaths.get(i));
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    this.getClassNamesFromDir(file, name, classNames);
                    continue;
                }
                this.getClassNamesFromJar(file, name, classNames);
            }
            return classNames.toArray(new String[classNames.size()]);
        }
        return new String[]{name};
    }

    private Set getClassNamesFromDir(File dir, String name, Set classNames) {
        block7: {
            block6: {
                if (!name.endsWith("**")) break block6;
                String packageName = name.substring(0, name.length() - 2);
                RecurciveSearchFile searchDir = new RecurciveSearchFile(dir, packageName.replace('.', '/'));
                File[] classFiles = searchDir.listAllTreeFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(Compiler.CLASS_EXTEND);
                    }
                });
                if (classFiles == null) break block7;
                int dirLength = dir.getAbsolutePath().length();
                for (int i = 0; i < classFiles.length; ++i) {
                    String tmpName = classFiles[i].getAbsolutePath().substring(dirLength);
                    tmpName = tmpName.replace('/', '.');
                    if ((tmpName = tmpName.replace('\\', '.')).charAt(0) == '.') {
                        tmpName = tmpName.substring(1);
                    }
                    tmpName = tmpName.substring(0, tmpName.length() - 6);
                    classNames.add(tmpName);
                }
                break block7;
            }
            String className = name;
            String packageName = null;
            if (name.lastIndexOf(46) != -1) {
                packageName = name.substring(0, name.lastIndexOf(46) + 1);
                className = name.substring(name.lastIndexOf(46) + 1);
            } else {
                packageName = "";
            }
            File searchDir = null;
            searchDir = packageName.length() == 0 ? dir : new File(dir, packageName.replace('.', '/'));
            final String startName = className.length() == 1 ? "" : className.substring(0, className.length() - 1);
            File[] classFiles = searchDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (!name.endsWith(Compiler.CLASS_EXTEND)) {
                        return false;
                    }
                    return name.startsWith(startName);
                }
            });
            if (classFiles != null) {
                for (int i = 0; i < classFiles.length; ++i) {
                    String tmpName = packageName + classFiles[i].getName();
                    tmpName = tmpName.substring(0, tmpName.length() - 6);
                    classNames.add(tmpName);
                }
            }
        }
        return classNames;
    }

    private Set getClassNamesFromJar(File jar, String name, Set classNames) throws IOException {
        if (!jar.exists()) {
            return classNames;
        }
        if (name.endsWith("**")) {
            String packageName = name.substring(0, name.length() - 2);
            String searchDir = packageName.replace('.', '/');
            ZipFile zipFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryName;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(searchDir) || !entryName.endsWith(CLASS_EXTEND)) continue;
                String tmpName = entryName.replace('/', '.');
                tmpName = tmpName.substring(0, tmpName.length() - 6);
                classNames.add(tmpName);
            }
        } else {
            String packageName = null;
            String className = name;
            if (name.lastIndexOf(46) != -1) {
                packageName = name.substring(0, name.lastIndexOf(46) + 1);
                className = name.substring(name.lastIndexOf(46) + 1);
            } else {
                packageName = "";
            }
            String searchDir = packageName.replace('.', '/');
            String startName = className.length() == 1 ? "" : className.substring(0, className.length() - 1);
            ZipFile zipFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int index;
                String entryName;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(searchDir) || entryName.indexOf(47, searchDir.length()) != -1 || !entryName.endsWith(CLASS_EXTEND) || (index = entryName.indexOf(startName, searchDir.length())) == -1) continue;
                String tmpName = packageName + entryName.substring(index);
                tmpName = tmpName.substring(0, tmpName.length() - 6);
                classNames.add(tmpName);
            }
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean compileInner(String className) throws IOException {
        byte[] tmpBytes;
        int i;
        byte[] bytecode;
        ClassLoader loader;
        block20: {
            String classRsrcName;
            if (this.isNonTranslatableClassName(className)) {
                if (!this.isVerbose) return false;
                System.out.println("Non translatable class. : " + className);
                return false;
            }
            loader = Thread.currentThread().getContextClassLoader();
            URL classURL = loader.getResource(classRsrcName = className.replace('.', '/') + CLASS_EXTEND);
            if (classURL == null) {
                if (!this.isVerbose) return false;
                System.out.println("Class not found. : " + className);
                return false;
            }
            bytecode = null;
            InputStream is = null;
            try {
                is = classURL.openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] tmp = new byte[1024];
                int read = 0;
                while ((read = is.read(tmp)) > 0) {
                    baos.write(tmp, 0, read);
                }
                bytecode = baos.toByteArray();
                Object var11_12 = null;
                if (is == null) break block20;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            is.close();
        }
        boolean isTransform = false;
        byte[] transformedBytes = bytecode;
        AspectTranslator[] translators = NimbusClassLoader.getVMAspectTranslators();
        for (i = 0; i < translators.length; ++i) {
            tmpBytes = translators[i].transform(loader, className, null, transformedBytes);
            if (tmpBytes == null) continue;
            isTransform = true;
            transformedBytes = tmpBytes;
        }
        translators = NimbusClassLoader.getInstance().getAspectTranslators();
        for (i = 0; i < translators.length; ++i) {
            tmpBytes = translators[i].transform(loader, className, null, transformedBytes);
            if (tmpBytes == null) continue;
            isTransform = true;
            transformedBytes = tmpBytes;
        }
        if (!isTransform) {
            return true;
        }
        if (this.isVerbose) {
            System.out.println("Compile " + className);
        }
        File destDir = null;
        if (this.destPath != null) {
            String packageName = null;
            if (className.lastIndexOf(46) != -1) {
                packageName = className.substring(0, className.lastIndexOf(46));
            }
            if (packageName != null && !(destDir = new File(this.destPath, packageName.replace('.', '/'))).exists()) {
                destDir.mkdirs();
            }
        }
        File classFile = null;
        classFile = className.lastIndexOf(46) == -1 ? new File(destDir, className + CLASS_EXTEND) : new File(destDir, className.substring(className.lastIndexOf(46) + 1) + CLASS_EXTEND);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(classFile);
            ((OutputStream)os).write(transformedBytes);
            Object var14_19 = null;
            if (os == null) return true;
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (os == null) throw throwable;
            try {
                ((OutputStream)os).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            return true;
        }
        ((OutputStream)os).close();
        return true;
    }

    private static void usage() {
        try {
            System.out.println(Compiler.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = Compiler.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
            Object var7_6 = null;
            if (reader == null) return Compiler.unicodeConvert(buf.toString());
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            reader.close();
            return Compiler.unicodeConvert(buf.toString());
        }
        catch (IOException e) {}
        return Compiler.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\') {
                if ((c = str.charAt(i++)) == 'u') {
                    int value = 0;
                    block12: for (int j = 0; j < 4; ++j) {
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Failed to convert unicode : " + c);
                            }
                        }
                    }
                    buf.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static List parsePaths(String paths) {
        ArrayList<String> result = new ArrayList<String>();
        if (paths == null || paths.length() == 0) {
            return result;
        }
        String separator = System.getProperty("path.separator");
        if (paths.indexOf(separator) == -1) {
            result.add(paths);
            return result;
        }
        String tmpPaths = paths;
        int index = -1;
        while ((index = tmpPaths.indexOf(separator)) != -1) {
            result.add(tmpPaths.substring(0, index));
            if (index != tmpPaths.length() - 1) {
                tmpPaths = tmpPaths.substring(index + separator.length());
                continue;
            }
            tmpPaths = null;
            break;
        }
        if (tmpPaths != null && tmpPaths.length() != 0) {
            result.add(tmpPaths);
        }
        return result;
    }

    protected boolean isNonTranslatableClassName(String classname) {
        return classname.startsWith("javassist.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("com.sun.") || classname.startsWith("jp.ossc.nimbus.service.aop.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 0 && args[0].equals("-help")) {
            Compiler.usage();
            return;
        }
        boolean option = false;
        String key = null;
        String dest = null;
        List servicePaths = null;
        boolean verbose = false;
        ArrayList<String> classNames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (option) {
                if (key.equals("-d")) {
                    dest = args[i];
                } else if (key.equals("-servicepath")) {
                    servicePaths = Compiler.parsePaths(args[i]);
                }
                option = false;
                key = null;
                continue;
            }
            if (args[i].equals("-d")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-servicepath")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            classNames.add(args[i]);
        }
        Compiler compiler = new Compiler(dest, verbose);
        Compiler.loadServices(servicePaths);
        try {
            if (compiler.compile(classNames)) {
                System.out.println("Compile is completed.");
            } else {
                System.out.println("Compile is not completed.");
                if (!verbose) {
                    System.out.println("If you want to know details, specify option v.");
                }
            }
        }
        catch (Throwable throwable) {
            Compiler.unloadServices(servicePaths);
            throw throwable;
        }
        Compiler.unloadServices(servicePaths);
    }
}

