/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.IncompatibleExceptionWrapExeption;
import jp.ossc.nimbus.service.aop.interceptor.IncompatibleExceptionWrapInterceptorServiceMBean;

public class IncompatibleExceptionWrapInterceptorService
extends ServiceBase
implements Interceptor,
IncompatibleExceptionWrapInterceptorServiceMBean {
    private static final long serialVersionUID = 6885480323358622660L;
    protected String[] incompatibleExceptions;
    protected Set incompatibleExceptionSet;

    public void setIncompatibleExceptions(String[] exceptions) {
        this.incompatibleExceptions = exceptions;
    }

    public String[] getIncompatibleExceptions() {
        return this.incompatibleExceptions;
    }

    public void startService() throws Exception {
        if (this.incompatibleExceptions != null) {
            HashSet tmpSet = new HashSet();
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            for (int i = 0; i < this.incompatibleExceptions.length; ++i) {
                Class<?> clazz = Class.forName(this.incompatibleExceptions[i], true, loader);
                tmpSet.add(clazz);
            }
            this.incompatibleExceptionSet = tmpSet;
        }
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object ret = null;
            try {
                ret = chain.invokeNext(context);
            }
            catch (Throwable th) {
                throw this.wrapIncompatibleException(th);
            }
            return ret;
        }
        return chain.invokeNext(context);
    }

    protected Throwable wrapIncompatibleException(Throwable th) {
        Throwable wrapCuase;
        Throwable cause;
        if (this.incompatibleExceptionSet == null || this.incompatibleExceptionSet.size() == 0) {
            return th;
        }
        Throwable result = th;
        if (this.incompatibleExceptionSet.contains(th.getClass())) {
            result = new IncompatibleExceptionWrapExeption(th);
        }
        if ((cause = IncompatibleExceptionWrapExeption.getCause(result)) != null && cause != (wrapCuase = this.wrapIncompatibleException(cause))) {
            IncompatibleExceptionWrapExeption.setCause(result, wrapCuase);
        }
        return result;
    }
}

