/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.ContextSaveOverflowActionServiceMBean;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.OverflowAction;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;
import jp.ossc.nimbus.service.cache.OverflowController;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.SharedContext;

public class ContextSaveOverflowActionService
extends ServiceBase
implements OverflowAction,
Serializable,
ContextSaveOverflowActionServiceMBean {
    private static final long serialVersionUID = 7753212558317658253L;
    private ServiceName contextServiceName;
    private Context context;
    private SharedContext sharedContext;
    private DistributedSharedContext distSharedContext;

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void startService() throws Exception {
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
        if (this.context == null) {
            throw new IllegalArgumentException("Context is null.");
        }
        if (this.context instanceof SharedContext) {
            this.sharedContext = (SharedContext)this.context;
        }
        if (this.context instanceof DistributedSharedContext) {
            this.distSharedContext = (DistributedSharedContext)this.context;
        }
    }

    public void setOverflowController(OverflowController controller) {
    }

    public void action(OverflowValidator validator, OverflowAlgorithm algorithm, CachedReference ref) {
        if (ref == null) {
            return;
        }
        KeyCachedReference keyRef = (KeyCachedReference)ref;
        boolean isSave = false;
        if (this.sharedContext != null) {
            if (!this.sharedContext.isClient()) {
                int index;
                isSave = this.distSharedContext != null ? !this.distSharedContext.isClient(index = this.distSharedContext.getDataNodeIndex(keyRef.getKey())) && this.distSharedContext.isMain(index) : this.sharedContext.isMain();
            }
        } else {
            isSave = true;
        }
        if (isSave) {
            try {
                this.context.save(keyRef.getKey());
                ref.remove(this);
            }
            catch (Exception e) {
                this.getLogger().write("CSOA_00001", keyRef.getKey(), (Throwable)e);
            }
        } else {
            ref.remove(this);
        }
        if (validator != null) {
            validator.remove(ref);
        }
        if (algorithm != null) {
            algorithm.remove(ref);
        }
    }

    public void reset() {
    }
}

