/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheMapFactoryService;
import jp.ossc.nimbus.service.cache.AbstractCacheMapService;
import jp.ossc.nimbus.service.cache.FileCacheMapFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.FileCacheMapService;

public class FileCacheMapFactoryService
extends AbstractCacheMapFactoryService
implements FileCacheMapFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = 2429673437287340561L;

    protected AbstractCacheMapService createAbstractCacheMapService() throws Exception {
        return new FileCacheMapService();
    }

    protected Service createServiceInstance() throws Exception {
        FileCacheMapService cacheMap = (FileCacheMapService)super.createServiceInstance();
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        cacheMap.setOutputDirectory(templateCacheMap.getOutputDirectory());
        cacheMap.setFileShared(templateCacheMap.isFileShared());
        cacheMap.setOutputPrefix(templateCacheMap.getOutputPrefix());
        cacheMap.setOutputSuffix(templateCacheMap.getOutputSuffix());
        cacheMap.setLoadOnStart(templateCacheMap.isLoadOnStart());
        cacheMap.setDeleteOnExitWithJVM(templateCacheMap.isDeleteOnExitWithJVM());
        cacheMap.setExternalizerServiceName(templateCacheMap.getExternalizerServiceName());
        return cacheMap;
    }

    public void setOutputDirectory(String path) throws IllegalArgumentException {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputDirectory(path);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setOutputDirectory(path);
        }
    }

    public String getOutputDirectory() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputDirectory();
    }

    public void setFileShared(boolean isShared) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setFileShared(isShared);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setFileShared(isShared);
        }
    }

    public boolean isFileShared() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isFileShared();
    }

    public void setOutputPrefix(String prefix) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputPrefix(prefix);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setOutputPrefix(prefix);
        }
    }

    public String getOutputPrefix() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputPrefix();
    }

    public void setOutputSuffix(String suffix) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setOutputSuffix(suffix);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setOutputSuffix(suffix);
        }
    }

    public String getOutputSuffix() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getOutputSuffix();
    }

    public void setLoadOnStart(boolean isLoad) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setLoadOnStart(isLoad);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setLoadOnStart(isLoad);
        }
    }

    public boolean isLoadOnStart() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isLoadOnStart();
    }

    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setDeleteOnExitWithJVM(isDeleteOnExit);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setDeleteOnExitWithJVM(isDeleteOnExit);
        }
    }

    public boolean isDeleteOnExitWithJVM() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return false;
        }
        return templateCacheMap.isDeleteOnExitWithJVM();
    }

    public void setExternalizerServiceName(ServiceName name) {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return;
        }
        templateCacheMap.setExternalizerServiceName(name);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheMapService cacheMap = (FileCacheMapService)instances.next();
            cacheMap.setExternalizerServiceName(name);
        }
    }

    public ServiceName getExternalizerServiceName() {
        FileCacheMapService templateCacheMap = (FileCacheMapService)this.getTemplate();
        if (templateCacheMap == null) {
            return null;
        }
        return templateCacheMap.getExternalizerServiceName();
    }
}

