/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheAccessListener;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.LRUOverflowAlgorithmServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;

public class LRUOverflowAlgorithmService
extends ServiceBase
implements OverflowAlgorithm,
CacheRemoveListener,
CacheAccessListener,
Serializable,
LRUOverflowAlgorithmServiceMBean {
    private static final long serialVersionUID = 2274633140923055371L;
    private Map referenceMap;
    private List referenceList;
    private long overflowCount;
    private long overflowCachedTime;

    public int size() {
        return this.referenceMap == null ? 0 : this.referenceMap.size();
    }

    public long getOverflowCount() {
        return this.overflowCount;
    }

    public long getAverageOverflowCachedTime() {
        return this.overflowCount == 0L ? 0L : this.overflowCachedTime / this.overflowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayReferenceTimes() {
        if (this.referenceMap == null) {
            return "";
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Collections.sort(this.referenceList);
            TimeCachedReference timeRef = (TimeCachedReference)this.referenceList.get(this.referenceList.size() - 1);
            long currentTime = System.currentTimeMillis();
            double unitTime = (double)(currentTime - timeRef.getLastAccessTime()) / 100.0;
            Iterator itr = this.referenceList.iterator();
            while (itr.hasNext()) {
                timeRef = (TimeCachedReference)itr.next();
                CachedReference ref = timeRef.getCachedReference();
                long interval = currentTime - timeRef.getLastAccessTime();
                long cachedTime = currentTime - timeRef.getCachedTime();
                int point = (int)((double)interval / unitTime);
                for (int i = 0; i < point; ++i) {
                    pw.print('*');
                }
                pw.print('\u3000');
                pw.print(Long.toString(interval));
                pw.print('(');
                pw.print(Long.toString(cachedTime));
                pw.print(')');
                if (ref instanceof KeyCachedReference) {
                    pw.print('\u3000');
                    pw.print(((KeyCachedReference)ref).getKey());
                }
                pw.println("<br>");
            }
            return sw.toString();
        }
    }

    public void createService() throws Exception {
        this.referenceMap = Collections.synchronizedMap(new HashMap());
        this.referenceList = Collections.synchronizedList(new ArrayList());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.referenceMap = null;
        this.referenceList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (!this.referenceMap.containsKey(ref)) {
                TimeCachedReference tmc = new TimeCachedReference(ref);
                this.referenceMap.put(ref, tmc);
                this.referenceList.add(tmc);
                ref.addCacheAccessListener(this);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.containsKey(ref)) {
                TimeCachedReference tmc = (TimeCachedReference)this.referenceMap.remove(ref);
                this.referenceList.remove(tmc);
                ref.removeCacheAccessListener(this);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedReference overflow() {
        if (this.referenceMap == null) {
            return null;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() != 0) {
                Collections.sort(this.referenceList);
                TimeCachedReference tmc = (TimeCachedReference)this.referenceList.remove(0);
                this.referenceMap.remove(tmc.getCachedReference());
                this.overflowCachedTime += System.currentTimeMillis() - tmc.getCachedTime();
                ++this.overflowCount;
                return tmc.getCachedReference();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedReference[] overflow(int size) {
        if (this.referenceMap == null || this.referenceMap.size() == 0) {
            return null;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() != 0) {
                CachedReference[] result = new CachedReference[Math.min(this.referenceMap.size(), size)];
                Collections.sort(this.referenceList);
                for (int i = 0; i < result.length; ++i) {
                    TimeCachedReference tmc = (TimeCachedReference)this.referenceList.remove(0);
                    this.referenceMap.remove(tmc.getCachedReference());
                    result[i] = tmc.getCachedReference();
                }
                return result;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap != null) {
                this.referenceMap.clear();
            }
            if (this.referenceList != null) {
                this.referenceList.clear();
            }
        }
    }

    public void removed(CachedReference ref) {
        this.remove(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessed(CachedReference ref) {
        if (this.referenceMap == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            TimeCachedReference tmcRef;
            if (this.referenceMap != null && this.referenceMap.containsKey(ref) && (tmcRef = (TimeCachedReference)this.referenceMap.get(ref)) != null) {
                tmcRef.access();
            }
        }
    }

    private static class TimeCachedReference
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 836007284114395682L;
        private CachedReference reference;
        private long lastAccessTime;
        private long cachedTime;

        public TimeCachedReference(CachedReference ref) {
            this.reference = ref;
            this.cachedTime = this.lastAccessTime = System.currentTimeMillis();
        }

        public CachedReference getCachedReference() {
            return this.reference;
        }

        public void access() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getCachedTime() {
            return this.cachedTime;
        }

        public int compareTo(Object arg0) {
            if (arg0 == null || !(arg0 instanceof TimeCachedReference)) {
                return 1;
            }
            if (arg0 == this) {
                return 0;
            }
            TimeCachedReference comp = (TimeCachedReference)arg0;
            long diff = this.lastAccessTime - comp.getLastAccessTime();
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return 1;
            }
            return -1;
        }
    }
}

