/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.context.DefaultContextService;
import jp.ossc.nimbus.service.context.NoConnectServerException;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextIndex;
import jp.ossc.nimbus.service.context.SharedContextIndexManager;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextTransactionManager;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextUpdateListener;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;
import jp.ossc.nimbus.service.context.SharedContextView;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.RequestTimeoutException;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedContextService
extends DefaultContextService
implements SharedContext,
RequestMessageListener,
CacheRemoveListener,
ClusterListener,
SharedContextServiceMBean,
Serializable {
    private static final long serialVersionUID = -7616415086512838961L;
    protected ServiceName requestConnectionFactoryServiceName;
    protected RequestServerConnection serverConnection;
    protected MessageReceiver messageReceiver;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ServiceName clientCacheMapServiceName;
    protected ServiceName serverCacheMapServiceName;
    protected CacheMap clientCacheMap;
    protected CacheMap serverCacheMap;
    protected CacheMap cacheMap;
    protected boolean isClient;
    protected ServiceName[] sharedContextUpdateListenerServiceNames;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected int executeThreadSize;
    protected QueueHandlerContainerService executeQueueHandlerContainer;
    protected ServiceName executeQueueServiceName;
    protected ServiceName sharedContextTransactionManagerServiceName;
    protected SharedContextTransactionManager sharedContextTransactionManager;
    protected long synchronizeTimeout = 5000L;
    protected long defaultTimeout = 1000L;
    protected String subject = "SharedContext";
    protected String clientSubject;
    protected boolean isSynchronizeOnStart = true;
    protected boolean isSaveOnlyMain;
    protected Map keyLockMap;
    protected Map idLocksMap;
    protected Map clientCacheLockMap;
    protected Message targetMessage;
    protected List updateListeners;
    protected SharedContextIndexManager indexManager;
    protected Timer lockTimeoutTimer;
    protected SynchronizeLock updateLock;
    protected SynchronizeLock referLock;

    public void setRequestConnectionFactoryServiceName(ServiceName name) {
        this.requestConnectionFactoryServiceName = name;
    }

    public ServiceName getRequestConnectionFactoryServiceName() {
        return this.requestConnectionFactoryServiceName;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setClientCacheMapServiceName(ServiceName name) {
        this.clientCacheMapServiceName = name;
    }

    public ServiceName getClientCacheMapServiceName() {
        return this.clientCacheMapServiceName;
    }

    public void setServerCacheMapServiceName(ServiceName name) {
        this.serverCacheMapServiceName = name;
    }

    public ServiceName getServerCacheMapServiceName() {
        return this.serverCacheMapServiceName;
    }

    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setExecuteThreadSize(int size) {
        this.executeThreadSize = size;
    }

    public int getExecuteThreadSize() {
        return this.executeThreadSize;
    }

    public void setExecuteQueueServiceName(ServiceName name) {
        this.executeQueueServiceName = name;
    }

    public ServiceName getExecuteQueueServiceName() {
        return this.executeQueueServiceName;
    }

    public void setSharedContextTransactionManagerServiceName(ServiceName name) {
        this.sharedContextTransactionManagerServiceName = name;
    }

    public ServiceName getSharedContextTransactionManagerServiceName() {
        return this.sharedContextTransactionManagerServiceName;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException {
        block27: {
            if (this.isClient == isClient) {
                return;
            }
            if (this.getState() == 3) {
                Object id = this.cluster.getUID();
                try {
                    this.referLock.acquireForLock(id, -1L);
                    this.updateLock.acquireForLock(id, -1L);
                    CacheMap oldCacheMap = this.cacheMap;
                    if (isClient) {
                        if (this.clientCacheMapServiceName != null) {
                            this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                        } else if (this.clientCacheMap != null) {
                            this.cacheMap = this.clientCacheMap;
                        }
                    } else if (this.serverCacheMapServiceName != null) {
                        this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
                    } else if (this.serverCacheMap != null) {
                        this.cacheMap = this.serverCacheMap;
                    }
                    if (this.indexManager != null) {
                        this.indexManager.clear();
                    }
                    try {
                        this.messageReceiver.addSubject(this, isClient ? this.clientSubject : this.subject);
                    }
                    catch (MessageSendException e) {
                        throw new SharedContextSendException(e);
                    }
                    try {
                        if (isClient) {
                            this.synchronizeForClient(this.synchronizeTimeout);
                        } else {
                            this.synchronizeWithMain(this.synchronizeTimeout);
                        }
                    }
                    catch (NoConnectServerException e) {
                        // empty catch block
                    }
                    try {
                        this.messageReceiver.removeSubject(this, isClient ? this.subject : this.clientSubject);
                    }
                    catch (MessageSendException e) {
                        throw new SharedContextSendException(e);
                    }
                    if (oldCacheMap == null) break block27;
                    Object[] keys = null;
                    Map map = this.context;
                    synchronized (map) {
                        keys = super.keySet().toArray();
                    }
                    for (int i = 0; i < keys.length; ++i) {
                        KeyCachedReference ref = oldCacheMap.getCachedReference(keys[i]);
                        if (ref != null) {
                            ref.removeCacheRemoveListener(this);
                        }
                        oldCacheMap.remove(keys[i]);
                    }
                }
                finally {
                    this.updateLock.releaseForLock(id);
                    this.referLock.releaseForLock(id);
                }
            }
        }
        this.isClient = isClient;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void setSynchronizeOnStart(boolean isSynch) {
        this.isSynchronizeOnStart = isSynch;
    }

    public boolean isSynchronizeOnStart() {
        return this.isSynchronizeOnStart;
    }

    public void setSaveOnlyMain(boolean isSave) {
        this.isSaveOnlyMain = isSave;
    }

    public boolean isSaveOnlyMain() {
        return this.isSaveOnlyMain;
    }

    public void setSynchronizeTimeout(long timeout) {
        this.synchronizeTimeout = timeout;
    }

    public long getSynchronizeTimeout() {
        return this.synchronizeTimeout;
    }

    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setClientCacheMap(CacheMap map) {
        this.clientCacheMap = map;
    }

    public void setServerCacheMap(CacheMap map) {
        this.serverCacheMap = map;
    }

    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names) {
        this.sharedContextUpdateListenerServiceNames = names;
    }

    public ServiceName[] getSharedContextUpdateListenerServiceNames() {
        return this.sharedContextUpdateListenerServiceNames;
    }

    public void setIndex(String name, String[] props) {
        this.indexManager.setIndex(name, props);
    }

    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        this.indexManager.setIndex(name, keyFactory);
    }

    public void removeIndex(String name) {
        this.indexManager.removeIndex(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeIndex(String name) {
        Map map = this.context;
        synchronized (map) {
            this.indexManager.replaceIndex(name, this.context);
        }
    }

    public SharedContextView createView() {
        return new SharedContextViewImpl();
    }

    public void createService() throws Exception {
        super.createService();
        this.keyLockMap = Collections.synchronizedMap(new HashMap());
        this.idLocksMap = Collections.synchronizedMap(new HashMap());
        this.clientCacheLockMap = Collections.synchronizedMap(new HashMap());
        this.indexManager = new SharedContextIndexManager();
    }

    public void startService() throws Exception {
        block19: {
            if (this.requestConnectionFactoryServiceName == null) {
                throw new IllegalArgumentException("RequestConnectionFactoryServiceName must be specified.");
            }
            this.updateLock = new SynchronizeLock();
            this.referLock = new SynchronizeLock();
            if (this.isClient) {
                if (this.clientCacheMapServiceName != null) {
                    this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                } else if (this.clientCacheMap != null) {
                    this.cacheMap = this.clientCacheMap;
                }
            } else if (this.serverCacheMapServiceName != null) {
                this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
            } else if (this.serverCacheMap != null) {
                this.cacheMap = this.serverCacheMap;
            }
            if (this.interpreterServiceName != null) {
                this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
            }
            if (this.sharedContextTransactionManagerServiceName != null) {
                this.sharedContextTransactionManager = (SharedContextTransactionManager)ServiceManagerFactory.getServiceObject(this.sharedContextTransactionManagerServiceName);
            }
            this.executeQueueHandlerContainer = new QueueHandlerContainerService();
            this.executeQueueHandlerContainer.create();
            this.executeQueueHandlerContainer.setQueueHandlerSize(this.executeThreadSize);
            if (this.executeQueueServiceName == null) {
                DefaultQueueService executeQueue = new DefaultQueueService();
                executeQueue.create();
                executeQueue.start();
                this.executeQueueHandlerContainer.setQueueService(executeQueue);
            } else {
                this.executeQueueHandlerContainer.setQueueServiceName(this.executeQueueServiceName);
            }
            this.executeQueueHandlerContainer.setQueueHandler(new ExecuteQueueHandler());
            this.executeQueueHandlerContainer.start();
            if (this.sharedContextUpdateListenerServiceNames != null) {
                for (int i = 0; i < this.sharedContextUpdateListenerServiceNames.length; ++i) {
                    this.addSharedContextUpdateListener((SharedContextUpdateListener)ServiceManagerFactory.getServiceObject(this.sharedContextUpdateListenerServiceNames[i]));
                }
            }
            ServerConnectionFactory factory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.serverConnection = (RequestServerConnection)factory.getServerConnection();
            this.targetMessage = this.serverConnection.createMessage(this.subject, null);
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.clientSubject = this.subject + ".Client";
            this.messageReceiver.addSubject(this, this.isClient ? this.clientSubject : this.subject);
            if (this.clusterServiceName == null) {
                throw new IllegalArgumentException("ClusterServiceName must be specified.");
            }
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.cluster.addClusterListener(this);
            this.lockTimeoutTimer = new Timer(true);
            super.startService();
            if (this.isSynchronizeOnStart && !this.isMain()) {
                try {
                    this.synchronize();
                }
                catch (NoConnectServerException e) {
                    if (this.isClient) break block19;
                    throw e;
                }
            }
        }
    }

    public void stopService() throws Exception {
        this.unlockAll();
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
        }
        if (this.messageReceiver != null) {
            try {
                this.messageReceiver.removeMessageListener(this);
            }
            catch (MessageSendException messageSendException) {
                // empty catch block
            }
        }
        if (this.updateLock != null) {
            this.updateLock.close();
        }
        if (this.referLock != null) {
            this.referLock.close();
        }
        this.executeQueueHandlerContainer.stop();
        this.executeQueueHandlerContainer.destroy();
        this.executeQueueHandlerContainer = null;
        super.stopService();
    }

    public void destroyService() throws Exception {
        this.keyLockMap = null;
        this.idLocksMap = null;
        this.clientCacheLockMap = null;
        super.destroyService();
    }

    public synchronized void load() throws Exception {
        this.load(-1L);
    }

    public synchronized void load(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    public synchronized void loadKey() throws Exception {
        this.loadKey(-1L);
    }

    public synchronized void loadKey(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.loadKey();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(17));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    public void load(Object key) throws Exception {
        this.load(key, -1L);
    }

    public void load(Object key, long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load(key);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16, key));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        Object ret = responses[0].getObject();
                        responses[0].recycle();
                        if (ret instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    public synchronized void save() throws Exception {
        this.save(-1L);
    }

    public synchronized void save(long timeout) throws Exception {
        block10: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        Message[] responses;
                        block9: {
                            message.setObject(new SharedContextEvent(15));
                            responses = null;
                            try {
                                responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                            }
                            catch (RequestTimeoutException e) {
                                responses = e.getResponses();
                                if (this.isSaveOnlyMain && responses != null && responses.length != 0) break block9;
                                throw new SharedContextTimeoutException(e);
                            }
                        }
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            responses[i].recycle();
                            if (!(ret instanceof Throwable)) continue;
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block10;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save();
        }
    }

    public void save(Object key) throws Exception {
        this.save(key, -1L);
    }

    public void save(Object key, long timeout) throws Exception {
        block10: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        Message[] responses;
                        block9: {
                            message.setObject(new SharedContextEvent(15, key));
                            responses = null;
                            try {
                                responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                            }
                            catch (RequestTimeoutException e) {
                                responses = e.getResponses();
                                if (this.isSaveOnlyMain && responses != null && responses.length != 0) break block9;
                                throw new SharedContextTimeoutException(e);
                            }
                        }
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            responses[i].recycle();
                            if (!(ret instanceof Throwable)) continue;
                            throw new SharedContextSendException((Throwable)ret);
                        }
                        break block10;
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save(key);
        }
    }

    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
        this.synchronize(this.synchronizeTimeout);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block22: {
            id = this.cluster.getUID();
            start = System.currentTimeMillis();
            if (!this.updateLock.acquireForLock(id, timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - start) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(24, null, new Long(timeout)));
                responses = this.serverConnection.request(message, this.isClient != false ? this.clientSubject : this.subject, null, 0, timeout);
                for (i = 0; i < responses.length; ++i) {
                    ret = responses[i].getObject();
                    responses[i].recycle();
                    if (ret instanceof Throwable) {
                        throw new SharedContextSendException((Throwable)ret);
                    }
                    if (ret != null && ((Boolean)ret).booleanValue()) continue;
                    throw new SharedContextTimeoutException();
                }
            }
            if (this.isClient) {
                this.synchronizeForClient(timeout);
                break block22;
            }
            if (this.isMain()) {
                message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(11, null, new Long(timeout)));
                    responses = this.serverConnection.request(message, 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        if (responses[i].getObject() == null || !((Boolean)responses[i].getObject()).booleanValue()) {
                            throw new SharedContextSendException("It faild to synchronize.");
                        }
                        responses[i].recycle();
                    }
                }
                break block22;
            }
            this.synchronizeWithMain(timeout);
        }
        var12_12 = null;
        try {
            message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) ** GOTO lbl77
            message.setObject(new SharedContextEvent(25, this.cluster.getUID()));
            this.serverConnection.sendAsynch(message);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        {
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        catch (Throwable var11_22) {
            var12_13 = null;
            try {
                message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(25, this.cluster.getUID()));
                    this.serverConnection.sendAsynch(message);
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            this.updateLock.releaseForLock(id);
            throw var11_22;
        }
lbl77:
        // 2 sources

        this.updateLock.releaseForLock(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void synchronizeForClient(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block17: {
            if (this.cacheMap != null) {
                Object[] keys = null;
                Map map = this.context;
                synchronized (map) {
                    keys = super.keySet().toArray();
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.cacheMap.remove(keys[i]);
                }
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                }
            }
            super.clear();
            if (this.updateListeners != null || this.indexManager.hasIndex()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(4));
                        Message[] responses = this.serverConnection.request(message, 1, timeout);
                        Map result = (Map)responses[0].getObject();
                        responses[0].recycle();
                        if (result != null) {
                            Iterator entries = result.entrySet().iterator();
                            while (entries.hasNext()) {
                                Map.Entry entry = entries.next();
                                boolean isPut = true;
                                if (this.updateListeners != null) {
                                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue())) continue;
                                        isPut = false;
                                        break;
                                    }
                                }
                                if (!isPut || !this.indexManager.hasIndex() || entry.getValue() == null) continue;
                                this.indexManager.add(entry.getKey(), entry.getValue());
                            }
                        }
                        break block17;
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
    }

    protected synchronized void synchronizeWithMain(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block11: {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(4));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                    Map result = (Map)responses[0].getObject();
                    responses[0].recycle();
                    if (this.updateListeners != null) {
                        for (int i = 0; i < this.updateListeners.size(); ++i) {
                            ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                        }
                    }
                    super.clear();
                    if (result != null) {
                        Iterator entries = result.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            boolean isPut = true;
                            if (this.updateListeners != null) {
                                for (int i = 0; i < this.updateListeners.size(); ++i) {
                                    if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue())) continue;
                                    isPut = false;
                                    break;
                                }
                            }
                            if (!isPut) continue;
                            super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                            if (!this.indexManager.hasIndex() || entry.getValue() == null) continue;
                            this.indexManager.add(entry.getKey(), entry.getValue());
                        }
                    }
                    break block11;
                }
                throw new NoConnectServerException("Main server is not found.");
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
    }

    protected Object wrapCachedReference(Object key, Object value) {
        if (value == null || this.cacheMap == null) {
            return value;
        }
        this.cacheMap.put(key, value);
        KeyCachedReference ref = this.cacheMap.getCachedReference(key);
        if (ref != null) {
            ref.addCacheRemoveListener(this);
        }
        return ref;
    }

    protected Object unwrapCachedReference(Object value, boolean notify, boolean remove) {
        if (value == null) {
            return null;
        }
        if (this.cacheMap == null) {
            return value;
        }
        CachedReference ref = (CachedReference)value;
        Object ret = ref.get(this, notify);
        if (remove) {
            ref.remove(this);
        }
        return ret;
    }

    public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object id = this.cluster.getUID();
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
            if (lock == null) {
                lock = new Lock(key);
                this.keyLockMap.put(key, lock);
            }
        }
        Object lockedOwner = lock.getOwner();
        if (id.equals(lockedOwner) && Thread.currentThread().equals(lock.getOwnerThread())) {
            return;
        }
        if (this.isMain()) {
            long start = System.currentTimeMillis();
            if (!lock.acquire(id, timeout)) throw new SharedContextTimeoutException();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout <= 0L) {
                lock.release(id, false);
                throw new SharedContextTimeoutException();
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) return;
                message.setObject(new SharedContextEvent(13, key, new Object[]{id, new Long(timeout)}));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                for (int i = 0; i < responses.length; ++i) {
                    Object ret = responses[i].getObject();
                    responses[i].recycle();
                    if (ret instanceof Throwable) {
                        this.unlock(key);
                        throw new SharedContextSendException((Throwable)ret);
                    }
                    if (ret != null && ((Boolean)ret).booleanValue()) continue;
                    this.unlock(key);
                    throw new SharedContextTimeoutException();
                }
                return;
            }
            catch (MessageException e) {
                this.unlock(key);
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                this.unlock(key);
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                this.unlock(key);
                throw new SharedContextTimeoutException(e);
            }
            catch (RuntimeException e) {
                this.unlock(key);
                throw e;
            }
            catch (Error e) {
                this.unlock(key);
                throw e;
            }
            catch (Throwable th) {
                this.unlock(key);
                throw new SharedContextSendException(th);
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) throw new NoConnectServerException("Main server is not found.");
            message.setObject(new SharedContextEvent(12, key, new Long(timeout)));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 1, timeout);
            Object ret = responses[0].getObject();
            responses[0].recycle();
            if (ret instanceof Throwable) {
                this.unlock(key);
                throw new SharedContextSendException((Throwable)ret);
            }
            if (ret == null || !((Boolean)ret).booleanValue()) {
                this.unlock(key);
                throw new SharedContextTimeoutException();
            }
        }
        catch (MessageException e) {
            this.unlock(key);
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            this.unlock(key);
            throw new SharedContextSendException(e);
        }
        catch (RequestTimeoutException e) {
            this.unlock(key);
            throw new SharedContextTimeoutException(e);
        }
        catch (RuntimeException e) {
            this.unlock(key);
            throw e;
        }
        catch (Error e) {
            this.unlock(key);
            throw e;
        }
        if (lock.acquire(id, timeout)) return;
        this.unlock(key);
        throw new SharedContextTimeoutException();
    }

    public boolean unlock(Object key) throws SharedContextSendException {
        return this.unlock(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(Object key, boolean force) throws SharedContextSendException {
        boolean result;
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        Object id = this.cluster.getUID();
        if (force && lock != null && lock.getOwner() != null) {
            id = lock.getOwner();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            message.setObject(new SharedContextEvent(14, key, id));
            this.serverConnection.sendAsynch(message);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        boolean bl = result = lock == null;
        if (lock != null) {
            result = lock.release(id, force);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll() {
        Map map = this.keyLockMap;
        synchronized (map) {
            Object myId = this.cluster.getUID();
            Iterator entries = this.keyLockMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                Lock lock = (Lock)entry.getValue();
                Object owner = lock.getOwner();
                if (owner == null || !owner.equals(myId)) continue;
                try {
                    this.unlock(key, true);
                }
                catch (SharedContextSendException e) {
                    lock.release(myId, true);
                }
            }
        }
        map = this.clientCacheLockMap;
        synchronized (map) {
            Iterator locks = this.clientCacheLockMap.values().iterator();
            while (locks.hasNext()) {
                ClientCacheLock lock = (ClientCacheLock)locks.next();
                lock.notifyAllLock();
            }
        }
        this.lockTimeoutTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLockOwner(Object key) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        return lock == null ? null : lock.getOwner();
    }

    public Object put(Object key, Object value) throws SharedContextSendException {
        return this.put(key, value, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            return transaction.put(this, key, value, timeout);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(1, key, value));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        if (responses[i].getObject() != null) {
                            result = responses[i].getObject();
                        }
                        responses[i].recycle();
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    result = super.put(key, this.wrapCachedReference(key, value));
                    result = this.unwrapCachedReference(result, false, true);
                }
            } else {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && result != null) {
                    if (value != null) {
                        this.indexManager.replace(key, result, value);
                    } else {
                        this.indexManager.remove(key, result);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putLocal(Object key, Object value) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            this.updateLock.acquireForUse(-1L);
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    result = super.put(key, this.wrapCachedReference(key, value));
                    result = this.unwrapCachedReference(result, false, true);
                }
            } else {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && result != null) {
                    if (value != null) {
                        this.indexManager.replace(key, result, value);
                    } else {
                        this.indexManager.remove(key, result);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAsynch(Object key, Object value) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return;
            }
        }
        Object removed = null;
        try {
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    removed = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(1, key, value));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            boolean isContainsKey = super.containsKey(key);
            if (this.isClient) {
                if (isContainsKey) {
                    super.put(key, this.wrapCachedReference(key, value));
                }
            } else {
                removed = super.put(key, this.wrapCachedReference(key, value));
                removed = this.unwrapCachedReference(removed, false, true);
            }
            if (this.indexManager.hasIndex()) {
                if (isContainsKey && removed != null) {
                    if (value != null) {
                        this.indexManager.replace(key, removed, value);
                    } else {
                        this.indexManager.remove(key, removed);
                    }
                } else if (value != null) {
                    this.indexManager.add(key, value);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, removed);
            }
        }
    }

    public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.update(key, diff, this.defaultTimeout);
    }

    public void updateIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateIfExists(key, diff, this.defaultTimeout);
    }

    public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.update(key, diff, this.defaultTimeout, false);
    }

    public void updateIfExists(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.update(key, diff, this.defaultTimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Object key, SharedContextValueDifference diff, long timeout, boolean ifExists) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (diff == null) {
            return;
        }
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            if (ifExists) {
                transaction.updateIfExists(this, key, diff, timeout);
            } else {
                transaction.update(this, key, diff, timeout);
            }
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object ret;
            int i;
            Message[] responses;
            Set receiveClients;
            Message message;
            Object oldValue = null;
            Object newValue = null;
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L) {
                if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                startTime = System.currentTimeMillis();
            }
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L) {
                if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                startTime = System.currentTimeMillis();
            }
            if (this.isClient && !super.containsKey(key)) {
                oldValue = this.get(key, timeout);
                if (!(oldValue instanceof SharedContextValueDifferenceSupport)) {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + oldValue);
                }
                oldValue = ((SharedContextValueDifferenceSupport)oldValue).clone();
                if (timeout > 0L) {
                    if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    startTime = System.currentTimeMillis();
                }
            }
            try {
                message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            if (!this.isClient || super.containsKey(key)) {
                Object current = this.getRawLocal(key);
                Object currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    if (!ifExists) {
                        throw new SharedContextUpdateException("Current value is null. key=" + key);
                    }
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                    if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                    newValue = currentValue;
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            } else {
                newValue = this.get(key, timeout);
                if (timeout > 0L) {
                    if ((timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    startTime = System.currentTimeMillis();
                }
            }
            try {
                message = this.serverConnection.createMessage(this.clientSubject, key == null ? null : key.toString());
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    for (i = 0; i < responses.length; ++i) {
                        ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
        }
        finally {
            this.referLock.releaseForUse();
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    public void updateLocal(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.updateLocal(key, diff, false);
    }

    public void updateLocalIfExists(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
        this.updateLocal(key, diff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal(Object key, SharedContextValueDifference diff, boolean ifExists) throws SharedContextUpdateException {
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object oldValue = null;
            Object newValue = null;
            this.updateLock.acquireForUse(-1L);
            Object current = this.getRawLocal(key);
            Object currentValue = this.unwrapCachedReference(current, false, false);
            if (currentValue != null) {
                if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
            }
            if (!this.isClient || super.containsKey(key)) {
                if (currentValue == null && !ifExists) {
                    throw new SharedContextUpdateException("Current value is null. key=" + key);
                }
                if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                    throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                }
                newValue = currentValue;
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateAsynch(key, diff, false);
    }

    public void updateAsynchIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.updateAsynch(key, diff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAsynch(Object key, SharedContextValueDifference diff, boolean ifExists) throws SharedContextSendException {
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Object oldValue = null;
            Object newValue = null;
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    oldValue = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(18, key, new Object[]{diff, ifExists ? Boolean.TRUE : Boolean.FALSE}));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            if (!this.isClient || super.containsKey(key)) {
                Object current = this.getRawLocal(key);
                Object currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    if (!ifExists) {
                        throw new SharedContextUpdateException("Current value is null. key=" + key);
                    }
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    oldValue = ((SharedContextValueDifferenceSupport)currentValue).clone();
                    if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                    newValue = currentValue;
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
                }
                if (currentValue != null && current instanceof CachedReference) {
                    try {
                        ((CachedReference)current).set(this, currentValue);
                    }
                    catch (IllegalCachedReferenceException e) {
                        throw new SharedContextUpdateException(e);
                    }
                }
            }
            if (super.containsKey(key) && this.indexManager.hasIndex()) {
                this.indexManager.replace(key, oldValue, newValue);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    public Object remove(Object key) throws SharedContextSendException {
        return this.remove(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.isMain() && !super.containsKey(key)) {
            return null;
        }
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            return transaction.remove(this, key, timeout);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(2, key));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    if (this.isMain()) {
                        result = super.remove(key);
                        result = this.unwrapCachedReference(result, false, true);
                        for (int i = 0; i < responses.length; ++i) {
                            responses[i].recycle();
                        }
                    } else {
                        Object removed = super.remove(key);
                        this.unwrapCachedReference(removed, false, true);
                        for (int i = 0; i < responses.length; ++i) {
                            if (responses[i].getObject() != null) {
                                result = responses[i].getObject();
                            }
                            responses[i].recycle();
                        }
                    }
                } else {
                    if (this.isClient) {
                        throw new NoConnectServerException();
                    }
                    result = super.remove(key);
                    result = this.unwrapCachedReference(result, false, true);
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            if (this.indexManager.hasIndex() && result != null) {
                this.indexManager.remove(key, result);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeLocal(Object key) {
        if (this.isMain() && !super.containsKey(key)) {
            return null;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return null;
            }
        }
        Object result = null;
        try {
            this.updateLock.acquireForUse(-1L);
            result = super.remove(key);
            result = this.unwrapCachedReference(result, false, true);
            if (this.indexManager.hasIndex() && result != null) {
                this.indexManager.remove(key, result);
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsynch(Object key) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return;
            }
        }
        Object removed = null;
        try {
            this.updateLock.acquireForUse(-1L);
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    removed = this.get(key);
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(2, key));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            if (removed == null) {
                removed = super.remove(key);
                removed = this.unwrapCachedReference(removed, false, true);
            } else {
                super.remove(key);
            }
            if (this.indexManager.hasIndex() && removed != null) {
                this.indexManager.remove(key, removed);
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, removed);
            }
        }
    }

    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(6, null, t));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                boolean isContainsKey = super.containsKey(entry.getKey());
                Object old = null;
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putAllLocal(Map t) {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            this.updateLock.acquireForUse(-1L);
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                boolean isContainsKey = super.containsKey(entry.getKey());
                Object old = null;
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putAllAsynch(Map t) throws SharedContextSendException {
        Map.Entry entry;
        Iterator entries;
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            this.updateLock.acquireForUse(-1L);
            HashMap oldMap = null;
            if (this.isClient && this.indexManager.hasIndex()) {
                try {
                    if (!this.referLock.acquireForUse(-1L)) {
                        throw new SharedContextTimeoutException();
                    }
                    oldMap = new HashMap();
                    entries = t.entrySet().iterator();
                    while (entries.hasNext()) {
                        entry = entries.next();
                        oldMap.put(entry.getKey(), this.get(entry.getKey()));
                    }
                }
                finally {
                    this.referLock.releaseForUse();
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(6, null, t));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                Object old = null;
                boolean isContainsKey = super.containsKey(entry.getKey());
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    } else {
                        old = oldMap.get(entry.getKey());
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    public void clear() throws SharedContextSendException {
        this.clear(this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Object receiveClients;
            long startTime = System.currentTimeMillis();
            if (!this.updateLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(3));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        responses[i].recycle();
                        if (ret == null || !(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
            Object[] keys = null;
            receiveClients = this.context;
            synchronized (receiveClients) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.indexManager.hasIndex() && removed != null) {
                    this.indexManager.remove(keys[i], removed);
                }
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearLocal() {
        if (this.size() == 0) {
            return;
        }
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        try {
            this.updateLock.acquireForUse(-1L);
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.indexManager.hasIndex() && removed != null) {
                    this.indexManager.remove(keys[i], removed);
                }
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearAsynch() throws SharedContextSendException {
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Object receiveClients;
            this.updateLock.acquireForUse(-1L);
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(3));
                    this.serverConnection.sendAsynch(message);
                } else if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            Object[] keys = null;
            receiveClients = this.context;
            synchronized (receiveClients) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                int j;
                if (this.updateListeners != null) {
                    boolean isRemove = true;
                    for (j = 0; j < this.updateListeners.size(); ++j) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                        isRemove = false;
                        break;
                    }
                    if (!isRemove) continue;
                }
                Object removed = super.remove(keys[i]);
                removed = this.unwrapCachedReference(removed, false, true);
                if (this.updateListeners == null) continue;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
                }
            }
            if (this.indexManager.hasIndex()) {
                this.indexManager.clear();
            }
        }
        finally {
            this.updateLock.releaseForUse();
        }
    }

    public Object get(Object key) throws SharedContextSendException {
        return this.get(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        Object result = null;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1 && transaction.containsKey(this, key)) {
            return transaction.get(this, key);
        }
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (this.isClient) {
                if (super.containsKey(key)) {
                    result = this.getLocal(key);
                    if (result != null) return result;
                    if (super.containsKey(key)) return result;
                    result = this.get(key, timeout);
                    return result;
                }
                ClientCacheLock lock = null;
                ClientCacheLock newLock = null;
                Map map2 = this.clientCacheLockMap;
                // MONITORENTER : map2
                lock = (ClientCacheLock)this.clientCacheLockMap.get(key);
                if (lock == null) {
                    newLock = new ClientCacheLock(key);
                    this.clientCacheLockMap.put(key, newLock);
                } else {
                    lock.init();
                }
                // MONITOREXIT : map2
                if (lock != null) {
                    long start = System.currentTimeMillis();
                    if (!lock.waitLock(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    result = this.get(key, timeout);
                    return result;
                }
                try {
                    try {
                        Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                        Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                        if (receiveClients.size() == 0) throw new NoConnectServerException();
                        message.setObject(new SharedContextEvent(5, key));
                        Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                        result = responses[0].getObject();
                        responses[0].recycle();
                        ClientCacheLock clientCacheLock = newLock;
                        // MONITORENTER : clientCacheLock
                        if (!newLock.isRemove()) {
                            result = newLock.updateValue(result);
                            super.put(key, this.wrapCachedReference(key, result));
                        }
                        // MONITOREXIT : clientCacheLock
                        Object var15_17 = null;
                        Map map = this.clientCacheLockMap;
                    }
                    catch (MessageException e) {
                        throw new SharedContextSendException(e);
                    }
                    catch (MessageSendException e) {
                        throw new SharedContextSendException(e);
                    }
                    catch (RequestTimeoutException e) {
                        throw new SharedContextTimeoutException(e);
                    }
                    // MONITORENTER : map
                    this.clientCacheLockMap.remove(key);
                    newLock.notifyAllLock();
                    // MONITOREXIT : map
                    return result;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    Map map = this.clientCacheLockMap;
                    // MONITORENTER : map
                    this.clientCacheLockMap.remove(key);
                    newLock.notifyAllLock();
                    // MONITOREXIT : map
                    throw throwable;
                }
            }
            result = this.getLocal(key);
            return result;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocal(Object key) {
        try {
            this.referLock.acquireForUse(-1L);
            Object raw = this.getRawLocal(key);
            Object unwrapped = this.unwrapCachedReference(raw, true, false);
            if (raw != unwrapped && unwrapped == null && !this.isClient && this.contextStore != null && super.containsKey(key)) {
                unwrapped = this.getLocal(key);
            }
            Object object = unwrapped;
            return object;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    protected Object getRawLocal(Object key) {
        Object result = super.get(key);
        if (result == null && !this.isClient && this.contextStore != null && super.containsKey(key)) {
            try {
                this.contextStore.load(this, key);
            }
            catch (Exception e) {
                this.getLogger().write("SCS__00001", new Object[]{key, this.subject}, (Throwable)e);
            }
            result = super.get(key);
        }
        return result;
    }

    public Set keySet() throws SharedContextSendException {
        return this.keySet(this.defaultTimeout);
    }

    public synchronized Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                Set set = super.keySet();
                return set;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(7));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                Set result = (Set)responses[0].getObject();
                responses[0].recycle();
                Set set = result;
                return set;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set keySetLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            Set set = super.keySet();
            return set;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public int size() throws SharedContextSendException {
        return this.size(this.defaultTimeout);
    }

    public synchronized int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                int n = super.size();
                return n;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(8));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                int result = (Integer)responses[0].getObject();
                responses[0].recycle();
                int n = result;
                return n;
            }
            int n = this.sizeLocal();
            return n;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int sizeLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            int n = super.size();
            return n;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public boolean isEmpty() throws SharedContextSendException {
        return this.size() == 0;
    }

    public boolean isEmptyLocal() {
        return this.sizeLocal() == 0;
    }

    public boolean containsKey(Object key) throws SharedContextSendException {
        return this.containsKey(key, this.defaultTimeout);
    }

    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1 && transaction.containsKey(this, key)) {
            return transaction.get(this, key) != null;
        }
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                boolean bl = super.containsKey(key);
                return bl;
            }
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(9, key));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                boolean result = (Boolean)responses[0].getObject();
                responses[0].recycle();
                boolean bl = result;
                return bl;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyLocal(Object key) {
        try {
            this.referLock.acquireForUse(-1L);
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public boolean containsValue(Object value) throws SharedContextSendException {
        return this.containsValue(value, this.defaultTimeout);
    }

    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.referLock.acquireForUse(timeout)) {
                throw new SharedContextTimeoutException();
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.isClient) {
                boolean bl = this.containsValueLocal(value);
                return bl;
            }
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(10, null, value));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                boolean result = (Boolean)responses[0].getObject();
                responses[0].recycle();
                boolean bl = result;
                return bl;
            }
            try {
                throw new NoConnectServerException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            catch (RequestTimeoutException e) {
                throw new SharedContextTimeoutException(e);
            }
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValueLocal(Object value) {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                boolean bl = super.containsValue(value);
                return bl;
            }
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                Object val = this.cacheMap.get(keys[i]);
                if (val == null) {
                    if (value != null) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!val.equals(value)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public Collection values() {
        if (!this.isClient) {
            return this.valuesLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection valuesLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Collection collection = super.values();
                return collection;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                result.add(this.cacheMap.get(keys[i]));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public Map all() {
        if (!this.isClient) {
            return this.allLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map allLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Map map = super.all();
                return map;
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Object[] keys = null;
            Map map = this.context;
            synchronized (map) {
                keys = super.keySet().toArray();
            }
            for (int i = 0; i < keys.length; ++i) {
                result.put(keys[i], this.cacheMap.get(keys[i]));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public Set entrySet() {
        if (!this.isClient) {
            return this.entrySetLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySetLocal() {
        try {
            this.referLock.acquireForUse(-1L);
            if (this.cacheMap == null) {
                Set set = super.entrySet();
                return set;
            }
            HashSet<Map.Entry> reuslt = new HashSet<Map.Entry>();
            Map.Entry[] entries = null;
            Map map = this.context;
            synchronized (map) {
                entries = this.cacheMap.entrySet().toArray(new Map.Entry[this.cacheMap.size()]);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (!super.containsKey(entries[i].getKey())) continue;
                reuslt.add(entries[i]);
            }
            HashSet<Map.Entry> hashSet = reuslt;
            return hashSet;
        }
        finally {
            this.referLock.releaseForUse();
        }
    }

    public boolean isMain() {
        return this.isMain(null);
    }

    protected boolean isMain(Object excludeId) {
        return this.isMain(this.cluster.getMembers(), excludeId);
    }

    protected boolean isMain(List members, Object excludeId) {
        if (this.isClient) {
            return false;
        }
        Object mainId = this.getMainId(members, excludeId);
        Object myId = this.cluster.getUID();
        return myId.equals(mainId);
    }

    public Object getMainId() {
        return this.getMainId(this.cluster.getMembers(), null);
    }

    protected Object getMainId(List members, Object excludeId) {
        if (this.cluster == null) {
            return null;
        }
        Object myId = this.cluster.getUID();
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(excludeId)) continue;
            if (id.equals(myId)) {
                return myId;
            }
            if (!targetMembers.contains(id)) continue;
            return id;
        }
        return myId;
    }

    public Object getId() {
        return this.cluster == null ? null : this.cluster.getUID();
    }

    public List getMemberIdList() {
        return this.cluster == null ? new ArrayList() : this.cluster.getMembers();
    }

    public Set getClientMemberIdSet() {
        if (this.serverConnection == null || this.clientSubject == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.clientSubject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    public Set getServerMemberIdSet() {
        if (this.serverConnection == null) {
            return new HashSet();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set result = this.serverConnection.getReceiveClientIds(message);
            if (!this.isClient) {
                result.add(this.getId());
            }
            return result;
        }
        catch (MessageException e) {
            return new HashSet();
        }
    }

    public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        return this.executeInterpretQuery(query, variables, this.defaultTimeout);
    }

    public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block8: {
            result = null;
            if (!this.isClient && this.isMain()) {
                result = this.executeInterpretQueryLocal(query, variables);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(23, query, variables));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        result = responses[0].getObject();
                        responses[0].recycle();
                        if (result != null && result instanceof Throwable) {
                            throw new SharedContextSendException((Throwable)result);
                        }
                        break block8;
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
                catch (RequestTimeoutException e) {
                    throw new SharedContextTimeoutException(e);
                }
            }
        }
        return result;
    }

    protected Object executeInterpretQueryLocal(String evaluate, Map variables) throws EvaluateException {
        if (this.interpreter == null) {
            throw new EvaluateException("Interpreter is null.");
        }
        if (variables == null) {
            variables = new HashMap<String, LocalSharedContext>();
        }
        variables.put("context", new LocalSharedContext());
        return this.interpreter.evaluate(evaluate, variables);
    }

    public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
    }

    public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove(listener);
    }

    public void memberInit(Object myId, List members) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberChange(List oldMembers, List newMembers) {
        block12: {
            block13: {
                block11: {
                    Set targetMembers;
                    if (!this.isClient) break block11;
                    if (this.sizeLocal() == 0 || (targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage)).size() != 0) break block12;
                    this.clearLocal();
                    break block12;
                }
                if (!this.isMain(newMembers)) break block13;
                if (!this.isMain() && this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeMain(this);
                    }
                }
                HashSet deadMembers = new HashSet(oldMembers);
                deadMembers.removeAll(newMembers);
                if (deadMembers.size() == 0) break block12;
                Iterator ids = deadMembers.iterator();
                while (ids.hasNext()) {
                    Object id = ids.next();
                    Set keySet = (Set)this.idLocksMap.remove(id);
                    if (keySet == null || keySet.size() == 0) continue;
                    Set set = keySet;
                    synchronized (set) {
                        Iterator keys = keySet.iterator();
                        while (keys.hasNext()) {
                            try {
                                this.unlock(keys.next(), true);
                            }
                            catch (SharedContextSendException e) {}
                        }
                    }
                    this.updateLock.releaseForLock(id);
                }
                break block12;
            }
            if (this.isMain() && this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onChangeSub(this);
                }
            }
        }
    }

    public void changeMain() throws Exception {
    }

    public void changeSub() {
    }

    public void removed(CachedReference ref) {
        if (ref == null) {
            return;
        }
        KeyCachedReference kcr = (KeyCachedReference)ref;
        if (this.isClient) {
            super.remove(kcr.getKey());
        } else {
            super.put(kcr.getKey(), (Object)null);
        }
    }

    public void onMessage(Message message) {
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
            message.recycle();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return;
        }
        switch (event.type) {
            case 1: {
                this.onPut(event);
                break;
            }
            case 6: {
                this.onPutAll(event);
                break;
            }
            case 2: {
                this.onRemove(event);
                break;
            }
            case 3: {
                this.onClear(event);
                break;
            }
            case 14: {
                this.onReleaseLock(event);
                break;
            }
            case 18: {
                this.onUpdate(event);
                break;
            }
            case 20: {
                this.onPutInner(event);
                break;
            }
            case 25: {
                this.onReleaseUpdateLock(event);
                break;
            }
        }
    }

    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
            message.recycle();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 1: {
                result = this.onPut(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 6: {
                result = this.onPutAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 2: {
                result = this.onRemove(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 3: {
                result = this.onClear(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 5: {
                result = this.onGet(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 4: {
                result = this.onGetAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 7: {
                result = this.onKeySet(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 8: {
                result = this.onSize(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 9: {
                result = this.onContainsKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 10: {
                result = this.onContainsValue(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 11: {
                result = this.onSynchronizeAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 19: {
                result = this.onSynchronize(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 12: {
                result = this.onGetLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 13: {
                result = this.onGotLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 15: {
                result = this.onSave(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 16: {
                result = this.onLoad(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 17: {
                result = this.onLoadKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 18: {
                result = this.onUpdate(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 21: {
                result = this.onAnalyzeKeyIndex(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 22: {
                result = this.onSearchIndex(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 23: {
                this.onExecuteInterpret(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 24: {
                result = this.onGetUpdateLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
        }
        return result;
    }

    protected Message createResponseMessage(String responseSubject, String responseKey, Object response) {
        Message result = null;
        try {
            result = this.serverConnection.createMessage(responseSubject, responseKey);
            if (responseSubject.endsWith(".Client")) {
                result.setSubject(responseSubject.substring(0, responseSubject.length() - ".Client".length()), responseKey);
            } else {
                result.setSubject(responseSubject + ".Client", responseKey);
            }
            result.setObject(response);
        }
        catch (MessageException e) {
            this.getLogger().write("SCS__00002", new Object[]{this.isClient ? this.clientSubject : this.subject, responseSubject, responseKey, response}, (Throwable)e);
            result = null;
        }
        return result;
    }

    protected void onPut(SharedContextEvent event) {
        this.onPut(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPut(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Object result = null;
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, event.key, event.value)) continue;
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        Object old = null;
        boolean isContainsKey = super.containsKey(event.key);
        if (this.isClient) {
            if (isContainsKey) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
            if (this.isMain(sourceId)) {
                result = old;
            }
        }
        if (this.indexManager.hasIndex()) {
            if (isContainsKey && old != null) {
                if (event.value != null) {
                    this.indexManager.replace(event.key, old, event.value);
                } else {
                    this.indexManager.remove(event.key, old);
                }
            } else if (event.value != null) {
                this.indexManager.add(event.key, event.value);
            }
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, event.key, event.value, old);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, result);
    }

    protected void onPutAll(SharedContextEvent event) {
        this.onPutAll(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPutAll(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Map map = (Map)event.value;
        if (map != null) {
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                boolean isPut = true;
                if (this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, entry.getKey(), entry.getValue())) continue;
                        isPut = false;
                        break;
                    }
                }
                if (!isPut) continue;
                Object old = null;
                boolean isContainsKey = super.containsKey(entry.getKey());
                if (this.isClient) {
                    if (isContainsKey) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    } else if (this.clientCacheLockMap.containsKey(entry.getKey())) {
                        ClientCacheLock lock = null;
                        Object object = this.clientCacheLockMap;
                        synchronized (object) {
                            lock = (ClientCacheLock)this.clientCacheLockMap.get(entry.getKey());
                        }
                        if (lock != null) {
                            object = lock;
                            synchronized (object) {
                                if (super.containsKey(entry.getKey())) {
                                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                                    old = this.unwrapCachedReference(old, false, true);
                                } else {
                                    lock.put(entry.getValue());
                                }
                            }
                        }
                    }
                } else {
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                }
                if (this.indexManager.hasIndex()) {
                    if (isContainsKey && old != null) {
                        if (entry.getValue() != null) {
                            this.indexManager.replace(entry.getKey(), old, entry.getValue());
                        } else {
                            this.indexManager.remove(entry.getKey(), old);
                        }
                    } else if (entry.getValue() != null) {
                        this.indexManager.add(entry.getKey(), entry.getValue());
                    }
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPutInner(SharedContextEvent event) {
        Object old = null;
        boolean isContainsKey = super.containsKey(event.key);
        if (this.isClient) {
            if (isContainsKey) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
        }
        if (this.indexManager.hasIndex()) {
            if (isContainsKey && old != null) {
                if (event.value != null) {
                    this.indexManager.replace(event.key, old, event.value);
                } else {
                    this.indexManager.remove(event.key, old);
                }
            } else if (event.value != null) {
                this.indexManager.add(event.key, event.value);
            }
        }
    }

    protected void onUpdate(SharedContextEvent event) {
        this.onUpdate(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Message onUpdate(final SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        block43: {
            block41: {
                block44: {
                    block42: {
                        diff = (SharedContextValueDifference)((Object[])event.value)[0];
                        ifExists = (Boolean)((Object[])event.value)[1];
                        if (this.updateListeners != null) {
                            for (i = 0; i < this.updateListeners.size(); ++i) {
                                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, false, event.key, diff)) continue;
                                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
                            }
                        }
                        if (this.isClient && !super.containsKey(event.key)) break block41;
                        current = this.getRawLocal(event.key);
                        currentValue = this.unwrapCachedReference(current, false, false);
                        if (currentValue != null) break block42;
                        if (this.isClient) {
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                        } else if (!ifExists) {
                            return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, new SharedContextUpdateException("Current value is null. key=" + event.key));
                        }
                        break block43;
                    }
                    if (!(currentValue instanceof SharedContextValueDifferenceSupport)) break block44;
                    try {
                        isSuccess = false;
                        try {
                            isSuccess = ((SharedContextValueDifferenceSupport)currentValue).update(diff);
                            if (!isSuccess) {
                                if (this.isClient) {
                                    this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                                } else if (!this.isMain(sourceId)) {
                                    this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key});
                                } else {
                                    this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key});
                                }
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            if (this.isClient) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                            }
                            if (!this.isMain(sourceId)) {
                                this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key}, (Throwable)e);
                            }
                            this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl116
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        if (this.isClient) {
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                        }
                        if (!this.isMain(sourceId)) {
                            message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                            message.setObject(new SharedContextEvent(19, event.key));
                            this.serverConnection.request(message, this.isClient != false ? this.clientSubject : this.subject, event.key == null ? null : event.key.toString(), 1, 0L, new RequestServerConnection.ResponseCallBack(){

                                public void onResponse(Object sourceId, Message message, boolean isLast) {
                                    SharedContextService.this.onMessage(message);
                                    if (SharedContextService.this.updateListeners != null) {
                                        for (int i = 0; i < SharedContextService.this.updateListeners.size(); ++i) {
                                            ((SharedContextUpdateListener)SharedContextService.this.updateListeners.get(i)).onUpdateAfter(SharedContextService.this, false, event.key, diff);
                                        }
                                    }
                                }
                            });
                            return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
                        }
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + ((SharedContextValueDifference)event.value).getUpdateVersion());
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, th);
                    }
                }
                e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, e);
            }
            if (!this.isClient || !this.clientCacheLockMap.containsKey(event.key)) break block43;
            lock = null;
            var9_12 = this.clientCacheLockMap;
            synchronized (var9_12) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock == null) break block43;
            var9_12 = lock;
            synchronized (var9_12) {
                if (!super.containsKey(event.key)) ** GOTO lbl112
                current = this.getRawLocal(event.key);
                currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    removed = super.remove(event.key);
                    removed = this.unwrapCachedReference(removed, false, true);
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    try {
                        isSuccess = false;
                        try {
                            isSuccess = ((SharedContextValueDifferenceSupport)currentValue).update((SharedContextValueDifference)event.value);
                            if (!isSuccess) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl116
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        removed = super.remove(event.key);
                        removed = this.unwrapCachedReference(removed, false, true);
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, th);
                    }
                } else {
                    e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                    this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                    return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, e);
lbl112:
                    // 1 sources

                    lock.update((SharedContextValueDifference)event.value);
                }
            }
        }
        if (this.updateListeners != null) {
            for (i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, false, event.key, (SharedContextValueDifference)event.value);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected void onRemove(SharedContextEvent event) {
        this.onRemove(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onRemove(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, false, event.key)) continue;
                return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        if (this.isClient && this.clientCacheLockMap.containsKey(event.key)) {
            ClientCacheLock lock = null;
            Object object = this.clientCacheLockMap;
            synchronized (object) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock != null) {
                object = lock;
                synchronized (object) {
                    lock.remove();
                }
            }
        }
        Object removed = super.remove(event.key);
        removed = this.unwrapCachedReference(removed, false, true);
        if (this.indexManager.hasIndex() && removed != null) {
            this.indexManager.remove(event.key, removed);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, this.isMain(sourceId) ? removed : null);
    }

    protected void onClear(SharedContextEvent event) {
        this.onClear(event, null, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onClear(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j2;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveBefore(this, false, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            if (this.isClient && this.clientCacheLockMap.containsKey(keys[i])) {
                ClientCacheLock lock = null;
                Object j2 = this.clientCacheLockMap;
                synchronized (j2) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(keys[i]);
                }
                if (lock != null) {
                    j2 = lock;
                    synchronized (j2) {
                        lock.remove();
                    }
                }
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            if (this.indexManager.hasIndex() && removed != null) {
                this.indexManager.remove(keys[i], removed);
            }
            if (this.updateListeners == null) continue;
            for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                ((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return sourceId == null ? null : this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected Message onGet(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.getLocal(event.key));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetAll(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Map map = this.context;
            synchronized (map) {
                if (this.cacheMap == null) {
                    result.putAll(this.context);
                } else {
                    Object[] keys = null;
                    Map map2 = this.context;
                    synchronized (map2) {
                        keys = super.keySet().toArray();
                    }
                    for (int i = 0; i < keys.length; ++i) {
                        if (!this.cacheMap.containsKey(keys[i])) continue;
                        result.put(keys[i], this.cacheMap.get(keys[i]));
                    }
                }
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onKeySet(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            HashSet result = new HashSet();
            Map map = this.context;
            synchronized (map) {
                result.addAll(this.context.keySet());
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    protected Message onSize(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, new Integer(this.size()));
        }
        return null;
    }

    protected Message onContainsKey(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsKey(event.key) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onContainsValue(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsValue(event.value) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onSynchronizeAll(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        Thread synchronizeThread = new Thread(){

            public void run() {
                Message response = null;
                try {
                    SharedContextService.this.synchronize((Long)event.value);
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
                }
                catch (SharedContextSendException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                catch (SharedContextTimeoutException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                try {
                    SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        synchronizeThread.start();
        return null;
    }

    protected Message onSynchronize(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isClient || !this.isMain(sourceId)) {
            return null;
        }
        if (this.containsKeyLocal(event.key)) {
            return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(20, event.key, this.getLocal(event.key)));
        }
        return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(2, event.key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetLock(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Lock lock = null;
            Map map = this.keyLockMap;
            synchronized (map) {
                lock = (Lock)this.keyLockMap.get(event.key);
                if (lock == null) {
                    lock = new Lock(event.key);
                    this.keyLockMap.put(event.key, lock);
                }
            }
            long timeout = (Long)event.value;
            long start = System.currentTimeMillis();
            if (lock.acquireForReply(sourceId, timeout, sourceId, sequence, responseSubject, responseKey)) {
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    lock.release(sourceId, false);
                    return this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                    message.setSubject(this.clientSubject, event.key == null ? null : event.key.toString());
                    final Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    receiveClients.remove(sourceId);
                    if (receiveClients.size() == 0) {
                        return this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
                    }
                    message.setDestinationIds(receiveClients);
                    message.setObject(new SharedContextEvent(13, event.key, new Object[]{sourceId, new Long(timeout)}));
                    this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, event.key == null ? null : event.key.toString(), 0, timeout, new RequestServerConnection.ResponseCallBack(){

                        public void onResponse(Object fromId, Message response, boolean isLast) {
                            if (receiveClients.size() == 0) {
                                return;
                            }
                            try {
                                if (response == null) {
                                    SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE));
                                    receiveClients.clear();
                                    return;
                                }
                                receiveClients.remove(fromId);
                                Object ret = response.getObject();
                                response.recycle();
                                if (ret == null || ret instanceof Throwable || !((Boolean)ret).booleanValue()) {
                                    SharedContextService.this.unlock(event.key);
                                    SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret));
                                    receiveClients.clear();
                                } else if (isLast) {
                                    SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret));
                                }
                            }
                            catch (Throwable th) {
                                try {
                                    SharedContextService.this.unlock(event.key);
                                }
                                catch (SharedContextSendException e) {
                                    SharedContextService.this.getLogger().write("SCS__00007", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, event.key}, (Throwable)e);
                                }
                                try {
                                    SharedContextService.this.serverConnection.response(sourceId, sequence, SharedContextService.this.createResponseMessage(responseSubject, responseKey, th));
                                }
                                catch (MessageSendException e) {
                                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, event.key}, (Throwable)e);
                                }
                            }
                        }
                    });
                }
                catch (Throwable th) {
                    try {
                        this.unlock(event.key);
                    }
                    catch (SharedContextSendException e) {
                        this.getLogger().write("SCS__00007", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                    }
                    return this.createResponseMessage(responseSubject, responseKey, th);
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGotLock(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
            if (lock == null) {
                lock = new Lock(event.key);
                this.keyLockMap.put(event.key, lock);
            }
        }
        Object[] params = (Object[])event.value;
        Object id = params[0];
        long timeout = (Long)params[1];
        try {
            if (lock.acquireForReply(id, timeout, sourceId, sequence, responseSubject, responseKey)) {
                return this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
            }
            return null;
        }
        catch (Throwable th) {
            lock.release(id, false);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReleaseLock(SharedContextEvent event) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
        }
        if (lock != null) {
            lock.release(event.value, true);
        }
    }

    protected Message onSave(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (!(this.isClient || !this.isMain(sourceId) && this.isSaveOnlyMain)) {
            Thread saveThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.save();
                        } else {
                            SharedContextService.super.save(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            saveThread.start();
        }
        return null;
    }

    protected Message onLoad(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.load();
                        } else {
                            SharedContextService.super.load(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onLoadKey(SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        SharedContextService.super.loadKey();
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onAnalyzeKeyIndex(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isClient) {
            return null;
        }
        try {
            this.analyzeIndex((String)event.key);
            return this.createResponseMessage(responseSubject, responseKey, null);
        }
        catch (Throwable th) {
            this.getLogger().write("SCS__00008", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, th);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    protected Message onSearchIndex(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            SearchEvent searchEvent = (SearchEvent)event.value;
            Object result = null;
            byte type = searchEvent.type;
            Object[] args = searchEvent.arguments;
            try {
                switch (type) {
                    case 1: {
                        result = this.indexManager.searchKey((String)args[0], (String[])args[1]);
                        break;
                    }
                    case 2: {
                        result = this.indexManager.searchNull((String)args[0], (String)args[1]);
                        break;
                    }
                    case 3: {
                        result = this.indexManager.searchNotNull((String)args[0], (String)args[1]);
                        break;
                    }
                    case 4: {
                        result = this.indexManager.searchBy(args[0], (String)args[1], (String[])args[2]);
                        break;
                    }
                    case 5: {
                        result = this.indexManager.searchIn((String)args[0], (String[])args[1], (Object[])args[2]);
                        break;
                    }
                    case 6: {
                        result = this.indexManager.searchByProperty(args[0], (String)args[1], (String)args[2]);
                        break;
                    }
                    case 7: {
                        result = this.indexManager.searchInProperty((String)args[0], (String)args[1], (Object[])args[2]);
                        break;
                    }
                    case 8: {
                        result = this.indexManager.searchByProperty((Map)args[0], (String)args[1]);
                        break;
                    }
                    case 9: {
                        result = this.indexManager.searchInProperty((String)args[0], (Map[])args[1]);
                        break;
                    }
                    case 10: {
                        if (args[0] == null) {
                            result = this.indexManager.searchFrom(args[3], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchFrom(args[3]);
                        break;
                    }
                    case 11: {
                        if (args[0] == null) {
                            result = this.indexManager.searchFromProperty(args[3], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchFromProperty(args[3]);
                        break;
                    }
                    case 12: {
                        if (args[0] == null) {
                            result = this.indexManager.searchTo(args[3], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchTo(args[3]);
                        break;
                    }
                    case 13: {
                        if (args[0] == null) {
                            result = this.indexManager.searchToProperty(args[3], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchToProperty(args[3]);
                        break;
                    }
                    case 14: {
                        if (args[0] == null) {
                            result = this.indexManager.searchRange(args[3], args[4], (String)args[1], (String)args[2]);
                            break;
                        }
                        result = this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchRange(args[3], args[4]);
                        break;
                    }
                    case 15: {
                        result = args[0] == null ? this.indexManager.searchRangeProperty(args[3], args[4], (String)args[1], (String)args[2]) : this.indexManager.createTemporaryIndex((Set)args[0], (String)args[1], (String)args[2]).searchRangeProperty(args[3], args[4]);
                    }
                }
            }
            catch (Throwable th) {
                result = th;
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    protected void onExecuteInterpret(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain(sourceId)) {
            this.executeQueueHandlerContainer.push(new AsynchContext(new Object[]{event.key, event.value, responseSubject, responseKey, sourceId, new Integer(sequence)}));
        }
    }

    protected Message onGetUpdateLock(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        Thread lockThread = new Thread(){

            public void run() {
                long timeout = (Long)event.value;
                Message response = null;
                try {
                    boolean locked = SharedContextService.this.updateLock.acquireForLock(sourceId, timeout);
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, locked ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable th) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                }
                try {
                    SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        lockThread.start();
        return null;
    }

    protected void onReleaseUpdateLock(SharedContextEvent event) {
        this.updateLock.releaseForLock(event.key);
    }

    protected static class SearchEvent
    implements Externalizable {
        public static final byte TYPE_KEY = 1;
        public static final byte TYPE_NULL = 2;
        public static final byte TYPE_NOT_NULL = 3;
        public static final byte TYPE_BY = 4;
        public static final byte TYPE_IN = 5;
        public static final byte TYPE_BY_PROP = 6;
        public static final byte TYPE_IN_PROP = 7;
        public static final byte TYPE_BY_PROP_MAP = 8;
        public static final byte TYPE_IN_PROP_MAP = 9;
        public static final byte TYPE_FROM = 10;
        public static final byte TYPE_FROM_PROP = 11;
        public static final byte TYPE_TO = 12;
        public static final byte TYPE_TO_PROP = 13;
        public static final byte TYPE_RANGE = 14;
        public static final byte TYPE_RANGE_PROP = 15;
        public byte type;
        public Object[] arguments;

        public SearchEvent(byte type, Object[] args) {
            this.type = type;
            this.arguments = args;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.arguments);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.arguments = (Object[])in.readObject();
        }
    }

    protected class SharedContextViewImpl
    implements SharedContextView,
    Cloneable {
        protected static final int OPERATOR_AND = 1;
        protected static final int OPERATOR_OR = 2;
        protected static final int OPERATOR_NAND = 3;
        protected static final int OPERATOR_NOR = 4;
        protected static final int OPERATOR_XOR = 5;
        protected static final int OPERATOR_XNOR = 6;
        protected static final int OPERATOR_IMP = 7;
        protected static final int OPERATOR_NIMP = 8;
        protected static final int OPERATOR_CIMP = 9;
        protected static final int OPERATOR_CNIMP = 10;
        protected Set resultSet;
        protected int operator = 1;

        public Set getResultSet() {
            return this.resultSet == null ? SharedContextService.this.indexManager.keySet() : this.resultSet;
        }

        public SharedContextView and() {
            this.operator = 1;
            return this;
        }

        public SharedContextView or() {
            this.operator = 2;
            return this;
        }

        public SharedContextView nand() {
            this.operator = 3;
            return this;
        }

        public SharedContextView nor() {
            this.operator = 4;
            return this;
        }

        public SharedContextView xor() {
            this.operator = 5;
            return this;
        }

        public SharedContextView xnor() {
            this.operator = 6;
            return this;
        }

        public SharedContextView imp() {
            this.operator = 7;
            return this;
        }

        public SharedContextView nimp() {
            this.operator = 8;
            return this;
        }

        public SharedContextView cimp() {
            this.operator = 9;
            return this;
        }

        public SharedContextView cnimp() {
            this.operator = 10;
            return this;
        }

        protected void operate(Set keys) {
            if (keys == null) {
                keys = new HashSet(0);
            }
            switch (this.operator) {
                case 2: {
                    this.resultSet.addAll(keys);
                    break;
                }
                case 3: {
                    this.resultSet.retainAll(keys);
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 4: {
                    this.resultSet.addAll(keys);
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 5: {
                    HashSet tmpSet = new HashSet(this.resultSet);
                    tmpSet.retainAll(keys);
                    this.resultSet.addAll(keys);
                    this.resultSet.removeAll(tmpSet);
                    break;
                }
                case 6: {
                    Set tmpSet = new HashSet(this.resultSet);
                    tmpSet.retainAll(keys);
                    this.resultSet.addAll(keys);
                    this.resultSet.removeAll(tmpSet);
                    tmpSet = SharedContextService.this.indexManager.keySet();
                    tmpSet.removeAll(this.resultSet);
                    this.resultSet = tmpSet;
                    break;
                }
                case 7: {
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(this.resultSet);
                    all.addAll(keys);
                    this.resultSet = all;
                    break;
                }
                case 8: {
                    this.resultSet.removeAll(keys);
                    break;
                }
                case 9: {
                    Set all = SharedContextService.this.indexManager.keySet();
                    all.removeAll(keys);
                    all.addAll(this.resultSet);
                    this.resultSet = all;
                    break;
                }
                case 10: {
                    HashSet targetSet = new HashSet(keys);
                    targetSet.removeAll(this.resultSet);
                    this.resultSet = targetSet;
                    break;
                }
                default: {
                    this.resultSet.retainAll(keys);
                }
            }
        }

        public SharedContextView not() {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        public SharedContextView and(SharedContextView view) {
            this.resultSet.retainAll(view.getResultSet());
            return this;
        }

        public SharedContextView or(SharedContextView view) {
            this.resultSet.addAll(view.getResultSet());
            return this;
        }

        public SharedContextView nand(SharedContextView view) {
            this.resultSet.retainAll(view.getResultSet());
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        public SharedContextView nor(SharedContextView view) {
            this.resultSet.addAll(view.getResultSet());
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        public SharedContextView xor(SharedContextView view) {
            HashSet andSet = new HashSet(this.resultSet);
            andSet.retainAll(view.getResultSet());
            this.resultSet.addAll(view.getResultSet());
            this.resultSet.removeAll(andSet);
            return this;
        }

        public SharedContextView xnor(SharedContextView view) {
            Set tmpSet = new HashSet(this.resultSet);
            tmpSet.retainAll(view.getResultSet());
            this.resultSet.addAll(view.getResultSet());
            this.resultSet.removeAll(tmpSet);
            tmpSet = SharedContextService.this.indexManager.keySet();
            tmpSet.removeAll(this.resultSet);
            this.resultSet = tmpSet;
            return this;
        }

        public SharedContextView imp(SharedContextView view) {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(this.resultSet);
            all.addAll(view.getResultSet());
            this.resultSet = all;
            return this;
        }

        public SharedContextView nimp(SharedContextView view) {
            this.resultSet.removeAll(view.getResultSet());
            return this;
        }

        public SharedContextView cimp(SharedContextView view) {
            Set all = SharedContextService.this.indexManager.keySet();
            all.removeAll(view.getResultSet());
            all.addAll(this.resultSet);
            this.resultSet = all;
            return this;
        }

        public SharedContextView cnimp(SharedContextView view) {
            HashSet targetSet = new HashSet(view.getResultSet());
            targetSet.removeAll(this.resultSet);
            this.resultSet = targetSet;
            return this;
        }

        public SharedContextView searchKey(String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchKey(SharedContextService.this.defaultTimeout, indexName, propNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchKey(long timeout, String indexName, String[] propNames) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(1, new Object[]{indexName, propNames})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchKey(this.resultSet, indexName, propNames);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchKey(indexName, propNames));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNull(SharedContextService.this.defaultTimeout, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(2, new Object[]{indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchNull(new HashSet(), indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchNull(indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchNotNull(String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchNotNull(SharedContextService.this.defaultTimeout, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchNotNull(long timeout, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(3, new Object[]{indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchNotNull(new HashSet(), indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchNotNull(indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchBy(Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchBy(SharedContextService.this.defaultTimeout, value, indexName, propNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchBy(long timeout, Object value, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(4, new Object[]{value, indexName, propNames})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchBy(new HashSet(), value, indexName, propNames);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchBy(value, indexName, propNames));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchIn(String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchIn(SharedContextService.this.defaultTimeout, indexName, propNames, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchIn(long timeout, String indexName, String[] propNames, Object[] values) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propNames)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(5, new Object[]{indexName, propNames, values})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchIn(this.resultSet, indexName, propNames, values);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchIn(indexName, propNames, values));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchByProperty(Object prop, String indexName, String propName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(SharedContextService.this.defaultTimeout, prop, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchByProperty(long timeout, Object prop, String indexName, String propName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(6, new Object[]{prop, indexName, propName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchByProperty(new HashSet(), prop, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchByProperty(prop, indexName, propName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchInProperty(String indexName, String propName, Object[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(SharedContextService.this.defaultTimeout, indexName, propName, props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchInProperty(long timeout, String indexName, String propName, Object[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(7, new Object[]{indexName, propName, props})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchInProperty(this.resultSet, indexName, propName, props);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchInProperty(indexName, propName, props));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchByProperty(Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchByProperty(SharedContextService.this.defaultTimeout, props, indexName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchByProperty(long timeout, Map props, String indexName) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, indexName == null && props != null ? props.keySet().toArray(new String[props.size()]) : null)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(8, new Object[]{props, indexName})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchByProperty(new HashSet(), props, indexName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchByProperty(props, indexName));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchInProperty(String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchInProperty(SharedContextService.this.defaultTimeout, indexName, props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchInProperty(long timeout, String indexName, Map[] props) throws IndexNotFoundException, IllegalArgumentException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, indexName == null && props != null && props.length != 0 ? props[0].keySet().toArray(new String[props[0].size()]) : null)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(9, new Object[]{indexName, props})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchInProperty(this.resultSet, indexName, props);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        this.operate(SharedContextService.this.indexManager.searchInProperty(indexName, props));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchFrom(Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFrom(SharedContextService.this.defaultTimeout, fromValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchFrom(long timeout, Object fromValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(10, new Object[]{this.resultSet, indexName, propName, fromValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFrom(this.resultSet, fromValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFrom(fromValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchFromProperty(Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchFromProperty(SharedContextService.this.defaultTimeout, fromProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchFromProperty(long timeout, Object fromProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(11, new Object[]{this.resultSet, indexName, propName, fromProp})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchFromProperty(this.resultSet, fromProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchFromProperty(fromProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchTo(Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchTo(SharedContextService.this.defaultTimeout, toValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchTo(long timeout, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(12, new Object[]{this.resultSet, indexName, propName, toValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchTo(this.resultSet, toValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchTo(toValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchToProperty(Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchToProperty(SharedContextService.this.defaultTimeout, toProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchToProperty(long timeout, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(13, new Object[]{this.resultSet, indexName, propName, toProp})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchToProperty(this.resultSet, toProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchToProperty(toProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchRange(Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRange(SharedContextService.this.defaultTimeout, fromValue, toValue, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchRange(long timeout, Object fromValue, Object toValue, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(14, new Object[]{this.resultSet, indexName, propName, fromValue, toValue})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRange(this.resultSet, fromValue, toValue, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRange(fromValue, toValue));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public SharedContextView searchRangeProperty(Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            return this.searchRangeProperty(SharedContextService.this.defaultTimeout, fromProp, toProp, indexName, propName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedContextView searchRangeProperty(long timeout, Object fromProp, Object toProp, String indexName, String propName) throws IndexNotFoundException, SharedContextSendException, SharedContextTimeoutException {
            block20: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (!SharedContextService.this.referLock.acquireForUse(timeout)) {
                        throw new SharedContextTimeoutException();
                    }
                    if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    if (SharedContextService.this.isClient && !SharedContextService.this.indexManager.hasIndex(indexName, propName)) {
                        try {
                            Message message = SharedContextService.this.serverConnection.createMessage(SharedContextService.this.subject, null);
                            Set receiveClients = SharedContextService.this.serverConnection.getReceiveClientIds(message);
                            if (receiveClients.size() != 0) {
                                message.setObject(new SharedContextEvent(22, null, new SearchEvent(15, new Object[]{fromProp, toProp, indexName, propName, this.resultSet})));
                                Message[] responses = SharedContextService.this.serverConnection.request(message, SharedContextService.this.clientSubject, null, 1, timeout);
                                Object ret = responses[0].getObject();
                                responses[0].recycle();
                                if (ret instanceof Throwable) {
                                    if (ret instanceof RuntimeException) {
                                        throw (RuntimeException)ret;
                                    }
                                    if (ret instanceof Error) {
                                        throw (Error)ret;
                                    }
                                    throw new SharedContextSendException((Throwable)ret);
                                }
                                Set result = (Set)ret;
                                if (this.resultSet == null) {
                                    this.resultSet = result;
                                    if (this.resultSet == null) {
                                        this.resultSet = new HashSet();
                                    }
                                } else {
                                    this.operate(this.resultSet);
                                }
                                break block20;
                            }
                            throw new NoConnectServerException();
                        }
                        catch (MessageException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (MessageSendException e) {
                            throw new SharedContextSendException(e);
                        }
                        catch (RequestTimeoutException e) {
                            throw new SharedContextTimeoutException(e);
                        }
                    }
                    if (this.resultSet == null) {
                        this.resultSet = SharedContextService.this.indexManager.searchRangeProperty(this.resultSet, fromProp, toProp, indexName, propName);
                        if (this.resultSet == null) {
                            this.resultSet = new HashSet();
                        }
                    } else {
                        SharedContextIndex index = SharedContextService.this.indexManager.createTemporaryIndex(this.resultSet, indexName, propName);
                        this.operate(index.searchRangeProperty(fromProp, toProp));
                    }
                }
                finally {
                    SharedContextService.this.referLock.releaseForUse();
                }
            }
            return this;
        }

        public Object clone() {
            SharedContextViewImpl clone = null;
            try {
                clone = (SharedContextViewImpl)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.resultSet != null) {
                clone.resultSet = new HashSet(this.resultSet);
            }
            this.operator = 1;
            return clone;
        }
    }

    protected class LocalSharedContext
    implements SharedContext {
        protected LocalSharedContext() {
        }

        public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public boolean unlock(Object key) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public boolean unlock(Object key, boolean force) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public Object getLockOwner(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public Object putLocal(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAsynch(Object key, Object value) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void updateLocal(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
            throw new UnsupportedOperationException();
        }

        public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void updateIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void updateIfExists(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void updateLocalIfExists(Object key, SharedContextValueDifference diff) throws SharedContextUpdateException {
            throw new UnsupportedOperationException();
        }

        public void updateAsynchIfExists(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void putAllLocal(Map t) {
            throw new UnsupportedOperationException();
        }

        public void putAllAsynch(Map t) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.getLocal(key);
        }

        public Object getLocal(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        public Object remove(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.removeLocal(key);
        }

        public Object removeLocal(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        public void removeAsynch(Object key) throws SharedContextSendException {
            SharedContextService.this.removeLocal(key);
        }

        public void clear() {
            SharedContextService.this.clearLocal();
        }

        public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            SharedContextService.this.clearLocal();
        }

        public void clearLocal() {
            SharedContextService.this.clearLocal();
        }

        public void clearAsynch() throws SharedContextSendException {
            SharedContextService.this.clearLocal();
        }

        public Set keySet() {
            return SharedContextService.this.keySetLocal();
        }

        public Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.keySetLocal();
        }

        public Set keySetLocal() {
            return SharedContextService.this.keySetLocal();
        }

        public int size() {
            return SharedContextService.this.sizeLocal();
        }

        public int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.sizeLocal();
        }

        public int sizeLocal() {
            return SharedContextService.this.sizeLocal();
        }

        public boolean isEmpty() throws SharedContextSendException {
            return SharedContextService.this.isEmptyLocal();
        }

        public boolean isEmptyLocal() {
            return SharedContextService.this.isEmptyLocal();
        }

        public boolean containsKey(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsKeyLocal(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsValue(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsValueLocal(value);
        }

        public boolean containsValueLocal(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        public Map all() {
            return SharedContextService.this.allLocal();
        }

        public Map allLocal() {
            return SharedContextService.this.allLocal();
        }

        public Set entrySet() {
            return SharedContextService.this.entrySetLocal();
        }

        public Set entrySetLocal() {
            return SharedContextService.this.entrySetLocal();
        }

        public Collection values() {
            return SharedContextService.this.valuesLocal();
        }

        public Collection valuesLocal() {
            return SharedContextService.this.valuesLocal();
        }

        public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public boolean isClient() {
            return SharedContextService.this.isClient();
        }

        public boolean isMain() {
            return SharedContextService.this.isMain();
        }

        public Object getId() {
            return SharedContextService.this.getId();
        }

        public Object getMainId() {
            return SharedContextService.this.getMainId();
        }

        public List getMemberIdList() {
            return SharedContextService.this.getMemberIdList();
        }

        public Set getClientMemberIdSet() {
            return SharedContextService.this.getClientMemberIdSet();
        }

        public Set getServerMemberIdSet() {
            return SharedContextService.this.getServerMemberIdSet();
        }

        public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.addSharedContextUpdateListener(listener);
        }

        public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.removeSharedContextUpdateListener(listener);
        }

        public void setIndex(String name, String[] props) {
            throw new UnsupportedOperationException();
        }

        public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
            throw new UnsupportedOperationException();
        }

        public void removeIndex(String name) {
            throw new UnsupportedOperationException();
        }

        public void analyzeIndex(String name) {
            throw new UnsupportedOperationException();
        }

        public SharedContextView createView() {
            return SharedContextService.this.createView();
        }

        public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void load() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void loadKey() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void load(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void load(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void loadKey(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void load(Object key, long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save(long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save(Object key, long timeout) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExecuteQueueHandler
    implements QueueHandler {
        protected ExecuteQueueHandler() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            if (ac == null) {
                return;
            }
            Object[] params = (Object[])ac.getInput();
            String query = (String)params[0];
            Map variables = (Map)params[1];
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Object ret = SharedContextService.this.executeInterpretQueryLocal(query, variables);
            Message response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret);
            try {
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            Object[] params = (Object[])ac.getInput();
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Message response = null;
            try {
                response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }
    }

    protected class SynchronizeLock {
        protected int useCount;
        protected final SynchronizeMonitor useMonitor = new WaitSynchronizeMonitor();
        protected final SynchronizeMonitor lockMonitor = new WaitSynchronizeMonitor();
        protected final Set lockOwners = new HashSet();

        protected SynchronizeLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForUse(long timeout) {
            if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                SynchronizeMonitor synchronizeMonitor = this.useMonitor;
                synchronized (synchronizeMonitor) {
                    if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                        if (this.useCount == 0) {
                            this.lockMonitor.notifyAllMonitor();
                        }
                        try {
                            if (!this.useMonitor.initAndWaitMonitor(timeout)) {
                                return false;
                            }
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                    ++this.useCount;
                }
            }
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.lockOwners.size() > 0 || this.lockMonitor.isWait()) {
                    if (this.useCount == 0) {
                        this.lockMonitor.notifyAllMonitor();
                    }
                    try {
                        if (!this.useMonitor.initAndWaitMonitor(timeout)) {
                            return false;
                        }
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                ++this.useCount;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseForUse() {
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.useCount > 0) {
                    --this.useCount;
                    if (this.useCount == 0) {
                        this.lockMonitor.notifyAllMonitor();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForLock(Object id, long timeout) {
            SynchronizeMonitor synchronizeMonitor;
            long start = System.currentTimeMillis();
            if (this.useCount <= 0) {
                synchronizeMonitor = this.useMonitor;
                synchronized (synchronizeMonitor) {
                    if (this.useCount <= 0) {
                        this.lockOwners.add(id);
                        return true;
                    }
                }
            }
            synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.useCount <= 0) {
                    this.lockOwners.add(id);
                    return true;
                }
                this.lockMonitor.initMonitor();
            }
            try {
                if (!this.lockMonitor.waitMonitor(timeout)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            if (timeout > 0L) {
                long processTime = System.currentTimeMillis() - start;
                if (processTime < timeout) {
                    return this.acquireForLock(id, timeout - processTime);
                }
                return false;
            }
            return this.acquireForLock(id, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseForLock(Object id) {
            SynchronizeMonitor synchronizeMonitor = this.useMonitor;
            synchronized (synchronizeMonitor) {
                if (this.lockOwners.size() > 0) {
                    this.lockOwners.remove(id);
                    if (this.lockOwners.size() == 0) {
                        this.useMonitor.notifyAllMonitor();
                    }
                }
            }
        }

        public void close() {
            this.useMonitor.close();
            this.lockMonitor.close();
        }
    }

    protected class ClientCacheLock {
        protected final SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        protected Object key;
        protected Object putVlaue;
        protected List updateDiffList;
        protected boolean isRemove;
        protected boolean isNotify;

        public ClientCacheLock(Object key) {
            this.key = key;
        }

        public void init() {
            this.monitor.initMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitLock(long timeout) {
            if (this.isNotify) {
                return true;
            }
            try {
                if (this.monitor.waitMonitor(timeout)) {
                    if (SharedContextService.this.getState() != 3) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.monitor.releaseMonitor();
            }
        }

        public void update(SharedContextValueDifference diff) {
            if (this.updateDiffList == null) {
                this.updateDiffList = new ArrayList();
            }
            this.updateDiffList.add(diff);
        }

        public void remove() {
            this.isRemove = true;
            this.updateDiffList = null;
            this.putVlaue = null;
        }

        public void put(Object value) {
            this.isRemove = false;
            this.updateDiffList = null;
            this.putVlaue = value;
        }

        protected boolean isRemove() {
            return this.isRemove;
        }

        public Object updateValue(Object value) throws SharedContextUpdateException {
            if (this.putVlaue != null) {
                return this.putVlaue;
            }
            if (this.updateDiffList != null) {
                if (value instanceof SharedContextValueDifferenceSupport) {
                    for (int i = 0; i < this.updateDiffList.size(); ++i) {
                        SharedContextValueDifference diff = (SharedContextValueDifference)this.updateDiffList.get(i);
                        if (((SharedContextValueDifferenceSupport)value).update(diff)) continue;
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)value).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + this.key + ", value=" + value);
                }
            }
            return value;
        }

        public void notifyAllLock() {
            this.isNotify = true;
            this.monitor.notifyAllMonitor();
        }
    }

    protected class Lock {
        protected Object key;
        protected Object owner;
        protected Thread ownerThread;
        protected final SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        protected Set callbacks = new LinkedHashSet();

        public Lock(Object key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire(Object id, long timeout) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null) {
                    if (SharedContextService.this.getState() != 3) {
                        return false;
                    }
                    this.owner = id;
                    if (isLocal) {
                        this.ownerThread = Thread.currentThread();
                    }
                    Map map = SharedContextService.this.idLocksMap;
                    synchronized (map) {
                        HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                        if (keySet == null) {
                            keySet = new HashSet<Object>();
                            SharedContextService.this.idLocksMap.put(id, keySet);
                        }
                        HashSet<Object> hashSet = keySet;
                        synchronized (hashSet) {
                            keySet.add(this.key);
                        }
                    }
                    return true;
                }
                if (id.equals(this.owner)) {
                    return isLocal ? Thread.currentThread().equals(this.ownerThread) : true;
                }
            }
            try {
                long start = System.currentTimeMillis();
                if (this.monitor.initAndWaitMonitor(timeout)) {
                    if ((timeout -= System.currentTimeMillis() - start) <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = this.acquire(id, timeout);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.monitor.releaseMonitor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForReply(Object id, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null) {
                    if (SharedContextService.this.getState() != 3) {
                        return false;
                    }
                    this.owner = id;
                    if (isLocal) {
                        this.ownerThread = Thread.currentThread();
                    }
                    Map map = SharedContextService.this.idLocksMap;
                    synchronized (map) {
                        HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                        if (keySet == null) {
                            keySet = new HashSet<Object>();
                            SharedContextService.this.idLocksMap.put(id, keySet);
                        }
                        HashSet<Object> hashSet = keySet;
                        synchronized (hashSet) {
                            keySet.add(this.key);
                        }
                    }
                    return true;
                }
                if (id.equals(this.owner)) {
                    return isLocal ? Thread.currentThread().equals(this.ownerThread) : true;
                }
                NotifyCallback callback = new NotifyCallback(id, timeout, sourceId, sequence, responseSubject, responseKey);
                this.callbacks.add(callback);
                if (timeout > 0L) {
                    SharedContextService.this.lockTimeoutTimer.schedule((TimerTask)callback, timeout);
                }
            }
            return false;
        }

        public Object getOwner() {
            return this.owner;
        }

        public Thread getOwnerThread() {
            return this.ownerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release(Object id, boolean force) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            boolean result = false;
            TimerTask callback = null;
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null || id.equals(this.owner) && (force || !isLocal || Thread.currentThread().equals(this.ownerThread))) {
                    this.owner = null;
                    this.ownerThread = null;
                    result = true;
                }
                Map map = SharedContextService.this.idLocksMap;
                synchronized (map) {
                    Set keySet = (Set)SharedContextService.this.idLocksMap.get(id);
                    if (keySet != null) {
                        Set set = keySet;
                        synchronized (set) {
                            keySet.remove(this.key);
                        }
                    }
                }
                if (this.monitor.isWait()) {
                    this.monitor.notifyMonitor();
                } else if (this.callbacks.size() != 0) {
                    Iterator itr = this.callbacks.iterator();
                    callback = (NotifyCallback)itr.next();
                    itr.remove();
                }
            }
            if (callback != null) {
                callback.cancel();
                ((NotifyCallback)callback).notify(true);
            }
            return result;
        }

        protected class NotifyCallback
        extends TimerTask {
            protected Object id;
            protected long startTime;
            protected long timeout;
            protected Object sourceId;
            protected int sequence;
            protected String responseSubject;
            protected String responseKey;

            public NotifyCallback(Object id, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
                this.id = id;
                this.sourceId = sourceId;
                this.sequence = sequence;
                this.responseSubject = responseSubject;
                this.responseKey = responseKey;
                this.timeout = timeout;
                this.startTime = System.currentTimeMillis();
            }

            public void notify(boolean notify) {
                if (notify) {
                    if (this.timeout <= 0L) {
                        if (!Lock.this.acquireForReply(this.id, this.timeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                            return;
                        }
                    } else {
                        long currentTimeout = this.startTime + this.timeout - System.currentTimeMillis();
                        if (currentTimeout > 0L) {
                            if (!Lock.this.acquireForReply(this.id, currentTimeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                                return;
                            }
                        } else {
                            notify = false;
                        }
                    }
                }
                Message response = null;
                try {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, notify ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable th) {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, th);
                }
                try {
                    ((Lock)Lock.this).SharedContextService.this.serverConnection.response(this.sourceId, this.sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{((Lock)Lock.this).SharedContextService.this.isClient ? ((Lock)Lock.this).SharedContextService.this.clientSubject : ((Lock)Lock.this).SharedContextService.this.subject, response}, (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isRemoved = false;
                Lock lock = Lock.this;
                synchronized (lock) {
                    isRemoved = Lock.this.callbacks.remove(this);
                }
                if (isRemoved) {
                    this.notify(false);
                }
            }
        }
    }

    protected static class SharedContextEvent
    implements Externalizable {
        public static final byte EVENT_PUT = 1;
        public static final byte EVENT_REMOVE = 2;
        public static final byte EVENT_CLEAR = 3;
        public static final byte EVENT_GET_ALL = 4;
        public static final byte EVENT_GET = 5;
        public static final byte EVENT_PUT_ALL = 6;
        public static final byte EVENT_KEY_SET = 7;
        public static final byte EVENT_SIZE = 8;
        public static final byte EVENT_CONTAINS_KEY = 9;
        public static final byte EVENT_CONTAINS_VALUE = 10;
        public static final byte EVENT_SYNCH_ALL = 11;
        public static final byte EVENT_GET_LOCK = 12;
        public static final byte EVENT_GOT_LOCK = 13;
        public static final byte EVENT_RELEASE_LOCK = 14;
        public static final byte EVENT_SAVE = 15;
        public static final byte EVENT_LOAD = 16;
        public static final byte EVENT_LOAD_KEY = 17;
        public static final byte EVENT_UPDATE = 18;
        public static final byte EVENT_SYNCH = 19;
        public static final byte EVENT_PUT_INNER = 20;
        public static final byte EVENT_ANALYZE_KEY_INDEX = 21;
        public static final byte EVENT_SEARCH_INDEX = 22;
        public static final byte EVENT_EXECUTE_INTERPRET = 23;
        public static final byte EVENT_GET_UPDATE_LOCK = 24;
        public static final byte EVENT_RELEASE_UPDATE_LOCK = 25;
        public byte type;
        public Object key;
        public Object value;

        public SharedContextEvent() {
        }

        public SharedContextEvent(byte type) {
            this(type, null, null);
        }

        public SharedContextEvent(byte type, Object key) {
            this(type, key, null);
        }

        public SharedContextEvent(byte type, Object key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.key);
            out.writeObject(this.value);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.key = in.readObject();
            this.value = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("type=").append(this.type);
            buf.append(", key=").append(this.key);
            buf.append(", value=").append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

