/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class IntegerGene
extends AbstractGene {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;
    public static final int CROSSOVER_AVERAGE = 5;
    public static final int CROSSOVER_RANDOM_RANGE = 6;
    public static final int MUTATE_SINGLE = 1;
    public static final int MUTATE_UNIFORM = 2;
    protected int maxValue = Integer.MAX_VALUE;
    protected int minValue = Integer.MIN_VALUE;
    protected float randomRangeMargin = 0.0f;

    public IntegerGene() {
        this.crossoverType = 6;
        this.mutateType = 2;
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int min) {
        this.minValue = min;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setRandomRangeMargin(float margin) {
        this.randomRangeMargin = margin;
    }

    public float getRandomRangeMargin() {
        return this.randomRangeMargin;
    }

    public void random(Random random) {
        this.setValue(new Integer(this.randomValue(random)));
    }

    protected int randomValue(Random random) {
        int result = 0;
        if (this.maxValue == this.minValue) {
            result = this.maxValue;
        } else if (this.maxValue >= 0 && this.minValue >= 0) {
            int range = this.maxValue - this.minValue;
            result = range == Integer.MAX_VALUE ? random.nextInt() : random.nextInt(range + 1);
            result += this.minValue;
        } else if (this.maxValue < 0 && this.minValue < 0) {
            int range = Math.abs(this.maxValue - this.minValue);
            result = -(range == Integer.MAX_VALUE ? random.nextInt() : random.nextInt(range + 1));
            result += this.maxValue;
        } else {
            boolean isPlus = random.nextBoolean();
            if (isPlus) {
                result = this.maxValue == Integer.MAX_VALUE ? random.nextInt() : random.nextInt(this.maxValue + 1);
            } else {
                int range = Math.abs(this.minValue + 1);
                result = range == Integer.MAX_VALUE ? random.nextInt() : random.nextInt(range + 1);
                result = -result - 1;
            }
        }
        return result;
    }

    public void crossover(Random random, Gene gene) {
        int result = 0;
        switch (this.crossoverType) {
            case 1: {
                result = this.crossoverBySinglePoint(random, gene);
                break;
            }
            case 2: {
                result = this.crossoverByTwoPoint(random, gene);
                break;
            }
            case 4: {
                result = this.crossoverByAllPoint(random, gene);
                break;
            }
            case 5: {
                result = this.crossoverByAverage(random, gene);
                break;
            }
            case 6: {
                result = this.crossoverByRandomRange(random, gene);
                break;
            }
            default: {
                result = this.crossoverByUniformPoint(random, gene);
            }
        }
        this.setValue(new Integer(this.mutate(random, result)));
        this.setCrossover(true);
    }

    protected int getMaxBitIndex(int val1, int val2) {
        int val;
        int tmpValue = val = Math.max(Math.abs(val1), Math.abs(val2));
        for (int i = 0; i < 31; ++i) {
            tmpValue <<= i + 1;
            if ((tmpValue >>= i + 1) == val) continue;
            return i + 1;
        }
        return 32;
    }

    protected int crossoverBySinglePoint(Random random, Gene gene) {
        int result;
        int val1 = (Integer)this.value;
        int val2 = (Integer)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(val1, val2);
        int crossoverPoint = 0;
        if (maxBitIndex >= 31) {
            return (Integer)gene.getValue();
        }
        crossoverPoint = maxBitIndex == 30 ? 31 : random.nextInt(32 - maxBitIndex - 1) + 1;
        val1 >>= crossoverPoint;
        val1 <<= crossoverPoint;
        boolean isMinus = Math.abs(val2) != val2;
        val2 <<= 31 - crossoverPoint;
        val2 >>>= 31 - crossoverPoint;
        if (isMinus) {
            val2 = -val2;
        }
        if ((result = val1 | val2) > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected int crossoverByTwoPoint(Random random, Gene gene) {
        int val1 = (Integer)this.value;
        int val2 = (Integer)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(val1, val2);
        int crossoverPoint1 = 0;
        int crossoverPoint2 = 0;
        if (maxBitIndex >= 31) {
            return (Integer)gene.getValue();
        }
        if (maxBitIndex == 30) {
            return this.crossoverBySinglePoint(random, gene);
        }
        if (maxBitIndex == 29) {
            crossoverPoint1 = 2;
            crossoverPoint2 = 1;
        } else {
            crossoverPoint1 = random.nextInt(32 - maxBitIndex - 2) + 2;
            crossoverPoint2 = random.nextInt(crossoverPoint1 - 1) + 1;
        }
        int mask = 0;
        for (int i = 32; i >= 1; --i) {
            if (i > crossoverPoint1 || i <= crossoverPoint2) {
                mask |= 1;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        int result = (val1 &= mask) | (val2 &= ~mask);
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected int crossoverByUniformPoint(Random random, Gene gene) {
        int val2;
        int val1 = (Integer)this.value;
        int maxBitIndex = this.getMaxBitIndex(val1, val2 = ((Integer)gene.getValue()).intValue());
        if (maxBitIndex >= 31) {
            return (Integer)gene.getValue();
        }
        int mask = 0;
        for (int i = 32; i >= 1; --i) {
            if (i <= 32 - maxBitIndex && random.nextBoolean()) {
                mask |= 1;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        int result = val1 & ~mask | val2 & mask;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected int crossoverByAllPoint(Random random, Gene gene) {
        return (Integer)gene.getValue();
    }

    protected int crossoverByAverage(Random random, Gene gene) {
        int val1 = (Integer)this.value;
        int val2 = (Integer)gene.getValue();
        return (int)Math.round((double)(val1 + val2) / 2.0);
    }

    protected int crossoverByRandomRange(Random random, Gene gene) {
        int val1 = (Integer)this.value;
        int val2 = (Integer)gene.getValue();
        int range = Math.abs(val1 - val2);
        int margin = this.randomRangeMargin == 0.0f ? 0 : Math.round((float)range * this.randomRangeMargin);
        int result = Math.round(random.nextFloat() * (float)(range + margin)) + Math.min(val1, val2) - margin / 2;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected int mutate(Random random, int val) {
        int result = val;
        if (this.isMutate(random)) {
            switch (this.mutateType) {
                case 2: {
                    result = this.mutateByUniform(random, val);
                    break;
                }
                default: {
                    result = this.mutateBySingle(random, val);
                }
            }
            this.setMutate(true);
        }
        return result;
    }

    protected int mutateBySingle(Random random, int val) {
        int mask;
        int result = val;
        int maxBitIndex = this.getMaxBitIndex(this.maxValue, this.minValue);
        do {
            int index = random.nextInt(32 - maxBitIndex);
            mask = 1;
            if (index <= 0) continue;
            mask <<= index;
        } while ((result = (val & mask) == 0 ? val | mask : val & ~mask) > this.maxValue || result < this.minValue);
        return result;
    }

    protected int mutateByUniform(Random random, int val) {
        return this.randomValue(random);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.maxValue);
        out.writeInt(this.minValue);
        out.writeFloat(this.randomRangeMargin);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.maxValue = in.readInt();
        this.minValue = in.readInt();
        this.randomRangeMargin = in.readFloat();
    }
}

