/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class LongGene
extends AbstractGene {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;
    public static final int CROSSOVER_AVERAGE = 5;
    public static final int CROSSOVER_RANDOM_RANGE = 6;
    public static final int MUTATE_SINGLE = 1;
    public static final int MUTATE_UNIFORM = 2;
    protected long maxValue = Long.MAX_VALUE;
    protected long minValue = Long.MIN_VALUE;
    protected float randomRangeMargin = 0.0f;

    public LongGene() {
        this.crossoverType = 6;
        this.mutateType = 2;
    }

    public void setMaxValue(long max) {
        this.maxValue = max;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(long min) {
        this.minValue = min;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setRandomRangeMargin(float margin) {
        this.randomRangeMargin = margin;
    }

    public float getRandomRangeMargin() {
        return this.randomRangeMargin;
    }

    public void random(Random random) {
        this.setValue(new Long(this.randomValue(random)));
    }

    protected long randomValue(Random random) {
        long result = 0L;
        if (this.maxValue == this.minValue) {
            result = this.maxValue;
        } else if (this.maxValue >= 0L && this.minValue >= 0L) {
            long range = this.maxValue - this.minValue;
            result = range == Long.MAX_VALUE ? random.nextLong() : LongGene.nextLong(random, range + 1L);
            result += this.minValue;
        } else if (this.maxValue < 0L && this.minValue < 0L) {
            long range = Math.abs(this.maxValue - this.minValue);
            result = -(range == Long.MAX_VALUE ? random.nextLong() : LongGene.nextLong(random, range + 1L));
            result += this.maxValue;
        } else {
            boolean isPlus = random.nextBoolean();
            if (isPlus) {
                result = this.maxValue == Long.MAX_VALUE ? random.nextLong() : LongGene.nextLong(random, this.maxValue + 1L);
            } else {
                long range = Math.abs(this.minValue + 1L);
                result = range == Long.MAX_VALUE ? random.nextLong() : LongGene.nextLong(random, range + 1L);
                result = -result - 1L;
            }
        }
        return result;
    }

    protected static long nextLong(Random random, long n) {
        long val;
        long bits;
        do {
            if ((bits = random.nextLong()) >= 0L) continue;
            bits -= Long.MIN_VALUE;
        } while (bits - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    public void crossover(Random random, Gene gene) {
        long result = 0L;
        switch (this.crossoverType) {
            case 1: {
                result = this.crossoverBySinglePoint(random, gene);
                break;
            }
            case 2: {
                result = this.crossoverByTwoPoint(random, gene);
                break;
            }
            case 4: {
                result = this.crossoverByAllPoint(random, gene);
                break;
            }
            case 5: {
                result = this.crossoverByAverage(random, gene);
                break;
            }
            case 6: {
                result = this.crossoverByRandomRange(random, gene);
                break;
            }
            default: {
                result = this.crossoverByUniformPoint(random, gene);
            }
        }
        this.setValue(new Long(this.mutate(random, result)));
        this.setCrossover(true);
    }

    protected int getMaxBitIndex(long val1, long val2) {
        long val;
        long tmpValue = val = Math.max(Math.abs(val1), Math.abs(val2));
        for (int i = 0; i < 63; ++i) {
            tmpValue <<= i + 1;
            if ((tmpValue >>= i + 1) == val) continue;
            return i + 1;
        }
        return 32;
    }

    protected long crossoverBySinglePoint(Random random, Gene gene) {
        long result;
        long val1 = (Long)this.value;
        long val2 = (Long)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(val1, val2);
        int crossoverPoint = 0;
        if (maxBitIndex >= 63) {
            return (Long)gene.getValue();
        }
        crossoverPoint = maxBitIndex == 62 ? 63 : random.nextInt(64 - maxBitIndex - 1) + 1;
        val1 >>= crossoverPoint;
        val1 <<= crossoverPoint;
        boolean isMinus = Math.abs(val2) != val2;
        val2 <<= 63 - crossoverPoint;
        val2 >>>= 63 - crossoverPoint;
        if (isMinus) {
            val2 = -val2;
        }
        if ((result = val1 | val2) > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected long crossoverByTwoPoint(Random random, Gene gene) {
        long val1 = (Long)this.value;
        long val2 = (Long)gene.getValue();
        int maxBitIndex = this.getMaxBitIndex(val1, val2);
        int crossoverPoint1 = 0;
        int crossoverPoint2 = 0;
        if (maxBitIndex >= 63) {
            return (Long)gene.getValue();
        }
        if (maxBitIndex == 62) {
            return this.crossoverBySinglePoint(random, gene);
        }
        if (maxBitIndex == 61) {
            crossoverPoint1 = 2;
            crossoverPoint2 = 1;
        } else {
            crossoverPoint1 = random.nextInt(64 - maxBitIndex - 2) + 2;
            crossoverPoint2 = random.nextInt(crossoverPoint1 - 1) + 1;
        }
        long mask = 0L;
        for (int i = 64; i >= 1; --i) {
            if (i > crossoverPoint1 || i <= crossoverPoint2) {
                mask |= 1L;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        long result = (val1 &= mask) | (val2 &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected long crossoverByUniformPoint(Random random, Gene gene) {
        long val2;
        long val1 = (Long)this.value;
        int maxBitIndex = this.getMaxBitIndex(val1, val2 = ((Long)gene.getValue()).longValue());
        if (maxBitIndex >= 63) {
            return (Long)gene.getValue();
        }
        long mask = 0L;
        for (int i = 64; i >= 1; --i) {
            if (i <= 64 - maxBitIndex && random.nextBoolean()) {
                mask |= 1L;
            }
            if (i == 1) continue;
            mask <<= 1;
        }
        long result = val1 & (mask ^ 0xFFFFFFFFFFFFFFFFL) | val2 & mask;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected long crossoverByAllPoint(Random random, Gene gene) {
        return (Long)gene.getValue();
    }

    protected long crossoverByAverage(Random random, Gene gene) {
        BigDecimal val1 = BigDecimal.valueOf((Long)this.value);
        BigDecimal val2 = BigDecimal.valueOf((Long)gene.getValue());
        BigDecimal sum = val1.add(val2);
        BigDecimal result = sum.divide(new BigDecimal(2.0), 6);
        return Math.round(result.floatValue());
    }

    protected long crossoverByRandomRange(Random random, Gene gene) {
        long val1 = (Long)this.value;
        long val2 = (Long)gene.getValue();
        long range = Math.abs(val1 - val2);
        long margin = this.randomRangeMargin == 0.0f ? 0L : (long)Math.round((float)range * this.randomRangeMargin);
        long result = Math.round(random.nextDouble() * (double)(range + margin)) + Math.min(val1, val2) - margin / 2L;
        if (result > this.maxValue) {
            result = this.maxValue;
        } else if (result < this.minValue) {
            result = this.minValue;
        }
        return result;
    }

    protected long mutate(Random random, long val) {
        long result = val;
        if (this.isMutate(random)) {
            switch (this.mutateType) {
                case 2: {
                    result = this.mutateByUniform(random, val);
                    break;
                }
                default: {
                    result = this.mutateBySingle(random, val);
                }
            }
            this.setMutate(true);
        }
        return result;
    }

    protected long mutateBySingle(Random random, long val) {
        long mask;
        long result = val;
        int maxBitIndex = this.getMaxBitIndex(this.maxValue, this.minValue);
        do {
            int index = random.nextInt(64 - maxBitIndex);
            mask = 1L;
            if (index <= 0) continue;
            mask <<= index;
        } while ((result = (val & mask) == 0L ? val | mask : val & (mask ^ 0xFFFFFFFFFFFFFFFFL)) > this.maxValue || result < this.minValue);
        return result;
    }

    protected long mutateByUniform(Random random, long val) {
        return this.randomValue(random);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.maxValue);
        out.writeLong(this.minValue);
        out.writeFloat(this.randomRangeMargin);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.maxValue = in.readLong();
        this.minValue = in.readLong();
        this.randomRangeMargin = in.readFloat();
    }
}

