/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageProducerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactoryServiceMBean;
import jp.ossc.nimbus.service.jms.JMSSessionCreateException;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class JMSMessageProducerFactoryService
extends ServiceBase
implements JMSMessageProducerFactory,
JMSMessageProducerFactoryServiceMBean {
    private static final long serialVersionUID = 8090980996008836232L;
    protected ServiceName jmsSessionFactoryServiceName;
    protected JMSSessionFactory jmsSessionFactory;
    protected ServiceName destinationFinderServiceName;
    protected JndiFinder destinationFinder;
    protected String destinationName;
    protected Destination destination;
    protected Session session;
    protected boolean isSessionCreate;
    protected boolean isCloseSession;
    protected int deliveryMode = 2;
    protected int priority = 4;
    protected long timeToLive = 0L;

    public void setJMSSessionFactoryServiceName(ServiceName name) {
        this.jmsSessionFactoryServiceName = name;
    }

    public ServiceName getJMSSessionFactoryServiceName() {
        return this.jmsSessionFactoryServiceName;
    }

    public void setDestinationFinderServiceName(ServiceName name) {
        this.destinationFinderServiceName = name;
    }

    public ServiceName getDestinationFinderServiceName() {
        return this.destinationFinderServiceName;
    }

    public void setDestinationName(String name) {
        this.destinationName = name;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setSessionCreate(boolean isCreate) {
        this.isSessionCreate = isCreate;
    }

    public boolean isSessionCreate() {
        return this.isSessionCreate;
    }

    public void setCloseSession(boolean isClose) {
        this.isCloseSession = isClose;
    }

    public boolean isCloseSession() {
        return this.isCloseSession;
    }

    public void setDeliveryMode(int mode) {
        this.deliveryMode = mode;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long ttl) {
        this.timeToLive = ttl;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setJndiFinder(JndiFinder destinationFinder) {
        this.destinationFinder = destinationFinder;
    }

    public void setJMSSessionFactory(JMSSessionFactory jmsSessionFactory) {
        this.jmsSessionFactory = jmsSessionFactory;
    }

    public void startService() throws Exception {
        if (this.jmsSessionFactoryServiceName != null) {
            this.jmsSessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.jmsSessionFactoryServiceName);
        }
        if (this.destinationFinderServiceName != null) {
            this.destinationFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.destinationFinderServiceName);
            this.destination = this.destinationName == null ? (Destination)this.destinationFinder.lookup() : (Destination)this.destinationFinder.lookup(this.destinationName);
        }
        if (this.isSessionCreate) {
            if (this.jmsSessionFactory == null) {
                throw new IllegalArgumentException("jmsSessionFactoryServiceName must be specified.");
            }
            this.session = this.jmsSessionFactory.getSession();
        }
    }

    public void stopService() throws Exception {
        if (this.isCloseSession && this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.destination = null;
    }

    public Session getSession() {
        return this.session;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public JMSSessionFactory getSessionFactory() {
        return this.jmsSessionFactory;
    }

    public MessageProducer createProducer() throws JMSMessageProducerCreateException {
        return this.createProducer(this.destination);
    }

    public MessageProducer createProducer(Destination dest) throws JMSMessageProducerCreateException {
        Session session = this.session;
        if (session == null) {
            try {
                session = this.jmsSessionFactory.getSession();
            }
            catch (JMSSessionCreateException e) {
                throw new JMSMessageProducerCreateException(e);
            }
        }
        return this.createProducer(session, dest);
    }

    public MessageProducer createProducer(Session session, Destination dest) throws JMSMessageProducerCreateException {
        if (session == null) {
            throw new JMSMessageProducerCreateException("Session is null.");
        }
        if (dest == null) {
            throw new JMSMessageProducerCreateException("Destination is null.");
        }
        try {
            MessageProducer mp = session.createProducer(dest);
            mp.setDeliveryMode(this.deliveryMode);
            mp.setPriority(this.priority);
            mp.setTimeToLive(this.timeToLive);
            return mp;
        }
        catch (JMSException e) {
            throw new JMSMessageProducerCreateException(e);
        }
    }
}

