/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;
import jp.ossc.nimbus.service.jms.ReflectionJMSConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;

public class ReflectionJMSConnectionFactoryService
extends ServiceBase
implements ReflectionJMSConnectionFactoryServiceMBean,
JMSConnectionFactory {
    private static final long serialVersionUID = 4215522886152064782L;
    protected Constructor factoryConstructor;
    protected Object[] factoryConstructorParameters;
    protected Method factoryMethod;
    protected Object[] factoryMethodParameters;
    protected Object factory;
    protected Constructor connectionFactoryConstructor;
    protected Object[] connectionFactoryConstructorParameters;
    protected String userName;
    protected String password;
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Set connections;
    protected boolean isSingleConnection = true;
    protected boolean isConnectionManagement;
    protected boolean isStartConnection;
    protected int autoReconnectMode = 0;
    protected ServiceName keepAliveCheckerServiceName;
    protected KeepAliveChecker keepAliveChecker;
    protected String autoReconnectErrorLogMessageId;
    protected int autoReconnectMaxRetryCount;
    protected long autoReconnectRetryInterval = 1000L;

    public void setFactoryConstructor(Constructor c) {
        this.factoryConstructor = c;
    }

    public Constructor getFactoryConstructor() {
        return this.factoryConstructor;
    }

    public void setFactoryConstructorParameters(Object[] params) {
        this.factoryConstructorParameters = params;
    }

    public Object[] getFactoryConstructorParameters() {
        return this.factoryConstructorParameters;
    }

    public void setFactoryMethod(Method m) {
        this.factoryMethod = m;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethodParameters(Object[] params) {
        this.factoryMethodParameters = params;
    }

    public Object[] getFactoryMethodParameters() {
        return this.factoryMethodParameters;
    }

    public void setFactory(Object fac) {
        this.factory = fac;
    }

    public Object getFactory() {
        return this.factory;
    }

    public void setConnectionFactoryConstructor(Constructor c) {
        this.connectionFactoryConstructor = c;
    }

    public Constructor getConnectionFactoryConstructor() {
        return this.connectionFactoryConstructor;
    }

    public void setConnectionFactoryConstructorParameters(Object[] params) {
        this.connectionFactoryConstructorParameters = params;
    }

    public Object[] getConnectionFactoryConstructorParameters() {
        return this.connectionFactoryConstructorParameters;
    }

    public void setConnectionManagement(boolean isManaged) {
        this.isConnectionManagement = isManaged;
    }

    public boolean isConnectionManagement() {
        return this.isConnectionManagement;
    }

    public void setSingleConnection(boolean isSingle) {
        this.isSingleConnection = isSingle;
    }

    public boolean isSingleConnection() {
        return this.isSingleConnection;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAutoReconnectMode(int mode) {
        this.autoReconnectMode = mode;
    }

    public int getAutoReconnectMode() {
        return this.autoReconnectMode;
    }

    public void setKeepAliveCheckerServiceName(ServiceName name) {
        this.keepAliveCheckerServiceName = name;
    }

    public ServiceName getKeepAliveCheckerServiceName() {
        return this.keepAliveCheckerServiceName;
    }

    public void setAutoReconnectErrorLogMessageId(String id) {
        this.autoReconnectErrorLogMessageId = id;
    }

    public String getAutoReconnectErrorLogMessageId() {
        return this.autoReconnectErrorLogMessageId;
    }

    public void setStartConnection(boolean isStart) {
        this.isStartConnection = isStart;
    }

    public boolean isStartConnection() {
        return this.isStartConnection;
    }

    public void setAutoReconnectMaxRetryCount(int count) {
        this.autoReconnectMaxRetryCount = count;
    }

    public int getAutoReconnectMaxRetryCount() {
        return this.autoReconnectMaxRetryCount;
    }

    public void setAutoReconnectRetryInterval(long interval) {
        this.autoReconnectRetryInterval = interval;
    }

    public long getAutoReconnectRetryInterval() {
        return this.autoReconnectRetryInterval;
    }

    public void setKeepAliveChecker(KeepAliveChecker checker) {
        this.keepAliveChecker = checker;
    }

    public void setConnectionFactory(ConnectionFactory tm) {
        this.connectionFactory = tm;
    }

    public void createService() throws Exception {
        this.connections = new HashSet();
    }

    public void startService() throws Exception {
        if (this.connectionFactoryConstructor != null) {
            this.connectionFactory = this.connectionFactoryConstructorParameters == null ? (ConnectionFactory)this.connectionFactoryConstructor.getDeclaringClass().newInstance() : (ConnectionFactory)this.connectionFactoryConstructor.newInstance(this.connectionFactoryConstructorParameters);
        }
        if (this.connectionFactory == null) {
            if (this.factoryConstructor != null) {
                this.factory = this.factoryConstructorParameters == null ? this.factoryConstructor.getDeclaringClass().newInstance() : this.factoryConstructor.newInstance(this.factoryConstructorParameters);
            }
            if (this.factoryMethod == null) {
                throw new IllegalArgumentException("FactoryMethod is null.");
            }
            this.connectionFactory = (ConnectionFactory)this.factoryMethod.invoke(this.factory, this.factoryMethodParameters);
        }
        if ((this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) && this.keepAliveCheckerServiceName == null && this.keepAliveChecker == null) {
            throw new IllegalArgumentException("KeepAliveCheckerServiceName or KeepAliveChecker must be specified.");
        }
        if (this.keepAliveCheckerServiceName != null) {
            this.keepAliveChecker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(this.keepAliveCheckerServiceName);
        }
        if (this.isSingleConnection) {
            this.getConnection();
        }
    }

    public void stopService() throws Exception {
        this.connectionFactory = null;
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.connections != null && this.connections.size() != 0) {
            Iterator itr = this.connections.iterator();
            while (itr.hasNext()) {
                Connection con = (Connection)itr.next();
                try {
                    con.stop();
                }
                catch (JMSException e) {
                    // empty catch block
                }
                try {
                    con.close();
                }
                catch (JMSException jMSException) {}
            }
            this.connections.clear();
        }
    }

    public void destroyService() throws Exception {
        this.connections = null;
    }

    public synchronized Connection getConnection() throws JMSConnectionCreateException {
        return this.getConnection(this.userName, this.password);
    }

    public synchronized Connection getConnection(String user, String pwd) throws JMSConnectionCreateException {
        if (this.connectionFactory == null) {
            throw new JMSConnectionCreateException("ConnectionFactory is null.");
        }
        Connection con = null;
        if (this.isSingleConnection && this.connection != null) {
            return this.connection;
        }
        try {
            if (this.isSingleConnection && this.connection != null) {
                return this.connection;
            }
            con = this.createConnection(user, pwd);
            if (this.isSingleConnection && con != null) {
                this.connection = con;
            }
            if (this.isConnectionManagement) {
                this.connections.add(con);
            }
            if (this.isStartConnection) {
                con.start();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectionCreateException(e);
        }
        return con;
    }

    protected Connection createConnection(String user, String pwd) throws JMSException, JMSConnectionCreateException {
        if (this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) {
            ReconnectableConnection con = null;
            con = user == null ? new ReconnectableConnection(this.connectionFactory) : new ReconnectableConnection(this.connectionFactory, user, pwd);
            con.setKeepAliveChecker(this.keepAliveChecker);
            con.setReconnectMode(this.autoReconnectMode);
            if (this.autoReconnectErrorLogMessageId != null) {
                con.setReconnectErrorLogMessageId(this.autoReconnectErrorLogMessageId);
                con.setLogger(this.getLogger());
            }
            con.setReconnectMaxRetryCount(this.autoReconnectMaxRetryCount);
            con.setReconnectRetryInterval(this.autoReconnectRetryInterval);
            return con;
        }
        if (user != null) {
            return this.connectionFactory.createConnection(user, pwd);
        }
        return this.connectionFactory.createConnection();
    }
}

