/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.GroupClientConnectionImpl;

public class GroupClientConnectionFactoryImpl
implements ClientConnectionFactory,
Serializable {
    private static final long serialVersionUID = -8701616559793730652L;
    private Map factories = new HashMap();

    public void addClientConnectionFactory(String subject, Pattern keyPattern, ClientConnectionFactory factory) {
        ArrayList<MessageKey> list = (ArrayList<MessageKey>)this.factories.get(factory);
        if (list == null) {
            list = new ArrayList<MessageKey>();
            this.factories.put(factory, list);
        }
        list.add(new MessageKey(subject, keyPattern));
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        GroupClientConnectionImpl connection = new GroupClientConnectionImpl();
        Iterator entries = this.factories.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ClientConnectionFactory factory = (ClientConnectionFactory)entry.getKey();
            ClientConnection con = factory.getClientConnection();
            List list = (List)entry.getValue();
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                MessageKey messageKey = (MessageKey)list.get(i);
                connection.addClientConnection(messageKey.subject, messageKey.keyPattern, con);
            }
        }
        return connection;
    }

    public int getClientCount() throws RemoteException {
        int result = 0;
        Iterator factories = this.factories.keySet().iterator();
        while (factories.hasNext()) {
            ClientConnectionFactory factory = (ClientConnectionFactory)factories.next();
            result += factory.getClientCount();
        }
        return result;
    }

    public static class MessageKey
    implements Serializable {
        private static final long serialVersionUID = 5276366941694918834L;
        public String subject;
        public Pattern keyPattern;

        public MessageKey() {
        }

        public MessageKey(String subject, Pattern keyPattern) {
            this.subject = subject;
            this.keyPattern = keyPattern;
        }
    }
}

