/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.context.SharedContextService;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextTransactionManager;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.SharedQueueServiceMBean;
import jp.ossc.nimbus.service.sequence.StringSequenceService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedQueueService
extends SharedContextService
implements Queue,
SharedQueueServiceMBean {
    private static final long serialVersionUID = -3323923547429465815L;
    protected static final EmptyElement EMPTY = new EmptyElement();
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected final Object lock = "lock";
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = false;
    protected boolean isMultiThreadGet = false;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;
    protected StringSequenceService sequence;
    protected String sequenceTimestampFormat = "yyyyMMddHHmmssSSS";
    protected int sequenceDigit = 5;

    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    public boolean isMultiThreadGet() {
        return this.isMultiThreadGet;
    }

    public void setMultiThreadGet(boolean isSafe) {
        this.isMultiThreadGet = isSafe;
    }

    public void setSequenceTimestampFormat(String format) {
        this.sequenceTimestampFormat = format;
    }

    public String getSequenceTimestampFormat() {
        return this.sequenceTimestampFormat;
    }

    public void setSequenceDigit(int digit) {
        this.sequenceDigit = digit;
    }

    public int getSequenceDigit() {
        return this.sequenceDigit;
    }

    public void startService() throws Exception {
        this.sequence = new StringSequenceService();
        this.sequence.create();
        this.sequence.setFormat("TIME_SEQ(" + this.sequenceTimestampFormat + "," + this.sequenceDigit + ")");
        this.sequence.start();
        if (!WaitSynchronizeMonitor.class.equals(this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        super.startService();
        this.accept();
    }

    public void stopService() throws Exception {
        this.release();
        super.stopService();
    }

    protected Map createContext() {
        return Collections.synchronizedSortedMap(new TreeMap());
    }

    protected void onPut(SharedContextService.SharedContextEvent event) {
        super.onPut(event);
        this.pushAfter();
    }

    public void push(Object item) {
        this.push(item, -1L);
    }

    public boolean push(Object item, long timeout) {
        return this.pushElement(item, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushElement(Object element, long timeout) {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        long startTime = System.currentTimeMillis();
        while (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                if (timeout == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (timeout < 0L) {
                    this.pushMonitor.initAndWaitMonitor();
                    continue;
                }
                if (this.pushMonitor.initAndWaitMonitor(timeout)) continue;
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
            return false;
        }
        String id = this.sequence.increment() + this.getId();
        boolean hasTransaction = false;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            hasTransaction = true;
        }
        if (hasTransaction) {
            this.put(id, element, timeout);
        } else {
            this.putAsynch(id, element);
        }
        this.pushAfter();
        return true;
    }

    protected void pushAfter() {
        if (!this.isClient) {
            int size = this.size();
            if ((long)size > this.maxDepth) {
                this.maxDepth = size;
            }
            ++this.count;
            ++this.countDelta;
            this.lastPushedTime = System.currentTimeMillis();
        }
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
        }
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object var6_4;
        block33: {
            Object object;
            block32: {
                Object var7_9;
                block31: {
                    if (this.isClient) {
                        throw new UnsupportedOperationException();
                    }
                    long processTime = 0L;
                    try {
                        Object ret;
                        if (isRemove) {
                            this.getMonitor.initMonitor();
                        } else {
                            this.peekMonitor.initMonitor();
                        }
                        while (!this.fourceEndFlg) {
                            long proc;
                            block30: {
                                if (this.size() > 0) {
                                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                                        ret = this.getQueueElement(isRemove);
                                        if (ret == EMPTY) continue;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                            if (this.size() > 0 && this.getMonitor.isWait()) {
                                                if (this.isSafeGetOrder) {
                                                    this.getMonitor.notifyMonitor();
                                                } else {
                                                    this.getMonitor.notifyAllMonitor();
                                                }
                                            }
                                            if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                                                this.pushMonitor.notifyMonitor();
                                            }
                                        }
                                        Object object2 = ret;
                                        Object var11_11 = null;
                                        if (isRemove) {
                                            this.getMonitor.releaseMonitor();
                                            return object2;
                                        }
                                        this.peekMonitor.releaseMonitor();
                                        return object2;
                                    }
                                    if (this.getMonitor.isWait()) {
                                        this.getMonitor.notifyMonitor();
                                    }
                                }
                                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                                proc = 0L;
                                if (timeOutMs >= 0L) {
                                    proc = System.currentTimeMillis();
                                }
                                try {
                                    long curSleepTime;
                                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                                    if (curSleepTime <= 0L || this.size() != 0 && isRemove && (!this.isSafeGetOrder || this.getMonitor.isFirst())) break block30;
                                    if (isRemove) {
                                        this.getMonitor.initAndWaitMonitor(curSleepTime);
                                    } else {
                                        this.peekMonitor.initAndWaitMonitor(curSleepTime);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Object var9_17 = null;
                                    Object var11_12 = null;
                                    if (isRemove) {
                                        this.getMonitor.releaseMonitor();
                                        return var9_17;
                                    }
                                    this.peekMonitor.releaseMonitor();
                                    return var9_17;
                                }
                            }
                            if (timeOutMs < 0L) continue;
                            proc = System.currentTimeMillis() - proc;
                            processTime += proc;
                        }
                        if (this.fourceEndFlg) {
                            ret = this.getQueueElement(isRemove);
                            if (ret == EMPTY) {
                                var7_9 = null;
                                break block31;
                            }
                            object = ret;
                            break block32;
                        }
                        if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                            if (this.isSafeGetOrder) {
                                this.getMonitor.notifyMonitor();
                            } else {
                                this.getMonitor.notifyAllMonitor();
                            }
                        }
                        var6_4 = null;
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        if (isRemove) {
                            this.getMonitor.releaseMonitor();
                            throw throwable;
                        }
                        this.peekMonitor.releaseMonitor();
                        throw throwable;
                    }
                }
                Object var11_13 = null;
                if (isRemove) {
                    this.getMonitor.releaseMonitor();
                    return var7_9;
                }
                this.peekMonitor.releaseMonitor();
                return var7_9;
            }
            Object var11_14 = null;
            if (isRemove) {
                this.getMonitor.releaseMonitor();
                return object;
            }
            this.peekMonitor.releaseMonitor();
            return object;
        }
        Object var11_15 = null;
        if (isRemove) {
            this.getMonitor.releaseMonitor();
            return var6_4;
        }
        this.peekMonitor.releaseMonitor();
        return var6_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.context == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.context == null) {
                return null;
            }
            if (this.size() == 0) {
                return EMPTY;
            }
            Object element = null;
            while (true) {
                Object var8_7;
                String id;
                block17: {
                    block16: {
                        id = null;
                        try {
                            try {
                                id = (String)((SortedMap)this.context).firstKey();
                                if (this.isMultiThreadGet) {
                                    this.lock(id);
                                }
                                if (this.containsKey(id)) {
                                    element = isRemove ? this.remove(id) : this.get(id);
                                    var8_7 = null;
                                    if (id == null || !this.isMultiThreadGet) break;
                                    break block16;
                                }
                                id = null;
                                break block17;
                            }
                            catch (SharedContextTimeoutException e) {
                                var8_7 = null;
                                if (id == null || !this.isMultiThreadGet) continue;
                                this.unlock(id);
                                continue;
                            }
                            catch (NoSuchElementException e) {
                                EmptyElement emptyElement = EMPTY;
                                var8_7 = null;
                                if (id != null && this.isMultiThreadGet) {
                                    this.unlock(id);
                                }
                                return emptyElement;
                            }
                        }
                        catch (Throwable throwable) {
                            var8_7 = null;
                            if (id != null && this.isMultiThreadGet) {
                                this.unlock(id);
                            }
                            throw throwable;
                        }
                    }
                    this.unlock(id);
                    break;
                }
                var8_7 = null;
                if (id == null || !this.isMultiThreadGet) continue;
                this.unlock(id);
            }
            if (element == null) {
                return null;
            }
            return element;
        }
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public Object remove(Object item) {
        return super.remove(item);
    }

    public void accept() {
        this.fourceEndFlg = false;
    }

    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
    }

    public List elements() {
        if (this.context == null) {
            return new ArrayList();
        }
        return new ArrayList(this.values());
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    public long getDepth() {
        return this.size();
    }

    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    public long getMaxDepth() {
        return this.maxDepth;
    }

    protected static class EmptyElement {
        protected EmptyElement() {
        }
    }
}

