/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.scheduler2.DatabaseScheduleManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleControlListener;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class DatabaseScheduleManagerService
extends ServiceBase
implements ScheduleManager,
DatabaseScheduleManagerServiceMBean {
    private static final long serialVersionUID = -768179222440496616L;
    protected Properties scheduleMakerTypeMapping;
    protected Map addedScheduleMakerMap;
    protected Map scheduleMakerMap;
    protected boolean isScheduleMakerTypeRegexEnabled;
    protected ServiceName defaultScheduleMakerServiceName;
    protected ScheduleMaker defaultScheduleMaker;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ScheduleMasterTableSchema scheduleMasterTableSchema = new ScheduleMasterTableSchema();
    protected ScheduleGroupMasterTableSchema scheduleGroupMasterTableSchema = new ScheduleGroupMasterTableSchema();
    protected ScheduleDependsMasterTableSchema scheduleDependsMasterTableSchema = new ScheduleDependsMasterTableSchema();
    protected ScheduleTableSchema scheduleTableSchema = new ScheduleTableSchema();
    protected ScheduleDependsTableSchema scheduleDependsTableSchema = new ScheduleDependsTableSchema();
    protected String nextScheduleIdSelectQuery;
    protected String dateFormat = "yyyyMMdd";
    protected String timeFormat = "HHmmssSSS";
    protected String updateUserId;
    protected Set scheduleControlListeners;
    protected boolean isMakeScheduleOnStart = true;
    protected long controlStateCheckInterval = 1000L;
    protected Daemon controlStateChecker;
    protected long timeoverCheckInterval = 1000L;
    protected Daemon timeoverChecker;
    protected boolean isLockForFindExecutable;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ClusterListener clusterListener;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected boolean isUseConcatFunction;
    protected boolean isJsonInput;

    public void setDefaultScheduleMakerServiceName(ServiceName name) {
        this.defaultScheduleMakerServiceName = name;
    }

    public ServiceName getDefaultScheduleMakerServiceName() {
        return this.defaultScheduleMakerServiceName;
    }

    public void setScheduleMakerTypeMapping(Properties mapping) {
        this.scheduleMakerTypeMapping = mapping;
    }

    public Properties getScheduleMakerTypeMapping() {
        return this.scheduleMakerTypeMapping;
    }

    public void setScheduleMakerTypeRegexEnabled(boolean isEnable) {
        this.isScheduleMakerTypeRegexEnabled = isEnable;
    }

    public boolean isScheduleMakerTypeRegexEnabled() {
        return this.isScheduleMakerTypeRegexEnabled;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setUpdateUserId(String id) {
        this.updateUserId = id;
    }

    public String getUpdateUserId() {
        return this.updateUserId;
    }

    public ScheduleMasterTableSchema getScheduleMasterTableSchema() {
        return this.scheduleMasterTableSchema;
    }

    public void setScheduleMasterTableSchema(ScheduleMasterTableSchema schema) {
        this.scheduleMasterTableSchema = schema;
    }

    public ScheduleGroupMasterTableSchema getScheduleGroupMasterTableSchema() {
        return this.scheduleGroupMasterTableSchema;
    }

    public void setScheduleGroupMasterTableSchema(ScheduleGroupMasterTableSchema schema) {
        this.scheduleGroupMasterTableSchema = schema;
    }

    public ScheduleDependsMasterTableSchema getScheduleDependsMasterTableSchema() {
        return this.scheduleDependsMasterTableSchema;
    }

    public void setScheduleDependsMasterTableSchema(ScheduleDependsMasterTableSchema schema) {
        this.scheduleDependsMasterTableSchema = schema;
    }

    public ScheduleTableSchema getScheduleTableSchema() {
        return this.scheduleTableSchema;
    }

    public void setScheduleTableSchema(ScheduleTableSchema schema) {
        this.scheduleTableSchema = schema;
    }

    public ScheduleDependsTableSchema getScheduleDependsTableSchema() {
        return this.scheduleDependsTableSchema;
    }

    public void setScheduleDependsTableSchema(ScheduleDependsTableSchema schema) {
        this.scheduleDependsTableSchema = schema;
    }

    public void setNextScheduleIdSelectQuery(String query) {
        this.nextScheduleIdSelectQuery = query;
    }

    public String getNextScheduleIdSelectQuery() {
        return this.nextScheduleIdSelectQuery;
    }

    public void setMakeScheduleOnStart(boolean isMake) {
        this.isMakeScheduleOnStart = isMake;
    }

    public boolean isMakeScheduleOnStart() {
        return this.isMakeScheduleOnStart;
    }

    public void setControlStateCheckInterval(long interval) {
        this.controlStateCheckInterval = interval;
    }

    public long getControlStateCheckInterval() {
        return this.controlStateCheckInterval;
    }

    public void setTimeoverCheckInterval(long interval) {
        this.timeoverCheckInterval = interval;
    }

    public long getTimeoverCheckInterval() {
        return this.timeoverCheckInterval;
    }

    public void setLockForFindExecutable(boolean isLock) {
        this.isLockForFindExecutable = isLock;
    }

    public boolean isLockForFindExecutable() {
        return this.isLockForFindExecutable;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setUseConcatFunction(boolean isUse) {
        this.isUseConcatFunction = isUse;
    }

    public boolean isUseConcatFunction() {
        return this.isUseConcatFunction;
    }

    public void setJSONInput(boolean isJson) {
        this.isJsonInput = isJson;
    }

    public boolean isJSONInput() {
        return this.isJsonInput;
    }

    public void createService() throws Exception {
        this.scheduleMakerMap = new HashMap();
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    public void startService() throws Exception {
        Date now;
        List oldScheduleList;
        if (this.scheduleMakerTypeMapping != null && this.scheduleMakerTypeMapping.size() != 0) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Map.Entry<Object, Object>> entries = this.scheduleMakerTypeMapping.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, Object> entry = entries.next();
                editor.setAsText((String)entry.getValue());
                ServiceName scheduleMakerServiceName = (ServiceName)editor.getValue();
                ScheduleMaker scheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(scheduleMakerServiceName);
                if (this.scheduleMakerMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("Dupulicate scheduleMakerTypeMapping : " + entry.getKey());
                }
                this.scheduleMakerMap.put(entry.getKey(), scheduleMaker);
            }
        }
        if (this.defaultScheduleMakerServiceName != null) {
            this.defaultScheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(this.defaultScheduleMakerServiceName);
        }
        if (this.defaultScheduleMaker == null) {
            DefaultScheduleMakerService defaultScheduleMakerService = new DefaultScheduleMakerService();
            defaultScheduleMakerService.create();
            defaultScheduleMakerService.start();
            this.defaultScheduleMaker = defaultScheduleMakerService;
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.updateUserId == null) {
            this.updateUserId = InetAddress.getLocalHost().getHostName();
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        format.applyPattern(this.timeFormat);
        if (this.isMakeScheduleOnStart && ((oldScheduleList = this.findSchedules(now = new Date())) == null || oldScheduleList.size() == 0)) {
            this.makeSchedule(now);
        }
        if (this.controlStateCheckInterval > 0L && this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus SchedulerManagerControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.suspend();
            this.controlStateChecker.start();
        }
        if (this.timeoverCheckInterval > 0L) {
            this.timeoverChecker = new Daemon(new TimeoverChecker());
            this.timeoverChecker.setName("Nimbus SchedulerManagerTimeoverChecker " + this.getServiceNameObject());
            this.timeoverChecker.suspend();
            this.timeoverChecker.start();
        }
        if (this.clusterServiceName != null && (this.controlStateChecker != null || this.timeoverChecker != null)) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.clusterListener = new ClusterListener();
            this.cluster.addClusterListener(this.clusterListener);
        } else {
            if (this.controlStateChecker != null) {
                this.controlStateChecker.resume();
            }
            if (this.timeoverChecker != null) {
                this.timeoverChecker.resume();
            }
        }
    }

    public void stopService() throws Exception {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.stop();
        }
        if (this.timeoverChecker != null) {
            this.timeoverChecker.stop();
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this.clusterListener);
            this.clusterListener = null;
            this.cluster = null;
        }
        if (this.scheduleMakerMap != null) {
            this.scheduleMakerMap.clear();
        }
    }

    public void destroyService() throws Exception {
        this.scheduleMakerMap = null;
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = null;
    }

    /*
     * Loose catch block
     */
    public List makeSchedule(Date date) throws ScheduleMakeException {
        ArrayList<DefaultScheduleMaster> masters;
        block27: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block25: {
                masters = new ArrayList<DefaultScheduleMaster>();
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleMakeException(e2);
                }
                st = null;
                rs = null;
                st = con.createStatement();
                rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
                while (rs.next()) {
                    DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                    masters.add(scheduleMaster);
                }
                rs.close();
                rs = null;
                this.setDependsOnScheduleMasters(con, masters);
                this.setGroupIdsOnScheduleMasters(con, masters);
                Object var8_13 = null;
                if (st == null) break block25;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block27;
            {
                catch (ScheduleManageException e4) {
                    throw new ScheduleMakeException(e4);
                }
                catch (ParseException e5) {
                    throw new ScheduleMakeException(e5);
                }
                catch (ClassNotFoundException e6) {
                    throw new ScheduleMakeException(e6);
                }
                catch (IOException e7) {
                    throw new ScheduleMakeException(e7);
                }
                catch (SQLException e8) {
                    throw new ScheduleMakeException(e8);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var8_14 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return this.makeSchedule(date, masters, null);
    }

    public List makeSchedule(Date date, ScheduleMaster master, String groupId) throws ScheduleMakeException {
        if (master == null) {
            return new ArrayList();
        }
        ArrayList<ScheduleMaster> masters = new ArrayList<ScheduleMaster>();
        masters.add(master);
        return this.makeSchedule(date, masters, groupId);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List makeSchedule(Date date, List masters, String groupId) throws ScheduleMakeException {
        block34: {
            block33: {
                block28: {
                    if (masters.size() == 0) {
                        return new ArrayList<E>();
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e) {
                        throw new ScheduleMakeException(e);
                    }
                    st = null;
                    ps1 = null;
                    ps2 = null;
                    try {
                        try {
                            st = con.createStatement();
                            ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.groupId + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
                            ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
                            result = new ArrayList<Schedule>();
                            for (i = 0; i < masters.size(); ++i) {
                                scheduleMaster = (ScheduleMaster)masters.get(i);
                                maker = this.getScheduleMaker(scheduleMaster.getScheduleType());
                                if (!scheduleMaster.isEnabled() || scheduleMaster.isTemplate() || (schedules = maker.makeSchedule(date, scheduleMaster)) == null || schedules.length == 0) continue;
                                for (j = 0; j < schedules.length; ++j) {
                                    schedules[j].setGroupId(groupId);
                                    this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, schedules[j]);
                                    result.add(schedules[j]);
                                }
                            }
                            var9_13 = result;
                            var15_18 = null;
                            if (st == null) break block28;
                        }
                        catch (ScheduleManageException e) {
                            throw new ScheduleMakeException(e);
                        }
                        catch (SQLException e) {
                            throw new ScheduleMakeException(e);
                        }
                    }
                    catch (Throwable var14_22) {
                        var15_19 = null;
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (ps1 != null) {
                            try {
                                ps1.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (ps2 != null) {
                            try {
                                ps2.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (con == null) throw var14_22;
                        try {
                            con.close();
                            throw var14_22;
                        }
                        catch (SQLException e) {
                            throw var14_22;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [5 : 795->805)] { 
lbl70:
                    // 1 sources

                    st.close();
                    break block28;
lbl72:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                if (ps1 != null) {
                    ** try [egrp 4[TRYBLOCK] [6 : 812->822)] { 
lbl77:
                    // 1 sources

                    ps1.close();
                    break block33;
lbl79:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (ps2 != null) {
                ** try [egrp 5[TRYBLOCK] [7 : 829->839)] { 
lbl84:
                // 1 sources

                ps2.close();
                break block34;
lbl86:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var9_13;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var9_13;
        }
        con.close();
        return var9_13;
    }

    /*
     * Loose catch block
     */
    protected void addSchedule(Schedule schedule, boolean isCreateId) throws ScheduleManageException {
        block29: {
            SQLException e32;
            Statement ps2;
            Statement ps1;
            Statement st;
            Connection con;
            block26: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                ps1 = null;
                ps2 = null;
                if (isCreateId) {
                    st = con.createStatement();
                }
                ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.groupId + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
                ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
                this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, schedule);
                Object var9_8 = null;
                if (st == null) break block26;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block29;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_9 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSchedule(Statement nextScheduleIdStatement, PreparedStatement scheduleInsertStatement, PreparedStatement scheduleDependsInsertStatement, Schedule schedule) throws ScheduleManageException {
        ResultSet rs = null;
        try {
            try {
                Date initialTime;
                if (this.nextScheduleIdSelectQuery != null) {
                    rs = nextScheduleIdStatement.executeQuery(this.nextScheduleIdSelectQuery);
                    rs.next();
                    schedule.setId(rs.getObject(1).toString());
                    rs.close();
                    rs = null;
                } else if (this.sequence != null) {
                    schedule.setId(this.sequence.increment());
                }
                int index = 0;
                scheduleInsertStatement.setString(++index, schedule.getId());
                scheduleInsertStatement.setString(++index, schedule.getGroupId());
                scheduleInsertStatement.setString(++index, schedule.getMasterId());
                SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
                if (schedule.getTime() == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(schedule.getTime()));
                }
                format.applyPattern(this.timeFormat);
                if (schedule.getTime() == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(schedule.getTime()));
                }
                scheduleInsertStatement.setString(++index, schedule.getTaskName());
                if (schedule.getInput() == null) {
                    scheduleInsertStatement.setNull(++index, 12);
                } else {
                    Object input = schedule.getInput();
                    if (this.isJsonInput && !(input instanceof String)) {
                        BeanJSONConverter jsonConverter = new BeanJSONConverter();
                        jsonConverter.setUnicodeEscape(false);
                        StringStreamConverter streamConverter = new StringStreamConverter();
                        input = streamConverter.convertToObject(jsonConverter.convertToStream(input));
                    }
                    this.scheduleTableSchema.setInputObject(++index, scheduleInsertStatement, input);
                }
                if (schedule.getOutput() == null) {
                    scheduleInsertStatement.setNull(++index, 12);
                } else {
                    this.scheduleTableSchema.setOutputObject(++index, scheduleInsertStatement, schedule.getOutput());
                }
                format.applyPattern(this.dateFormat);
                Date date = initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                if (initialTime == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(initialTime));
                }
                format.applyPattern(this.timeFormat);
                if (initialTime == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(initialTime));
                }
                if (schedule.getRetryInterval() > 0L) {
                    scheduleInsertStatement.setLong(++index, schedule.getRetryInterval());
                } else {
                    scheduleInsertStatement.setNull(++index, 3);
                }
                format.applyPattern(this.dateFormat + this.timeFormat);
                if (schedule.getRetryEndTime() == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(schedule.getRetryEndTime()));
                }
                if (schedule.getMaxDelayTime() > 0L) {
                    scheduleInsertStatement.setLong(++index, schedule.getMaxDelayTime());
                } else {
                    scheduleInsertStatement.setNull(++index, 3);
                }
                scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getStateString(schedule.getState()));
                scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getControlStateString(schedule.getControlState()));
                scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getCheckStateString(schedule.getCheckState()));
                if (schedule.getExecutorKey() == null) {
                    scheduleInsertStatement.setNull(++index, 12);
                } else {
                    scheduleInsertStatement.setString(++index, schedule.getExecutorKey());
                }
                if (schedule.getExecutorType() == null) {
                    scheduleInsertStatement.setNull(++index, 12);
                } else {
                    scheduleInsertStatement.setString(++index, schedule.getExecutorType());
                }
                if (schedule.getExecuteStartTime() == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(schedule.getExecuteStartTime()));
                }
                if (schedule.getExecuteEndTime() == null) {
                    scheduleInsertStatement.setNull(++index, 1);
                } else {
                    scheduleInsertStatement.setString(++index, format.format(schedule.getExecuteEndTime()));
                }
                Timestamp now = new Timestamp(System.currentTimeMillis());
                scheduleInsertStatement.setTimestamp(++index, now);
                scheduleInsertStatement.executeUpdate();
                String[] depends = schedule.getDepends();
                if (depends != null && depends.length != 0) {
                    if (scheduleDependsInsertStatement == null) {
                        throw new ScheduleManageException("ScheduleDependsInsertQuery is null.");
                    }
                    for (int i = 0; i < depends.length; ++i) {
                        scheduleDependsInsertStatement.setString(1, schedule.getId());
                        scheduleDependsInsertStatement.setString(2, depends[i]);
                        scheduleDependsInsertStatement.setTimestamp(3, now);
                        scheduleDependsInsertStatement.executeUpdate();
                    }
                }
                Object var13_14 = null;
                if (rs == null) return;
            }
            catch (IOException e) {
                throw new ScheduleManageException(e);
            }
            catch (SQLException e) {
                throw new ScheduleManageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        rs.close();
        return;
    }

    public void setScheduleMaker(String scheduleType, ScheduleMaker maker) throws IllegalArgumentException {
        if (this.addedScheduleMakerMap == null) {
            this.addedScheduleMakerMap = new HashMap();
        }
        if (this.addedScheduleMakerMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Dupulicate scheduleType : " + scheduleType);
        }
        this.addedScheduleMakerMap.put(scheduleType, maker);
    }

    public ScheduleMaker getScheduleMaker(String scheduleType) {
        ScheduleMaker maker = (ScheduleMaker)this.scheduleMakerMap.get(scheduleType);
        if (this.isScheduleMakerTypeRegexEnabled && maker == null) {
            Iterator entries = this.scheduleMakerMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                try {
                    if (!Pattern.matches(key, scheduleType)) continue;
                    maker = (ScheduleMaker)entry.getValue();
                    break;
                }
                catch (PatternSyntaxException e) {
                }
            }
        }
        if (maker == null) {
            maker = this.defaultScheduleMaker;
        }
        return maker;
    }

    public Map getScheduleMakerMap() {
        return this.scheduleMakerMap;
    }

    public void setDefaultScheduleMaker(ScheduleMaker maker) {
        this.defaultScheduleMaker = maker;
    }

    public ScheduleMaker getDefaultScheduleMaker() {
        return this.defaultScheduleMaker;
    }

    /*
     * Loose catch block
     */
    public List findScheduleMasters(String groupId) throws ScheduleManageException {
        ArrayList<DefaultScheduleMaster> result;
        block27: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block25: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                result = new ArrayList<DefaultScheduleMaster>();
                StringBuffer buf = new StringBuffer();
                buf.append("select ").append("A.").append(this.scheduleMasterTableSchema.id).append(',').append("A.").append(this.scheduleMasterTableSchema.taskName).append(',').append("A.").append(this.scheduleMasterTableSchema.scheduleType).append(',').append("A.").append(this.scheduleMasterTableSchema.input).append(',').append("A.").append(this.scheduleMasterTableSchema.startTime).append(',').append("A.").append(this.scheduleMasterTableSchema.endTime).append(',').append("A.").append(this.scheduleMasterTableSchema.repeatInterval).append(',').append("A.").append(this.scheduleMasterTableSchema.retryInterval).append(',').append("A.").append(this.scheduleMasterTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleMasterTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleMasterTableSchema.enable).append(',').append("A.").append(this.scheduleMasterTableSchema.executorKey).append(',').append("A.").append(this.scheduleMasterTableSchema.executorType).append(',').append("A.").append(this.scheduleMasterTableSchema.template).append(" from ").append(this.scheduleMasterTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append(groupId == null ? " is null" : "='" + groupId + "'").append(") B").append(" where ").append("A.").append(this.scheduleMasterTableSchema.id).append("=B.").append(this.scheduleGroupMasterTableSchema.id);
                st = con.createStatement();
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                    result.add(scheduleMaster);
                }
                rs.close();
                rs = null;
                this.setDependsOnScheduleMasters(con, result);
                this.setGroupIdsOnScheduleMasters(con, result);
                Object var9_14 = null;
                if (st == null) break block25;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block27;
            {
                catch (ScheduleManageException e4) {
                    throw new ScheduleMakeException(e4);
                }
                catch (ParseException e5) {
                    throw new ScheduleMakeException(e5);
                }
                catch (ClassNotFoundException e6) {
                    throw new ScheduleMakeException(e6);
                }
                catch (IOException e7) {
                    throw new ScheduleMakeException(e7);
                }
                catch (SQLException e8) {
                    throw new ScheduleMakeException(e8);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_15 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public List findAllScheduleMasters() throws ScheduleManageException {
        ArrayList<DefaultScheduleMaster> result;
        block27: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block25: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                result = new ArrayList<DefaultScheduleMaster>();
                st = con.createStatement();
                rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
                while (rs.next()) {
                    DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                    result.add(scheduleMaster);
                }
                rs.close();
                rs = null;
                this.setDependsOnScheduleMasters(con, result);
                this.setGroupIdsOnScheduleMasters(con, result);
                Object var7_12 = null;
                if (st == null) break block25;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block27;
            {
                catch (ScheduleManageException e4) {
                    throw new ScheduleMakeException(e4);
                }
                catch (ParseException e5) {
                    throw new ScheduleMakeException(e5);
                }
                catch (ClassNotFoundException e6) {
                    throw new ScheduleMakeException(e6);
                }
                catch (IOException e7) {
                    throw new ScheduleMakeException(e7);
                }
                catch (SQLException e8) {
                    throw new ScheduleMakeException(e8);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var7_13 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScheduleMaster findScheduleMaster(String id) throws ScheduleManageException {
        block35: {
            block34: {
                block30: {
                    block33: {
                        block28: {
                            block29: {
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleManageException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        st = con.prepareStatement("select * from " + this.scheduleMasterTableSchema.table + " where " + this.scheduleMasterTableSchema.id + "=?");
                                        st.setString(1, id);
                                        rs = st.executeQuery();
                                        if (!rs.next()) {
                                            var5_6 = null;
                                            var8_12 = null;
                                            if (rs == null) break block28;
                                            break block29;
                                        }
                                        scheduleMaster = this.createScheduleMaster(rs);
                                        this.setDependsOnScheduleMaster(con, scheduleMaster);
                                        this.setGroupIdsOnScheduleMaster(con, scheduleMaster);
                                        var6_18 = scheduleMaster;
                                        break block30;
                                    }
                                    catch (ParseException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (IOException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                }
                                catch (Throwable var7_19) {
                                    var8_14 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var7_19;
                                    try {
                                        con.close();
                                        throw var7_19;
                                    }
                                    catch (SQLException e) {
                                        throw var7_19;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [12 : 216->226)] { 
lbl61:
                            // 1 sources

                            rs.close();
                            break block28;
lbl63:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [13 : 232->241)] { 
lbl68:
                            // 1 sources

                            st.close();
                            break block33;
lbl70:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var5_6;
                    ** try [egrp 5[TRYBLOCK] [14 : 247->256)] { 
lbl75:
                    // 1 sources

                    con.close();
                    return var5_6;
lbl77:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var5_6;
                }
                var8_13 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [12 : 216->226)] { 
lbl84:
                    // 1 sources

                    rs.close();
                    break block34;
lbl86:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [13 : 232->241)] { 
lbl91:
                // 1 sources

                st.close();
                break block35;
lbl93:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var6_18;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var6_18;
        }
        con.close();
        return var6_18;
    }

    protected DefaultScheduleMaster createScheduleMaster(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(this.timeFormat);
        DefaultScheduleMaster scheduleMaster = new DefaultScheduleMaster();
        scheduleMaster.setId(rs.getString(this.scheduleMasterTableSchema.id));
        scheduleMaster.setTaskName(rs.getString(this.scheduleMasterTableSchema.taskName));
        scheduleMaster.setScheduleType(rs.getString(this.scheduleMasterTableSchema.scheduleType));
        scheduleMaster.setInput(this.scheduleMasterTableSchema.getInputObject(rs));
        String str = rs.getString(this.scheduleMasterTableSchema.startTime);
        if (str != null && str.length() != 0) {
            scheduleMaster.setStartTime(timeFormatter.parse(str));
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.endTime)) != null && str.length() != 0) {
            scheduleMaster.setEndTime(timeFormatter.parse(str));
        }
        long longVal = rs.getLong(this.scheduleMasterTableSchema.repeatInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRepeatInterval(longVal);
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.retryInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRetryInterval(longVal);
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.retryEndTime)) != null && str.length() != 0) {
            scheduleMaster.setRetryEndTime(timeFormatter.parse(str));
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            scheduleMaster.setMaxDelayTime(longVal);
        }
        scheduleMaster.setExecutorKey(rs.getString(this.scheduleMasterTableSchema.executorKey));
        scheduleMaster.setExecutorType(rs.getString(this.scheduleMasterTableSchema.executorType));
        Object obj = rs.getObject(this.scheduleMasterTableSchema.enable);
        boolean isEnabled = true;
        isEnabled = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Number ? ((Number)obj).intValue() != 0 : (obj == null ? false : Boolean.valueOf(obj.toString())));
        scheduleMaster.setEnabled(isEnabled);
        obj = rs.getObject(this.scheduleMasterTableSchema.template);
        boolean isTemplate = true;
        isTemplate = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Number ? ((Number)obj).intValue() != 0 : (obj == null ? false : Boolean.valueOf(obj.toString())));
        scheduleMaster.setTemplate(isTemplate);
        return scheduleMaster;
    }

    protected ScheduleMaster setDependsOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setDependsOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    protected List setDependsOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, ScheduleMaster> scheduleMap = new HashMap<String, ScheduleMaster>();
        HashMap<String, ArrayList<String>> scheduleDependsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            ScheduleMaster schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleDependsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleDependsMasterTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleDependsMasterTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                schedule = (ScheduleMaster)schedules.get(j);
                buf.append('\'').append(schedule.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule.getId(), schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsMasterTableSchema.id);
                ArrayList<String> depends = (ArrayList<String>)scheduleDependsMap.get(id);
                if (depends == null) {
                    depends = new ArrayList<String>();
                    scheduleDependsMap.put(id, depends);
                }
                depends.add(rs.getString(this.scheduleDependsMasterTableSchema.dependsId));
            }
            Iterator itr = scheduleDependsMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                List depends = (List)entry.getValue();
                if (depends.size() == 0) continue;
                ((DefaultScheduleMaster)schedule).setDepends(depends.toArray(new String[depends.size()]));
            }
            rs.close();
        }
        return schedules;
    }

    protected ScheduleMaster setGroupIdsOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setGroupIdsOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    protected List setGroupIdsOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, ScheduleMaster> scheduleMap = new HashMap<String, ScheduleMaster>();
        HashMap<String, ArrayList<String>> scheduleGroupIdsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            ScheduleMaster schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleGroupIdsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleGroupMasterTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleGroupMasterTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                schedule = (ScheduleMaster)schedules.get(j);
                buf.append('\'').append(schedule.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule.getId(), schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleGroupMasterTableSchema.id);
                ArrayList<String> groupIds = (ArrayList<String>)scheduleGroupIdsMap.get(id);
                if (groupIds == null) {
                    groupIds = new ArrayList<String>();
                    scheduleGroupIdsMap.put(id, groupIds);
                }
                groupIds.add(rs.getString(this.scheduleGroupMasterTableSchema.groupId));
            }
            Iterator itr = scheduleGroupIdsMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                List groupIds = (List)entry.getValue();
                if (groupIds.size() == 0) continue;
                ((DefaultScheduleMaster)schedule).setGroupIds(groupIds.toArray(new String[groupIds.size()]));
            }
            rs.close();
        }
        return schedules;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findAllSchedules() throws ScheduleManageException {
        block28: {
            block24: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e) {
                    throw new ScheduleManageException(e);
                }
                st = null;
                rs = null;
                try {
                    try {
                        st = con.createStatement();
                        rs = st.executeQuery("select * from " + this.scheduleTableSchema.table);
                        result = new ArrayList<Schedule>();
                        while (rs.next()) {
                            result.add(this.createSchedule(rs));
                        }
                        this.setDependsOnSchedules(con, result);
                        var5_11 = result;
                        var7_12 = null;
                        if (rs == null) break block24;
                    }
                    catch (ParseException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (SQLException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (IOException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (ConvertException e) {
                        throw new ScheduleManageException(e);
                    }
                }
                catch (Throwable var6_16) {
                    var7_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (con == null) throw var6_16;
                    try {
                        con.close();
                        throw var6_16;
                    }
                    catch (SQLException e) {
                        throw var6_16;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [8 : 194->203)] { 
lbl60:
                // 1 sources

                rs.close();
                break block24;
lbl62:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [9 : 209->218)] { 
lbl67:
                // 1 sources

                st.close();
                break block28;
lbl69:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var5_11;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var5_11;
        }
        con.close();
        return var5_11;
    }

    protected Schedule createSchedule(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        String executeEndTimeStr;
        String retryEndTimeStr;
        DefaultSchedule schedule = new DefaultSchedule();
        schedule.setId(rs.getString(this.scheduleTableSchema.id));
        schedule.setGroupId(rs.getString(this.scheduleTableSchema.groupId));
        schedule.setMasterId(rs.getString(this.scheduleTableSchema.masterId));
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
        String str = rs.getString(this.scheduleTableSchema.date) + rs.getString(this.scheduleTableSchema.time);
        schedule.setTime(format.parse(str));
        schedule.setTaskName(rs.getString(this.scheduleTableSchema.taskName));
        Object input = this.scheduleTableSchema.getInputObject(rs);
        if (this.isJsonInput && input instanceof String) {
            BeanJSONConverter jsonConverter = new BeanJSONConverter();
            jsonConverter.setUnicodeEscape(false);
            StringStreamConverter streamConverter = new StringStreamConverter();
            input = jsonConverter.convertToObject(streamConverter.convertToStream(input));
        }
        schedule.setInput(input);
        schedule.setOutput(this.scheduleTableSchema.getOutputObject(rs));
        str = rs.getString(this.scheduleTableSchema.initialDate) + rs.getString(this.scheduleTableSchema.initialTime);
        schedule.setInitialTime(format.parse(str));
        long longVal = rs.getLong(this.scheduleTableSchema.retryInterval);
        if (!rs.wasNull()) {
            schedule.setRetryInterval(longVal);
        }
        if ((retryEndTimeStr = rs.getString(this.scheduleTableSchema.retryEndTime)) != null) {
            schedule.setRetryEndTime(format.parse(retryEndTimeStr));
        }
        longVal = rs.getLong(this.scheduleTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            schedule.setMaxDelayTime(longVal);
        }
        schedule.setState(this.scheduleTableSchema.getState(rs.getString(this.scheduleTableSchema.state)));
        schedule.setControlState(this.scheduleTableSchema.getControlState(rs.getString(this.scheduleTableSchema.controlState)));
        schedule.setCheckState(this.scheduleTableSchema.getCheckState(rs.getString(this.scheduleTableSchema.checkState)));
        schedule.setExecutorKey(rs.getString(this.scheduleTableSchema.executorKey));
        schedule.setExecutorType(rs.getString(this.scheduleTableSchema.executorType));
        String executeStartTimeStr = rs.getString(this.scheduleTableSchema.executeStartTime);
        if (executeStartTimeStr != null) {
            schedule.setExecuteStartTime(format.parse(executeStartTimeStr));
        }
        if ((executeEndTimeStr = rs.getString(this.scheduleTableSchema.executeEndTime)) != null) {
            schedule.setExecuteEndTime(format.parse(executeEndTimeStr));
        }
        return schedule;
    }

    protected Schedule setDependsOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setDependsOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    protected List setDependsOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, Schedule> scheduleMap = new HashMap<String, Schedule>();
        HashMap<String, ArrayList<String>> scheduleDependsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            Schedule schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleDependsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleDependsTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleDependsTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                schedule = (Schedule)schedules.get(j);
                buf.append('\'').append(schedule.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule.getId(), schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleDependsTableSchema.id);
                ArrayList<String> depends = (ArrayList<String>)scheduleDependsMap.get(id);
                if (depends == null) {
                    depends = new ArrayList<String>();
                    scheduleDependsMap.put(id, depends);
                }
                depends.add(rs.getString(this.scheduleDependsTableSchema.dependsId));
            }
            Iterator itr = scheduleDependsMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                schedule = (DefaultSchedule)scheduleMap.get(entry.getKey());
                List depends = (List)entry.getValue();
                if (depends.size() == 0) continue;
                ((DefaultSchedule)schedule).setDepends(depends.toArray(new String[depends.size()]));
            }
            rs.close();
        }
        return schedules;
    }

    protected Schedule setGroupIdsOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setGroupIdsOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    protected List setGroupIdsOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, HashSet<Schedule>> scheduleMap = new HashMap<String, HashSet<Schedule>>();
        HashMap<String, ArrayList<String>> scheduleGroupIdsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            int startIndex;
            scheduleMap.clear();
            scheduleGroupIdsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleGroupMasterTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleGroupMasterTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                HashSet<Schedule> scheduleSet;
                Schedule schedule = (Schedule)schedules.get(j);
                buf.append('\'').append(schedule.getMasterId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                if ((scheduleSet = (HashSet<Schedule>)scheduleMap.get(schedule.getMasterId())) == null) {
                    scheduleSet = new HashSet<Schedule>();
                    scheduleMap.put(schedule.getMasterId(), scheduleSet);
                }
                scheduleSet.add(schedule);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleGroupMasterTableSchema.id);
                ArrayList<String> groupIds = (ArrayList<String>)scheduleGroupIdsMap.get(id);
                if (groupIds == null) {
                    groupIds = new ArrayList<String>();
                    scheduleGroupIdsMap.put(id, groupIds);
                }
                groupIds.add(rs.getString(this.scheduleGroupMasterTableSchema.groupId));
            }
            Iterator entries = scheduleGroupIdsMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Set scheduleSet = (Set)scheduleMap.get(entry.getKey());
                if (scheduleSet == null) continue;
                List groupIds = (List)entry.getValue();
                String[] ids = groupIds.toArray(new String[groupIds.size()]);
                Iterator itr = scheduleSet.iterator();
                while (itr.hasNext()) {
                    Schedule schedule = (Schedule)itr.next();
                    ((DefaultSchedule)schedule).setMasterGroupIds(ids);
                }
            }
            rs.close();
        }
        return schedules;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schedule findSchedule(String id) throws ScheduleManageException {
        block36: {
            block35: {
                block31: {
                    block34: {
                        block29: {
                            block30: {
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleManageException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                        st.setString(1, id);
                                        rs = st.executeQuery();
                                        if (!rs.next()) {
                                            var5_6 = null;
                                            var7_13 = null;
                                            if (rs == null) break block29;
                                            break block30;
                                        }
                                        var5_7 = this.setGroupIdsOnSchedule(con, this.setDependsOnSchedule(con, this.createSchedule(rs)));
                                        break block31;
                                    }
                                    catch (ParseException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (IOException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (ConvertException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                }
                                catch (Throwable var6_19) {
                                    var7_15 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var6_19;
                                    try {
                                        con.close();
                                        throw var6_19;
                                    }
                                    catch (SQLException e) {
                                        throw var6_19;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [14 : 218->228)] { 
lbl58:
                            // 1 sources

                            rs.close();
                            break block29;
lbl60:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [15 : 234->243)] { 
lbl65:
                            // 1 sources

                            st.close();
                            break block34;
lbl67:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var5_6;
                    ** try [egrp 5[TRYBLOCK] [16 : 249->258)] { 
lbl72:
                    // 1 sources

                    con.close();
                    return var5_6;
lbl74:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var5_6;
                }
                var7_14 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [14 : 218->228)] { 
lbl81:
                    // 1 sources

                    rs.close();
                    break block35;
lbl83:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [15 : 234->243)] { 
lbl88:
                // 1 sources

                st.close();
                break block36;
lbl90:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var5_7;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var5_7;
        }
        con.close();
        return var5_7;
    }

    /*
     * Loose catch block
     */
    public List findSchedules(String groupId) throws ScheduleManageException {
        ArrayList<Schedule> result;
        block27: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block25: {
                result = new ArrayList<Schedule>();
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.groupId + "=?");
                st.setString(1, groupId);
                rs = st.executeQuery();
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                this.setDependsOnSchedules(con, result);
                this.setGroupIdsOnSchedules(con, result);
                Object var8_7 = null;
                if (rs == null) break block25;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block27;
            {
                catch (ParseException e4) {
                    throw new ScheduleManageException(e4);
                }
                catch (SQLException e5) {
                    throw new ScheduleManageException(e5);
                }
                catch (IOException e6) {
                    throw new ScheduleManageException(e6);
                }
                catch (ClassNotFoundException e7) {
                    throw new ScheduleManageException(e7);
                }
                catch (ConvertException e8) {
                    throw new ScheduleManageException(e8);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var8_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Collections.sort(result);
        return result;
    }

    /*
     * Loose catch block
     */
    public List findSchedules(String masterId, String masterGroupId) throws ScheduleManageException {
        ArrayList<Schedule> result;
        block29: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block27: {
                result = new ArrayList<Schedule>();
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                if (masterId != null) {
                    st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
                    st.setString(1, masterId);
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.groupId).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A, ").append("(select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?) B ").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleGroupMasterTableSchema.id);
                    st = con.prepareStatement(buf.toString());
                    st.setString(1, masterGroupId);
                }
                rs = st.executeQuery();
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                this.setDependsOnSchedules(con, result);
                this.setGroupIdsOnSchedules(con, result);
                Object var9_14 = null;
                if (rs == null) break block27;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block29;
            {
                catch (ParseException e4) {
                    throw new ScheduleManageException(e4);
                }
                catch (SQLException e5) {
                    throw new ScheduleManageException(e5);
                }
                catch (IOException e6) {
                    throw new ScheduleManageException(e6);
                }
                catch (ClassNotFoundException e7) {
                    throw new ScheduleManageException(e7);
                }
                catch (ConvertException e8) {
                    throw new ScheduleManageException(e8);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_15 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Collections.sort(result);
        return result;
    }

    public List findSchedules(Date date) throws ScheduleManageException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date from = cal.getTime();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date to = cal.getTime();
        return this.findSchedules(from, to);
    }

    public List findSchedules(Date from, Date to) throws ScheduleManageException {
        return this.findSchedules(from, to, null);
    }

    public List findSchedules(int[] states) throws ScheduleManageException {
        return this.findSchedules(null, null, states);
    }

    public List findSchedules(Date from, Date to, int[] states) throws ScheduleManageException {
        return this.findSchedules(from, to, states, null, null, null, null, null, false);
    }

    public List findSchedules(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId) throws ScheduleManageException {
        return this.findSchedules(from, to, states, masterId, masterGroupId, groupId, null, null, false);
    }

    protected StringBuffer concatQuery(StringBuffer buf, String s1, String s2) {
        if (this.isUseConcatFunction) {
            buf.append("concat(").append(s1).append(',').append(s2).append(')');
        } else {
            buf.append(s1).append("||").append(s2);
        }
        return buf;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List findSchedules(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId, String[] executorTypes, String executorKey, boolean isLock) throws ScheduleManageException {
        block64: {
            block60: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e) {
                    throw new ScheduleManageException(e);
                }
                st = null;
                rs = null;
                try {
                    try {
                        buf = new StringBuffer();
                        buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.groupId).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A");
                        isAppendWhere = false;
                        if (masterGroupId != null) {
                            buf.append(", (select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?) B ").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleGroupMasterTableSchema.id);
                            isAppendWhere = true;
                        } else if (masterId != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            }
                            buf.append("A.").append(this.scheduleTableSchema.masterId).append("=?");
                        }
                        if (groupId != null) {
                            if (!isAppendWhere) {
                                buf.append(" where (");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            buf.append("A.").append(this.scheduleTableSchema.groupId).append(" =?)");
                        }
                        if (executorTypes != null && executorTypes.length != 0) {
                            if (!isAppendWhere) {
                                buf.append(" where (");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            buf.append("A.").append(this.scheduleTableSchema.executorType).append(" is null or ");
                            for (i = 0; i < executorTypes.length; ++i) {
                                buf.append(this.scheduleTableSchema.executorType);
                                buf.append("=?");
                                if (i == executorTypes.length - 1) continue;
                                buf.append(" or ");
                            }
                            buf.append(')');
                        }
                        if (executorKey != null) {
                            if (!isAppendWhere) {
                                buf.append(" where (");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            buf.append("A.").append(this.scheduleTableSchema.executorKey).append(" is null or ").append(this.scheduleTableSchema.executorKey).append(" =?)");
                        }
                        if (states != null && states.length != 0) {
                            if (!isAppendWhere) {
                                buf.append(" where (");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            for (i = 0; i < states.length; ++i) {
                                buf.append("A.").append(this.scheduleTableSchema.state).append("=?");
                                if (i == states.length - 1) continue;
                                buf.append(" or ");
                            }
                            buf.append(')');
                        }
                        if (from != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and ");
                            }
                            this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                            buf.append(">=?");
                        }
                        if (to != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and ");
                            }
                            this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                            buf.append("<=?");
                        }
                        if (isLock) {
                            buf.append(" for update");
                        }
                        st = con.prepareStatement(buf.toString());
                        buf = null;
                        format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                        index = 0;
                        if (masterId != null) {
                            st.setString(++index, masterId);
                        } else if (masterGroupId != null) {
                            st.setString(++index, masterGroupId);
                        }
                        if (groupId != null) {
                            st.setString(++index, groupId);
                        }
                        if (executorTypes != null && executorTypes.length != 0) {
                            for (i = 0; i < executorTypes.length; ++i) {
                                st.setString(++index, executorTypes[i]);
                            }
                        }
                        if (executorKey != null) {
                            st.setString(++index, executorKey);
                        }
                        if (states != null && states.length != 0) {
                            for (i = 0; i < states.length; ++i) {
                                st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                            }
                        }
                        if (from != null) {
                            st.setString(++index, format.format(from));
                        }
                        if (to != null) {
                            st.setString(++index, format.format(to));
                        }
                        rs = st.executeQuery();
                        result = new ArrayList<Schedule>();
                        while (rs.next()) {
                            result.add(this.createSchedule(rs));
                        }
                        this.setDependsOnSchedules(con, result);
                        this.setGroupIdsOnSchedules(con, result);
                        Collections.sort(result);
                        var18_26 = result;
                        var20_27 = null;
                        if (rs == null) break block60;
                    }
                    catch (ParseException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (SQLException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (IOException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (ConvertException e) {
                        throw new ScheduleManageException(e);
                    }
                }
                catch (Throwable var19_31) {
                    var20_28 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (con == null) throw var19_31;
                    try {
                        con.close();
                        throw var19_31;
                    }
                    catch (SQLException e) {
                        throw var19_31;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [8 : 1618->1628)] { 
lbl188:
                // 1 sources

                rs.close();
                break block60;
lbl190:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [9 : 1635->1645)] { 
lbl195:
                // 1 sources

                st.close();
                break block64;
lbl197:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var18_26;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var18_26;
        }
        con.close();
        return var18_26;
    }

    public List findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException {
        return this.findExecutableSchedules(date, executorTypes, null);
    }

    /*
     * Loose catch block
     */
    public List findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException {
        SQLException e32;
        List list;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            List result = this.findSchedules(null, date, new int[]{1, 8}, null, null, null, executorTypes, executorKey, this.isLockForFindExecutable);
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select count(1) from " + this.scheduleTableSchema.table + " A, " + "(" + " select " + this.scheduleDependsTableSchema.dependsId + " from " + this.scheduleDependsTableSchema.table + " where " + this.scheduleDependsTableSchema.id + "=?" + ") B " + " where A." + this.scheduleTableSchema.masterId + "=B." + this.scheduleDependsTableSchema.dependsId + " and A." + this.scheduleTableSchema.id + "<>?" + " and ((A." + this.scheduleTableSchema.state + "<>'" + this.scheduleTableSchema.stateString_END + '\'' + " and A." + this.scheduleTableSchema.state + "<>'" + this.scheduleTableSchema.stateString_DISABLE + '\'' + " and " + this.concatQuery(new StringBuffer(), "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime) + "<=?)" + " or (A." + this.scheduleTableSchema.state + "='" + this.scheduleTableSchema.stateString_ENTRY + '\'' + " or A." + this.scheduleTableSchema.state + "='" + this.scheduleTableSchema.stateString_RUN + '\'' + " or A." + this.scheduleTableSchema.state + "='" + this.scheduleTableSchema.stateString_PAUSE + "'))");
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            Iterator itr = result.iterator();
            while (itr.hasNext()) {
                int paramIndex = 1;
                Schedule schedule = (Schedule)itr.next();
                st.setString(paramIndex++, schedule.getId());
                st.setString(paramIndex++, schedule.getId());
                Date initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                st.setString(paramIndex++, format.format(initialTime));
                rs = st.executeQuery();
                rs.next();
                if (rs.getInt(1) == 0) continue;
                itr.remove();
            }
            Collections.sort(result);
            list = result;
            Object var14_16 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return list;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var14_17 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findDependsSchedules(String id) throws ScheduleManageException {
        block37: {
            block36: {
                block32: {
                    block35: {
                        block30: {
                            block31: {
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleManageException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        buf = new StringBuffer();
                                        buf.append("select * from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append('\'');
                                        st = con.createStatement();
                                        rs = st.executeQuery(buf.toString());
                                        result = new ArrayList<Schedule>();
                                        if (!rs.next()) {
                                            var7_13 = result;
                                            var12_15 = null;
                                            if (rs == null) break block30;
                                            break block31;
                                        }
                                        schedule = this.createSchedule(rs);
                                        initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                                        rs.close();
                                        rs = null;
                                        buf.setLength(0);
                                        buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.groupId).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A, ").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append("') B ").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>'").append(id).append('\'').append(" and ((A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'').append(" and ");
                                        format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                                        this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("<='").append(format.format(initialTime)).append("')").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))");
                                        rs = st.executeQuery(buf.toString());
                                        while (rs.next()) {
                                            result.add(this.createSchedule(rs));
                                        }
                                        rs.close();
                                        rs = null;
                                        this.setDependsOnSchedules(con, result);
                                        this.setGroupIdsOnSchedules(con, result);
                                        Collections.sort(result);
                                        var10_23 = result;
                                        break block32;
                                    }
                                    catch (ParseException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (IOException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (ClassNotFoundException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (ConvertException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                }
                                catch (Throwable var11_24) {
                                    var12_17 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var11_24;
                                    try {
                                        con.close();
                                        throw var11_24;
                                    }
                                    catch (SQLException e) {
                                        throw var11_24;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [14 : 1202->1212)] { 
lbl83:
                            // 1 sources

                            rs.close();
                            break block30;
lbl85:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [15 : 1218->1227)] { 
lbl90:
                            // 1 sources

                            st.close();
                            break block35;
lbl92:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var7_13;
                    ** try [egrp 5[TRYBLOCK] [16 : 1233->1242)] { 
lbl97:
                    // 1 sources

                    con.close();
                    return var7_13;
lbl99:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var7_13;
                }
                var12_16 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [14 : 1202->1212)] { 
lbl106:
                    // 1 sources

                    rs.close();
                    break block36;
lbl108:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [15 : 1218->1227)] { 
lbl113:
                // 1 sources

                st.close();
                break block37;
lbl115:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var10_23;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var10_23;
        }
        con.close();
        return var10_23;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findDependedSchedules(String id) throws ScheduleManageException {
        block49: {
            block48: {
                block42: {
                    block47: {
                        block46: {
                            block41: {
                                block45: {
                                    block39: {
                                        block40: {
                                            con = null;
                                            try {
                                                con = this.connectionFactory.getConnection();
                                            }
                                            catch (ConnectionFactoryException e) {
                                                throw new ScheduleManageException(e);
                                            }
                                            st = null;
                                            rs = null;
                                            try {
                                                try {
                                                    buf = new StringBuffer();
                                                    buf.append("select * from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'');
                                                    st = con.createStatement();
                                                    rs = st.executeQuery(buf.toString());
                                                    result = new ArrayList<Schedule>();
                                                    if (!rs.next()) {
                                                        var7_13 = result;
                                                        var17_15 = null;
                                                        if (rs == null) break block39;
                                                        break block40;
                                                    }
                                                    schedule = this.createSchedule(rs);
                                                    initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                                                    rs.close();
                                                    rs = null;
                                                    buf.setLength(0);
                                                    buf.append("select distinct ").append(this.scheduleDependsTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("=(select ").append(this.scheduleTableSchema.masterId).append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append("')");
                                                    rs = st.executeQuery(buf.toString());
                                                    idList = new ArrayList<Object>();
                                                    while (rs.next()) {
                                                        dependedId = rs.getString(1);
                                                        if (id.equals(dependedId)) continue;
                                                        idList.add(dependedId);
                                                    }
                                                    rs.close();
                                                    rs = null;
                                                    if (idList.size() == 0) {
                                                        dependedId = result;
                                                        break block41;
                                                    }
                                                    to = idList.size() % 1000 == 0 ? idList.size() / 1000 : idList.size() / 1000 + 1;
                                                    format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                                                    for (i = 0; i < to; ++i) {
                                                        buf.setLength(0);
                                                        buf.append("select * from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append(" in (");
                                                        jmax = Math.min(startIndex + 1000, idList.size());
                                                        for (j = startIndex = i * 1000; j < jmax; ++j) {
                                                            buf.append('\'').append(idList.get(j)).append('\'');
                                                            if (j == jmax - 1) continue;
                                                            buf.append(',');
                                                        }
                                                        buf.append(')').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'').append(" and ");
                                                        this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append(">='").append(format.format(initialTime)).append("'");
                                                        rs = st.executeQuery(buf.toString());
                                                        while (rs.next()) {
                                                            result.add(this.createSchedule(rs));
                                                        }
                                                        rs.close();
                                                        rs = null;
                                                    }
                                                    st.close();
                                                    st = null;
                                                    this.setDependsOnSchedules(con, result);
                                                    this.setGroupIdsOnSchedules(con, result);
                                                    Collections.sort(result);
                                                    var12_29 = result;
                                                    break block42;
                                                }
                                                catch (ParseException e) {
                                                    throw new ScheduleManageException(e);
                                                }
                                                catch (SQLException e) {
                                                    throw new ScheduleManageException(e);
                                                }
                                                catch (IOException e) {
                                                    throw new ScheduleManageException(e);
                                                }
                                                catch (ClassNotFoundException e) {
                                                    throw new ScheduleManageException(e);
                                                }
                                                catch (ConvertException e) {
                                                    throw new ScheduleManageException(e);
                                                }
                                            }
                                            catch (Throwable var16_33) {
                                                var17_18 = null;
                                                if (rs != null) {
                                                    try {
                                                        rs.close();
                                                    }
                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (st != null) {
                                                    try {
                                                        st.close();
                                                    }
                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (con == null) throw var16_33;
                                                try {
                                                    con.close();
                                                    throw var16_33;
                                                }
                                                catch (SQLException e) {
                                                    throw var16_33;
                                                }
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [20 : 991->1001)] { 
lbl115:
                                        // 1 sources

                                        rs.close();
                                        break block39;
lbl117:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 4[TRYBLOCK] [21 : 1007->1016)] { 
lbl122:
                                        // 1 sources

                                        st.close();
                                        break block45;
lbl124:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return var7_13;
                                ** try [egrp 5[TRYBLOCK] [22 : 1022->1031)] { 
lbl129:
                                // 1 sources

                                con.close();
                                return var7_13;
lbl131:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var7_13;
                            }
                            var17_16 = null;
                            if (rs != null) {
                                ** try [egrp 3[TRYBLOCK] [20 : 991->1001)] { 
lbl138:
                                // 1 sources

                                rs.close();
                                break block46;
lbl140:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [21 : 1007->1016)] { 
lbl145:
                            // 1 sources

                            st.close();
                            break block47;
lbl147:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return dependedId;
                    ** try [egrp 5[TRYBLOCK] [22 : 1022->1031)] { 
lbl152:
                    // 1 sources

                    con.close();
                    return dependedId;
lbl154:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return dependedId;
                }
                var17_17 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [20 : 991->1001)] { 
lbl161:
                    // 1 sources

                    rs.close();
                    break block48;
lbl163:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [21 : 1007->1016)] { 
lbl168:
                // 1 sources

                st.close();
                break block49;
lbl170:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var12_29;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var12_29;
        }
        con.close();
        return var12_29;
    }

    public void addSchedule(Schedule schedule) throws ScheduleManageException {
        this.addSchedule(schedule, true);
    }

    public void addSchedule(String masterId, Date time, String taskName, Object input, String[] depends, String executorKey, String executorType, long retryInterval, Date retryEndTime, long maxDelayTime) throws ScheduleManageException {
        this.addSchedule(new DefaultSchedule(masterId, null, time, taskName, input, depends, executorKey, executorType, retryInterval, retryEndTime, maxDelayTime));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reschedule(String id, Date time, Object output) throws ScheduleManageException {
        block25: {
            block21: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e) {
                    throw new ScheduleManageException(e);
                }
                st = null;
                rs = null;
                try {
                    try {
                        st = con.prepareStatement("select " + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                        st.setString(1, id);
                        rs = st.executeQuery();
                        if (!rs.next()) {
                            throw new ScheduleStateControlException("Schedule not found : " + id);
                        }
                        rowVersion = rs.getInt(1);
                        rs.close();
                        rs = null;
                        st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.date + "=?, " + this.scheduleTableSchema.time + "=?," + this.scheduleTableSchema.checkState + "='" + this.scheduleTableSchema.getCheckStateString(1) + "'," + this.scheduleTableSchema.output + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
                        index = 0;
                        format = new SimpleDateFormat(this.dateFormat);
                        st.setString(++index, format.format(time));
                        format.applyPattern(this.timeFormat);
                        st.setString(++index, format.format(time));
                        this.scheduleTableSchema.setOutputObject(++index, (PreparedStatement)st, output);
                        st.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
                        st.setString(++index, id);
                        var10_13 = st.executeUpdate() != 0;
                        var12_14 = null;
                        if (rs == null) break block21;
                    }
                    catch (SQLException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (IOException e) {
                        throw new ScheduleManageException(e);
                    }
                }
                catch (Throwable var11_18) {
                    var12_15 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (con == null) throw var11_18;
                    try {
                        con.close();
                        throw var11_18;
                    }
                    catch (SQLException e) {
                        throw var11_18;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 600->610)] { 
lbl62:
                // 1 sources

                rs.close();
                break block21;
lbl64:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 617->627)] { 
lbl69:
                // 1 sources

                st.close();
                break block25;
lbl71:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var10_13;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var10_13;
        }
        con.close();
        return var10_13;
    }

    /*
     * Loose catch block
     */
    public boolean removeSchedule(String id) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block14: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            bl = st.executeUpdate() != 0;
            Object var6_7 = null;
            if (st == null) break block14;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException e32;
                    Object var6_8 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block16;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeScheduleByMasterId(String masterId, String masterGroupId) throws ScheduleManageException {
        SQLException e32;
        boolean buf222;
        Statement st;
        Connection con;
        block16: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            if (masterId != null) {
                st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
                st.setString(1, masterId);
            } else {
                StringBuffer buf222 = new StringBuffer();
                buf222.append("delete from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.masterId).append(" in (").append("select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?)");
                st = con.prepareStatement(buf222.toString());
                st.setString(1, masterGroupId);
            }
            buf222 = st.executeUpdate() != 0;
            Object var7_9 = null;
            if (st == null) break block16;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return buf222;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block18: {
                    SQLException e32;
                    Object var7_10 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block18;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeSchedule(Date date) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block14: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.date + "=?");
            st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
            bl = st.executeUpdate() != 0;
            Object var6_7 = null;
            if (st == null) break block14;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException e32;
                    Object var6_8 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block16;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeSchedule(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block40: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            StringBuffer buf = new StringBuffer();
            buf.append("delete from ");
            buf.append(this.scheduleTableSchema.table);
            boolean isAppendWhere = false;
            if (masterId != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                }
                buf.append(this.scheduleTableSchema.masterId);
                buf.append("=?");
            } else if (masterGroupId != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                }
                buf.append(this.scheduleTableSchema.masterId).append(" in (").append("select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?)");
            }
            if (groupId != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append(this.scheduleTableSchema.groupId);
                buf.append("=?");
            }
            if (states != null && states.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                for (int i = 0; i < states.length; ++i) {
                    buf.append(this.scheduleTableSchema.state);
                    buf.append("=?");
                    if (i == states.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (from != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append(">=?");
            }
            if (to != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, this.scheduleTableSchema.date, this.scheduleTableSchema.time);
                buf.append("<=?");
            }
            st = con.prepareStatement(buf.toString());
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            int index = 0;
            if (masterId != null) {
                st.setString(++index, masterId);
            } else if (masterGroupId != null) {
                st.setString(++index, masterGroupId);
            }
            if (groupId != null) {
                st.setString(++index, groupId);
            }
            if (states != null && states.length != 0) {
                for (int i = 0; i < states.length; ++i) {
                    st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                }
            }
            if (from != null) {
                st.setString(++index, format.format(from));
            }
            if (to != null) {
                st.setString(++index, format.format(to));
            }
            bl = st.executeUpdate() != 0;
            Object var15_17 = null;
            if (st == null) break block40;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block42: {
                    SQLException e32;
                    Object var15_18 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block42;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void setExecutorKey(String id, String key) throws ScheduleManageException {
        block24: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block22: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.executorKey + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                if (key == null) {
                    st.setNull(1, 12);
                } else {
                    st.setString(1, key);
                }
                st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                st.setString(3, id);
                st.executeUpdate();
                Object var8_7 = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block24;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var8_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void setRetryEndTime(String id, Date time) throws ScheduleManageException {
        block24: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block22: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.retryEndTime + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                if (time == null) {
                    st.setNull(1, 1);
                } else {
                    st.setString(1, format.format(time));
                }
                st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                st.setString(3, id);
                st.executeUpdate();
                Object var9_8 = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block24;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_9 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void setMaxDelayTime(String id, long time) throws ScheduleManageException {
        block24: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block22: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.maxDelayTime + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                if (time <= 0L) {
                    st.setNull(1, 3);
                } else {
                    st.setLong(1, time);
                }
                st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                st.setString(3, id);
                st.executeUpdate();
                Object var9_7 = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block24;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getState(String id) throws ScheduleStateControlException {
        SQLException e32;
        int n;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleStateControlException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            n = this.scheduleTableSchema.getState(rs.getString(1));
            Object var7_8 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return n;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var7_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getControlState(String id) throws ScheduleStateControlException {
        SQLException e32;
        int n;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleStateControlException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            n = this.scheduleTableSchema.getControlState(rs.getString(1));
            Object var7_8 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return n;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var7_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean changeState(String id, int state) throws ScheduleStateControlException {
        SQLException e222222;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block38: {
            String newStateStr;
            int rowVersion;
            Date executeEndTime;
            Date executeStartTime;
            boolean isUpdateExecuteEndTime;
            boolean isUpdateExecuteStartTime;
            block34: {
                SQLException e222222;
                boolean bl2;
                block35: {
                    isUpdateExecuteStartTime = false;
                    isUpdateExecuteEndTime = false;
                    executeStartTime = null;
                    executeEndTime = null;
                    switch (state) {
                        case 3: {
                            executeStartTime = new Date();
                            isUpdateExecuteStartTime = true;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 7: {
                            executeEndTime = new Date();
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            isUpdateExecuteStartTime = true;
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 6: 
                        case 8: 
                        case 9: {
                            break;
                        }
                        default: {
                            throw new ScheduleStateControlException("Unknown state : " + state);
                        }
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e3) {
                        throw new ScheduleStateControlException(e3);
                    }
                    st = null;
                    rs = null;
                    st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                    st.setString(1, id);
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleStateControlException("Schedule not found : " + id);
                    }
                    String oldStateStr = rs.getString(1);
                    rowVersion = rs.getInt(2);
                    rs.close();
                    rs = null;
                    newStateStr = this.scheduleTableSchema.getStateString(state);
                    if (!oldStateStr.equals(newStateStr)) break block34;
                    bl2 = false;
                    Object var17_17 = null;
                    if (rs == null) break block35;
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0;
            Object var17_18 = null;
            if (rs == null) break block38;
            try {
                rs.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block41: {
                    SQLException e222222;
                    Object var17_19 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block41;
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException {
        SQLException e222222;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block38: {
            String newStateStr;
            int rowVersion;
            Date executeEndTime;
            Date executeStartTime;
            boolean isUpdateExecuteEndTime;
            boolean isUpdateExecuteStartTime;
            block34: {
                SQLException e222222;
                boolean bl2;
                block35: {
                    isUpdateExecuteStartTime = false;
                    isUpdateExecuteEndTime = false;
                    executeStartTime = null;
                    executeEndTime = null;
                    switch (newState) {
                        case 3: {
                            executeStartTime = new Date();
                            isUpdateExecuteStartTime = true;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 7: {
                            executeEndTime = new Date();
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            isUpdateExecuteStartTime = true;
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 6: 
                        case 8: 
                        case 9: {
                            break;
                        }
                        default: {
                            throw new ScheduleStateControlException("Unknown state : " + newState);
                        }
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e3) {
                        throw new ScheduleStateControlException(e3);
                    }
                    st = null;
                    rs = null;
                    st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                    st.setString(1, id);
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleStateControlException("Schedule not found : " + id);
                    }
                    String oldStateStr = rs.getString(1);
                    rowVersion = rs.getInt(2);
                    rs.close();
                    rs = null;
                    newStateStr = this.scheduleTableSchema.getStateString(newState);
                    if (!oldStateStr.equals(newStateStr)) break block34;
                    bl2 = false;
                    Object var18_18 = null;
                    if (rs == null) break block35;
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
            bl = st.executeUpdate() != 0;
            Object var18_19 = null;
            if (rs == null) break block38;
            try {
                rs.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block41: {
                    SQLException e222222;
                    Object var18_20 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block41;
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeState(String id, int oldState, int newState, Object output) throws ScheduleStateControlException {
        block42: {
            block41: {
                block37: {
                    block40: {
                        block35: {
                            block36: {
                                isUpdateExecuteStartTime = false;
                                isUpdateExecuteEndTime = false;
                                executeStartTime = null;
                                executeEndTime = null;
                                switch (newState) {
                                    case 3: {
                                        executeStartTime = new Date();
                                        isUpdateExecuteStartTime = true;
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 7: {
                                        executeEndTime = new Date();
                                        isUpdateExecuteEndTime = true;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        isUpdateExecuteStartTime = true;
                                        isUpdateExecuteEndTime = true;
                                        break;
                                    }
                                    case 6: 
                                    case 8: 
                                    case 9: {
                                        break;
                                    }
                                    default: {
                                        throw new ScheduleStateControlException("Unknown state : " + newState);
                                    }
                                }
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleStateControlException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                        st.setString(1, id);
                                        rs = st.executeQuery();
                                        if (!rs.next()) {
                                            throw new ScheduleStateControlException("Schedule not found : " + id);
                                        }
                                        oldStateStr = rs.getString(1);
                                        rowVersion = rs.getInt(2);
                                        rs.close();
                                        rs = null;
                                        newStateStr = this.scheduleTableSchema.getStateString(newState);
                                        if (oldStateStr.equals(newStateStr)) {
                                            var15_18 = false;
                                            var19_20 = null;
                                            if (rs == null) break block35;
                                            break block36;
                                        }
                                        st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime != false ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime != false ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.output + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
                                        i = 0;
                                        st.setString(++i, newStateStr);
                                        format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                                        if (isUpdateExecuteStartTime) {
                                            st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
                                        }
                                        if (isUpdateExecuteEndTime) {
                                            st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
                                        }
                                        this.scheduleTableSchema.setOutputObject(++i, (PreparedStatement)st, output);
                                        st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                                        st.setString(++i, id);
                                        st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
                                        var17_27 = st.executeUpdate() != 0;
                                        break block37;
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleStateControlException(e);
                                    }
                                    catch (IOException e) {
                                        throw new ScheduleStateControlException(e);
                                    }
                                }
                                catch (Throwable var18_28) {
                                    var19_22 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var18_28;
                                    try {
                                        con.close();
                                        throw var18_28;
                                    }
                                    catch (SQLException e) {
                                        throw var18_28;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [8 : 911->921)] { 
lbl92:
                            // 1 sources

                            rs.close();
                            break block35;
lbl94:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [9 : 928->938)] { 
lbl99:
                            // 1 sources

                            st.close();
                            break block40;
lbl101:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var15_18;
                    ** try [egrp 5[TRYBLOCK] [10 : 945->955)] { 
lbl106:
                    // 1 sources

                    con.close();
                    return var15_18;
lbl108:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var15_18;
                }
                var19_21 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [8 : 911->921)] { 
lbl115:
                    // 1 sources

                    rs.close();
                    break block41;
lbl117:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [9 : 928->938)] { 
lbl122:
                // 1 sources

                st.close();
                break block42;
lbl124:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var17_27;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var17_27;
        }
        con.close();
        return var17_27;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException {
        block42: {
            block41: {
                block37: {
                    block40: {
                        block35: {
                            block36: {
                                isUpdateExecuteStartTime = false;
                                isUpdateExecuteEndTime = false;
                                executeStartTime = null;
                                executeEndTime = null;
                                switch (state) {
                                    case 3: {
                                        executeStartTime = new Date();
                                        isUpdateExecuteStartTime = true;
                                        break;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 7: {
                                        executeEndTime = new Date();
                                        isUpdateExecuteEndTime = true;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        isUpdateExecuteStartTime = true;
                                        isUpdateExecuteEndTime = true;
                                        break;
                                    }
                                    case 6: 
                                    case 8: 
                                    case 9: {
                                        break;
                                    }
                                    default: {
                                        throw new ScheduleStateControlException("Unknown state : " + state);
                                    }
                                }
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleStateControlException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                        st.setString(1, id);
                                        rs = st.executeQuery();
                                        if (!rs.next()) {
                                            throw new ScheduleStateControlException("Schedule not found : " + id);
                                        }
                                        oldStateStr = rs.getString(1);
                                        rowVersion = rs.getInt(2);
                                        rs.close();
                                        rs = null;
                                        newStateStr = this.scheduleTableSchema.getStateString(state);
                                        if (oldStateStr.equals(newStateStr)) {
                                            var14_17 = false;
                                            var18_19 = null;
                                            if (rs == null) break block35;
                                            break block36;
                                        }
                                        st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + this.scheduleTableSchema.output + "=?," + (isUpdateExecuteStartTime != false ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime != false ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
                                        i = 0;
                                        st.setString(++i, newStateStr);
                                        this.scheduleTableSchema.setOutputObject(++i, (PreparedStatement)st, output);
                                        format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                                        if (isUpdateExecuteStartTime) {
                                            st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
                                        }
                                        if (isUpdateExecuteEndTime) {
                                            st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
                                        }
                                        st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                                        st.setString(++i, id);
                                        var16_26 = st.executeUpdate() != 0 && newStateStr.equals(oldStateStr) == false;
                                        break block37;
                                    }
                                    catch (IOException e) {
                                        throw new ScheduleStateControlException(e);
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleStateControlException(e);
                                    }
                                }
                                catch (Throwable var17_27) {
                                    var18_21 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var17_27;
                                    try {
                                        con.close();
                                        throw var17_27;
                                    }
                                    catch (SQLException e) {
                                        throw var17_27;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [8 : 884->894)] { 
lbl91:
                            // 1 sources

                            rs.close();
                            break block35;
lbl93:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [9 : 901->911)] { 
lbl98:
                            // 1 sources

                            st.close();
                            break block40;
lbl100:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var14_17;
                    ** try [egrp 5[TRYBLOCK] [10 : 918->928)] { 
lbl105:
                    // 1 sources

                    con.close();
                    return var14_17;
lbl107:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var14_17;
                }
                var18_20 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [8 : 884->894)] { 
lbl114:
                    // 1 sources

                    rs.close();
                    break block41;
lbl116:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [9 : 901->911)] { 
lbl121:
                // 1 sources

                st.close();
                break block42;
lbl123:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var16_26;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var16_26;
        }
        con.close();
        return var16_26;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException {
        block68: {
            block67: {
                block57: {
                    block66: {
                        block65: {
                            block56: {
                                block64: {
                                    block63: {
                                        block55: {
                                            block62: {
                                                block61: {
                                                    block54: {
                                                        block60: {
                                                            block52: {
                                                                block53: {
                                                                    con = null;
                                                                    try {
                                                                        con = this.connectionFactory.getConnection();
                                                                    }
                                                                    catch (ConnectionFactoryException e) {
                                                                        throw new ScheduleStateControlException(e);
                                                                    }
                                                                    result = false;
                                                                    st = null;
                                                                    rs = null;
                                                                    try {
                                                                        try {
                                                                            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, id);
                                                                            rs = st.executeQuery();
                                                                            if (!rs.next()) {
                                                                                throw new ScheduleStateControlException("Schedule not found : " + id);
                                                                            }
                                                                            oldStateStr = rs.getString(1);
                                                                            nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
                                                                            rowVersion = rs.getInt(2);
                                                                            rs.close();
                                                                            rs = null;
                                                                            if (nowOldState == state) {
                                                                                var10_12 = false;
                                                                                var16_17 = null;
                                                                                if (rs == null) break block52;
                                                                                break block53;
                                                                            }
                                                                            switch (state) {
                                                                                case 2: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var10_13 = false;
                                                                                    break block54;
                                                                                }
                                                                                case 3: {
                                                                                    if (nowOldState == 6) break;
                                                                                    var10_14 = false;
                                                                                    break block55;
                                                                                }
                                                                                case 4: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var10_15 = false;
                                                                                    break block56;
                                                                                }
                                                                                default: {
                                                                                    throw new ScheduleStateControlException("Unknown state : " + state);
                                                                                }
                                                                            }
                                                                            newStateStr = this.scheduleTableSchema.getControlStateString(state);
                                                                            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, newStateStr);
                                                                            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                                                                            st.setString(3, id);
                                                                            v0 = result = st.executeUpdate() != 0;
                                                                            if (!result) break block57;
                                                                            try {
                                                                                if (this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
                                                                                    var11_29 = this.scheduleControlListeners;
                                                                                    synchronized (var11_29) {
                                                                                        itr = this.scheduleControlListeners.iterator();
                                                                                        while (itr.hasNext()) {
                                                                                            listener = (ScheduleControlListener)itr.next();
                                                                                            listener.changedControlState(id, state);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                break block57;
                                                                            }
                                                                            catch (ScheduleStateControlException e) {
                                                                                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                                                                                st.executeUpdate();
                                                                                throw e;
                                                                            }
                                                                        }
                                                                        catch (SQLException e) {
                                                                            throw new ScheduleStateControlException(e);
                                                                        }
                                                                    }
                                                                    catch (Throwable var15_33) {
                                                                        var16_22 = null;
                                                                        if (rs != null) {
                                                                            try {
                                                                                rs.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (st != null) {
                                                                            try {
                                                                                st.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (con == null) throw var15_33;
                                                                        try {
                                                                            con.close();
                                                                            throw var15_33;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            // empty catch block
                                                                        }
                                                                        throw var15_33;
                                                                    }
                                                                }
                                                                ** try [egrp 5[TRYBLOCK] [15 : 706->716)] { 
lbl96:
                                                                // 1 sources

                                                                rs.close();
                                                                break block52;
lbl98:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (st != null) {
                                                                ** try [egrp 6[TRYBLOCK] [16 : 723->733)] { 
lbl103:
                                                                // 1 sources

                                                                st.close();
                                                                break block60;
lbl105:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con == null) return var10_12;
                                                        ** try [egrp 7[TRYBLOCK] [17 : 739->748)] { 
lbl110:
                                                        // 1 sources

                                                        con.close();
                                                        return var10_12;
lbl112:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                        return var10_12;
                                                    }
                                                    var16_18 = null;
                                                    if (rs != null) {
                                                        ** try [egrp 5[TRYBLOCK] [15 : 706->716)] { 
lbl119:
                                                        // 1 sources

                                                        rs.close();
                                                        break block61;
lbl121:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (st != null) {
                                                    ** try [egrp 6[TRYBLOCK] [16 : 723->733)] { 
lbl126:
                                                    // 1 sources

                                                    st.close();
                                                    break block62;
lbl128:
                                                    // 1 sources

                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (con == null) return var10_13;
                                            ** try [egrp 7[TRYBLOCK] [17 : 739->748)] { 
lbl133:
                                            // 1 sources

                                            con.close();
                                            return var10_13;
lbl135:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                            return var10_13;
                                        }
                                        var16_19 = null;
                                        if (rs != null) {
                                            ** try [egrp 5[TRYBLOCK] [15 : 706->716)] { 
lbl142:
                                            // 1 sources

                                            rs.close();
                                            break block63;
lbl144:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 6[TRYBLOCK] [16 : 723->733)] { 
lbl149:
                                        // 1 sources

                                        st.close();
                                        break block64;
lbl151:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return var10_14;
                                ** try [egrp 7[TRYBLOCK] [17 : 739->748)] { 
lbl156:
                                // 1 sources

                                con.close();
                                return var10_14;
lbl158:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var10_14;
                            }
                            var16_20 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [15 : 706->716)] { 
lbl165:
                                // 1 sources

                                rs.close();
                                break block65;
lbl167:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (st != null) {
                            ** try [egrp 6[TRYBLOCK] [16 : 723->733)] { 
lbl172:
                            // 1 sources

                            st.close();
                            break block66;
lbl174:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var10_15;
                    ** try [egrp 7[TRYBLOCK] [17 : 739->748)] { 
lbl179:
                    // 1 sources

                    con.close();
                    return var10_15;
lbl181:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var10_15;
                }
                var16_21 = null;
                if (rs != null) {
                    ** try [egrp 5[TRYBLOCK] [15 : 706->716)] { 
lbl188:
                    // 1 sources

                    rs.close();
                    break block67;
lbl190:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 6[TRYBLOCK] [16 : 723->733)] { 
lbl195:
                // 1 sources

                st.close();
                break block68;
lbl197:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return result;
        try {}
        catch (SQLException e) {}
        con.close();
        return result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException {
        block68: {
            block67: {
                block57: {
                    block66: {
                        block65: {
                            block56: {
                                block64: {
                                    block63: {
                                        block55: {
                                            block62: {
                                                block61: {
                                                    block54: {
                                                        block60: {
                                                            block52: {
                                                                block53: {
                                                                    con = null;
                                                                    try {
                                                                        con = this.connectionFactory.getConnection();
                                                                    }
                                                                    catch (ConnectionFactoryException e) {
                                                                        throw new ScheduleStateControlException(e);
                                                                    }
                                                                    result = false;
                                                                    st = null;
                                                                    rs = null;
                                                                    try {
                                                                        try {
                                                                            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, id);
                                                                            rs = st.executeQuery();
                                                                            if (!rs.next()) {
                                                                                throw new ScheduleStateControlException("Schedule not found : " + id);
                                                                            }
                                                                            oldStateStr = rs.getString(1);
                                                                            nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
                                                                            rowVersion = rs.getInt(2);
                                                                            rs.close();
                                                                            rs = null;
                                                                            if (nowOldState == newState) {
                                                                                var11_13 = false;
                                                                                var17_18 = null;
                                                                                if (rs == null) break block52;
                                                                                break block53;
                                                                            }
                                                                            switch (newState) {
                                                                                case 2: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var11_14 = false;
                                                                                    break block54;
                                                                                }
                                                                                case 3: {
                                                                                    if (nowOldState == 6) break;
                                                                                    var11_15 = false;
                                                                                    break block55;
                                                                                }
                                                                                case 4: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var11_16 = false;
                                                                                    break block56;
                                                                                }
                                                                                default: {
                                                                                    throw new ScheduleStateControlException("Unknown state : " + newState);
                                                                                }
                                                                            }
                                                                            newStateStr = this.scheduleTableSchema.getControlStateString(newState);
                                                                            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.controlState + "=?");
                                                                            st.setString(1, newStateStr);
                                                                            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                                                                            st.setString(3, id);
                                                                            st.setString(4, this.scheduleTableSchema.getControlStateString(oldState));
                                                                            v0 = result = st.executeUpdate() != 0;
                                                                            if (!result) break block57;
                                                                            try {
                                                                                if (this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
                                                                                    var12_30 = this.scheduleControlListeners;
                                                                                    synchronized (var12_30) {
                                                                                        itr = this.scheduleControlListeners.iterator();
                                                                                        while (itr.hasNext()) {
                                                                                            listener = (ScheduleControlListener)itr.next();
                                                                                            listener.changedControlState(id, newState);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                break block57;
                                                                            }
                                                                            catch (ScheduleStateControlException e) {
                                                                                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                                                                                st.executeUpdate();
                                                                                throw e;
                                                                            }
                                                                        }
                                                                        catch (SQLException e) {
                                                                            throw new ScheduleStateControlException(e);
                                                                        }
                                                                    }
                                                                    catch (Throwable var16_34) {
                                                                        var17_23 = null;
                                                                        if (rs != null) {
                                                                            try {
                                                                                rs.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (st != null) {
                                                                            try {
                                                                                st.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (con == null) throw var16_34;
                                                                        try {
                                                                            con.close();
                                                                            throw var16_34;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            // empty catch block
                                                                        }
                                                                        throw var16_34;
                                                                    }
                                                                }
                                                                ** try [egrp 5[TRYBLOCK] [15 : 743->753)] { 
lbl97:
                                                                // 1 sources

                                                                rs.close();
                                                                break block52;
lbl99:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (st != null) {
                                                                ** try [egrp 6[TRYBLOCK] [16 : 760->770)] { 
lbl104:
                                                                // 1 sources

                                                                st.close();
                                                                break block60;
lbl106:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con == null) return var11_13;
                                                        ** try [egrp 7[TRYBLOCK] [17 : 777->787)] { 
lbl111:
                                                        // 1 sources

                                                        con.close();
                                                        return var11_13;
lbl113:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                        return var11_13;
                                                    }
                                                    var17_19 = null;
                                                    if (rs != null) {
                                                        ** try [egrp 5[TRYBLOCK] [15 : 743->753)] { 
lbl120:
                                                        // 1 sources

                                                        rs.close();
                                                        break block61;
lbl122:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (st != null) {
                                                    ** try [egrp 6[TRYBLOCK] [16 : 760->770)] { 
lbl127:
                                                    // 1 sources

                                                    st.close();
                                                    break block62;
lbl129:
                                                    // 1 sources

                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (con == null) return var11_14;
                                            ** try [egrp 7[TRYBLOCK] [17 : 777->787)] { 
lbl134:
                                            // 1 sources

                                            con.close();
                                            return var11_14;
lbl136:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                            return var11_14;
                                        }
                                        var17_20 = null;
                                        if (rs != null) {
                                            ** try [egrp 5[TRYBLOCK] [15 : 743->753)] { 
lbl143:
                                            // 1 sources

                                            rs.close();
                                            break block63;
lbl145:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 6[TRYBLOCK] [16 : 760->770)] { 
lbl150:
                                        // 1 sources

                                        st.close();
                                        break block64;
lbl152:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return var11_15;
                                ** try [egrp 7[TRYBLOCK] [17 : 777->787)] { 
lbl157:
                                // 1 sources

                                con.close();
                                return var11_15;
lbl159:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var11_15;
                            }
                            var17_21 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [15 : 743->753)] { 
lbl166:
                                // 1 sources

                                rs.close();
                                break block65;
lbl168:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (st != null) {
                            ** try [egrp 6[TRYBLOCK] [16 : 760->770)] { 
lbl173:
                            // 1 sources

                            st.close();
                            break block66;
lbl175:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var11_16;
                    ** try [egrp 7[TRYBLOCK] [17 : 777->787)] { 
lbl180:
                    // 1 sources

                    con.close();
                    return var11_16;
lbl182:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var11_16;
                }
                var17_22 = null;
                if (rs != null) {
                    ** try [egrp 5[TRYBLOCK] [15 : 743->753)] { 
lbl189:
                    // 1 sources

                    rs.close();
                    break block67;
lbl191:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 6[TRYBLOCK] [16 : 760->770)] { 
lbl196:
                // 1 sources

                st.close();
                break block68;
lbl198:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return result;
        try {}
        catch (SQLException e) {}
        con.close();
        return result;
        return result;
    }

    public void addScheduleControlListener(ScheduleControlListener listener) {
        if ((this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) && this.controlStateChecker == null && this.getState() == 3 && this.controlStateCheckInterval > 0L) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus ControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.start();
        }
        this.scheduleControlListeners.add(listener);
    }

    public void removeScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.remove(listener);
    }

    private static final Object getInOutObject(int type, String name, ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
        int length = 0;
        switch (type) {
            case 2005: {
                Reader reader = rs.getCharacterStream(name);
                StringWriter writer = new StringWriter();
                char[] chars = new char[1024];
                while ((length = reader.read(chars)) > 0) {
                    writer.write(chars, 0, length);
                }
                return writer.toString();
            }
            case 2004: {
                InputStream is = rs.getBinaryStream(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, length);
                }
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                return ois.readObject();
            }
        }
        return rs.getObject(name);
    }

    private static final void setInOutObject(int type, int index, PreparedStatement ps, Object value) throws IOException, SQLException {
        if (value == null) {
            ps.setNull(index, type);
            return;
        }
        switch (type) {
            case 2005: {
                char[] chars = value.toString().toCharArray();
                ps.setCharacterStream(index, (Reader)new CharArrayReader(chars), chars.length);
                break;
            }
            case 2004: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = baos.toByteArray();
                ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                break;
            }
            default: {
                ps.setString(index, value.toString());
            }
        }
    }

    protected class ClusterListener
    implements jp.ossc.nimbus.service.keepalive.ClusterListener {
        protected ClusterListener() {
        }

        public void memberInit(Object myId, List members) {
        }

        public void memberChange(List oldMembers, List newMembers) {
        }

        public void changeMain() throws Exception {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.resume();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.resume();
            }
        }

        public void changeSub() {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.suspend();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.suspend();
            }
        }
    }

    protected class TimeoverChecker
    implements DaemonRunnable {
        protected TimeoverChecker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getTimeoverCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void consume(Object dequeued, DaemonControl ctrl) throws Throwable {
            block33: {
                SQLException e322;
                ResultSet rs;
                Statement st;
                Connection con;
                block28: {
                    con = null;
                    try {
                        con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e2) {
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e2);
                        return;
                    }
                    st = null;
                    PreparedStatement ps = null;
                    rs = null;
                    st = con.createStatement();
                    SimpleDateFormat format = new SimpleDateFormat(DatabaseScheduleManagerService.this.dateFormat + DatabaseScheduleManagerService.this.timeFormat);
                    Calendar nowCal = Calendar.getInstance();
                    rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.date + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.time + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.state + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.taskName + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + " is not null" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ">0" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(4) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(9) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(5) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(7) + "' and " + DatabaseScheduleManagerService.this.concatQuery(new StringBuffer(), DatabaseScheduleManagerService.this.scheduleTableSchema.date, DatabaseScheduleManagerService.this.scheduleTableSchema.time) + "<'" + format.format(nowCal.getTime()) + '\'');
                    Calendar tmpCal = Calendar.getInstance();
                    while (rs.next()) {
                        Date time = format.parse(rs.getString(2) + rs.getString(3));
                        tmpCal.clear();
                        long maxDelayTime = rs.getLong(4);
                        tmpCal.setTimeInMillis(time.getTime() + maxDelayTime);
                        if (tmpCal.after(nowCal) || tmpCal.equals(nowCal)) continue;
                        String id = rs.getString(1);
                        if (ps == null) {
                            String checkStateStr = DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2);
                            ps = con.prepareStatement("update " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " set " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "='" + checkStateStr + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateUserId + "='" + DatabaseScheduleManagerService.this.updateUserId + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateTime + "=?" + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + "=?" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + checkStateStr + '\'');
                        }
                        ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        ps.setString(2, id);
                        if (ps.executeUpdate() == 0) continue;
                        String state = rs.getString(5);
                        String taskName = rs.getString(6);
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00003", new Object[]{id, taskName, state});
                    }
                    Object var17_17 = null;
                    if (rs == null) break block28;
                    try {
                        rs.close();
                    }
                    catch (SQLException e322) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e322) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e322) {}
                }
                break block33;
                {
                    catch (SQLException e4) {
                        SQLException e322;
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e4);
                        Object var17_18 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    SQLException e322;
                    Object var17_19 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }

        public void garbage() {
        }
    }

    protected class ControlStateChecker
    implements DaemonRunnable {
        protected ControlStateChecker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getControlStateCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void consume(Object input, DaemonControl ctrl) throws Throwable {
            block41: {
                SQLException e422;
                ResultSet rs;
                Statement st;
                Connection con;
                block36: {
                    if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) {
                        return;
                    }
                    con = null;
                    try {
                        con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e2) {
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e2);
                        return;
                    }
                    st = null;
                    rs = null;
                    st = con.createStatement();
                    rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where (" + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(6) + "') and (" + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(2) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(4) + "')");
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String controlStateStr = rs.getString(2);
                        int controlState = DatabaseScheduleManagerService.this.scheduleTableSchema.getControlState(controlStateStr);
                        try {
                            if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) continue;
                            Set set = DatabaseScheduleManagerService.this.scheduleControlListeners;
                            synchronized (set) {
                                Iterator itr = DatabaseScheduleManagerService.this.scheduleControlListeners.iterator();
                                while (itr.hasNext()) {
                                    ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                                    listener.changedControlState(id, controlState);
                                }
                            }
                        }
                        catch (ScheduleStateControlException e3) {
                            try {
                                DatabaseScheduleManagerService.this.changeControlState(id, 5);
                            }
                            catch (ScheduleStateControlException e2) {
                                // empty catch block
                            }
                            DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e3);
                        }
                    }
                    Object var14_17 = null;
                    if (rs == null) break block36;
                    try {
                        rs.close();
                    }
                    catch (SQLException e422) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e422) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e422) {}
                }
                break block41;
                {
                    catch (SQLException e5) {
                        SQLException e422;
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e5);
                        Object var14_18 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    SQLException e422;
                    Object var14_19 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }

        public void garbage() {
        }
    }

    public static class ScheduleDependsTableSchema
    extends ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_DEPENDS";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_GROUP_ID = "GROUP_ID";
        public static final String DEFAULT_MASTER_ID = "MASTER_ID";
        public static final String DEFAULT_DATE = "S_DATE";
        public static final String DEFAULT_TIME = "S_TIME";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_OUTPUT = "OUTPUT";
        public static final String DEFAULT_INITIAL_DATE = "INITIAL_DATE";
        public static final String DEFAULT_INITIAL_TIME = "INITIAL_TIME";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_STATE = "STATE";
        public static final String DEFAULT_CONTROL_STATE = "CONTROL_STATE";
        public static final String DEFAULT_CHECK_STATE = "CHECK_STATE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public static final String DEFAULT_EXECUTE_START_TIME = "EXEC_S_TIME";
        public static final String DEFAULT_EXECUTE_END_TIME = "EXEC_E_TIME";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public static final String DEFAULT_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_STATE_STRING_ENTRY = "E";
        public static final String DEFAULT_STATE_STRING_RUN = "R";
        public static final String DEFAULT_STATE_STRING_END = "N";
        public static final String DEFAULT_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_STATE_STRING_RETRY = "T";
        public static final String DEFAULT_STATE_STRING_DISABLE = "D";
        public static final String DEFAULT_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CONTROL_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CONTROL_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_CONTROL_STATE_STRING_RESUME = "R";
        public static final String DEFAULT_CONTROL_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_CONTROL_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_CONTROL_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CHECK_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CHECK_STATE_STRING_TIMEOVER = "O";
        public static final String DEFAULT_CHECK_STATE_STRING_UNKNOWN = "U";
        public String table = "SCHEDULE";
        public String id = "ID";
        public String groupId = "GROUP_ID";
        public String masterId = "MASTER_ID";
        public String date = "S_DATE";
        public String time = "S_TIME";
        public String taskName = "TASK_NAME";
        public String input = "INPUT";
        public String output = "OUTPUT";
        public String initialDate = "INITIAL_DATE";
        public String initialTime = "INITIAL_TIME";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String state = "STATE";
        public String controlState = "CONTROL_STATE";
        public String checkState = "CHECK_STATE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public String executeStartTime = "EXEC_S_TIME";
        public String executeEndTime = "EXEC_E_TIME";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
        public String stateString_INITIAL = "I";
        public String stateString_ENTRY = "E";
        public String stateString_RUN = "R";
        public String stateString_END = "N";
        public String stateString_FAILED = "F";
        public String stateString_PAUSE = "P";
        public String stateString_ABORT = "A";
        public String stateString_RETRY = "T";
        public String stateString_DISABLE = "D";
        public String stateString_UNKNOWN = "U";
        public String controlStateString_INITIAL = "I";
        public String controlStateString_PAUSE = "P";
        public String controlStateString_RESUME = "R";
        public String controlStateString_ABORT = "A";
        public String controlStateString_FAILED = "F";
        public String controlStateString_UNKNOWN = "U";
        public String checkStateString_INITIAL = "I";
        public String checkStateString_TIMEOVER = "O";
        public String checkStateString_UNKNOWN = "U";
        public int inputColumnType = 12;
        public int outputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }

        protected void setInputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.inputColumnType, index, ps, value);
        }

        protected Object getOutputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.outputColumnType, this.output, rs);
        }

        protected void setOutputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.outputColumnType, index, ps, value);
        }

        public String getStateString(int state) {
            switch (state) {
                case 1: {
                    return this.stateString_INITIAL;
                }
                case 2: {
                    return this.stateString_ENTRY;
                }
                case 3: {
                    return this.stateString_RUN;
                }
                case 4: {
                    return this.stateString_END;
                }
                case 5: {
                    return this.stateString_FAILED;
                }
                case 6: {
                    return this.stateString_PAUSE;
                }
                case 7: {
                    return this.stateString_ABORT;
                }
                case 8: {
                    return this.stateString_RETRY;
                }
                case 9: {
                    return this.stateString_DISABLE;
                }
            }
            return this.stateString_UNKNOWN;
        }

        public int getState(String state) {
            if (this.stateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.stateString_ENTRY.equals(state)) {
                return 2;
            }
            if (this.stateString_RUN.equals(state)) {
                return 3;
            }
            if (this.stateString_END.equals(state)) {
                return 4;
            }
            if (this.stateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.stateString_PAUSE.equals(state)) {
                return 6;
            }
            if (this.stateString_ABORT.equals(state)) {
                return 7;
            }
            if (this.stateString_RETRY.equals(state)) {
                return 8;
            }
            if (this.stateString_DISABLE.equals(state)) {
                return 9;
            }
            return -1;
        }

        public String getControlStateString(int state) {
            switch (state) {
                case 1: {
                    return this.controlStateString_INITIAL;
                }
                case 2: {
                    return this.controlStateString_PAUSE;
                }
                case 3: {
                    return this.controlStateString_RESUME;
                }
                case 4: {
                    return this.controlStateString_ABORT;
                }
                case 5: {
                    return this.controlStateString_FAILED;
                }
            }
            return this.controlStateString_UNKNOWN;
        }

        public int getControlState(String state) {
            if (this.controlStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.controlStateString_PAUSE.equals(state)) {
                return 2;
            }
            if (this.controlStateString_ABORT.equals(state)) {
                return 4;
            }
            if (this.controlStateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.controlStateString_RESUME.equals(state)) {
                return 3;
            }
            return -1;
        }

        public String getCheckStateString(int state) {
            switch (state) {
                case 1: {
                    return this.checkStateString_INITIAL;
                }
                case 2: {
                    return this.checkStateString_TIMEOVER;
                }
            }
            return this.checkStateString_UNKNOWN;
        }

        public int getCheckState(String state) {
            if (this.checkStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.checkStateString_TIMEOVER.equals(state)) {
                return 2;
            }
            return -1;
        }
    }

    public static class ScheduleGroupMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_GROUP_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_GROUP_ID = "GROUP_ID";
        public String table = "SCHEDULE_GROUP_MST";
        public String id = "ID";
        public String groupId = "GROUP_ID";
    }

    public static class ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_DEPENDS_ID = "DEPENDS_ID";
        public String table = "SCHEDULE_DEPENDS_MST";
        public String id = "ID";
        public String dependsId = "DEPENDS_ID";
    }

    public static class ScheduleMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_SCHEDULE_TYPE = "SCHEDULE_TYPE";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_START_TIME = "START_TIME";
        public static final String DEFAULT_END_TIME = "END_TIME";
        public static final String DEFAULT_REPEAT_INTERVAL = "REPEAT_INTERVAL";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_ENABLE = "ENABLE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public static final String DEFAULT_TEMPLATE = "TEMPLATE";
        public String table = "SCHEDULE_MST";
        public String id = "ID";
        public String taskName = "TASK_NAME";
        public String scheduleType = "SCHEDULE_TYPE";
        public String input = "INPUT";
        public String startTime = "START_TIME";
        public String endTime = "END_TIME";
        public String repeatInterval = "REPEAT_INTERVAL";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String enable = "ENABLE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public String template = "TEMPLATE";
        public int inputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }
    }
}

