/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.OperateFile;
import jp.ossc.nimbus.service.scheduler2.ConcentrateBackupException;
import jp.ossc.nimbus.service.scheduler2.ConcentrateBackupManager;
import jp.ossc.nimbus.service.scheduler2.FileConcentrateBackupManagerServiceMBean;

public class FileConcentrateBackupManagerService
extends ServiceBase
implements ConcentrateBackupManager,
FileConcentrateBackupManagerServiceMBean {
    private static final long serialVersionUID = -8740313948817168475L;
    protected File backupDir = new File("backup");
    protected int backupBufferSize = 1024;
    protected int compressMode = 0;
    protected int compressLevel = -1;
    protected int compressMethod = 8;
    protected String dateFormat = "yyyyMMdd";

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setBackupDirectory(File dir) {
        this.backupDir = dir;
    }

    public File getBackupDirectory() {
        return this.backupDir;
    }

    public void setBufferSize(int size) {
        this.backupBufferSize = size;
    }

    public int getBufferSize() {
        return this.backupBufferSize;
    }

    public void setCompressMode(int mode) {
        this.compressMode = mode;
    }

    public int getCompressMode() {
        return this.compressMode;
    }

    public void setCompressLevel(int level) {
        this.compressLevel = level;
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public void setCompressMethod(int method) {
        this.compressMethod = method;
    }

    public int getCompressMethod() {
        return this.compressMethod;
    }

    public void startService() throws Exception {
        if (this.backupDir.exists()) {
            if (!this.backupDir.isDirectory()) {
                throw new IllegalArgumentException("BackupDirectory is not directory." + this.backupDir.getPath());
            }
        } else if (!this.backupDir.mkdirs() && !this.backupDir.exists()) {
            throw new IllegalArgumentException("BackupDirectory can not create." + this.backupDir.getPath());
        }
    }

    public Object backup(String group, Date date, String key, File file, boolean compressed) throws ConcentrateBackupException {
        return this.backup(group, date, key, file, compressed, null);
    }

    public Object backup(String group, Date date, String key, File file, boolean compressed, Object output) throws ConcentrateBackupException {
        if (group == null && date == null && key == null) {
            throw new ConcentrateBackupException("Backup directory can not create.");
        }
        File currentDir = this.backupDir;
        if (!(group == null || (currentDir = new File(currentDir, group)).exists() || currentDir.mkdirs() || currentDir.exists())) {
            throw new ConcentrateBackupException("Directory of group '" + group + "' can not make." + currentDir);
        }
        String dateDirName = null;
        if (!(date == null || (currentDir = new File(currentDir, dateDirName = new SimpleDateFormat(this.dateFormat).format(date))).exists() || currentDir.mkdirs() || currentDir.exists())) {
            throw new ConcentrateBackupException("Directory of date '" + dateDirName + "' can not make." + currentDir);
        }
        if (!(key == null || (currentDir = new File(currentDir, key)).exists() || currentDir.mkdirs() || currentDir.exists())) {
            throw new ConcentrateBackupException("Directory of key '" + key + "' can not make." + currentDir);
        }
        ArrayList<File> result = new ArrayList<File>();
        File backupFile = new File(currentDir, file.getName());
        try {
            backupFile = this.backupFile(file, compressed, backupFile);
        }
        catch (IOException e) {
            throw new ConcentrateBackupException(e);
        }
        result.add(backupFile);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File backupFile(File src, boolean compressed, File dest) throws IOException {
        String destPath = dest.getCanonicalPath();
        if (src.getCanonicalPath().equals(destPath)) {
            dest = new File(destPath + ".bk");
        }
        String destFileName = dest.getName();
        FileInputStream in = new FileInputStream(src);
        OutputStream os = null;
        Deflater deflater = null;
        if (compressed) {
            os = new FileOutputStream(dest);
        } else {
            switch (this.compressMode) {
                case 1: {
                    dest = new File(destPath + ".zlib");
                    deflater = new Deflater(this.compressLevel);
                    os = new FileOutputStream(dest);
                    os = new DeflaterOutputStream(os, deflater, this.backupBufferSize);
                    break;
                }
                case 2: {
                    dest = new File(destPath + ".zip");
                    os = new FileOutputStream(dest);
                    ZipOutputStream zos = new ZipOutputStream(os);
                    zos.setLevel(this.compressLevel);
                    zos.setMethod(this.compressMethod);
                    zos.putNextEntry(new ZipEntry(destFileName));
                    os = zos;
                    break;
                }
                case 3: {
                    dest = new File(destPath + ".gz");
                    os = new FileOutputStream(dest);
                    os = new GZIPOutputStream(os, this.backupBufferSize);
                    break;
                }
                case 0: {
                    os = new FileOutputStream(dest);
                    break;
                }
                default: {
                    throw new IOException("Unknown compress mode : " + this.compressMode);
                }
            }
        }
        int len = -1;
        byte[] b = new byte[this.backupBufferSize];
        try {
            while ((len = ((InputStream)in).read(b, 0, b.length)) != -1) {
                os.write(b, 0, len);
            }
            os.flush();
            if (!compressed) {
                if (this.compressMode == 2) {
                    ((ZipOutputStream)os).closeEntry();
                }
                if (this.compressMode != 0) {
                    ((DeflaterOutputStream)os).finish();
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (deflater != null) {
                deflater.end();
            }
            throw throwable;
        }
        try {
            ((InputStream)in).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            os.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (deflater != null) {
            deflater.end();
        }
        return dest;
    }

    public boolean clear() throws ConcentrateBackupException {
        boolean result = true;
        File[] groupFiles = this.backupDir.listFiles();
        for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory()) {
                result &= groupFiles[i].exists() ? OperateFile.deleteAll(groupFiles[i]) : true;
                continue;
            }
            File groupDir = groupFiles[i];
            result &= this.remove(groupDir.getName());
        }
        return result;
    }

    public boolean remove(String group) throws ConcentrateBackupException {
        File groupDir = new File(this.backupDir, group);
        if (groupDir.exists()) {
            return groupDir.exists() ? OperateFile.deleteAll(groupDir) : true;
        }
        return true;
    }

    public boolean remove(Date date) throws ConcentrateBackupException {
        boolean result = true;
        String dateDirName = new SimpleDateFormat(this.dateFormat).format(date);
        File[] groupFiles = this.backupDir.listFiles();
        block0: for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory()) continue;
            File groupDir = groupFiles[i];
            if (groupDir.getName().equals(dateDirName)) {
                result &= groupDir.exists() ? OperateFile.deleteAll(groupDir) : true;
                break;
            }
            File[] dateFiles = groupDir.listFiles();
            for (int j = 0; j < dateFiles.length; ++j) {
                File dateDir;
                if (!dateFiles[j].isDirectory() || !(dateDir = dateFiles[j]).getName().equals(dateDirName)) continue;
                result &= dateDir.exists() ? OperateFile.deleteAll(dateDir) : true;
                continue block0;
            }
        }
        return result;
    }

    public boolean remove(String group, Date date) throws ConcentrateBackupException {
        boolean result = true;
        String dateDirName = new SimpleDateFormat(this.dateFormat).format(date);
        File[] groupFiles = this.backupDir.listFiles();
        for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory() || !groupFiles[i].getName().equals(group)) continue;
            File groupDir = groupFiles[i];
            File[] dateFiles = groupDir.listFiles();
            for (int j = 0; j < dateFiles.length; ++j) {
                File dateDir;
                if (!dateFiles[j].isDirectory() || !(dateDir = dateFiles[j]).getName().equals(dateDirName)) continue;
                return dateDir.exists() ? OperateFile.deleteAll(dateDir) : true;
            }
            break;
        }
        return result;
    }

    public boolean removeTo(Date date) throws ConcentrateBackupException {
        boolean result = true;
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        String dateDirName = format.format(date);
        File[] groupFiles = this.backupDir.listFiles();
        for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory()) continue;
            File groupDir = groupFiles[i];
            try {
                Date targetDate = format.parse(groupDir.getName());
                if (targetDate.after(date)) continue;
                result &= groupDir.exists() ? OperateFile.deleteAll(groupDir) : true;
                continue;
            }
            catch (ParseException e) {
                File[] dateFiles = groupDir.listFiles();
                for (int j = 0; j < dateFiles.length; ++j) {
                    if (!dateFiles[j].isDirectory()) continue;
                    File dateDir = dateFiles[j];
                    try {
                        Date targetDate = format.parse(dateDir.getName());
                        if (targetDate.after(date)) continue;
                        result &= dateDir.exists() ? OperateFile.deleteAll(dateDir) : true;
                        continue;
                    }
                    catch (ParseException e2) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    public boolean removeTo(String group, Date date) throws ConcentrateBackupException {
        boolean result = true;
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        File[] groupFiles = this.backupDir.listFiles();
        for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory() || !groupFiles[i].getName().equals(group)) continue;
            File groupDir = groupFiles[i];
            File[] dateFiles = groupDir.listFiles();
            for (int j = 0; j < dateFiles.length; ++j) {
                if (!dateFiles[j].isDirectory()) continue;
                File dateDir = dateFiles[j];
                try {
                    Date targetDate = format.parse(dateDir.getName());
                    if (targetDate.after(date)) continue;
                    result &= dateDir.exists() ? OperateFile.deleteAll(dateDir) : true;
                    continue;
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            break;
        }
        return result;
    }

    public boolean remove(String group, Date date, String key) throws ConcentrateBackupException {
        boolean result = true;
        String dateDirName = new SimpleDateFormat(this.dateFormat).format(date);
        File[] groupFiles = this.backupDir.listFiles();
        block0: for (int i = 0; i < groupFiles.length; ++i) {
            if (!groupFiles[i].isDirectory() || !groupFiles[i].getName().equals(group)) continue;
            File groupDir = groupFiles[i];
            File[] dateFiles = groupDir.listFiles();
            for (int j = 0; j < dateFiles.length; ++j) {
                if (!dateFiles[j].isDirectory() || !dateFiles[j].getName().equals(dateDirName)) continue;
                File dateDir = dateFiles[j];
                File[] keyFiles = dateDir.listFiles();
                for (int k = 0; k < keyFiles.length; ++k) {
                    if (!keyFiles[k].getName().equals(key)) continue;
                    File keyFile = keyFiles[k];
                    return keyFile.exists() ? OperateFile.deleteAll(keyFile) : true;
                }
                break block0;
            }
            break;
        }
        return result;
    }
}

