/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scp.ganymed;

import java.io.File;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.scp.SCPClient;
import jp.ossc.nimbus.service.scp.SCPClientFactory;
import jp.ossc.nimbus.service.scp.SCPException;
import jp.ossc.nimbus.service.scp.ganymed.SCPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.scp.ganymed.SCPClientImpl;

public class SCPClientFactoryService
extends ServiceBase
implements SCPClientFactory,
SCPClientFactoryServiceMBean {
    private static final long serialVersionUID = 2888605574336286830L;
    private int connectionTimeout = -1;
    private int keyExchangeTimeout = -1;
    private Boolean isTcpNoDelay;
    private String hostName;
    private int port = -1;
    private String userName;
    private String password = "";
    private File pemFile;
    private String[] serverHostKeyAlgorithms;
    private File homeDir;

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setKeyExchangeTimeout(int timeout) {
        this.keyExchangeTimeout = timeout;
    }

    public int getKeyExchangeTimeout() {
        return this.keyExchangeTimeout;
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.isTcpNoDelay = noDelay ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isTcpNoDelay() {
        return this.isTcpNoDelay == null ? false : this.isTcpNoDelay;
    }

    public void setHostName(String addr) {
        this.hostName = addr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPemFile(File path) {
        this.pemFile = path;
    }

    public File getPemFile() {
        return this.pemFile;
    }

    public void setServerHostKeyAlgorithms(String[] algos) {
        this.serverHostKeyAlgorithms = algos;
    }

    public String[] getServerHostKeyAlgorithms() {
        return this.serverHostKeyAlgorithms;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public SCPClient createSCPClient() throws SCPException {
        SCPClientImpl client = new SCPClientImpl();
        if (this.connectionTimeout > 0) {
            client.setConnectionTimeout(this.connectionTimeout);
        }
        if (this.keyExchangeTimeout > 0) {
            client.setKeyExchangeTimeout(this.keyExchangeTimeout);
        }
        if (this.isTcpNoDelay != null) {
            client.setTcpNoDelay(this.isTcpNoDelay);
        }
        if (this.serverHostKeyAlgorithms != null) {
            client.setServerHostKeyAlgorithms(this.serverHostKeyAlgorithms);
        }
        if (this.userName != null) {
            if (this.pemFile == null) {
                if (this.port > 0) {
                    client.connect(this.userName, this.hostName, this.port, this.password);
                } else {
                    client.connect(this.userName, this.hostName, this.password);
                }
            } else if (this.port > 0) {
                client.connect(this.userName, this.hostName, this.port, this.pemFile, this.password);
            } else {
                client.connect(this.userName, this.hostName, this.pemFile, this.password);
            }
        }
        if (this.homeDir != null) {
            client.setHomeDirectory(this.homeDir);
        }
        return client;
    }
}

