/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sftp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.sftp.ClusterSFTPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.sftp.SFTPClient;
import jp.ossc.nimbus.service.sftp.SFTPClientFactory;
import jp.ossc.nimbus.service.sftp.SFTPException;

public class ClusterSFTPClientFactoryService
extends ServiceBase
implements SFTPClientFactory,
ClusterSFTPClientFactoryServiceMBean {
    private static final long serialVersionUID = -2309390745942004716L;
    private ServiceName[] sftpClientFactoryServiceNames;
    private SFTPClientFactory[] sftpClientFactories;
    private int clusterMode = 1;
    private String connectErrorMessageId = "CSFTP00001";
    private String skipMessageId = "CSFTP00002";

    public void setSFTPClientFactoryServiceNames(ServiceName[] names) {
        this.sftpClientFactoryServiceNames = names;
    }

    public ServiceName[] getSFTPClientFactoryServiceNames() {
        return this.sftpClientFactoryServiceNames;
    }

    public void setClusterMode(int mode) throws IllegalArgumentException {
        switch (this.clusterMode) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
        this.clusterMode = mode;
    }

    public int getClusterMode() {
        return this.clusterMode;
    }

    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    public void setSkipMessageId(String id) {
        this.skipMessageId = id;
    }

    public String getSkipMessageId() {
        return this.skipMessageId;
    }

    public void startService() throws Exception {
        if (this.sftpClientFactoryServiceNames == null || this.sftpClientFactoryServiceNames.length == 0) {
            throw new IllegalArgumentException("SFTPClientFactoryServiceNames is null.");
        }
        this.sftpClientFactories = new SFTPClientFactory[this.sftpClientFactoryServiceNames.length];
        for (int i = 0; i < this.sftpClientFactoryServiceNames.length; ++i) {
            this.sftpClientFactories[i] = (SFTPClientFactory)ServiceManagerFactory.getServiceObject(this.sftpClientFactoryServiceNames[i]);
        }
    }

    public SFTPClient createSFTPClient() throws SFTPException {
        return new ClusterSFTPClient(this.clusterMode);
    }

    private class ClusterSFTPClient
    implements SFTPClient {
        private final int clusterMode;
        private SFTPClient client;
        private List clients;
        private List noConnectedClients;

        public ClusterSFTPClient(int mode) throws SFTPException {
            this.clusterMode = mode;
            block2 : switch (this.clusterMode) {
                case 1: {
                    int imax = ClusterSFTPClientFactoryService.this.sftpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.client = ClusterSFTPClientFactoryService.this.sftpClientFactories[i].createSFTPClient();
                            break block2;
                        }
                        catch (SFTPException e) {
                            if (i == imax - 1) {
                                throw e;
                            }
                            if (ClusterSFTPClientFactoryService.this.connectErrorMessageId == null) continue;
                            ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.connectErrorMessageId, ClusterSFTPClientFactoryService.this.sftpClientFactories[i], (Throwable)e);
                            continue;
                        }
                    }
                    break;
                }
                case 2: {
                    this.clients = new ArrayList();
                    this.noConnectedClients = new ArrayList();
                    int imax = ClusterSFTPClientFactoryService.this.sftpClientFactories.length;
                    for (int i = 0; i < imax; ++i) {
                        try {
                            this.clients.add(ClusterSFTPClientFactoryService.this.sftpClientFactories[i].createSFTPClient());
                            continue;
                        }
                        catch (SFTPException e) {
                            ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.connectErrorMessageId, ClusterSFTPClientFactoryService.this.sftpClientFactories[i], (Throwable)e);
                            this.noConnectedClients.add(ClusterSFTPClientFactoryService.this.sftpClientFactories[i]);
                        }
                    }
                    if (this.clients.size() != 0) break;
                    throw new SFTPException("I could not connect all the cluster members.");
                }
            }
        }

        public void connect(String user, String host, String password) throws SFTPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, int port, String password) throws SFTPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, File pemFile, String passphrase) throws SFTPException {
            throw new UnsupportedOperationException();
        }

        public void connect(String user, String host, int port, File pemFile, String passphrase) throws SFTPException {
            throw new UnsupportedOperationException();
        }

        public String[] ls() throws SFTPException {
            return this.ls(".");
        }

        public String[] ls(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.ls(path);
                }
            }
            ArrayList<String> resultList = null;
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    String[] results = client.ls(path);
                    if (resultList == null) {
                        resultList = new ArrayList<String>();
                    }
                    if (results == null) continue;
                    for (int j = 0; j < results.length; ++j) {
                        String result = results[j];
                        if (resultList.indexOf(result) != -1) continue;
                        resultList.add(result);
                    }
                    continue;
                }
                catch (SFTPException e) {
                    if (i != imax - 1 || resultList != null) continue;
                    throw e;
                }
            }
            return resultList == null ? null : resultList.toArray(new String[resultList.size()]);
        }

        public SFTPClient.SFTPFile[] lsFile() throws SFTPException {
            return this.lsFile(".");
        }

        public SFTPClient.SFTPFile[] lsFile(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.lsFile(path);
                }
            }
            ArrayList<SFTPClient.SFTPFile> resultList = null;
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    SFTPClient.SFTPFile[] results = client.lsFile(path);
                    if (resultList == null) {
                        resultList = new ArrayList<SFTPClient.SFTPFile>();
                    }
                    if (results == null) continue;
                    for (int j = 0; j < results.length; ++j) {
                        SFTPClient.SFTPFile result = results[j];
                        if (resultList.indexOf(result) != -1) continue;
                        resultList.add(result);
                    }
                    continue;
                }
                catch (SFTPException e) {
                    if (i != imax - 1 || resultList != null) continue;
                    throw e;
                }
            }
            return resultList == null ? null : resultList.toArray(new SFTPClient.SFTPFile[resultList.size()]);
        }

        public String pwd() throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.pwd();
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    return client.pwd();
                }
                catch (SFTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        public File lpwd() throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.lpwd();
                }
            }
            return ((SFTPClient)this.clients.get(0)).lpwd();
        }

        public void cd(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.cd(path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.cd(path);
                            continue;
                        }
                        catch (SFTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        public void lcd(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.lcd(path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.lcd(path);
                            continue;
                        }
                        catch (SFTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        public void mkdir(String dir) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mkdir(dir);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.mkdir(dir);
                            continue;
                        }
                        catch (SFTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        public void rename(String from, String to) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.rename(from, to);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.rename(from, to);
                            continue;
                        }
                        catch (SFTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }

        public File get(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(path);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    return client.get(path);
                }
                catch (SFTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        public File get(String remote, String local) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.get(remote, local);
                }
            }
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    return client.get(remote, local);
                }
                catch (SFTPException e) {
                    if (i != imax - 1) continue;
                    throw e;
                }
            }
            return null;
        }

        public File[] mget(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.mget(path);
                }
            }
            ArrayList<File> resultList = null;
            HashSet<String> resultSet = new HashSet<String>();
            int imax = this.clients.size();
            for (int i = 0; i < imax; ++i) {
                SFTPClient client = (SFTPClient)this.clients.get(i);
                try {
                    String[] results = client.ls(path);
                    for (int j = 0; j < results.length; ++j) {
                        String result = results[j];
                        if (resultSet.contains(result)) continue;
                        resultSet.add(result);
                        File file = client.get(result);
                        if (resultList == null) {
                            resultList = new ArrayList<File>();
                        }
                        resultList.add(file);
                    }
                    continue;
                }
                catch (SFTPException e) {
                    if (i != imax - 1 || resultList != null) continue;
                    throw e;
                }
            }
            return resultList == null ? null : resultList.toArray(new File[resultList.size()]);
        }

        public void put(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.put(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void put(String local, String remote) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.put(local, remote);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.put(local, remote);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "put"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "put"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void mput(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.mput(path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.mput(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "mput"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "mput"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public boolean rm(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.rm(path);
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    boolean isRemove = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            isRemove |= client.rm(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "rm"});
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "rm"});
                    }
                    if (!isSuccess) {
                        throw ex;
                    }
                    return isRemove;
                }
            }
            return false;
        }

        public boolean rmdir(String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    return this.client.rmdir(path);
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    boolean isRemove = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            isRemove |= client.rmdir(path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "rmdir"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "rmdir"});
                    }
                    if (!isSuccess) {
                        throw ex;
                    }
                    return isRemove;
                }
            }
            return false;
        }

        public void chmod(String mode, String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.chmod(mode, path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.chmod(mode, path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "chmod"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "chmod"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void chown(String uid, String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.chown(uid, path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.chown(uid, path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "chown"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "chown"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void chgrp(String gid, String path) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.chgrp(gid, path);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.chgrp(gid, path);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "chgrp"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "chgrp"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void symlink(String path, String link) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.symlink(path, link);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.symlink(path, link);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "symlink"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "symlink"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void ln(String path, String link) throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.ln(path, link);
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    boolean isSuccess = false;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.ln(path, link);
                            isSuccess = true;
                            continue;
                        }
                        catch (SFTPException e) {
                            if (ClusterSFTPClientFactoryService.this.skipMessageId != null) {
                                ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{client, "ln"}, (Throwable)e);
                            }
                            ex = e;
                        }
                    }
                    if (ClusterSFTPClientFactoryService.this.skipMessageId != null && this.noConnectedClients.size() > 0) {
                        ClusterSFTPClientFactoryService.this.getLogger().write(ClusterSFTPClientFactoryService.this.skipMessageId, new Object[]{this.noConnectedClients, "ln"});
                    }
                    if (isSuccess) break;
                    throw ex;
                }
            }
        }

        public void close() throws SFTPException {
            switch (this.clusterMode) {
                case 1: {
                    this.client.close();
                    break;
                }
                case 2: {
                    SFTPException ex = null;
                    int imax = this.clients.size();
                    for (int i = 0; i < imax; ++i) {
                        SFTPClient client = (SFTPClient)this.clients.get(i);
                        try {
                            client.close();
                            continue;
                        }
                        catch (SFTPException e) {
                            ex = e;
                        }
                    }
                    if (ex == null) break;
                    throw ex;
                }
            }
        }
    }
}

