/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sftp.jsch;

import com.jcraft.jsch.Proxy;
import java.io.File;
import java.util.Properties;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.sftp.SFTPClient;
import jp.ossc.nimbus.service.sftp.SFTPClientFactory;
import jp.ossc.nimbus.service.sftp.SFTPException;
import jp.ossc.nimbus.service.sftp.jsch.SFTPClientCreateTimeoutException;
import jp.ossc.nimbus.service.sftp.jsch.SFTPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.sftp.jsch.SFTPClientImpl;

public class SFTPClientFactoryService
extends ServiceBase
implements SFTPClientFactory,
SFTPClientFactoryServiceMBean {
    private static final long serialVersionUID = 3883321019571577279L;
    private int timeout = -1;
    private int serverAliveInterval = -1;
    private int serverAliveCountMax = -1;
    private String hostName;
    private int port = -1;
    private String userName;
    private String password;
    private File pemFile;
    private Proxy proxy;
    private ServiceName semaphoreServiceName;
    private Semaphore semaphore;
    private Properties configProperties;
    private File homeDir;
    private String fileNameEncoding;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServerAliveInterval(int interval) {
        this.serverAliveInterval = this.timeout;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int count) {
        this.serverAliveCountMax = count;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setHostName(String addr) {
        this.hostName = addr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPemFile(File path) {
        this.pemFile = path;
    }

    public File getPemFile() {
        return this.pemFile;
    }

    public void setConfig(Properties conf) {
        this.configProperties = conf;
    }

    public Properties getConfig() {
        return this.configProperties;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public void setFileNameEncoding(String encoding) {
        this.fileNameEncoding = encoding;
    }

    public String getFileNameEncoding() {
        return this.fileNameEncoding;
    }

    public void setSemaphoreServiceName(ServiceName name) {
        this.semaphoreServiceName = name;
    }

    public ServiceName getSemaphoreServiceName() {
        return this.semaphoreServiceName;
    }

    public void startService() throws Exception {
        if (this.semaphoreServiceName != null) {
            this.semaphore = (Semaphore)ServiceManagerFactory.getServiceObject(this.semaphoreServiceName);
            this.semaphore.accept();
        }
    }

    public void stopService() throws Exception {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public SFTPClient createSFTPClient() throws SFTPException {
        if (this.semaphore != null && !this.semaphore.getResource()) {
            throw new SFTPClientCreateTimeoutException();
        }
        SFTPClientImpl client = new SFTPClientImpl();
        if (this.semaphore != null) {
            client.setSemaphore(this.semaphore);
        }
        if (this.timeout >= 0) {
            client.setTimeout(this.timeout);
        }
        if (this.serverAliveInterval >= 0) {
            client.setServerAliveInterval(this.serverAliveInterval);
        }
        if (this.serverAliveCountMax >= 0) {
            client.setServerAliveCountMax(this.serverAliveCountMax);
        }
        if (this.configProperties != null) {
            client.setConfig(this.configProperties);
        }
        if (this.proxy != null) {
            client.setProxy(this.proxy);
        }
        if (this.homeDir != null) {
            client.setHomeDirectory(this.homeDir);
        }
        if (this.fileNameEncoding != null) {
            client.setFileNameEncoding(this.fileNameEncoding);
        }
        if (this.userName != null) {
            if (this.pemFile == null) {
                if (this.port > 0) {
                    client.connect(this.userName, this.hostName, this.port, this.password);
                } else {
                    client.connect(this.userName, this.hostName, this.password);
                }
            } else if (this.port > 0) {
                client.connect(this.userName, this.hostName, this.port, this.pemFile, this.password);
            } else {
                client.connect(this.userName, this.hostName, this.pemFile, this.password);
            }
        }
        return client;
    }
}

