/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sftp.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.sftp.SFTPClient;
import jp.ossc.nimbus.service.sftp.SFTPException;
import jp.ossc.nimbus.service.sftp.jsch.NoSuchFileSFTPException;

public class SFTPClientImpl
implements SFTPClient {
    private static final int ERROR_ID_NO_SUCH_FILE = 2;
    private int timeout = -1;
    private int serverAliveInterval = -1;
    private int serverAliveCountMax = -1;
    private Properties configProperties;
    private File homeDir;
    private String fileNameEncoding;
    private JSch jsch;
    private Session session;
    private ChannelSftp channel;
    private Proxy proxy;
    private Semaphore semaphore;

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServerAliveInterval(int interval) {
        this.serverAliveInterval = this.timeout;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int count) {
        this.serverAliveCountMax = count;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setConfig(Properties conf) {
        this.configProperties = conf;
    }

    public Properties getConfig() {
        return this.configProperties;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public void setFileNameEncoding(String encoding) {
        this.fileNameEncoding = encoding;
    }

    public String getFileNameEncoding() {
        return this.fileNameEncoding;
    }

    public void connect(String user, String host, String password) throws SFTPException {
        this.connect(user, host, 22, password);
    }

    public void connect(String user, String host, int port, String password) throws SFTPException {
        if (this.jsch != null) {
            throw new SFTPException("It is already connected!");
        }
        this.jsch = new JSch();
        try {
            this.session = this.jsch.getSession(user, host, port);
            if (this.configProperties != null) {
                this.session.setConfig(this.configProperties);
            }
            if (this.proxy != null) {
                this.session.setProxy(this.proxy);
            }
            if (this.timeout >= 0) {
                this.session.setTimeout(this.timeout);
            }
            if (this.serverAliveInterval >= 0) {
                this.session.setServerAliveInterval(this.serverAliveInterval);
            }
            if (this.serverAliveCountMax >= 0) {
                this.session.setServerAliveCountMax(this.serverAliveCountMax);
            }
            if (password != null) {
                this.session.setPassword(password);
            }
            this.session.connect();
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            if (this.fileNameEncoding != null) {
                this.channel.setFilenameEncoding(this.fileNameEncoding);
            }
            this.channel.connect();
            if (this.homeDir != null) {
                this.channel.lcd(this.homeDir.getPath());
            }
        }
        catch (JSchException e) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
            this.jsch = null;
            throw new SFTPException("It failed to connect!", e);
        }
        catch (SftpException e) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
            this.jsch = null;
            throw new SFTPException("It failed to connect!", e);
        }
    }

    public void connect(String user, String host, File pemFile, String passphrase) throws SFTPException {
        this.connect(user, host, 22, pemFile, passphrase);
    }

    public void connect(String user, String host, int port, File pemFile, String passphrase) throws SFTPException {
        if (this.jsch != null) {
            throw new SFTPException("It is already connected!");
        }
        this.jsch = new JSch();
        try {
            this.jsch.addIdentity(pemFile.getAbsolutePath(), passphrase);
            this.session = this.jsch.getSession(user, host, port);
            if (this.configProperties != null) {
                this.session.setConfig(this.configProperties);
            }
            if (this.proxy != null) {
                this.session.setProxy(this.proxy);
            }
            if (this.timeout >= 0) {
                this.session.setTimeout(this.timeout);
            }
            if (this.serverAliveInterval >= 0) {
                this.session.setServerAliveInterval(this.serverAliveInterval);
            }
            if (this.serverAliveCountMax >= 0) {
                this.session.setServerAliveCountMax(this.serverAliveCountMax);
            }
            this.session.connect();
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            if (this.fileNameEncoding != null) {
                this.channel.setFilenameEncoding(this.fileNameEncoding);
            }
            this.channel.connect();
            if (this.homeDir != null) {
                this.channel.lcd(this.homeDir.getPath());
            }
        }
        catch (JSchException e) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
            this.jsch = null;
            throw new SFTPException("It failed to connect!", e);
        }
        catch (SftpException e) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
            this.jsch = null;
            throw new SFTPException("It failed to connect!", e);
        }
    }

    public String[] ls() throws SFTPException {
        return this.ls(".");
    }

    public String[] ls(String path) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            Vector entries = this.channel.ls(path);
            String[] fileNames = new String[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)entries.get(i);
                fileNames[i] = entry.getFilename();
            }
            return fileNames;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to ls! path=" + path, e);
            }
            throw new SFTPException("It failed to ls! path=" + path, e);
        }
    }

    public SFTPClient.SFTPFile[] lsFile() throws SFTPException {
        return this.lsFile(".");
    }

    public SFTPClient.SFTPFile[] lsFile(String path) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            Vector entries = this.channel.ls(path);
            SFTPClient.SFTPFile[] files = new SFTPClient.SFTPFile[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)entries.get(i);
                files[i] = new SFTPFileImpl(entry);
            }
            return files;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to ls! path=" + path, e);
            }
            throw new SFTPException("It failed to ls! path=" + path, e);
        }
    }

    public String pwd() throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new SFTPException("It failed to pwd!", e);
        }
    }

    public File lpwd() throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        String path = this.channel.lpwd();
        return new File(path);
    }

    public void cd(String path) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to cd! to=" + path, e);
            }
            throw new SFTPException("It failed to cd! to=" + path, e);
        }
    }

    public void lcd(String path) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.lcd(path);
        }
        catch (SftpException e) {
            throw new SFTPException("It failed to lcd! to=" + path, e);
        }
    }

    public void mkdir(String dir) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.mkdir(dir);
        }
        catch (SftpException e) {
            throw new SFTPException("It failed to mkdir! dir=" + dir, e);
        }
    }

    public void rename(String from, String to) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.rename(from, to);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to rename! from=" + from + ", to=" + to, e);
            }
            throw new SFTPException("It failed to rename! from=" + from + ", to=" + to, e);
        }
    }

    public File get(String remote) throws NoSuchFileSFTPException, SFTPException {
        return this.get(remote, null);
    }

    public File get(String remote, String local) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            if (local == null) {
                local = this.lpwd().getPath();
            }
            this.channel.get(remote, local);
            File remoteFile = new File(remote);
            File localFile = new File(local);
            return localFile.isDirectory() ? new File(localFile, remoteFile.getName()) : localFile;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to get! remote=" + remote + ", local=" + local, e);
            }
            throw new SFTPException("It failed to get! remote=" + remote + ", local=" + local, e);
        }
    }

    public File[] mget(String remote) throws NoSuchFileSFTPException, SFTPException {
        return this.mget(remote, null);
    }

    public File[] mget(String remote, String localDir) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            String[] fileNames = this.ls(remote);
            if (fileNames.length == 0) {
                return new File[0];
            }
            if (localDir == null) {
                localDir = this.lpwd().getPath();
            }
            this.channel.get(remote, localDir);
            File[] files = new File[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                files[i] = new File(localDir, fileNames[i]);
            }
            return files;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to mget! remote=" + remote + ", localDir=" + localDir, e);
            }
            throw new SFTPException("It failed to mget! remote=" + remote + ", localDir=" + localDir, e);
        }
    }

    public void put(String local) throws SFTPException {
        this.put(local, null);
    }

    public void put(String local, String remote) throws SFTPException {
        this.put(local, remote, null);
    }

    public void put(String local, String remote, String mode) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.put(local, remote == null ? "." : remote, mode == null ? 644 : Integer.parseInt(mode));
        }
        catch (NumberFormatException e) {
            throw new SFTPException("Mode must be number! mode=" + mode, e);
        }
        catch (SftpException e) {
            throw new SFTPException("It failed to put! local=" + local + ", remote=" + remote, e);
        }
    }

    public void mput(String local) throws SFTPException {
        this.mput(local, ".");
    }

    public void mput(String local, String remoteDir) throws SFTPException {
        this.mput(local, remoteDir, null);
    }

    public void mput(String local, String remoteDir, String mode) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        if (remoteDir == null) {
            remoteDir = "./";
        } else if (!remoteDir.endsWith("/")) {
            remoteDir = remoteDir + "/";
        }
        RecurciveSearchFile rsf = new RecurciveSearchFile(this.lpwd().getPath());
        File[] localFiles = rsf.listAllTreeFiles(local);
        for (int i = 0; i < localFiles.length; ++i) {
            if (mode == null) {
                this.put(localFiles[i].getAbsolutePath(), remoteDir + localFiles[i].getName());
                continue;
            }
            this.put(localFiles[i].getAbsolutePath(), remoteDir + localFiles[i].getName(), mode);
        }
    }

    public boolean rm(String path) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.rm(path);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return false;
            }
            throw new SFTPException("It failed to rmove! path=" + path, e);
        }
        return true;
    }

    public boolean rmdir(String path) throws SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.rmdir(path);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return false;
            }
            throw new SFTPException("It failed to rmove! path=" + path, e);
        }
        return true;
    }

    public void chmod(String mode, String path) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.chmod(Integer.parseInt(mode), path);
        }
        catch (NumberFormatException e) {
            throw new SFTPException("Mode must be number! mode=" + mode, e);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to chmod! mode=" + mode + ", path=" + path, e);
            }
            throw new SFTPException("It failed to chmod! mode=" + mode + ", path=" + path, e);
        }
    }

    public void chown(String uid, String path) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.chown(Integer.parseInt(uid), path);
        }
        catch (NumberFormatException e) {
            throw new SFTPException("uid must be number! uid=" + uid, e);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to chown! uid=" + uid + ", path=" + path, e);
            }
            throw new SFTPException("It failed to chown! uid=" + uid + ", path=" + path, e);
        }
    }

    public void chgrp(String gid, String path) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.chgrp(Integer.parseInt(gid), path);
        }
        catch (NumberFormatException e) {
            throw new SFTPException("gid must be number! gid=" + gid, e);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to chgrp! gid=" + gid + ", path=" + path, e);
            }
            throw new SFTPException("It failed to chgrp! gid=" + gid + ", path=" + path, e);
        }
    }

    public void symlink(String path, String link) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.symlink(path, link);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to symlink! path=" + path + ", link=" + link, e);
            }
            throw new SFTPException("It failed to symlink! path=" + path + ", link=" + link, e);
        }
    }

    public void ln(String path, String link) throws NoSuchFileSFTPException, SFTPException {
        if (this.channel == null) {
            throw new SFTPException("Connection is not established!");
        }
        try {
            this.channel.hardlink(path, link);
        }
        catch (SftpException e) {
            if (e.id == 2) {
                throw new NoSuchFileSFTPException("It failed to ln! path=" + path + ", link=" + link, e);
            }
            throw new SFTPException("It failed to ln! path=" + path + ", link=" + link, e);
        }
    }

    public void close() throws SFTPException {
        if (this.semaphore != null) {
            this.semaphore.freeResource();
        }
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        this.jsch = null;
    }

    protected static class SFTPFileImpl
    implements SFTPClient.SFTPFile {
        protected ChannelSftp.LsEntry entry;

        public SFTPFileImpl(ChannelSftp.LsEntry entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getFilename();
        }

        public int getUserId() {
            return this.entry.getAttrs().getUId();
        }

        public int getGroupId() {
            return this.entry.getAttrs().getGId();
        }

        public int getPermissions() {
            return this.entry.getAttrs().getPermissions();
        }

        public Date getLastAccessTime() {
            return new Date((long)this.entry.getAttrs().getATime() * 1000L);
        }

        public Date getLastModificationTime() {
            return new Date((long)this.entry.getAttrs().getMTime() * 1000L);
        }

        public boolean isDirectory() {
            return this.entry.getAttrs().isDir();
        }

        public boolean isLink() {
            return this.entry.getAttrs().isLink();
        }

        public long size() {
            return this.entry.getAttrs().getSize();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SFTPClient.SFTPFile)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            SFTPClient.SFTPFile file = (SFTPClient.SFTPFile)obj;
            return this.getName().equals(file.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

