/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.util.SynchronizeMonitor;

public class WaitSynchronizeMonitor
implements SynchronizeMonitor,
Serializable {
    private static final long serialVersionUID = -2224847461399411455L;
    protected transient Map monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean isClosed;

    public synchronized boolean initMonitor() {
        return this.initMonitor(Thread.currentThread());
    }

    public synchronized boolean initMonitor(Thread thread) {
        if (this.isClosed) {
            return true;
        }
        MonitorFlag monitorFlag = (MonitorFlag)this.monitorFlagMap.get(thread);
        if (monitorFlag == null) {
            monitorFlag = new MonitorFlag();
            this.monitorFlagMap.put(thread, monitorFlag);
        }
        boolean isNotify = monitorFlag.isNotify;
        monitorFlag.isWait = false;
        monitorFlag.isNotify = false;
        return isNotify;
    }

    public synchronized void releaseMonitor() {
        Thread currentThread = Thread.currentThread();
        this.monitorFlagMap.remove(currentThread);
    }

    public synchronized void releaseAllMonitor() {
        this.monitorFlagMap.clear();
    }

    public synchronized void initAndWaitMonitor() throws InterruptedException {
        this.initAndWaitMonitor(-1L);
    }

    public synchronized boolean initAndWaitMonitor(long timeout) throws InterruptedException {
        return !this.initMonitor() ? this.waitMonitor(timeout) : true;
    }

    public synchronized void waitMonitor() throws InterruptedException {
        this.waitMonitor(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean waitMonitor(long timeout) throws InterruptedException {
        if (this.isClosed) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag = (MonitorFlag)this.monitorFlagMap.get(currentThread);
        if (monitorFlag == null) {
            return false;
        }
        if (monitorFlag.isNotify) {
            return true;
        }
        monitorFlag.isWait = true;
        try {
            long waitTime = timeout;
            while (!monitorFlag.isNotify) {
                if (timeout > 0L) {
                    if (waitTime >= 0L) {
                        this.wait(waitTime);
                    }
                    if ((waitTime = timeout - (System.currentTimeMillis() - startTime)) <= 0L) {
                        break;
                    }
                } else {
                    this.wait();
                }
                if (!this.isClosed) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            monitorFlag.isWait = false;
        }
        boolean isNotify = monitorFlag.isNotify;
        monitorFlag.isNotify = false;
        return isNotify;
    }

    public synchronized void notifyMonitor() {
        if (this.monitorFlagMap.size() != 0) {
            ((MonitorFlag)this.monitorFlagMap.values().iterator().next()).isNotify = true;
        }
        this.notifyAll();
    }

    public synchronized void notifyAllMonitor() {
        if (this.monitorFlagMap.size() != 0) {
            Iterator itr = this.monitorFlagMap.values().iterator();
            while (itr.hasNext()) {
                ((MonitorFlag)itr.next()).isNotify = true;
            }
        }
        this.notifyAll();
    }

    public synchronized boolean isNotify() {
        if (this.isClosed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        MonitorFlag monitorFlag = (MonitorFlag)this.monitorFlagMap.get(currentThread);
        return monitorFlag != null && monitorFlag.isNotify;
    }

    public synchronized boolean isFirst() {
        if (this.monitorFlagMap.size() == 0) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        if (!this.monitorFlagMap.containsKey(currentThread)) {
            return false;
        }
        Thread first = (Thread)this.monitorFlagMap.keySet().iterator().next();
        return first == null ? false : first.equals(currentThread);
    }

    public synchronized boolean isWait() {
        if (this.monitorFlagMap.size() != 0) {
            Iterator itr = this.monitorFlagMap.values().iterator();
            while (itr.hasNext()) {
                if (!((MonitorFlag)itr.next()).isWait) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized int getWaitCount() {
        int count = 0;
        if (this.monitorFlagMap.size() != 0) {
            Iterator itr = this.monitorFlagMap.values().iterator();
            while (itr.hasNext()) {
                if (!((MonitorFlag)itr.next()).isWait) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized Thread[] getWaitThreads() {
        ArrayList result = new ArrayList();
        if (this.monitorFlagMap.size() != 0) {
            Iterator entries = this.monitorFlagMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!((MonitorFlag)entry.getValue()).isWait) continue;
                result.add(entry.getKey());
            }
        }
        return result.toArray(new Thread[result.size()]);
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAllMonitor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.monitorFlagMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    protected static final class MonitorFlag
    implements Serializable {
        private static final long serialVersionUID = -4683612743846239879L;
        public boolean isWait;
        public boolean isNotify;

        protected MonitorFlag() {
        }
    }
}

