/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.util.converter.BufferedStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.DOMHTMLConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMXMLConverter
extends BufferedStreamConverter
implements StreamStringConverter,
Serializable {
    private static final long serialVersionUID = -7589887444564629172L;
    private static final String METHOD_NAME_SET_XML_VERSION = "setXmlVersion";
    private static final Class[] METHOD_ARGS_SET_XML_VERSION = new Class[]{String.class};
    public static final int DOM_TO_XML = 1;
    public static final int XML_TO_DOM = 2;
    protected int convertType;
    protected String xslFilePath;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isSynchronizedDomParse;
    protected String documentBuilderFactoryClass;
    protected String xmlVersion;

    public DOMXMLConverter() {
        this(1);
    }

    public void setDocumentBuilderFactoryClassName(String clazz) {
        this.documentBuilderFactoryClass = clazz;
    }

    public DOMXMLConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        if (encoding == null && this.characterEncodingToStream == null || encoding != null && encoding.equals(this.characterEncodingToStream)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToStream(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        if (encoding == null && this.characterEncodingToObject == null || encoding != null && encoding.equals(this.characterEncodingToObject)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToObject(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setSynchronizedDomParse(boolean isSync) {
        this.isSynchronizedDomParse = isSync;
    }

    public boolean isSynchronizedDomParse() {
        return this.isSynchronizedDomParse;
    }

    public void setXmlVersion(String version) throws IllegalArgumentException {
        try {
            Method method = Document.class.getMethod(METHOD_NAME_SET_XML_VERSION, METHOD_ARGS_SET_XML_VERSION);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("DOM version is old. Not support to change xml version.");
        }
        this.xmlVersion = version;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDOM((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDOM((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        if (obj instanceof Document) {
            return this.toXML((Document)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDOM(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document toDOM(InputStream is) throws ConvertException {
        Document doc;
        block16: {
            doc = null;
            try {
                InputSource inputSource = new InputSource(is);
                if (this.characterEncodingToObject != null) {
                    String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToObject);
                    if (encoding == null) {
                        encoding = this.characterEncodingToObject;
                    }
                    inputSource.setEncoding(encoding);
                }
                DocumentBuilderFactory domFactory = null;
                if (this.documentBuilderFactoryClass == null) {
                    domFactory = DocumentBuilderFactory.newInstance();
                } else {
                    try {
                        domFactory = (DocumentBuilderFactory)Class.forName(this.documentBuilderFactoryClass, true, NimbusClassLoader.getInstance()).newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new ConvertException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ConvertException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConvertException(e);
                    }
                }
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                if (this.isSynchronizedDomParse) {
                    Class<?> lock;
                    Class<?> clazz = lock = builder.getClass();
                    synchronized (clazz) {
                        doc = builder.parse(inputSource);
                        break block16;
                    }
                }
                doc = builder.parse(inputSource);
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            catch (ParserConfigurationException e) {
                throw new ConvertException(e);
            }
            catch (SAXException e) {
                throw new ConvertException(e);
            }
        }
        return doc;
    }

    protected Document toDOM(File file) throws ConvertException {
        try {
            return this.toDOM(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected byte[] toXML(Document document) throws ConvertException {
        byte[] result = null;
        try {
            if (this.xmlVersion != null) {
                try {
                    Method method = Document.class.getMethod(METHOD_NAME_SET_XML_VERSION, METHOD_ARGS_SET_XML_VERSION);
                    method.invoke((Object)document, this.xmlVersion);
                }
                catch (NoSuchMethodException e) {
                    throw new ConvertException("DOM version is old. Not support to change xml version.", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException("DOM version is old. Not support to change xml version.", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException(e);
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            if (this.characterEncodingToStream != null) {
                String encoding = (String)DOMHTMLConverter.IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToStream);
                if (encoding == null) {
                    encoding = this.characterEncodingToStream;
                }
                transformer.setOutputProperty("encoding", encoding);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            result = baos.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
        return result;
    }
}

