/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.BufferedStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class DataSetJSONConverter
extends BufferedStreamConverter
implements BindingStreamConverter,
StreamStringConverter {
    private static final String STRING_ENCLOSURE = "\"";
    private static final String ARRAY_SEPARATOR = ",";
    private static final String ARRAY_ENCLOSURE_START = "[";
    private static final String ARRAY_ENCLOSURE_END = "]";
    private static final String OBJECT_ENCLOSURE_START = "{";
    private static final String OBJECT_ENCLOSURE_END = "}";
    private static final String PROPERTY_SEPARATOR = ":";
    private static final String NULL_VALUE = "null";
    private static final String BOOLEAN_VALUE_TRUE = "true";
    private static final String BOOLEAN_VALUE_FALSE = "false";
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char SLASH = '/';
    private static final char BACK_SPACE = '\b';
    private static final char BACK_SPACE_CHAR = 'b';
    private static final char CHANGE_PAGE = '\f';
    private static final char CHANGE_PAGE_CHAR = 'f';
    private static final char LF = '\n';
    private static final char LF_CHAR = 'n';
    private static final char CR = '\r';
    private static final char CR_CHAR = 'r';
    private static final char TAB = '\t';
    private static final char TAB_CHAR = 't';
    private static final String ESCAPE_QUOTE = "\\\"";
    private static final String ESCAPE_BACK_SLASH = "\\\\";
    private static final String ESCAPE_SLASH = "\\/";
    private static final String ESCAPE_BACK_SPACE = "\\b";
    private static final String ESCAPE_CHANGE_PAGE = "\\f";
    private static final String ESCAPE_LF = "\\n";
    private static final String ESCAPE_CR = "\\r";
    private static final String ESCAPE_TAB = "\\t";
    private static final String NAME_SCHEMA = "schema";
    private static final String NAME_HEADER = "header";
    private static final String NAME_RECORD_LIST = "recordList";
    private static final String NAME_NESTED_RECORD = "nestedRecord";
    private static final String NAME_NESTED_RECORD_LIST = "nestedRecordList";
    private static final String NAME_VALUE = "value";
    private static final String NAME_INDEX = "index";
    private static final String NAME_TYPE = "type";
    private static final String UTF8 = "UTF-8";
    private static final String UTF16 = "UTF-16";
    private static final String UTF16BE = "UTF-16BE";
    private static final String UTF16LE = "UTF-16LE";
    private static String UTF8_BOM;
    private static String UTF16_BOM_LE;
    private static String UTF16_BOM_BE;
    public static final int DATASET_TO_JSON = 1;
    public static final int JSON_TO_DATASET = 2;
    protected int convertType;
    protected Map dataSetMap = new HashMap();
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected String dataSetFlowNamePrefix;
    protected boolean isOutputSchema = true;
    protected String characterEncodingToStream = "UTF-8";
    protected String characterEncodingToObject = "UTF-8";
    protected boolean isIgnoreUnknownElement;
    protected boolean isOutputPropertyNameOfHeader = true;
    protected boolean isOutputPropertyNameOfRecordList = true;
    protected boolean isOutputNullProperty = true;
    protected boolean isOutputJSONSchema = false;
    protected boolean isUnicodeEscape = true;

    public DataSetJSONConverter() {
        this(1);
    }

    public DataSetJSONConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setDataSet(DataSet dataSet) {
        if (dataSet.getName() == null) {
            throw new IllegalArgumentException("DataSet name is null. dataSet=" + dataSet);
        }
        this.dataSetMap.put(dataSet.getName(), dataSet);
    }

    public void setDataSet(String name, DataSet dataSet) {
        if (dataSet.getName() == null) {
            dataSet.setName(name);
        }
        this.dataSetMap.put(name, dataSet);
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public void setDataSetFlowNamePrefix(String prefix) {
        this.dataSetFlowNamePrefix = prefix;
    }

    public String getDataSetFlowNamePrefix() {
        return this.dataSetFlowNamePrefix;
    }

    public void setOutputSchema(boolean isOutput) {
        this.isOutputSchema = isOutput;
    }

    public boolean isOutputSchema() {
        return this.isOutputSchema;
    }

    public void setOutputPropertyNameOfHeader(boolean isOutput) {
        this.isOutputPropertyNameOfHeader = isOutput;
    }

    public boolean isOutputPropertyNameOfHeader() {
        return this.isOutputPropertyNameOfHeader;
    }

    public void setOutputPropertyNameOfRecordList(boolean isOutput) {
        this.isOutputPropertyNameOfRecordList = isOutput;
    }

    public boolean isOutputPropertyNameOfRecordList() {
        return this.isOutputPropertyNameOfRecordList;
    }

    public void setOutputNullProperty(boolean isOutput) {
        this.isOutputNullProperty = isOutput;
    }

    public boolean isOutputNullProperty() {
        return this.isOutputNullProperty;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        if (encoding == null && this.characterEncodingToStream == null || encoding != null && encoding.equals(this.characterEncodingToStream)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToStream(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        if (encoding == null && this.characterEncodingToObject == null || encoding != null && encoding.equals(this.characterEncodingToObject)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToObject(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setIgnoreUnknownElement(boolean isIgnore) {
        this.isIgnoreUnknownElement = isIgnore;
    }

    public boolean isIgnoreUnknownElement() {
        return this.isIgnoreUnknownElement;
    }

    public void setOutputJSONSchema(boolean isOutput) {
        this.isOutputJSONSchema = isOutput;
    }

    public boolean isOutputJSONSchema() {
        return this.isOutputJSONSchema;
    }

    public boolean isUnicodeEscape() {
        return this.isUnicodeEscape;
    }

    public void setUnicodeEscape(boolean isEscape) {
        this.isUnicodeEscape = isEscape;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDataSet((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDataSet((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        if (obj instanceof DataSet) {
            return this.toJSON((DataSet)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDataSet(is);
    }

    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        if (returnType != null && !(returnType instanceof DataSet)) {
            throw new ConvertException("ReturnType is not DataSet." + returnType);
        }
        return this.toDataSet(is, (DataSet)returnType);
    }

    protected byte[] toJSON(DataSet dataSet) throws ConvertException {
        byte[] result = null;
        try {
            String[] recListNames;
            String[] headerNames;
            StringBuffer buf = new StringBuffer();
            String dsName = dataSet.getName();
            if (dsName == null) {
                dsName = "";
            }
            buf.append(OBJECT_ENCLOSURE_START);
            this.appendName(buf, dsName);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            boolean isOutput = false;
            if (this.isOutputSchema) {
                RecordSchema recSchema;
                String[] recNames;
                String[] recListNames2;
                this.appendName(buf, NAME_SCHEMA);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                headerNames = dataSet.getHeaderNames();
                if (headerNames != null && headerNames.length > 0) {
                    this.appendName(buf, NAME_HEADER);
                    buf.append(PROPERTY_SEPARATOR);
                    buf.append(OBJECT_ENCLOSURE_START);
                    int imax = headerNames.length;
                    for (int i = 0; i < imax; ++i) {
                        Header header = dataSet.getHeader(headerNames[i]);
                        this.appendName(buf, headerNames[i] == null ? "" : headerNames[i]);
                        buf.append(PROPERTY_SEPARATOR);
                        if (this.isOutputJSONSchema) {
                            RecordSchema schema = header.getRecordSchema();
                            if (schema == null) {
                                this.appendValue(buf, null, null);
                            } else {
                                this.appendSchema(buf, schema);
                            }
                        } else {
                            this.appendValue(buf, null, header.getSchema());
                        }
                        if (i == imax - 1) continue;
                        buf.append(ARRAY_SEPARATOR);
                    }
                    buf.append(OBJECT_ENCLOSURE_END);
                    isOutput = true;
                }
                if ((recListNames2 = dataSet.getRecordListNames()) != null && recListNames2.length > 0) {
                    if (isOutput) {
                        buf.append(ARRAY_SEPARATOR);
                    }
                    this.appendName(buf, NAME_RECORD_LIST);
                    buf.append(PROPERTY_SEPARATOR);
                    buf.append(OBJECT_ENCLOSURE_START);
                    int imax = recListNames2.length;
                    for (int i = 0; i < imax; ++i) {
                        RecordList recList = dataSet.getRecordList(recListNames2[i]);
                        this.appendName(buf, recListNames2[i] == null ? "" : recListNames2[i]);
                        buf.append(PROPERTY_SEPARATOR);
                        if (this.isOutputJSONSchema) {
                            RecordSchema schema = recList.getRecordSchema();
                            if (schema == null) {
                                this.appendValue(buf, null, null);
                            } else {
                                this.appendSchema(buf, schema);
                            }
                        } else {
                            this.appendValue(buf, null, recList.getSchema());
                        }
                        if (i == imax - 1) continue;
                        buf.append(ARRAY_SEPARATOR);
                    }
                    buf.append(OBJECT_ENCLOSURE_END);
                    isOutput = true;
                }
                if ((recNames = dataSet.getNestedRecordSchemaNames()) != null && recNames.length > 0) {
                    if (isOutput) {
                        buf.append(ARRAY_SEPARATOR);
                    }
                    this.appendName(buf, NAME_NESTED_RECORD);
                    buf.append(PROPERTY_SEPARATOR);
                    buf.append(OBJECT_ENCLOSURE_START);
                    int imax = recNames.length;
                    for (int i = 0; i < imax; ++i) {
                        recSchema = dataSet.getNestedRecordSchema(recNames[i]);
                        this.appendName(buf, recNames[i]);
                        buf.append(PROPERTY_SEPARATOR);
                        if (this.isOutputJSONSchema) {
                            if (recSchema == null) {
                                this.appendValue(buf, null, null);
                            } else {
                                this.appendSchema(buf, recSchema);
                            }
                        } else {
                            this.appendValue(buf, null, recSchema.getSchema());
                        }
                        if (i == imax - 1) continue;
                        buf.append(ARRAY_SEPARATOR);
                    }
                    buf.append(OBJECT_ENCLOSURE_END);
                    isOutput = true;
                }
                if ((recListNames2 = dataSet.getNestedRecordListSchemaNames()) != null && recListNames2.length > 0) {
                    if (isOutput) {
                        buf.append(ARRAY_SEPARATOR);
                    }
                    this.appendName(buf, NAME_NESTED_RECORD_LIST);
                    buf.append(PROPERTY_SEPARATOR);
                    buf.append(OBJECT_ENCLOSURE_START);
                    int imax = recListNames2.length;
                    for (int i = 0; i < imax; ++i) {
                        recSchema = dataSet.getNestedRecordListSchema(recListNames2[i]);
                        this.appendName(buf, recListNames2[i]);
                        buf.append(PROPERTY_SEPARATOR);
                        if (this.isOutputJSONSchema) {
                            if (recSchema == null) {
                                this.appendValue(buf, null, null);
                            } else {
                                this.appendSchema(buf, recSchema);
                            }
                        } else {
                            this.appendValue(buf, null, recSchema.getSchema());
                        }
                        if (i == imax - 1) continue;
                        buf.append(ARRAY_SEPARATOR);
                    }
                    buf.append(OBJECT_ENCLOSURE_END);
                    isOutput = true;
                }
                buf.append(OBJECT_ENCLOSURE_END);
            }
            if ((headerNames = dataSet.getHeaderNames()) != null && headerNames.length > 0) {
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, NAME_HEADER);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = headerNames.length;
                for (int i = 0; i < imax; ++i) {
                    Header header = dataSet.getHeader(headerNames[i]);
                    this.appendName(buf, headerNames[i] == null ? "" : headerNames[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendValue(buf, null, header);
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            if ((recListNames = dataSet.getRecordListNames()) != null && recListNames.length > 0) {
                if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                this.appendName(buf, NAME_RECORD_LIST);
                buf.append(PROPERTY_SEPARATOR);
                buf.append(OBJECT_ENCLOSURE_START);
                int imax = recListNames.length;
                for (int i = 0; i < imax; ++i) {
                    RecordList recList = dataSet.getRecordList(recListNames[i]);
                    this.appendName(buf, recListNames[i] == null ? "" : recListNames[i]);
                    buf.append(PROPERTY_SEPARATOR);
                    this.appendArray(buf, recList);
                    if (i == imax - 1) continue;
                    buf.append(ARRAY_SEPARATOR);
                }
                buf.append(OBJECT_ENCLOSURE_END);
                isOutput = true;
            }
            buf.append(OBJECT_ENCLOSURE_END);
            buf.append(OBJECT_ENCLOSURE_END);
            String str = buf.toString();
            result = this.characterEncodingToStream == null ? str.getBytes() : str.getBytes(this.characterEncodingToStream);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return result;
    }

    private StringBuffer appendSchema(StringBuffer buf, RecordSchema schema) {
        PropertySchema[] props = schema.getPropertySchemata();
        buf.append(OBJECT_ENCLOSURE_START);
        for (int j = 0; j < props.length; ++j) {
            this.appendName(buf, props[j].getName());
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            this.appendName(buf, NAME_INDEX);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(j);
            buf.append(ARRAY_SEPARATOR);
            this.appendName(buf, NAME_TYPE);
            buf.append(PROPERTY_SEPARATOR);
            String nestedSchemaName = null;
            if (props[j] instanceof RecordListPropertySchema) {
                this.appendValue(buf, null, NAME_NESTED_RECORD_LIST);
                nestedSchemaName = ((RecordListPropertySchema)props[j]).getRecordListName();
            } else if (props[j] instanceof RecordPropertySchema) {
                this.appendValue(buf, null, NAME_NESTED_RECORD);
                nestedSchemaName = ((RecordPropertySchema)props[j]).getRecordName();
            } else {
                this.appendValue(buf, null, NAME_VALUE);
            }
            if (nestedSchemaName != null) {
                buf.append(ARRAY_SEPARATOR);
                this.appendName(buf, NAME_SCHEMA);
                buf.append(PROPERTY_SEPARATOR);
                this.appendValue(buf, null, nestedSchemaName);
            }
            buf.append(OBJECT_ENCLOSURE_END);
            if (j == props.length - 1) continue;
            buf.append(ARRAY_SEPARATOR);
        }
        buf.append(OBJECT_ENCLOSURE_END);
        return buf;
    }

    private StringBuffer appendName(StringBuffer buf, String name) {
        buf.append(STRING_ENCLOSURE);
        buf.append(this.escape(name));
        buf.append(STRING_ENCLOSURE);
        return buf;
    }

    private StringBuffer appendValue(StringBuffer buf, Class type, Object value) {
        if (type == null && value != null) {
            type = value.getClass();
        }
        if (value == null) {
            if (type == null) {
                buf.append(NULL_VALUE);
            } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
                buf.append('0');
            } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                buf.append(BOOLEAN_VALUE_FALSE);
            } else {
                buf.append(NULL_VALUE);
            }
        } else if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    buf.append(BOOLEAN_VALUE_TRUE);
                } else {
                    buf.append(BOOLEAN_VALUE_FALSE);
                }
            } else {
                buf.append(this.escape(value.toString()));
            }
        } else if (Number.class.isAssignableFrom(type) || type.isPrimitive() && (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type))) {
            if (value instanceof Float && (((Float)value).isNaN() || ((Float)value).isInfinite()) || value instanceof Double && (((Double)value).isNaN() || ((Double)value).isInfinite()) || value instanceof String && ("-Infinity".equals(value) || "Infinity".equals(value) || "NaN".equals(value))) {
                buf.append(STRING_ENCLOSURE);
                buf.append(this.escape(value.toString()));
                buf.append(STRING_ENCLOSURE);
            } else {
                buf.append(value);
            }
        } else if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            this.appendArray(buf, value);
        } else if (Record.class.isAssignableFrom(type)) {
            Record rec = (Record)value;
            RecordSchema schema = rec.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            boolean isOutputPropertyName = true;
            if (rec instanceof Header && !this.isOutputPropertyNameOfHeader || !(rec instanceof Header) && !this.isOutputPropertyNameOfRecordList) {
                isOutputPropertyName = false;
            }
            if (isOutputPropertyName) {
                buf.append(OBJECT_ENCLOSURE_START);
            } else {
                buf.append(ARRAY_ENCLOSURE_START);
            }
            boolean isOutput = false;
            int imax = propSchemata.length;
            for (int i = 0; i < imax; ++i) {
                Object prop = rec.getProperty(i);
                PropertySchema propSchema = propSchemata[i];
                if (isOutputPropertyName) {
                    if (!this.isOutputNullProperty && prop == null) continue;
                    if (isOutput) {
                        buf.append(ARRAY_SEPARATOR);
                    }
                    this.appendName(buf, propSchema.getName());
                    buf.append(PROPERTY_SEPARATOR);
                } else if (isOutput) {
                    buf.append(ARRAY_SEPARATOR);
                }
                if (prop == null) {
                    this.appendValue(buf, propSchema.getType(), null);
                } else {
                    Class<?> propType = propSchema.getType();
                    if (propType == null) {
                        propType = prop.getClass();
                    }
                    if (propType.isArray() || (class$java$util$Collection == null ? DataSetJSONConverter.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(propType)) {
                        this.appendArray(buf, prop);
                    } else {
                        Object formatProp = rec.getFormatProperty(i);
                        if ((class$java$lang$Number == null ? DataSetJSONConverter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(propType) || propType.isPrimitive() && (Byte.TYPE.equals(propType) || Short.TYPE.equals(propType) || Integer.TYPE.equals(propType) || Long.TYPE.equals(propType) || Float.TYPE.equals(propType) || Double.TYPE.equals(propType) || Boolean.TYPE.equals(propType)) || (class$java$lang$Boolean == null ? DataSetJSONConverter.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(propType)) {
                            this.appendValue(buf, propType, formatProp);
                        } else {
                            this.appendValue(buf, null, formatProp);
                        }
                    }
                }
                isOutput = true;
            }
            if (isOutputPropertyName) {
                buf.append(OBJECT_ENCLOSURE_END);
            } else {
                buf.append(ARRAY_ENCLOSURE_END);
            }
        } else {
            buf.append(STRING_ENCLOSURE);
            buf.append(this.escape(value.toString()));
            buf.append(STRING_ENCLOSURE);
        }
        return buf;
    }

    private StringBuffer appendArray(StringBuffer buf, Object array) {
        buf.append(ARRAY_ENCLOSURE_START);
        if (array.getClass().isArray()) {
            int imax = Array.getLength(array);
            for (int i = 0; i < imax; ++i) {
                this.appendValue(buf, null, Array.get(array, i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (List.class.isAssignableFrom(array.getClass())) {
            List list = (List)array;
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                this.appendValue(buf, null, list.get(i));
                if (i == imax - 1) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        } else if (Collection.class.isAssignableFrom(array.getClass())) {
            Iterator itr = ((Collection)array).iterator();
            while (itr.hasNext()) {
                this.appendValue(buf, null, itr.next());
                if (!itr.hasNext()) continue;
                buf.append(ARRAY_SEPARATOR);
            }
        }
        buf.append(ARRAY_ENCLOSURE_END);
        return buf;
    }

    private String escape(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean isEscape = false;
        StringBuffer buf = new StringBuffer();
        int imax = str.length();
        block10: for (int i = 0; i < imax; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append(ESCAPE_QUOTE);
                    isEscape = true;
                    continue block10;
                }
                case '\\': {
                    buf.append(ESCAPE_BACK_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '/': {
                    buf.append(ESCAPE_SLASH);
                    isEscape = true;
                    continue block10;
                }
                case '\b': {
                    buf.append(ESCAPE_BACK_SPACE);
                    isEscape = true;
                    continue block10;
                }
                case '\f': {
                    buf.append(ESCAPE_CHANGE_PAGE);
                    isEscape = true;
                    continue block10;
                }
                case '\n': {
                    buf.append(ESCAPE_LF);
                    isEscape = true;
                    continue block10;
                }
                case '\r': {
                    buf.append(ESCAPE_CR);
                    isEscape = true;
                    continue block10;
                }
                case '\t': {
                    buf.append(ESCAPE_TAB);
                    isEscape = true;
                    continue block10;
                }
                default: {
                    if (!(!this.isUnicodeEscape || c == ' ' || c == '!' || '#' <= c && c <= '[' || ']' <= c && c <= '~')) {
                        isEscape = true;
                        this.toUnicode(c, buf);
                        continue block10;
                    }
                    buf.append(c);
                }
            }
        }
        return isEscape ? buf.toString() : str;
    }

    private StringBuffer toUnicode(char c, StringBuffer buf) {
        buf.append('\\');
        buf.append('u');
        int mask = 61440;
        block18: for (int i = 0; i < 4; ++i) {
            mask = 61440 >> i * 4;
            int val = c & mask;
            switch (val <<= i * 4) {
                case 0: {
                    buf.append('0');
                    continue block18;
                }
                case 4096: {
                    buf.append('1');
                    continue block18;
                }
                case 8192: {
                    buf.append('2');
                    continue block18;
                }
                case 12288: {
                    buf.append('3');
                    continue block18;
                }
                case 16384: {
                    buf.append('4');
                    continue block18;
                }
                case 20480: {
                    buf.append('5');
                    continue block18;
                }
                case 24576: {
                    buf.append('6');
                    continue block18;
                }
                case 28672: {
                    buf.append('7');
                    continue block18;
                }
                case 32768: {
                    buf.append('8');
                    continue block18;
                }
                case 36864: {
                    buf.append('9');
                    continue block18;
                }
                case 40960: {
                    buf.append('a');
                    continue block18;
                }
                case 45056: {
                    buf.append('b');
                    continue block18;
                }
                case 49152: {
                    buf.append('c');
                    continue block18;
                }
                case 53248: {
                    buf.append('d');
                    continue block18;
                }
                case 57344: {
                    buf.append('e');
                    continue block18;
                }
                case 61440: {
                    buf.append('f');
                    continue block18;
                }
            }
        }
        return buf;
    }

    protected DataSet toDataSet(File file) throws ConvertException {
        try {
            return this.toDataSet(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected DataSet toDataSet(InputStream is) throws ConvertException {
        return this.toDataSet(is, null);
    }

    protected DataSet toDataSet(InputStream is, DataSet dataSet) throws ConvertException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataSet ds = dataSet;
        try {
            Object recListObj;
            Object headerObj;
            int length = 0;
            byte[] buf = new byte[1024];
            while ((length = is.read(buf)) != -1) {
                baos.write(buf, 0, length);
            }
            String dataStr = new String(baos.toByteArray(), this.characterEncodingToObject);
            dataStr = this.removeBOM(dataStr);
            dataStr = this.fromUnicode(dataStr);
            Map jsonObj = new HashMap();
            this.readJSONObject(new StringReader(dataStr), new StringBuffer(), jsonObj, false);
            if (jsonObj.size() == 0) {
                return ds;
            }
            Iterator entries = jsonObj.entrySet().iterator();
            Map.Entry entry = entries.next();
            String dsName = (String)entry.getKey();
            jsonObj = (Map)entry.getValue();
            if (ds == null) {
                String dsFlowName = dsName;
                if (this.dataSetFlowNamePrefix != null) {
                    dsFlowName = this.dataSetFlowNamePrefix + dsFlowName;
                }
                if (this.dataSetMap.containsKey(dsName)) {
                    ds = ((DataSet)this.dataSetMap.get(dsName)).cloneSchema();
                } else if (this.beanFlowInvokerFactory != null && this.beanFlowInvokerFactory.containsFlow(dsFlowName)) {
                    BeanFlowInvoker beanFlowInvoker = this.beanFlowInvokerFactory.createFlow(dsFlowName);
                    Object ret = null;
                    try {
                        ret = beanFlowInvoker.invokeFlow(null);
                    }
                    catch (Exception e) {
                        throw new ConvertException("Exception occured in BeanFlow '" + dsFlowName + "'", e);
                    }
                    if (!(ret instanceof DataSet)) {
                        throw new ConvertException("Result of BeanFlow '" + dsFlowName + "' is not DataSet.");
                    }
                    ds = (DataSet)ret;
                } else {
                    Object nestedRecListObj;
                    Object nestedRecObj;
                    Object recListObj2;
                    ds = new DataSet(dsName);
                    Object schemaObj = jsonObj.get(NAME_SCHEMA);
                    if (schemaObj == null || !(schemaObj instanceof Map)) {
                        throw new ConvertException("Dataset is not found. name=" + dsName);
                    }
                    Map schemaMap = (Map)schemaObj;
                    Object headerObj2 = schemaMap.get(NAME_HEADER);
                    if (headerObj2 != null) {
                        if (!(headerObj2 instanceof Map)) {
                            throw new ConvertException("Header schema is not jsonObject." + headerObj2);
                        }
                        Map headerMap = (Map)headerObj2;
                        entries = headerMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            Object schemaStrObj;
                            entry = entries.next();
                            String name = (String)entry.getKey();
                            if (name.length() == 0) {
                                name = null;
                            }
                            if (!((schemaStrObj = entry.getValue()) instanceof String)) {
                                throw new ConvertException("Header schema '" + name + "' is not string." + schemaStrObj);
                            }
                            ds.setHeaderSchema(name, (String)schemaStrObj);
                        }
                    }
                    if ((recListObj2 = schemaMap.get(NAME_RECORD_LIST)) != null) {
                        if (!(recListObj2 instanceof Map)) {
                            throw new ConvertException("RecordList schema is not jsonObject." + recListObj2);
                        }
                        Map recListMap = (Map)recListObj2;
                        entries = recListMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            Object schemaStrObj;
                            entry = entries.next();
                            String name = (String)entry.getKey();
                            if (name.length() == 0) {
                                name = null;
                            }
                            if (!((schemaStrObj = entry.getValue()) instanceof String)) {
                                throw new ConvertException("RecordList schema '" + name + "' is not string." + schemaStrObj);
                            }
                            ds.setRecordListSchema(name, (String)schemaStrObj);
                        }
                    }
                    if ((nestedRecObj = schemaMap.get(NAME_NESTED_RECORD)) != null) {
                        if (!(nestedRecObj instanceof Map)) {
                            throw new ConvertException("NestedRecord schema is not jsonObject." + nestedRecObj);
                        }
                        Map nestedRecMap = (Map)nestedRecObj;
                        entries = nestedRecMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            entry = entries.next();
                            String name = (String)entry.getKey();
                            Object schemaStrObj = entry.getValue();
                            if (!(schemaStrObj instanceof String)) {
                                throw new ConvertException("NestedRecord schema '" + name + "' is not string." + schemaStrObj);
                            }
                            ds.setNestedRecordSchema(name, (String)schemaStrObj);
                        }
                    }
                    if ((nestedRecListObj = schemaMap.get(NAME_NESTED_RECORD_LIST)) != null) {
                        if (!(nestedRecListObj instanceof Map)) {
                            throw new ConvertException("NestedRecordList schema is not jsonObject." + nestedRecListObj);
                        }
                        Map nestedRecListMap = (Map)nestedRecListObj;
                        entries = nestedRecListMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            entry = entries.next();
                            String name = (String)entry.getKey();
                            Object schemaStrObj = entry.getValue();
                            if (!(schemaStrObj instanceof String)) {
                                throw new ConvertException("NestedRecordList schema '" + name + "' is not string." + schemaStrObj);
                            }
                            ds.setNestedRecordListSchema(name, (String)schemaStrObj);
                        }
                    }
                }
            } else {
                ds = ds.cloneSchema();
            }
            if ((headerObj = jsonObj.get(NAME_HEADER)) != null) {
                if (!(headerObj instanceof Map)) {
                    throw new ConvertException("Header is not jsonObject." + headerObj);
                }
                Map headerMap = (Map)headerObj;
                entries = headerMap.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    this.readHeader(ds, (String)entry.getKey(), entry.getValue());
                }
            }
            if ((recListObj = jsonObj.get(NAME_RECORD_LIST)) != null) {
                if (!(recListObj instanceof Map)) {
                    throw new ConvertException("RecordList is not jsonObject." + recListObj);
                }
                Map recListMap = (Map)recListObj;
                entries = recListMap.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    this.readRecordList(ds, (String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return ds;
    }

    private DataSet readHeader(DataSet dataSet, String headerName, Object headerValue) throws ConvertException {
        Header header = dataSet.getHeader(headerName);
        if (header == null && headerName != null && headerName.length() == 0) {
            header = dataSet.getHeader();
        }
        if (header == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown header : " + headerName);
        }
        return this.readRecord(dataSet, header, headerValue);
    }

    private DataSet readRecord(DataSet dataSet, Record record, Object recordValue) throws ConvertException {
        RecordSchema schema = record.getRecordSchema();
        if (recordValue instanceof Map) {
            Map propertyMap = (Map)recordValue;
            Iterator entries = propertyMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String propName = (String)entry.getKey();
                PropertySchema propSchema = schema.getPropertySchema(propName);
                if (propSchema == null && this.isIgnoreUnknownElement) continue;
                Object propValue = entry.getValue();
                if (propSchema instanceof RecordPropertySchema) {
                    if (propValue == null) continue;
                    RecordPropertySchema recPropSchema = (RecordPropertySchema)propSchema;
                    Record rec = dataSet.createNestedRecord(recPropSchema.getRecordName());
                    this.readRecord(dataSet, rec, propValue);
                    record.setProperty(propName, (Object)rec);
                    continue;
                }
                if (propSchema instanceof RecordListPropertySchema) {
                    if (propValue == null) continue;
                    RecordListPropertySchema recListPropSchema = (RecordListPropertySchema)propSchema;
                    RecordList recList = dataSet.createNestedRecordList(recListPropSchema.getRecordListName());
                    this.readRecordList(dataSet, recList, (Object)((List)propValue));
                    record.setProperty(propName, (Object)recList);
                    continue;
                }
                if (propValue instanceof List) {
                    propValue = ((List)propValue).toArray(new String[((List)propValue).size()]);
                }
                record.setParseProperty(propName, propValue);
            }
        } else if (recordValue instanceof List) {
            List propertyList;
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            if (propSchemata.length != (propertyList = (List)recordValue).size() && !this.isIgnoreUnknownElement) {
                throw new ConvertException("Unmatch record property size. " + propertyList.size());
            }
            int imax = propSchemata.length;
            for (int i = 0; i < imax && i < propertyList.size(); ++i) {
                PropertySchema propSchema = propSchemata[i];
                Object propValue = propertyList.get(i);
                if (propValue == null) continue;
                if (propSchema instanceof RecordPropertySchema) {
                    RecordPropertySchema recPropSchema = (RecordPropertySchema)propSchema;
                    Record rec = dataSet.createNestedRecord(recPropSchema.getRecordName());
                    this.readRecord(dataSet, rec, propValue);
                    record.setProperty(i, (Object)rec);
                    continue;
                }
                if (propSchema instanceof RecordListPropertySchema) {
                    RecordListPropertySchema recListPropSchema = (RecordListPropertySchema)propSchema;
                    RecordList recList = dataSet.createNestedRecordList(recListPropSchema.getRecordListName());
                    this.readRecordList(dataSet, recList, propValue);
                    record.setProperty(i, (Object)recList);
                    continue;
                }
                if (propValue instanceof List) {
                    propValue = ((List)propValue).toArray(new String[((List)propValue).size()]);
                }
                record.setParseProperty(i, propValue);
            }
        } else {
            throw new ConvertException("Record is neither jsonObject nor array." + recordValue);
        }
        return dataSet;
    }

    private DataSet readRecordList(DataSet dataSet, String recListName, Object recordListValue) throws ConvertException {
        if (recordListValue == null) {
            return dataSet;
        }
        RecordList recList = dataSet.getRecordList(recListName);
        if (recList == null && recListName != null && recListName.length() == 0) {
            recList = dataSet.getRecordList();
        }
        if (recList == null) {
            if (this.isIgnoreUnknownElement) {
                return dataSet;
            }
            throw new ConvertException("Unknown recordList : " + recListName);
        }
        return this.readRecordList(dataSet, recList, recordListValue);
    }

    private DataSet readRecordList(DataSet dataSet, RecordList recordList, Object recordListValue) throws ConvertException {
        if (!(recordListValue instanceof List)) {
            throw new ConvertException("RecordList must be json array." + recordListValue);
        }
        List recListValue = (List)recordListValue;
        int imax = recListValue.size();
        for (int i = 0; i < imax; ++i) {
            Record record = recordList.createRecord();
            this.readRecord(dataSet, record, recListValue.get(i));
            recordList.addRecord(record);
        }
        return dataSet;
    }

    private int readJSONObject(Reader reader, StringBuffer buf, Map jsonObj, boolean isStart) throws ConvertException, IOException {
        int c = 0;
        if (!isStart) {
            c = this.skipWhitespace(reader);
            if (c == -1) {
                throw new ConvertException("It reached EOF on the way.");
            }
            if (c != 123) {
                throw new ConvertException("JSON object must be enclosed '{' and '}'");
            }
        }
        do {
            if ((c = this.readJSONProperty(reader, buf, jsonObj)) != -1) continue;
            throw new ConvertException("It reached EOF on the way.");
        } while (c == 44);
        return c;
    }

    private int readJSONArray(Reader reader, StringBuffer buf, List array, boolean isStart) throws ConvertException, IOException {
        buf.setLength(0);
        int c = 0;
        if (!isStart) {
            c = this.skipWhitespace(reader);
            if (c == -1) {
                throw new ConvertException("It reached EOF on the way.");
            }
            if (c != 91) {
                throw new ConvertException("JSON array must be enclosed '[' and ']'");
            }
        }
        block5: do {
            c = this.skipWhitespace(reader);
            Object value = null;
            switch (c) {
                case 34: {
                    while ((c = reader.read()) != -1 && c != 34) {
                        if (c == 92) {
                            buf.append((char)c);
                            c = reader.read();
                            if (c == -1) break;
                        }
                        buf.append((char)c);
                    }
                    value = this.unescape(buf.toString());
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                case 123: {
                    value = new LinkedHashMap();
                    c = this.readJSONObject(reader, buf, (Map)value, true);
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                case 91: {
                    value = new ArrayList();
                    c = this.readJSONArray(reader, buf, (List)value, true);
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    c = this.skipWhitespace(reader);
                    break;
                }
                default: {
                    while (c != -1 && c != 44 && c != 93 && c != 125 && !Character.isWhitespace((char)c)) {
                        buf.append((char)c);
                        c = reader.read();
                    }
                    if (c == -1) {
                        throw new ConvertException("It reached EOF on the way.");
                    }
                    String str = this.unescape(buf.toString());
                    if (NULL_VALUE.equals(str)) {
                        value = null;
                        break;
                    }
                    if (str.length() != 0) {
                        value = str;
                        break;
                    }
                    buf.setLength(0);
                    continue block5;
                }
            }
            array.add(value);
            buf.setLength(0);
        } while (c == 44);
        return c;
    }

    private int readJSONProperty(Reader reader, StringBuffer buf, Map jsonObj) throws ConvertException, IOException {
        buf.setLength(0);
        int c = this.skipWhitespace(reader);
        if (c == 34) {
            while ((c = reader.read()) != -1 && c != 34) {
                if (c == 92) {
                    buf.append((char)c);
                    c = reader.read();
                    if (c == -1) break;
                }
                buf.append((char)c);
            }
        } else {
            if (c == 125) {
                return c;
            }
            throw new ConvertException("JSON name must be enclosed '\"'.");
        }
        String name = this.unescape(buf.toString());
        buf.setLength(0);
        c = reader.read();
        if (c != 58) {
            throw new ConvertException("JSON name and value must be separated ':'.");
        }
        c = reader.read();
        Object value = null;
        switch (c) {
            case 34: {
                while ((c = reader.read()) != -1 && c != 34) {
                    if (c == 92) {
                        buf.append((char)c);
                        c = reader.read();
                        if (c == -1) break;
                    }
                    buf.append((char)c);
                }
                value = this.unescape(buf.toString());
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                break;
            }
            case 123: {
                value = new LinkedHashMap();
                c = this.readJSONObject(reader, buf, (Map)value, true);
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                break;
            }
            case 91: {
                value = new ArrayList();
                c = this.readJSONArray(reader, buf, (List)value, true);
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                c = this.skipWhitespace(reader);
                break;
            }
            default: {
                while (c != -1 && c != 44 && c != 93 && c != 125 && !Character.isWhitespace((char)c)) {
                    buf.append((char)c);
                    c = reader.read();
                }
                if (c == -1) {
                    throw new ConvertException("It reached EOF on the way.");
                }
                String str = this.unescape(buf.toString());
                if (NULL_VALUE.equals(str)) {
                    value = null;
                    break;
                }
                if (str.length() != 0) {
                    value = str;
                    break;
                }
                return c;
            }
        }
        jsonObj.put(name, value);
        return c;
    }

    private String removeBOM(String str) {
        if (this.characterEncodingToObject != null) {
            if (UTF8.equals(this.characterEncodingToObject)) {
                if (UTF8_BOM != null && str.startsWith(UTF8_BOM)) {
                    str = str.substring(UTF8_BOM.length());
                }
            } else if (UTF16.equals(this.characterEncodingToObject)) {
                if (UTF16_BOM_LE != null && str.startsWith(UTF16_BOM_LE)) {
                    str = str.substring(UTF16_BOM_LE.length());
                } else if (UTF16_BOM_BE != null && str.startsWith(UTF16_BOM_BE)) {
                    str = str.substring(UTF16_BOM_BE.length());
                }
            } else if (UTF16LE.equals(this.characterEncodingToObject)) {
                if (UTF16_BOM_LE != null && str.startsWith(UTF16_BOM_LE)) {
                    str = str.substring(UTF16_BOM_LE.length());
                }
            } else if (UTF16BE.equals(this.characterEncodingToObject) && UTF16_BOM_BE != null && str.startsWith(UTF16_BOM_BE)) {
                str = str.substring(UTF16_BOM_BE.length());
            }
        }
        return str;
    }

    private String fromUnicode(String unicodeStr) {
        String str = null;
        if (unicodeStr != null) {
            int length = unicodeStr.length();
            StringBuffer buf = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                char c;
                if ((c = unicodeStr.charAt(i++)) == '\\' && length - 1 > i) {
                    if ((c = unicodeStr.charAt(i++)) == 'u') {
                        int value = 0;
                        block6: for (int j = 0; j < 4; ++j) {
                            c = unicodeStr.charAt(i++);
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    value = (value << 4) + (c - 48);
                                    continue block6;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value = (value << 4) + 10 + (c - 97);
                                    continue block6;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    value = (value << 4) + 10 + (c - 65);
                                    continue block6;
                                }
                                default: {
                                    throw new IllegalArgumentException("Failed to convert unicode char is " + c);
                                }
                            }
                        }
                        buf.append((char)value);
                        continue;
                    }
                    buf.append('\\');
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            str = buf.toString();
        }
        return str;
    }

    private String unescape(String str) {
        if (str != null) {
            int length = str.length();
            StringBuffer buf = new StringBuffer(length);
            boolean isUnescape = false;
            int i = 0;
            while (i < length) {
                int c;
                if ((c = str.charAt(i++)) == 92 && length > i) {
                    isUnescape = true;
                    c = str.charAt(i++);
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                    }
                }
                buf.append((char)c);
            }
            if (isUnescape) {
                str = buf.toString();
            }
        }
        return str;
    }

    private int skipWhitespace(Reader reader) throws IOException {
        int c = 0;
        while ((c = reader.read()) != -1 && Character.isWhitespace((char)c)) {
        }
        return c;
    }

    static {
        try {
            UTF8_BOM = new String(new byte[]{-17, -69, -65}, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            UTF16_BOM_LE = new String(new byte[]{-1, -2}, UTF16);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            UTF16_BOM_BE = new String(new byte[]{-2, -1}, UTF16);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

