/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.PaddingConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class PaddingStringConverter
implements StringConverter,
PaddingConverter,
Serializable {
    private static final long serialVersionUID = -3962004369893317399L;
    public static final char DEFAULT_PADDING_LITERAL = ' ';
    public static final int DEFAULT_PADDING_DIRECTION = 1;
    protected int convertType;
    protected char paddingLiteral = (char)32;
    protected int paddingLength = -1;
    protected int paddingDirection = 1;
    protected boolean isCountTwiceByZenkaku;

    public PaddingStringConverter() {
        this(1, ' ', -1, 1);
    }

    public PaddingStringConverter(int length) {
        this(1, ' ', length, 1);
    }

    public PaddingStringConverter(int length, char literal, int direction) {
        this(1, literal, length, direction);
    }

    public PaddingStringConverter(char literal, int direction) {
        this(2, literal, -1, direction);
    }

    public PaddingStringConverter(int type, char literal, int length, int direction) {
        this.setConvertType(type);
        this.setPaddingLiteral(literal);
        this.setPaddingLength(length);
        this.setPaddingDirection(direction);
    }

    public void setConvertType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                this.convertType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid convert type : " + type);
            }
        }
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setPaddingLiteral(char literal) {
        this.paddingLiteral = literal;
    }

    public char getPaddingLiteral() {
        return this.paddingLiteral;
    }

    public void setPaddingLength(int length) {
        this.paddingLength = length;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public void setPaddingDirection(int direct) {
        switch (direct) {
            case 1: 
            case 2: 
            case 3: {
                this.paddingDirection = direct;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid padding direction : " + direct);
            }
        }
    }

    public int getPaddingDirection() {
        return this.paddingDirection;
    }

    public boolean isCountTwiceByZenkaku() {
        return this.isCountTwiceByZenkaku;
    }

    public void setCountTwiceByZenkaku(boolean isTwice) {
        this.isCountTwiceByZenkaku = isTwice;
    }

    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj == null ? (String)null : (String)(obj instanceof String ? obj : String.valueOf(obj)));
    }

    public String convert(String str) throws ConvertException {
        switch (this.convertType) {
            case 2: {
                if (str == null || str.length() == 0 || str.indexOf(this.paddingLiteral) == -1) {
                    return str;
                }
                return this.parse(str);
            }
        }
        return this.padding(str);
    }

    protected int countLength(CharSequence str) {
        if (this.isCountTwiceByZenkaku) {
            int length = 0;
            int imax = str.length();
            for (int i = 0; i < imax; ++i) {
                char c = str.charAt(i);
                if (c <= '\u007f' || '\uff61' <= c && c <= '\uff9f') {
                    ++length;
                    continue;
                }
                length += 2;
            }
            return length;
        }
        return str.length();
    }

    public String padding(String str) throws ConvertException {
        if (this.paddingLength <= 0 || str != null && this.countLength(str) >= this.paddingLength) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        if (str != null) {
            buf.append(str);
        }
        switch (this.paddingDirection) {
            case 3: {
                return this.paddingCenter(buf).toString();
            }
            case 2: {
                return this.paddingRight(buf).toString();
            }
        }
        return this.paddingLeft(buf).toString();
    }

    protected StringBuffer paddingCenter(StringBuffer buf) throws ConvertException {
        int length = this.countLength(buf);
        int cnter = (this.paddingLength - length) / 2;
        int i = this.paddingLength - length;
        while (--i >= 0) {
            if (cnter > i) {
                buf.append(this.paddingLiteral);
                continue;
            }
            buf.insert(0, this.paddingLiteral);
        }
        return buf;
    }

    protected StringBuffer paddingRight(StringBuffer buf) throws ConvertException {
        int length = this.countLength(buf);
        int i = this.paddingLength - length;
        while (--i >= 0) {
            buf.insert(0, this.paddingLiteral);
        }
        return buf;
    }

    protected StringBuffer paddingLeft(StringBuffer buf) throws ConvertException {
        int length = this.countLength(buf);
        int i = this.paddingLength - length;
        while (--i >= 0) {
            buf.append(this.paddingLiteral);
        }
        return buf;
    }

    public String parse(String str) throws ConvertException {
        StringBuffer buf = new StringBuffer(str);
        switch (this.paddingDirection) {
            case 3: {
                return this.parseCenter(buf).toString();
            }
            case 2: {
                return this.parseRight(buf).toString();
            }
        }
        return this.parseLeft(buf).toString();
    }

    protected StringBuffer parseCenter(StringBuffer buf) throws ConvertException {
        int startIndex = -1;
        int length = this.countLength(buf);
        int max = length;
        for (int i = 0; i < max; ++i) {
            if (buf.charAt(i) == this.paddingLiteral) continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            return buf;
        }
        if (startIndex != 0) {
            buf.delete(0, startIndex);
        }
        if ((length = this.countLength(buf)) <= 1) {
            return buf;
        }
        int endIndex = -1;
        int i = length;
        while (--i >= 0) {
            if (buf.charAt(i) == this.paddingLiteral) continue;
            endIndex = i;
            break;
        }
        if (endIndex != length - 1) {
            buf.delete(endIndex + 1, length);
        }
        return buf;
    }

    protected StringBuffer parseRight(StringBuffer buf) throws ConvertException {
        int startIndex = -1;
        int length = this.countLength(buf);
        int max = length;
        for (int i = 0; i < max; ++i) {
            if (buf.charAt(i) == this.paddingLiteral) continue;
            startIndex = i;
            break;
        }
        if (startIndex == -1) {
            return buf;
        }
        if (startIndex != 0) {
            buf.delete(0, startIndex);
        }
        return buf;
    }

    protected StringBuffer parseLeft(StringBuffer buf) throws ConvertException {
        int length;
        int endIndex = -1;
        int i = length = this.countLength(buf);
        while (--i >= 0) {
            if (buf.charAt(i) == this.paddingLiteral) continue;
            endIndex = i;
            break;
        }
        if (endIndex != length - 1) {
            buf.delete(endIndex + 1, length);
        }
        return buf;
    }
}

