/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.Record;

public class BeanTableIndex
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -1133271083255739920L;
    protected String name;
    protected Class elementClass;
    protected boolean isSynchronized;
    protected TreeMap indexValueMap = new TreeMap(new ComparableComparator());
    protected Set notNullValueSet = new HashSet();
    protected Set linkedIndex = new HashSet();
    protected BeanTableIndexKeyFactory indexKeyFactory;

    public BeanTableIndex() {
    }

    public BeanTableIndex(boolean isSynchronized, Class elementClass, String[] propNames) throws NoSuchPropertyException {
        this(null, isSynchronized, elementClass, propNames);
    }

    public BeanTableIndex(String name, boolean isSynchronized, Class elementClass, String[] propNames) throws NoSuchPropertyException {
        if (propNames == null || propNames.length == 0) {
            new IllegalArgumentException("propNames is empty.");
        }
        this.name = name;
        this.isSynchronized = isSynchronized;
        this.elementClass = elementClass;
        this.indexKeyFactory = new DefaultBeanTableIndexKeyFactory(propNames);
    }

    public BeanTableIndex(String name, boolean isSynchronized, Class elementClass, BeanTableIndexKeyFactory keyFactory) {
        this.name = name;
        this.isSynchronized = isSynchronized;
        this.elementClass = elementClass;
        this.indexKeyFactory = keyFactory;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Set getIndexedPropertyNames() {
        return this.indexKeyFactory.getPropertyNames();
    }

    public void addLinkedIndex(String indexName) {
        this.linkedIndex.add(indexName);
    }

    public void removeLinkedIndex(String indexName) {
        this.linkedIndex.remove(indexName);
    }

    public Set getLinkedIndexSet() {
        return this.linkedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object element) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                this.addInternal(element);
            }
        } else {
            this.addInternal(element);
        }
    }

    protected void addInternal(Object element) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(element);
        HashSet<Object> elements = (HashSet<Object>)this.indexValueMap.get(indexKey);
        if (elements == null) {
            elements = new HashSet<Object>();
            this.indexValueMap.put(indexKey, elements);
        }
        elements.add(element);
        if (indexKey != null) {
            this.notNullValueSet.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object element) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                this.removeInternal(element);
            }
        } else {
            this.removeInternal(element);
        }
    }

    protected void removeInternal(Object element) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(element);
        Set elements = (Set)this.indexValueMap.get(indexKey);
        if (elements != null) {
            elements.remove(element);
            if (elements.size() == 0) {
                this.indexValueMap.remove(indexKey);
            }
        }
        this.notNullValueSet.remove(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object oldElement, Object newElement) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                this.removeInternal(oldElement);
                this.addInternal(newElement);
            }
        } else {
            this.removeInternal(oldElement);
            this.addInternal(newElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                this.clearInternal();
            }
        } else {
            this.clearInternal();
        }
    }

    protected void clearInternal() {
        this.indexValueMap.clear();
        this.notNullValueSet.clear();
    }

    public Set searchKeyElement() {
        return this.searchKeyElement(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchKeyElement(Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchKeyElementInternal(result);
            }
        }
        return this.searchKeyElementInternal(result);
    }

    protected Set searchKeyElementInternal(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        for (Set elements : this.indexValueMap.values()) {
            result.add(elements.iterator().next());
        }
        return result;
    }

    public Set searchNull() {
        return this.searchNull(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchNull(Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchNullInternal(result);
            }
        }
        return this.searchNullInternal(result);
    }

    protected Set searchNullInternal(Set result) {
        Set elements = (Set)this.indexValueMap.get(null);
        if (result == null) {
            if (!this.isSynchronized) {
                return elements;
            }
            result = new HashSet();
        }
        if (elements != null) {
            result.addAll(elements);
        }
        return result;
    }

    public Set searchNotNull() {
        return this.searchNotNull(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchNotNull(Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchNotNullInternal(result);
            }
        }
        return this.searchNotNullInternal(result);
    }

    protected Set searchNotNullInternal(Set result) {
        if (result == null) {
            if (!this.isSynchronized) {
                return this.notNullValueSet;
            }
            result = new HashSet();
        }
        result.addAll(this.notNullValueSet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object searchByPrimaryElement(Object element) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchByPrimaryElementInternal(element);
            }
        }
        return this.searchByPrimaryElementInternal(element);
    }

    protected Object searchByPrimaryElementInternal(Object element) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(element);
        Set elements = (Set)this.indexValueMap.get(indexKey);
        if (elements == null) {
            return null;
        }
        return elements.iterator().next();
    }

    public Set searchByElement(Object element) throws IndexPropertyAccessException {
        return this.searchByElement(element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchByElement(Object element, Set result) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchByElementInternal(element, result);
            }
        }
        return this.searchByElementInternal(element, result);
    }

    protected Set searchByElementInternal(Object element, Set result) throws IndexPropertyAccessException {
        Object indexKey = this.indexKeyFactory.createIndexKey(element);
        Set elements = (Set)this.indexValueMap.get(indexKey);
        if (result == null) {
            if (!this.isSynchronized) {
                return elements;
            }
            result = new HashSet();
        }
        if (elements == null) {
            return result;
        }
        result.addAll(elements);
        return result;
    }

    public Set searchInElement(Object[] elements) throws IndexPropertyAccessException {
        return this.searchInElement(null, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchInElement(Set result, Object[] elements) throws IndexPropertyAccessException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchInElementInternal(result, elements);
            }
        }
        return this.searchInElementInternal(result, elements);
    }

    protected Set searchInElementInternal(Set result, Object[] elements) throws IndexPropertyAccessException {
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            Object indexKey = this.indexKeyFactory.createIndexKey(element);
            Set ret = (Set)this.indexValueMap.get(indexKey);
            if (ret == null) continue;
            result.addAll(ret);
        }
        return result;
    }

    public Set searchBy(Object value) {
        return this.searchBy(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchBy(Object value, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchByInternal(value, result);
            }
        }
        return this.searchByInternal(value, result);
    }

    protected Set searchByInternal(Object value, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Set elements = (Set)this.indexValueMap.get(value);
        if (elements == null) {
            return result;
        }
        if (result == null) {
            if (!this.isSynchronized) {
                return elements;
            }
            result = new HashSet();
        }
        result.addAll(elements);
        return result;
    }

    public Set searchIn(Object[] values) {
        return this.searchIn(null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchIn(Set result, Object[] values) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchInInternal(result, values);
            }
        }
        return this.searchInInternal(result, values);
    }

    protected Set searchInInternal(Set result, Object[] values) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < values.length; ++i) {
            Set elements = (Set)this.indexValueMap.get(values[i]);
            if (elements == null) continue;
            result.addAll(elements);
        }
        return result;
    }

    public Set searchBy(Map keys) throws IllegalArgumentException {
        return this.searchBy(keys, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchBy(Map keys, Set result) throws IllegalArgumentException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchByInternal(keys, result);
            }
        }
        return this.searchByInternal(keys, result);
    }

    protected Set searchByInternal(Map keys, Set result) throws IllegalArgumentException {
        Object indexKey = this.indexKeyFactory.createIndexKeyByProperties(keys);
        Set elements = (Set)this.indexValueMap.get(indexKey);
        if (elements == null) {
            return result;
        }
        if (result == null) {
            if (!this.isSynchronized) {
                return elements;
            }
            result = new HashSet();
        }
        result.addAll(elements);
        return result;
    }

    public Set searchIn(Map[] keys) throws IllegalArgumentException {
        return this.searchIn((Set)null, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchIn(Set result, Map[] keys) throws IllegalArgumentException {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchInInternal(result, keys);
            }
        }
        return this.searchInInternal(result, keys);
    }

    protected Set searchInInternal(Set result, Map[] keys) throws IllegalArgumentException {
        if (result == null) {
            result = new HashSet();
        }
        for (int i = 0; i < keys.length; ++i) {
            Object indexKey = this.indexKeyFactory.createIndexKeyByProperties(keys[i]);
            Set elements = (Set)this.indexValueMap.get(indexKey);
            if (elements == null) continue;
            result.addAll(elements);
        }
        return result;
    }

    public Set searchFromElement(Object from) throws IndexPropertyAccessException {
        return this.searchFromElement(from, null);
    }

    public Set searchFromElement(Object from, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(from);
        return this.searchFrom(fromProp, result);
    }

    public Set searchFrom(Object from) {
        return this.searchFrom(from, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchFrom(Object from, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchFromInternal(from, result);
            }
        }
        return this.searchFromInternal(from, result);
    }

    protected Set searchFromInternal(Object from, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set values : this.indexValueMap.tailMap(from).values()) {
            result.addAll(values);
        }
        return result;
    }

    public Set searchToElement(Object to) throws IndexPropertyAccessException {
        return this.searchToElement(to, null);
    }

    public Set searchToElement(Object to, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object toProp = this.indexKeyFactory.createIndexKey(to);
        return this.searchTo(toProp, result);
    }

    public Set searchTo(Object to) {
        return this.searchTo(to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchTo(Object to, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchToInternal(to, result);
            }
        }
        return this.searchToInternal(to, result);
    }

    protected Set searchToInternal(Object to, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set values : this.indexValueMap.headMap(to).values()) {
            result.addAll(values);
        }
        return result;
    }

    public Set searchRangeElement(Object from, Object to) throws IndexPropertyAccessException {
        return this.searchRangeElement(from, to, null);
    }

    public Set searchRangeElement(Object from, Object to, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(from);
        Object toProp = this.indexKeyFactory.createIndexKey(to);
        return this.searchRange(fromProp, toProp, result);
    }

    public Set searchRange(Object from, Object to) {
        return this.searchRange(from, to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchRange(Object from, Object to, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchRangeInternal(from, to, result);
            }
        }
        return this.searchRangeInternal(from, to, result);
    }

    protected Set searchRangeInternal(Object from, Object to, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        if (from == null) {
            return this.searchTo(to, result);
        }
        if (to == null) {
            return this.searchFrom(from, result);
        }
        for (Set values : this.indexValueMap.subMap(from, to).values()) {
            result.addAll(values);
        }
        return result;
    }

    public Set searchFromElement(Object from, boolean inclusive) throws IndexPropertyAccessException {
        return this.searchFromElement(from, inclusive, null);
    }

    public Set searchFromElement(Object from, boolean inclusive, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(from);
        return this.searchFrom(fromProp, inclusive, result);
    }

    public Set searchFrom(Object from, boolean inclusive) {
        return this.searchFrom(from, inclusive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchFrom(Object from, boolean inclusive, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchFromInternal(from, inclusive, result);
            }
        }
        return this.searchFromInternal(from, inclusive, result);
    }

    protected Set searchFromInternal(Object from, boolean inclusive, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set values : this.indexValueMap.tailMap(from, inclusive).values()) {
            result.addAll(values);
        }
        return result;
    }

    public Set searchToElement(Object to, boolean inclusive) throws IndexPropertyAccessException {
        return this.searchToElement(to, inclusive, null);
    }

    public Set searchToElement(Object to, boolean inclusive, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object toProp = this.indexKeyFactory.createIndexKey(to);
        return this.searchTo(toProp, inclusive, result);
    }

    public Set searchTo(Object to, boolean inclusive) {
        return this.searchTo(to, inclusive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchTo(Object to, boolean inclusive, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchToInternal(to, inclusive, result);
            }
        }
        return this.searchToInternal(to, inclusive, result);
    }

    protected Set searchToInternal(Object to, boolean inclusive, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        for (Set values : this.indexValueMap.headMap(to, inclusive).values()) {
            result.addAll(values);
        }
        return result;
    }

    public Set searchRangeElement(Object from, boolean fromInclusive, Object to, boolean toInclusive) throws IndexPropertyAccessException {
        return this.searchRangeElement(from, fromInclusive, to, toInclusive, null);
    }

    public Set searchRangeElement(Object from, boolean fromInclusive, Object to, boolean toInclusive, Set result) throws IndexPropertyAccessException {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        Object fromProp = this.indexKeyFactory.createIndexKey(from);
        Object toProp = this.indexKeyFactory.createIndexKey(to);
        return this.searchRange(fromProp, fromInclusive, toProp, toInclusive, result);
    }

    public Set searchRange(Object from, boolean fromInclusive, Object to, boolean toInclusive) {
        return this.searchRange(from, fromInclusive, to, toInclusive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchRange(Object from, boolean fromInclusive, Object to, boolean toInclusive, Set result) {
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                return this.searchRangeInternal(from, fromInclusive, to, toInclusive, result);
            }
        }
        return this.searchRangeInternal(from, fromInclusive, to, toInclusive, result);
    }

    protected Set searchRangeInternal(Object from, boolean fromInclusive, Object to, boolean toInclusive, Set result) {
        int indexKeySize = this.indexKeyFactory.getPropertyNames().size();
        if (indexKeySize != 1) {
            throw new UnsupportedOperationException("This method is not supported, beacause this index is complex key index.");
        }
        if (result == null) {
            result = new HashSet();
        }
        if (from == null) {
            return this.searchTo(to, toInclusive, result);
        }
        if (to == null) {
            return this.searchFrom(from, fromInclusive, result);
        }
        for (Set values : this.indexValueMap.subMap(from, fromInclusive, to, toInclusive).values()) {
            result.addAll(values);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out, boolean writeValue) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.elementClass);
        out.writeBoolean(this.isSynchronized);
        out.writeObject(this.indexKeyFactory);
        if (this.isSynchronized) {
            BeanTableIndex beanTableIndex = this;
            synchronized (beanTableIndex) {
                out.writeObject(this.linkedIndex);
                if (writeValue) {
                    out.writeObject(this.indexValueMap);
                    out.writeObject(this.notNullValueSet);
                }
            }
        } else {
            out.writeObject(this.linkedIndex);
            if (writeValue) {
                out.writeObject(this.indexValueMap);
                out.writeObject(this.notNullValueSet);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, true);
    }

    public void readExternal(ObjectInput in, boolean readValue) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.elementClass = (Class)in.readObject();
        this.isSynchronized = in.readBoolean();
        this.indexKeyFactory = (BeanTableIndexKeyFactory)in.readObject();
        this.linkedIndex = (Set)in.readObject();
        if (readValue) {
            this.indexValueMap = (TreeMap)in.readObject();
            this.notNullValueSet = (Set)in.readObject();
        }
    }

    public BeanTableIndex cloneEmpty(boolean isSynchronized) {
        BeanTableIndex clone = null;
        try {
            clone = (BeanTableIndex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.isSynchronized = isSynchronized;
        clone.indexValueMap = new TreeMap(new ComparableComparator());
        clone.notNullValueSet = new HashSet();
        clone.linkedIndex = new HashSet();
        return clone;
    }

    public static class ComplexKey
    implements Comparable,
    Externalizable {
        private Comparable[] keys;
        private int hashCode;

        public ComplexKey() {
        }

        public ComplexKey(int size) {
            this.keys = new Comparable[size];
        }

        public void set(int index, Object key) {
            this.keys[index] = (Comparable)key;
            this.hashCode += key == null ? 0 : key.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof ComplexKey)) {
                return false;
            }
            ComplexKey cmp = (ComplexKey)obj;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!(this.keys[i] == null ? cmp.keys[i] != null : !this.keys[i].equals(cmp.keys[i]))) continue;
                return false;
            }
            return true;
        }

        public int compareTo(Object obj) {
            ComplexKey cmp = (ComplexKey)obj;
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) {
                    if (cmp.keys[i] == null) continue;
                    return -1;
                }
                if (cmp.keys[i] == null) {
                    return 1;
                }
                int ret = this.keys[i].compareTo(cmp.keys[i]);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.keys);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Object[] tmpKeys = (Object[])in.readObject();
            if (tmpKeys != null) {
                this.keys = new Comparable[tmpKeys.length];
                for (int i = 0; i < tmpKeys.length; ++i) {
                    this.set(i, tmpKeys[i]);
                }
            }
        }
    }

    protected static class ComparableComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1186653106412122081L;

        protected ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c1 != null && c2 != null) {
                return c1.compareTo(c2);
            }
            if (c1 == null && c2 != null) {
                return -1;
            }
            if (c1 != null && c2 == null) {
                return 1;
            }
            return 0;
        }
    }

    protected class DefaultBeanTableIndexKeyFactory
    implements BeanTableIndexKeyFactory,
    Externalizable {
        protected List indexedProperties = new ArrayList();
        protected Set indexedPropertyNames = new HashSet();

        public DefaultBeanTableIndexKeyFactory(String[] propNames) throws NoSuchPropertyException {
            for (int i = 0; i < propNames.length; ++i) {
                String propName = propNames[i];
                SimpleProperty prop = new SimpleProperty(propName);
                if (!Record.class.isAssignableFrom(BeanTableIndex.this.elementClass) && !prop.isReadable(BeanTableIndex.this.elementClass)) {
                    throw new NoSuchPropertyException(BeanTableIndex.this.elementClass, propName);
                }
                if (this.indexedPropertyNames.contains(prop.getPropertyName())) continue;
                this.indexedPropertyNames.add(prop.getPropertyName());
                this.indexedProperties.add(prop);
            }
            ((ArrayList)this.indexedProperties).trimToSize();
        }

        @Override
        public Set getPropertyNames() {
            return this.indexedPropertyNames;
        }

        @Override
        public Object createIndexKey(Object element) throws IndexPropertyAccessException {
            int indexKeySize = this.indexedProperties.size();
            if (indexKeySize == 1) {
                try {
                    return ((Property)this.indexedProperties.get(0)).getProperty(element);
                }
                catch (NoSuchPropertyException e) {
                    throw new IndexPropertyAccessException(BeanTableIndex.this.elementClass, ((Property)this.indexedProperties.get(0)).getPropertyName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IndexPropertyAccessException(BeanTableIndex.this.elementClass, ((Property)this.indexedProperties.get(0)).getPropertyName(), e.getTargetException());
                }
            }
            ComplexKey indexKey = new ComplexKey(indexKeySize);
            for (int i = 0; i < indexKeySize; ++i) {
                SimpleProperty prop = (SimpleProperty)this.indexedProperties.get(i);
                try {
                    indexKey.set(i, prop.getProperty(element));
                    continue;
                }
                catch (NoSuchPropertyException e) {
                    throw new IndexPropertyAccessException(BeanTableIndex.this.elementClass, ((Property)this.indexedProperties.get(0)).getPropertyName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IndexPropertyAccessException(BeanTableIndex.this.elementClass, ((Property)this.indexedProperties.get(0)).getPropertyName(), e.getTargetException());
                }
            }
            return indexKey;
        }

        @Override
        public Object createIndexKeyByProperties(Map keys) throws IllegalArgumentException {
            if (!keys.keySet().containsAll(this.indexedPropertyNames)) {
                throw new IllegalArgumentException("keys are insufficient. keys=" + keys + ", indexedProperties=" + this.indexedPropertyNames);
            }
            int indexKeySize = this.indexedPropertyNames.size();
            if (indexKeySize == 1) {
                return keys.get(this.indexedPropertyNames.iterator().next());
            }
            ComplexKey indexKey = new ComplexKey(indexKeySize);
            for (int i = 0; i < indexKeySize; ++i) {
                indexKey.set(i, keys.get(((Property)this.indexedProperties.get(i)).getPropertyName()));
            }
            return indexKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.indexedProperties.size());
            for (int i = 0; i < this.indexedProperties.size(); ++i) {
                SimpleProperty prop = (SimpleProperty)this.indexedProperties.get(i);
                out.writeObject(prop.getPropertyName());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.indexedProperties = new ArrayList();
            this.indexedPropertyNames = new HashSet();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String propName = (String)in.readObject();
                this.indexedProperties.add(new SimpleProperty(propName));
                this.indexedPropertyNames.add(propName);
            }
            ((ArrayList)this.indexedProperties).trimToSize();
        }
    }
}

