/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchIndexPropertyException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class IndexedProperty
extends SimpleProperty
implements Serializable {
    private static final long serialVersionUID = -3949215311238233792L;
    private static final String RECORD_PROP_NAME = "Property";
    protected static final String GET_METHOD_NAME = "get";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{Integer.TYPE};
    protected static final String SET_METHOD_NAME = "set";
    protected int index;
    protected transient Map indexedReadMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map indexedWriteMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map indexedObjReadMethodCache = Collections.synchronizedMap(new HashMap());
    protected transient Map indexedObjWriteMethodCache = Collections.synchronizedMap(new HashMap());

    public IndexedProperty() {
    }

    public IndexedProperty(String name) throws IllegalArgumentException {
        super(name);
    }

    public IndexedProperty(String name, int index) throws IllegalArgumentException {
        super(name);
        this.index = index;
    }

    @Override
    public String getPropertyName() {
        return (super.getPropertyName() == null ? "" : super.getPropertyName()) + '[' + this.getIndex() + ']';
    }

    @Override
    protected void setPropertyName(String prop) {
        this.property = prop;
    }

    @Override
    public void parse(String prop) throws IllegalArgumentException {
        int startIndexedDelim = prop.indexOf(91);
        int endIndexedDelim = prop.indexOf(93);
        if (startIndexedDelim == -1 || endIndexedDelim == -1 || endIndexedDelim - startIndexedDelim <= 1 || endIndexedDelim != prop.length() - 1) {
            throw new IllegalArgumentException("Illegal IndexedProperty : " + prop);
        }
        String indexStr = prop.substring(startIndexedDelim + 1, endIndexedDelim);
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal IndexedProperty : " + prop);
        }
        this.setPropertyName(prop.substring(0, startIndexedDelim));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        return this.getIndexedPropertyType(obj);
    }

    @Override
    public Class getPropertyType(Class clazz) throws NoSuchPropertyException {
        return this.getIndexedPropertyType(clazz);
    }

    protected Class getIndexedPropertyType(Object obj) throws NoSuchPropertyException {
        if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName())) {
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema == null) {
                throw new NoSuchPropertyException(obj.getClass(), this.getPropertyName());
            }
            PropertySchema propSchema = recSchema.getPropertySchema(this.getIndex());
            if (propSchema == null) {
                throw new NoSuchPropertyException(obj.getClass(), this.getPropertyName());
            }
            Class type = propSchema.getType();
            if (type != null) {
                return type;
            }
        }
        return this.getIndexedPropertyType(obj.getClass());
    }

    protected Class getIndexedPropertyType(Class clazz) throws NoSuchPropertyException {
        Method readMethod = null;
        if (this.property == null || this.property.length() == 0) {
            return this.getIndexedObjectPropertyType(clazz);
        }
        readMethod = this.getReadIndexedMethod(clazz);
        if (readMethod == null) {
            Method setMethod = this.getWriteIndexedMethod(clazz, null);
            if (setMethod != null) {
                Map overloadMap;
                Object methodObj;
                if (this.indexedWriteMethodCache.containsKey(clazz) && !((methodObj = this.indexedWriteMethodCache.get(clazz)) instanceof Method) && ((overloadMap = (Map)methodObj).size() > 2 || overloadMap.size() == 2 && !overloadMap.containsKey(null))) {
                    return null;
                }
                return setMethod.getParameterTypes()[1];
            }
            Class retClass = null;
            try {
                retClass = super.getPropertyType(clazz);
            }
            catch (NoSuchPropertyException e) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            return this.getIndexedObjectPropertyType(retClass);
        }
        return readMethod.getReturnType();
    }

    @Override
    public boolean isReadable(Object obj) {
        if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName())) {
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema == null) {
                return false;
            }
            PropertySchema propSchema = recSchema.getPropertySchema(this.getIndex());
            return propSchema != null;
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.isReadableNoIndexedProperty(obj, readMethod);
        }
        if (this.indexedReadMethodCache.get(clazz) != null) {
            return true;
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isReadableIndexedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadIndexedMethod(clazz);
        if (readMethod != null) {
            return true;
        }
        Object prop = null;
        try {
            prop = super.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (prop == null) {
            return false;
        }
        return this.isReadableIndexedObjectProperty(prop.getClass(), prop);
    }

    @Override
    public boolean isReadable(Class clazz) {
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.isReadableNoIndexedProperty(readMethod);
        }
        if (this.indexedReadMethodCache.get(clazz) != null) {
            return true;
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isReadableIndexedObjectProperty(clazz);
        }
        readMethod = this.getReadIndexedMethod(clazz);
        if (readMethod != null) {
            return true;
        }
        try {
            readMethod = super.getReadMethod(clazz, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return this.isReadableIndexedObjectProperty(readMethod.getReturnType());
        }
        Field field = null;
        try {
            field = super.getField(clazz, false);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (field == null) {
            return false;
        }
        return this.isReadableIndexedObjectProperty(field.getType());
    }

    @Override
    public boolean isWritable(Object obj, Class clazz) {
        if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName())) {
            Record record = (Record)obj;
            RecordSchema recSchema = record.getRecordSchema();
            if (recSchema == null) {
                return false;
            }
            PropertySchema propSchema = recSchema.getPropertySchema(this.getIndex());
            if (propSchema == null) {
                return false;
            }
            if (clazz == null) {
                return true;
            }
            return propSchema.getType() == null ? true : this.isAssignableFrom(propSchema.getType(), clazz);
        }
        Class<?> objClazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(objClazz) && this.getMethodCache.get(objClazz) != null) {
            readMethod = (Method)this.getMethodCache.get(objClazz);
            return this.isWritableNoIndexedProperty(obj, readMethod, clazz);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isWritableIndexedObjectProperty(obj, clazz);
        }
        writeMethod = this.getWriteIndexedMethod(objClazz, clazz);
        if (writeMethod != null) {
            return true;
        }
        Object prop = null;
        try {
            prop = super.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (prop == null) {
            return false;
        }
        return this.isWritableIndexedObjectProperty(prop, clazz);
    }

    @Override
    public boolean isWritable(Class targetClass, Class clazz) {
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(targetClass) && this.getMethodCache.get(targetClass) != null) {
            readMethod = (Method)this.getMethodCache.get(targetClass);
            return this.isWritableIndexedObjectProperty(readMethod.getReturnType(), clazz);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.isWritableIndexedObjectProperty(targetClass, clazz);
        }
        writeMethod = this.getWriteIndexedMethod(targetClass, clazz);
        if (writeMethod != null) {
            return true;
        }
        try {
            readMethod = super.getReadMethod(targetClass, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (readMethod != null) {
            return this.isWritableIndexedObjectProperty(readMethod.getReturnType(), clazz);
        }
        Field field = null;
        try {
            field = super.getField(targetClass, false);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        if (field == null) {
            return false;
        }
        return this.isWritableIndexedObjectProperty(field.getType(), clazz);
    }

    @Override
    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (obj == null && this.isIgnoreNullProperty) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.getNoIndexedProperty(obj, readMethod);
        }
        if (this.indexedReadMethodCache.get(clazz) != null) {
            readMethod = (Method)this.indexedReadMethodCache.get(clazz);
            return this.getIndexedProperty(obj, readMethod);
        }
        if (this.property == null || this.property.length() == 0) {
            return this.getIndexedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadIndexedMethod(clazz);
        if (readMethod != null) {
            return this.getIndexedProperty(obj, readMethod);
        }
        Object prop = super.getProperty(obj);
        if (prop == null) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName());
        }
        return this.getIndexedObjectProperty(prop.getClass(), prop);
    }

    protected Method getReadIndexedMethod(Class clazz) {
        if (this.indexedReadMethodCache.containsKey(clazz)) {
            return (Method)this.indexedReadMethodCache.get(clazz);
        }
        if (!IndexedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getReadIndexedMethod(interfaces[i]);
                if (method == null) continue;
                this.indexedReadMethodCache.put(clazz, method);
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getReadIndexedMethod(superClass);
            }
            this.indexedReadMethodCache.put(clazz, null);
            return null;
        }
        StringBuffer methodName = new StringBuffer(GET_METHOD_NAME);
        if (this.property != null && this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        try {
            Method method = clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
            this.indexedReadMethodCache.put(clazz, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            if (this.property == null || this.property.length() == 0) {
                this.indexedReadMethodCache.put(clazz, null);
                return null;
            }
            try {
                Method method = clazz.getMethod(this.property, GET_METHOD_ARGS);
                this.indexedReadMethodCache.put(clazz, method);
                return method;
            }
            catch (NoSuchMethodException e2) {
                this.indexedReadMethodCache.put(clazz, null);
                return null;
            }
        }
    }

    @Override
    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    @Override
    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoIndexedProperty(obj, readMethod, value);
        } else if (this.property == null || this.property.length() == 0) {
            this.setIndexedObjectProperty(clazz, obj, value);
        } else {
            if (type == null) {
                if (value == null) {
                    PropertySchema propSchema;
                    Record record;
                    RecordSchema recSchema;
                    if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName()) && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getIndex())) != null) {
                        type = propSchema.getType();
                    }
                } else {
                    type = value.getClass();
                }
            }
            if ((writeMethod = this.getWriteIndexedMethod(clazz, type)) != null) {
                this.setIndexedProperty(obj, writeMethod, value);
                return;
            }
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            this.setIndexedObjectProperty(prop.getClass(), prop, value);
        }
    }

    protected Method getWriteIndexedMethod(Class clazz, Class param) {
        if (this.indexedWriteMethodCache.containsKey(clazz)) {
            Object methodObj = this.indexedWriteMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            Map overloadMap = (Map)methodObj;
            if (param == null) {
                if (overloadMap.size() == 1) {
                    return (Method)overloadMap.values().iterator().next();
                }
                Method setMethod = (Method)overloadMap.get(null);
                if (setMethod != null) {
                    return setMethod;
                }
                Object[] classes = overloadMap.keySet().toArray();
                for (int i = 0; i < classes.length; ++i) {
                    Method method = (Method)overloadMap.get(classes[i]);
                    Class<?>[] params = method.getParameterTypes();
                    if (setMethod == null) {
                        if (params[1].isPrimitive()) continue;
                        setMethod = method;
                        continue;
                    }
                    if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                    setMethod = method;
                }
                Map<Object, Method> tmpOverloadMap = Collections.synchronizedMap(new HashMap(overloadMap));
                tmpOverloadMap.put(null, setMethod);
                this.indexedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
            if (overloadMap.containsKey(param)) {
                return (Method)overloadMap.get(param);
            }
            Method setMethod = (Method)overloadMap.get(null);
            if (setMethod != null) {
                return setMethod;
            }
            Object[] classes = overloadMap.keySet().toArray();
            Class primitiveClazz = this.toPrimitive(param);
            for (int i = 0; i < classes.length; ++i) {
                Method method = (Method)overloadMap.get(classes[i]);
                Class<?>[] params = method.getParameterTypes();
                if (setMethod == null) {
                    if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                    setMethod = method;
                    if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                    break;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                    setMethod = method;
                    break;
                }
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            Map<Class, Method> tmpOverloadMap = Collections.synchronizedMap(new HashMap(overloadMap));
            tmpOverloadMap.put(param, setMethod);
            this.indexedWriteMethodCache.put(clazz, tmpOverloadMap);
            return setMethod;
        }
        if (!IndexedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getWriteIndexedMethod(interfaces[i], param);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteIndexedMethod(superClass, param);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(SET_METHOD_NAME);
        if (this.property != null && this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        Class primitiveClazz = this.toPrimitive(param);
        Map<Class<?>, Method> overloadMap = Collections.synchronizedMap(new HashMap());
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!methodName.toString().equals(method.getName()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.TYPE)) continue;
            overloadMap.put(params[1], method);
            if (isMatch) continue;
            if (setMethod == null) {
                if (param == null) {
                    setMethod = method;
                    continue;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                setMethod = method;
                if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (param == null) {
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
            if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                isMatch = true;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        if (param == null) {
            overloadMap.put(null, setMethod);
        }
        if (setMethod != null) {
            if (overloadMap.size() > 1) {
                this.indexedWriteMethodCache.put(clazz, overloadMap);
            } else {
                this.indexedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }

    protected Object getIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, new Integer(this.getIndex()));
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected void setIndexedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            Class<?> paramType = writeMethod.getParameterTypes()[1];
            if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                value = this.castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(obj, new Integer(this.getIndex()), value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected Object getIndexedObject(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        return this.getIndexedObject(obj, readMethod, true);
    }

    protected Object getIndexedObject(Object obj, Method readMethod, boolean isThrow) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            if (readMethod.getParameterTypes().length == 0) {
                return readMethod.invoke(obj, NULL_ARGS);
            }
            return readMethod.invoke(obj, super.getPropertyName());
        }
        catch (IllegalAccessException e) {
            if (isThrow) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (isThrow) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
            return null;
        }
    }

    protected Object getNoIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = this.getIndexedObject(obj, readMethod);
        if (indexedObj == null) {
            if (this.isIgnoreNullProperty) {
                return null;
            }
            throw new NullIndexPropertyException(clazz, this.getPropertyName());
        }
        return this.getIndexedObjectProperty(indexedObj.getClass(), indexedObj);
    }

    protected void setNoIndexedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = this.getIndexedObject(obj, readMethod);
        if (indexedObj == null) {
            throw new NullIndexPropertyException(clazz, this.getPropertyName());
        }
        this.setIndexedObjectProperty(indexedObj.getClass(), indexedObj, value);
    }

    protected boolean isReadableNoIndexedProperty(Object obj, Method readMethod) {
        Object indexedObj = null;
        try {
            indexedObj = this.getIndexedObject(obj, readMethod, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (indexedObj == null) {
            return false;
        }
        return this.isReadableIndexedObjectProperty(indexedObj.getClass(), indexedObj);
    }

    protected boolean isReadableNoIndexedProperty(Method readMethod) {
        Class<?> indexedClass = readMethod.getReturnType();
        if (indexedClass == null) {
            return false;
        }
        return this.isReadableIndexedObjectProperty(indexedClass);
    }

    protected boolean isReadableIndexedObjectProperty(Class clazz, Object obj) {
        if (clazz.isArray()) {
            return Array.getLength(obj) > this.getIndex();
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.size() > this.getIndex();
        }
        Method getMethod = null;
        if (this.indexedObjReadMethodCache.containsKey(clazz) && (getMethod = (Method)this.indexedObjReadMethodCache.get(clazz)) == null) {
            return false;
        }
        if (getMethod == null) {
            if (!IndexedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                    return this.isReadableIndexedObjectProperty(interfaces[i], obj);
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.isReadableIndexedObjectProperty(superClass, obj);
                }
                return false;
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.indexedObjReadMethodCache.put(clazz, getMethod);
                return true;
            }
            this.indexedObjReadMethodCache.put(clazz, null);
            return false;
        }
        return true;
    }

    protected boolean isReadableIndexedObjectProperty(Class clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return true;
        }
        Method getMethod = null;
        if (this.indexedObjReadMethodCache.containsKey(clazz) && (getMethod = (Method)this.indexedObjReadMethodCache.get(clazz)) == null) {
            return false;
        }
        if (getMethod == null) {
            if (!IndexedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                    return this.isReadableIndexedObjectProperty(interfaces[i]);
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.isReadableIndexedObjectProperty(superClass);
                }
                return false;
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.indexedObjReadMethodCache.put(clazz, getMethod);
                return true;
            }
            this.indexedObjReadMethodCache.put(clazz, null);
            return false;
        }
        return true;
    }

    protected boolean isWritableNoIndexedProperty(Object obj, Method readMethod, Class clazz) {
        Object indexedObj = null;
        try {
            indexedObj = this.getIndexedObject(obj, readMethod, false);
        }
        catch (NoSuchPropertyException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (indexedObj == null) {
            return false;
        }
        return this.isWritableIndexedObjectProperty(indexedObj, clazz);
    }

    protected boolean isWritableIndexedObjectProperty(Object obj, Class clazz) {
        Class<?> indexdClazz = obj.getClass();
        if (indexdClazz.isArray()) {
            if (clazz != null && !this.isAssignableFrom(indexdClazz.getComponentType(), clazz)) {
                return false;
            }
            return Array.getLength(obj) > this.getIndex();
        }
        if (obj instanceof List) {
            return true;
        }
        Method setMethod = null;
        if (this.indexedObjWriteMethodCache.containsKey(indexdClazz)) {
            setMethod = (Method)this.indexedObjWriteMethodCache.get(indexdClazz);
            if (setMethod == null) {
                return false;
            }
        } else {
            Method[] methods = indexdClazz.getMethods();
            if (methods == null || methods.length == 0) {
                this.indexedObjWriteMethodCache.put(indexdClazz, null);
                return false;
            }
            Class valueClass = clazz == null ? null : clazz;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.class) && !params[0].equals(Integer.TYPE) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                this.indexedObjWriteMethodCache.put(indexdClazz, null);
                return false;
            }
            this.indexedObjWriteMethodCache.put(indexdClazz, setMethod);
        }
        return true;
    }

    protected boolean isWritableIndexedObjectProperty(Class indexdClazz, Class clazz) {
        if (indexdClazz.isArray()) {
            return clazz == null || this.isAssignableFrom(indexdClazz.getComponentType(), clazz);
        }
        if (List.class.isAssignableFrom(indexdClazz)) {
            return true;
        }
        Method setMethod = null;
        if (this.indexedObjWriteMethodCache.containsKey(indexdClazz)) {
            setMethod = (Method)this.indexedObjWriteMethodCache.get(indexdClazz);
            if (setMethod == null) {
                return false;
            }
        } else {
            Method[] methods = indexdClazz.getMethods();
            if (methods == null || methods.length == 0) {
                this.indexedObjWriteMethodCache.put(indexdClazz, null);
                return false;
            }
            Class valueClass = clazz == null ? null : clazz;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.class) && !params[0].equals(Integer.TYPE) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                this.indexedObjWriteMethodCache.put(indexdClazz, null);
                return false;
            }
            this.indexedObjWriteMethodCache.put(indexdClazz, setMethod);
        }
        return true;
    }

    protected Object getIndexedObjectProperty(Class clazz, Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (clazz.isArray()) {
            if (Array.getLength(obj) <= this.getIndex()) {
                if (this.isIgnoreNullProperty) {
                    return null;
                }
                throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex());
            }
            return Array.get(obj, this.getIndex());
        }
        if (obj instanceof List) {
            List list = (List)obj;
            try {
                return list.get(this.getIndex());
            }
            catch (IndexOutOfBoundsException e) {
                if (this.isIgnoreNullProperty) {
                    return null;
                }
                throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex(), e);
            }
        }
        Method getMethod = null;
        if (this.indexedObjReadMethodCache.containsKey(clazz) && (getMethod = (Method)this.indexedObjReadMethodCache.get(clazz)) == null) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName());
        }
        if (getMethod == null) {
            if (!IndexedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                    try {
                        return this.getIndexedObjectProperty(interfaces[i], obj);
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.getIndexedObjectProperty(superClass, obj);
                }
                this.indexedObjReadMethodCache.put(clazz, null);
                throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex());
            }
            try {
                getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
            if (Modifier.isPublic(getMethod.getModifiers())) {
                this.indexedObjReadMethodCache.put(clazz, getMethod);
            } else {
                this.indexedObjReadMethodCache.put(clazz, null);
                throw new NoSuchPropertyException(clazz, this.getPropertyName());
            }
        }
        try {
            return getMethod.invoke(obj, new Integer(this.getIndex()));
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
        }
    }

    protected Class getIndexedObjectPropertyType(Class indexdClazz) throws NoSuchPropertyException {
        return this.getIndexedObjectPropertyType(indexdClazz, true);
    }

    protected Class getIndexedObjectPropertyType(Class indexdClazz, boolean isThrow) throws NoSuchPropertyException {
        if (indexdClazz.isArray()) {
            return indexdClazz.getComponentType();
        }
        if (List.class.isAssignableFrom(indexdClazz)) {
            return Object.class;
        }
        try {
            Method getMethod = null;
            if (this.indexedObjReadMethodCache.containsKey(indexdClazz)) {
                getMethod = (Method)this.indexedObjReadMethodCache.get(indexdClazz);
                if (getMethod == null) {
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
            } else {
                getMethod = indexdClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                if (!Modifier.isPublic(getMethod.getModifiers())) {
                    this.indexedObjReadMethodCache.put(indexdClazz, null);
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
                this.indexedObjReadMethodCache.put(indexdClazz, getMethod);
            }
            return getMethod.getReturnType();
        }
        catch (NoSuchMethodException e) {
            Method setMethod = null;
            if (this.indexedObjWriteMethodCache.containsKey(indexdClazz)) {
                setMethod = (Method)this.indexedObjWriteMethodCache.get(indexdClazz);
                if (setMethod == null) {
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
            } else {
                Method[] methods = indexdClazz.getMethods();
                if (methods == null || methods.length == 0) {
                    this.indexedObjWriteMethodCache.put(indexdClazz, null);
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] params;
                    Method method = methods[i];
                    if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.class) && !params[0].equals(Integer.TYPE)) continue;
                    if (setMethod == null) {
                        setMethod = method;
                        continue;
                    }
                    this.indexedObjWriteMethodCache.put(indexdClazz, null);
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
                if (setMethod == null) {
                    this.indexedObjWriteMethodCache.put(indexdClazz, null);
                    if (isThrow) {
                        throw new NoSuchPropertyException(indexdClazz, this.getPropertyName());
                    }
                    return null;
                }
                this.indexedObjWriteMethodCache.put(indexdClazz, setMethod);
            }
            return setMethod.getParameterTypes()[1];
        }
    }

    protected void setIndexedObjectProperty(Class clazz, Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (clazz.isArray()) {
            if (Array.getLength(obj) <= this.getIndex()) {
                throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex());
            }
            Array.set(obj, this.getIndex(), value);
        } else {
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.size() <= this.getIndex()) {
                    for (int i = list.size(); i <= this.getIndex(); ++i) {
                        list.add(null);
                    }
                }
                try {
                    list.set(this.getIndex(), value);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex(), e);
                }
            }
            Method setMethod = null;
            if (this.indexedObjWriteMethodCache.containsKey(clazz)) {
                setMethod = (Method)this.indexedObjWriteMethodCache.get(clazz);
                if (setMethod == null) {
                    throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex());
                }
            } else {
                if (!IndexedProperty.isAccessableClass(clazz)) {
                    Class<?>[] interfaces = clazz.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                        try {
                            this.setIndexedObjectProperty(interfaces[i], obj, value);
                            return;
                        }
                        catch (NoSuchPropertyException e) {
                            // empty catch block
                        }
                    }
                    Class superClass = clazz.getSuperclass();
                    if (superClass != null) {
                        this.setIndexedObjectProperty(superClass, obj, value);
                        return;
                    }
                    this.indexedObjWriteMethodCache.put(clazz, null);
                    throw new NoSuchIndexPropertyException(clazz, this.getPropertyName(), this.getIndex());
                }
                Class<?> valueClass = value == null ? null : value.getClass();
                Method[] methods = clazz.getMethods();
                if (methods == null || methods.length == 0) {
                    this.indexedObjWriteMethodCache.put(clazz, null);
                    throw new NoSuchPropertyException(clazz, this.getPropertyName());
                }
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] params;
                    Method method = methods[i];
                    if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.class) && !params[0].equals(Integer.TYPE) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                    setMethod = method;
                }
                if (setMethod == null) {
                    this.indexedObjWriteMethodCache.put(clazz, null);
                    throw new NoSuchPropertyException(clazz, this.getPropertyName());
                }
                this.indexedObjWriteMethodCache.put(clazz, setMethod);
            }
            try {
                setMethod.invoke(obj, new Integer(this.getIndex()), value);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.getPropertyName(), e);
            }
        }
    }

    public static IndexedProperty[] getIndexedProperties(Object bean) {
        return IndexedProperty.getIndexedProperties(bean.getClass());
    }

    public static IndexedProperty[] getIndexedProperties(Class clazz) {
        Set props = new HashSet();
        if (IndexedProperty.isAccessableClass(clazz)) {
            props = IndexedProperty.getIndexedProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                props = IndexedProperty.getIndexedProperties(interfaces[i], props);
                break;
            }
        }
        Object[] result = props.toArray(new IndexedProperty[props.size()]);
        Arrays.sort(result);
        return result;
    }

    private static Set getIndexedProperties(Class clazz, Set props) {
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return props;
        }
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (method.getName().startsWith(GET_METHOD_NAME)) {
                Class<?> retType = method.getReturnType();
                if (Void.TYPE.equals(retType)) continue;
                if (params == null) {
                    if (retType.isArray() || List.class.isAssignableFrom(retType)) {
                        props.add(new IndexedProperty(method.getName().substring(3)));
                        continue;
                    }
                    try {
                        retType.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                        props.add(new IndexedProperty(method.getName().substring(3)));
                    }
                    catch (NoSuchMethodException e) {
                        Method[] nestedMethods = retType.getMethods();
                        boolean isFound = false;
                        for (int j = 0; j < nestedMethods.length; ++j) {
                            Class<?>[] nestedParams = nestedMethods[j].getParameterTypes();
                            if (!SET_METHOD_NAME.equals(nestedMethods[j].getName()) || nestedParams.length != 2 || !Integer.TYPE.equals(nestedParams[0])) continue;
                            isFound = true;
                            break;
                        }
                        if (!isFound) continue;
                        props.add(new IndexedProperty(method.getName().substring(3)));
                    }
                    continue;
                }
                if (params.length != 1 || !Integer.TYPE.equals(params[0])) continue;
                props.add(new IndexedProperty(method.getName().substring(3)));
                continue;
            }
            if (!method.getName().startsWith(SET_METHOD_NAME) || params == null || params.length != 2 || !Integer.TYPE.equals(params[0])) continue;
            props.add(new IndexedProperty(method.getName().substring(3)));
        }
        return props;
    }

    @Override
    public String toString() {
        return "IndexedProperty{" + this.property + '[' + this.getIndex() + "]}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexedProperty)) {
            return false;
        }
        IndexedProperty comp = (IndexedProperty)obj;
        if (this.property == null && comp.property != null || this.property != null && comp.property == null) {
            return false;
        }
        if (this.property != null && comp.property != null && !this.property.equals(comp.property)) {
            return false;
        }
        return this.index == comp.index;
    }

    @Override
    public int hashCode() {
        return (this.property == null ? 0 : this.property.hashCode()) + this.getIndex() + 2;
    }

    @Override
    public int compareTo(Object obj) {
        int val;
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof IndexedProperty)) {
            return 1;
        }
        IndexedProperty comp = (IndexedProperty)obj;
        if (this.property == null && comp.property != null) {
            return -1;
        }
        if (this.property != null && comp.property == null) {
            return 1;
        }
        if (this.property != null && comp.property != null && (val = this.property.compareTo(comp.property)) != 0) {
            return val;
        }
        return this.index - comp.index;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = Collections.synchronizedMap(new HashMap());
        this.setMethodCache = Collections.synchronizedMap(new HashMap());
        this.fieldCache = Collections.synchronizedMap(new HashMap());
        this.indexedReadMethodCache = Collections.synchronizedMap(new HashMap());
        this.indexedWriteMethodCache = Collections.synchronizedMap(new HashMap());
        this.indexedObjReadMethodCache = Collections.synchronizedMap(new HashMap());
        this.indexedObjWriteMethodCache = Collections.synchronizedMap(new HashMap());
    }
}

