/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;
import jp.ossc.nimbus.recset.InvalidSchemaException;

public class FieldSchema
implements Serializable {
    private static final long serialVersionUID = 750474574072043812L;
    public static final String C_FIELD_TYPE_VARCHAR = "VARCHAR";
    public static final String C_FIELD_TYPE_CHAR = "CHAR";
    public static final String C_FIELD_TYPE_LONG = "LONG";
    public static final String C_FIELD_TYPE_INT = "INT";
    public static final String C_FIELD_TYPE_FLOAT = "FLOAT";
    public static final String C_FIELD_TYPE_DOUBLE = "DOUBLE";
    public static final String C_FIELD_TYPE_DATE = "DATE";
    public static final String C_FIELD_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String C_FIELD_TYPE_BLOB = "BLOB";
    public static final String C_FIELD_TYPE_CLOB = "CLOB";
    public static final int C_KEY_UNIQUE = 0;
    public static final int C_KEY_ROW_VERSION = 1;
    public static final int C_KEY_READ = 2;
    public static final int C_KEY_UPDATE = 3;
    public static final int C_KEY_DUMMY = 4;
    public static final int C_TYPE_NONE = -1;
    public static final int C_TYPE_INT = 1;
    public static final int C_TYPE_LONG = 8;
    public static final int C_TYPE_STRING = 2;
    public static final int C_TYPE_CHAR = 3;
    public static final int C_TYPE_DATE = 4;
    public static final int C_TYPE_FLOAT = 5;
    public static final int C_TYPE_DOUBLE = 7;
    public static final int C_TYPE_TIMESTAMP = 9;
    public static final int C_TYPE_BLOB = 10;
    public static final int C_TYPE_CLOB = 11;
    private String mFieldName = null;
    private String mPysicalName = null;
    private int mFieldType = -1;
    private int mFieldLength = -1;
    private int mIndex = -1;
    private boolean mIsCrypt = false;
    private int mSqlType = -1;
    private int mFieldKey = -1;

    public int getFieldLength() {
        return this.mFieldLength;
    }

    public String getFieldName() {
        return this.mFieldName;
    }

    public String getPysicalName() {
        return this.mPysicalName;
    }

    public int getFieldType() {
        return this.mFieldType;
    }

    public int getFieldKey() {
        return this.mFieldKey;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isCrypt() {
        return this.mIsCrypt && (this.mFieldType == 2 || this.mFieldType == 3);
    }

    public boolean isUniqueKey() {
        return this.mFieldKey == 0;
    }

    public boolean isUpdateField() {
        return this.mFieldKey == 0 || this.mFieldKey == 1 || this.mFieldKey == 3;
    }

    public boolean isRowVersionField() {
        return this.mFieldKey == 1;
    }

    public void setFieldLength(int l) {
        if (this.mFieldLength == -1) {
            this.mFieldLength = l;
        }
    }

    public void setFieldName(String name) {
        if (this.mFieldName == null) {
            int index = name.lastIndexOf(32);
            if (index == -1 || index == name.length() - 1) {
                this.mFieldName = name;
            } else {
                this.mPysicalName = name.substring(0, index);
                this.mFieldName = name.substring(index + 1);
            }
        }
    }

    public void setFieldType(int type) {
        if (this.mFieldType != -1) {
            return;
        }
        switch (type) {
            case 1: {
                this.mSqlType = 4;
                break;
            }
            case 8: {
                this.mSqlType = 4;
                break;
            }
            case 2: {
                this.mSqlType = 12;
                break;
            }
            case 3: {
                this.mSqlType = 1;
                break;
            }
            case 4: {
                this.mSqlType = 91;
                break;
            }
            case 9: {
                this.mSqlType = 93;
                break;
            }
            case 5: {
                this.mSqlType = 6;
                break;
            }
            case 7: {
                this.mSqlType = 8;
                break;
            }
            case 10: {
                this.mSqlType = 2004;
                break;
            }
            case 11: {
                this.mSqlType = 2005;
                break;
            }
            default: {
                this.mFieldType = -1;
                return;
            }
        }
        this.mFieldType = type;
    }

    public void setFieldKey(int key) {
        if (this.mFieldKey == -1) {
            switch (key) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mFieldKey = key;
                    break;
                }
            }
        }
    }

    public void setIndex(int l) {
        if (this.mIndex == -1) {
            this.mIndex = l;
        }
    }

    public void setCrypt(boolean val) {
        this.mIsCrypt = val;
    }

    public void setSqlType(int arg) {
        this.mSqlType = arg;
    }

    public int getSqlType() {
        return this.mSqlType;
    }

    public static int getFieldTypeValue(String type) {
        if (C_FIELD_TYPE_VARCHAR.equals(type)) {
            return 2;
        }
        if (C_FIELD_TYPE_CHAR.equals(type)) {
            return 3;
        }
        if (C_FIELD_TYPE_LONG.equals(type)) {
            return 8;
        }
        if (C_FIELD_TYPE_INT.equals(type)) {
            return 1;
        }
        if (C_FIELD_TYPE_DOUBLE.equals(type)) {
            return 7;
        }
        if (C_FIELD_TYPE_FLOAT.equals(type)) {
            return 5;
        }
        if (C_FIELD_TYPE_DATE.equals(type)) {
            return 4;
        }
        if (C_FIELD_TYPE_TIMESTAMP.equals(type)) {
            return 9;
        }
        if (C_FIELD_TYPE_BLOB.equals(type)) {
            return 10;
        }
        if (C_FIELD_TYPE_CLOB.equals(type)) {
            return 11;
        }
        throw new InvalidSchemaException("Unknown type : " + type);
    }

    public static String getFieldTypeString(int type) {
        switch (type) {
            case 2: {
                return C_FIELD_TYPE_VARCHAR;
            }
            case 3: {
                return C_FIELD_TYPE_CHAR;
            }
            case 8: {
                return C_FIELD_TYPE_LONG;
            }
            case 1: {
                return C_FIELD_TYPE_INT;
            }
            case 7: {
                return C_FIELD_TYPE_DOUBLE;
            }
            case 5: {
                return C_FIELD_TYPE_FLOAT;
            }
            case 4: {
                return C_FIELD_TYPE_DATE;
            }
            case 9: {
                return C_FIELD_TYPE_TIMESTAMP;
            }
            case 10: {
                return C_FIELD_TYPE_BLOB;
            }
            case 11: {
                return C_FIELD_TYPE_CLOB;
            }
        }
        throw new InvalidSchemaException("Unknown type : " + type);
    }
}

