/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.NullKeyPropertyException;
import jp.ossc.nimbus.beans.NullNestPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionHandlingInterceptorServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class ExceptionHandlingInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionHandlingInterceptorServiceMBean {
    private static final long serialVersionUID = -1127585815625955982L;
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private static final String EHI__00001 = "EHI__00001";
    protected Map exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    @Override
    public void setExceptionAndHandlerMapping(Map map) {
        this.exceptionAndHandlerMapping = map;
    }

    @Override
    public Map getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    @Override
    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    @Override
    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (String exName : this.exceptionAndHandlerMapping.keySet()) {
                String name = (String)this.exceptionAndHandlerMapping.get(exName);
                String condition = null;
                int index = exName.indexOf(40);
                if (index != -1 && exName.charAt(exName.length() - 1) == ')') {
                    condition = exName.substring(index + 1, exName.length() - 1);
                    exName = exName.substring(0, index);
                }
                Class<?> clazz = Class.forName(exName, true, loader);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                ExceptionHandler handler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(serviceName);
                if (condition == null) {
                    this.exceptionMapForHandler.add(clazz, handler);
                    continue;
                }
                Condition cond = new Condition(condition, handler);
                try {
                    cond.evaluate((Throwable)clazz.newInstance(), null, true);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                this.exceptionMapForHandler.add(clazz, cond);
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            Object ret;
            block5: {
                ret = null;
                try {
                    ret = chain.invokeNext(context);
                }
                catch (Throwable th) {
                    boolean isHandled = false;
                    ExceptionHandler handler = this.getTargetExceptionHandlerCause(th, context);
                    if (handler != null) {
                        Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th, context);
                        if (targetTh == null) {
                            targetTh = th;
                        }
                        handler.handleException(targetTh, context);
                        isHandled = true;
                    }
                    if (isHandled) break block5;
                    throw th;
                }
            }
            return ret;
        }
        return chain.invokeNext(context);
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th, InvocationContext context) {
        ExceptionHandler handler = this.getTargetHandlerCause(this.exceptionMapForHandler, th, context);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected ExceptionHandler getTargetHandlerCause(ClassMappingTree handlerMap, Throwable th, InvocationContext context) {
        Throwable cause;
        if (handlerMap == null) {
            return null;
        }
        List handlers = handlerMap.getValueList(th.getClass());
        if (handlers != null) {
            int imax = handlers.size();
            for (int i = 0; i < imax; ++i) {
                Object handler = handlers.get(i);
                if (handler instanceof Condition) {
                    Condition condition = (Condition)handler;
                    try {
                        if (condition.evaluate(th, context)) {
                            return condition.handler;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().write(EHI__00001, e);
                    }
                    continue;
                }
                return (ExceptionHandler)handler;
            }
        }
        return (cause = this.getCause(th)) == null ? null : this.getTargetHandlerCause(handlerMap, cause, context);
    }

    protected Throwable getTargetException(ClassMappingTree handlerMap, Throwable th, InvocationContext context) {
        Throwable cause;
        if (handlerMap == null) {
            return th;
        }
        List handlers = handlerMap.getValueList(th.getClass());
        if (handlers != null) {
            int imax = handlers.size();
            for (int i = 0; i < imax; ++i) {
                Object handler = handlers.get(i);
                if (handler instanceof Condition) {
                    Condition condition = (Condition)handler;
                    try {
                        if (condition.evaluate(th, context)) {
                            return th;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().write(EHI__00001, e);
                    }
                    continue;
                }
                return th;
            }
        }
        return (cause = this.getCause(th)) == null ? null : this.getTargetException(handlerMap, cause, context);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th.getClass().getName().equals(SERVLET_EXCEPTION_NAME)) {
            cause = th.getCause();
            if (cause == null) {
                try {
                    cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, (Object[])null);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            }
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    protected static class Condition
    implements Serializable {
        private static final long serialVersionUID = 3347564788011911395L;
        public static final String EXCEPTION_KEY = "exception";
        public static final String CONTEXT_KEY = "context";
        public ExceptionHandler handler;
        protected transient List properties;
        protected transient Expression expression;
        protected transient List keyList;
        public String condition;
        protected static final String DELIMITER = "@";

        public Condition(String cond, ExceptionHandler handler) throws Exception {
            this.initCondition(cond);
            this.condition = cond;
            this.handler = handler;
        }

        protected void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
        }

        public boolean evaluate(Throwable th, InvocationContext context) throws Exception {
            return this.evaluate(th, context, false);
        }

        public boolean evaluate(Throwable th, InvocationContext context, boolean isTest) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            Map vars = jexlContext.getVars();
            vars.put(EXCEPTION_KEY, th);
            vars.put(CONTEXT_KEY, context);
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(vars);
                }
                catch (NullNestPropertyException e) {
                }
                catch (NullKeyPropertyException e) {
                }
                catch (NullIndexPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    Throwable th2 = e.getTargetException();
                    if (th2 instanceof Exception) {
                        throw (Exception)th2;
                    }
                    if (th2 instanceof Error) {
                        throw (Error)th2;
                    }
                    throw e;
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            if (exp == null && isTest) {
                return true;
            }
            throw new IllegalArgumentException(this.expression.getExpression());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

