/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ThreadContextInitializeInterceptorServiceMBean;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.sequence.Sequence;

public class ThreadContextInitializeInterceptorService
extends ServiceBase
implements Interceptor,
ThreadContextInitializeInterceptorServiceMBean {
    private static final long serialVersionUID = 7085572561373638170L;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected ServiceName codeMasterFinderServiceName;
    protected ServiceNameRef[] contextValueServiceNames;
    protected Properties contextValueInvocationContext;
    protected Map contextKeyPropMapping;
    protected Map contextValueMapping;
    protected boolean isOutputThreadName = true;
    protected boolean isOutputThreadGroupName = true;
    protected boolean isInitializeRecursiveCall = true;
    protected boolean isClear = true;
    protected ThreadLocal callStack;

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    @Override
    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setContextValueServiceNames(ServiceNameRef[] names) {
        this.contextValueServiceNames = names;
    }

    @Override
    public ServiceNameRef[] getContextValueServiceNames() {
        return this.contextValueServiceNames;
    }

    @Override
    public void setContextValueInvocationContext(Properties map) {
        this.contextValueInvocationContext = map;
    }

    @Override
    public Properties getContextValueInvocationContext() {
        return this.contextValueInvocationContext;
    }

    @Override
    public void setOutputThreadName(boolean isOutput) {
        this.isOutputThreadName = isOutput;
    }

    @Override
    public boolean isOutputThreadName() {
        return this.isOutputThreadName;
    }

    @Override
    public void setOutputThreadGroupName(boolean isOutput) {
        this.isOutputThreadGroupName = isOutput;
    }

    @Override
    public boolean isOutputThreadGroupName() {
        return this.isOutputThreadGroupName;
    }

    @Override
    public boolean isInitializeRecursiveCall() {
        return this.isInitializeRecursiveCall;
    }

    @Override
    public void setInitializeRecursiveCall(boolean isInitialize) {
        this.isInitializeRecursiveCall = isInitialize;
    }

    @Override
    public void setContextValueMapping(Map mapping) {
        this.contextValueMapping = mapping;
    }

    @Override
    public Map getContextValueMapping() {
        return this.contextValueMapping;
    }

    @Override
    public void setContextValue(String key, Object value) {
        if (this.contextValueMapping == null) {
            this.contextValueMapping = new HashMap();
        }
        this.contextValueMapping.put(key, value);
    }

    @Override
    public Object getContextValue(String key) {
        if (this.contextValueMapping == null) {
            return null;
        }
        return this.contextValueMapping.get(key);
    }

    @Override
    public boolean isClear() {
        return this.isClear;
    }

    @Override
    public void setClear(boolean isClear) {
        this.isClear = isClear;
    }

    @Override
    public void startService() throws Exception {
        if (this.threadContextServiceName == null) {
            throw new IllegalArgumentException("threadContextServiceName must be specified.");
        }
        this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        if (!this.isInitializeRecursiveCall) {
            this.callStack = new ThreadLocal(){

                protected Object initialValue() {
                    return new CallStack();
                }
            };
        }
        if (this.contextValueInvocationContext != null) {
            if (this.contextKeyPropMapping == null) {
                this.contextKeyPropMapping = new HashMap();
            }
            for (String string : this.contextValueInvocationContext.keySet()) {
                String propStr = this.contextValueInvocationContext.getProperty(string);
                Property prop = PropertyFactory.createProperty(propStr);
                this.contextKeyPropMapping.put(string, prop);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.callStack = null;
        if (this.contextKeyPropMapping != null) {
            this.contextKeyPropMapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && (this.callStack == null || ((CallStack)this.callStack.get()).stackIndex == 0)) {
            if (this.isClear) {
                this.threadContext.clear();
            }
            Sequence sequence = null;
            if (this.sequenceServiceName != null) {
                try {
                    sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
            }
            if (sequence != null) {
                String requestId = sequence.increment();
                this.threadContext.put("REQUEST_ID", requestId);
            }
            if (this.contextValueServiceNames != null) {
                for (int i = 0; i < this.contextValueServiceNames.length; ++i) {
                    this.threadContext.put(this.contextValueServiceNames[i].getReferenceServiceName(), ServiceManagerFactory.getServiceObject(this.contextValueServiceNames[i].getServiceName()));
                }
            }
            if (this.contextKeyPropMapping != null && this.contextKeyPropMapping.size() != 0) {
                for (String key : this.contextKeyPropMapping.keySet()) {
                    Property prop = (Property)this.contextKeyPropMapping.get(key);
                    this.threadContext.put(key, prop.getProperty(context));
                }
            }
            if (this.contextValueMapping != null && this.contextValueMapping.size() != 0) {
                for (String key : this.contextValueMapping.keySet()) {
                    this.threadContext.put(key, this.contextValueMapping.get(key));
                }
            }
            Thread thread = Thread.currentThread();
            if (this.isOutputThreadName) {
                this.threadContext.put("THREAD_NAME", thread.getName());
            }
            if (this.isOutputThreadGroupName) {
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.threadContext.put("THREAD_GROUP_NAME", threadGroup.getName());
            }
            CodeMasterFinder codeMasterFinder = null;
            if (this.codeMasterFinderServiceName != null) {
                try {
                    codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
            }
            if (codeMasterFinder != null) {
                Map codeMasters = codeMasterFinder.getCodeMasters();
                this.threadContext.put("CODE_MASTER", codeMasters);
            }
        }
        try {
            if (this.callStack != null) {
                ++((CallStack)this.callStack.get()).stackIndex;
            }
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            if (this.callStack != null) {
                --((CallStack)this.callStack.get()).stackIndex;
                if (this.isClear && ((CallStack)this.callStack.get()).stackIndex == 0) {
                    this.threadContext.clear();
                }
            } else if (this.isClear) {
                this.threadContext.clear();
            }
        }
    }

    protected static class CallStack {
        public int stackIndex;

        protected CallStack() {
        }
    }
}

