/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.TransactionSynchronizerServiceMBean;
import jp.ossc.nimbus.service.transaction.TransactionManagerFactory;

public class TransactionSynchronizerService
extends ServiceBase
implements TransactionSynchronizerServiceMBean {
    private static final long serialVersionUID = -3312681330940114153L;
    private ServiceName sourceConnectionFactoryServiceName;
    private ConnectionFactory sourceConnectionFactory;
    private ServiceName destinationConnectionFactoryServiceName;
    private ConnectionFactory destinationConnectionFactory;
    private String transactionTableName = "TRANSACTION_LOG";
    private String transactionParamTableName = "TRANSACTION_PARAMS_LOG";
    private ServiceName transactionManagerFactoryServiceName;
    private TransactionManagerFactory transactionManagerFactory;
    private boolean isSynchronizeOnStart;
    private int maxBatchCount = 10;

    @Override
    public void setSourceConnectionFactoryServiceName(ServiceName name) {
        this.sourceConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getSourceConnectionFactoryServiceName() {
        return this.sourceConnectionFactoryServiceName;
    }

    @Override
    public void setDestinationConnectionFactoryServiceName(ServiceName name) {
        this.destinationConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getDestinationConnectionFactoryServiceName() {
        return this.destinationConnectionFactoryServiceName;
    }

    @Override
    public void setTransactionTableName(String name) {
        this.transactionTableName = name;
    }

    @Override
    public String getTransactionTableName() {
        return this.transactionTableName;
    }

    @Override
    public void setTransactionParamTableName(String name) {
        this.transactionParamTableName = name;
    }

    @Override
    public String getTransactionParamTableName() {
        return this.transactionParamTableName;
    }

    @Override
    public void setTransactionManagerFactoryServiceName(ServiceName name) {
        this.transactionManagerFactoryServiceName = name;
    }

    @Override
    public ServiceName getTransactionManagerFactoryServiceName() {
        return this.transactionManagerFactoryServiceName;
    }

    @Override
    public void setSynchronizeOnStart(boolean isSynchronize) {
        this.isSynchronizeOnStart = isSynchronize;
    }

    @Override
    public boolean isSynchronizeOnStart() {
        return this.isSynchronizeOnStart;
    }

    @Override
    public void setMaxBatchCount(int max) {
        this.maxBatchCount = max;
    }

    @Override
    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countTransactionLog() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) from ").append(this.getTransactionTableName());
        Connection sourceConnection = this.sourceConnectionFactory.getConnection();
        long result = 0L;
        try {
            Object ret;
            Statement selectTransactionLog = sourceConnection.createStatement();
            ResultSet rsTransactionLog = selectTransactionLog.executeQuery(sql.toString());
            if (rsTransactionLog.next() && (ret = rsTransactionLog.getObject(1)) != null) {
                result = ret instanceof Number ? ((Number)ret).longValue() : Long.parseLong(ret.toString());
            }
        }
        finally {
            try {
                sourceConnection.close();
            }
            catch (SQLException e) {}
            sourceConnection = null;
        }
        return result;
    }

    @Override
    public void startService() throws Exception {
        if (this.sourceConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("SourceConnectionFactoryServiceName must be specified.");
        }
        this.sourceConnectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.sourceConnectionFactoryServiceName);
        if (this.destinationConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("DestinationConnectionFactoryServiceName must be specified.");
        }
        this.destinationConnectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.destinationConnectionFactoryServiceName);
        if (this.transactionManagerFactoryServiceName != null) {
            this.transactionManagerFactory = (TransactionManagerFactory)ServiceManagerFactory.getServiceObject(this.transactionManagerFactoryServiceName);
        }
        if (this.isSynchronizeOnStart) {
            this.synchronize();
        }
    }

    @Override
    public void stopService() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int synchronize() throws Exception {
        int executeLogCount = 0;
        Connection sourceConnection1 = this.sourceConnectionFactory.getConnection();
        TransactionManager transactionManager = null;
        if (this.transactionManagerFactory != null) {
            transactionManager = this.transactionManagerFactory.getTransactionManager();
        }
        try {
            Transaction oldTransaction;
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append("SEQNO").append(',');
            sql.append("QUERY").append(',');
            sql.append("QUERY_TYPE");
            sql.append(" from ").append(this.getTransactionTableName());
            sql.append(" order by ").append("SEQNO");
            Statement selectTransactionLog = sourceConnection1.createStatement();
            ResultSet rsTransactionLog = selectTransactionLog.executeQuery(sql.toString());
            sql.setLength(0);
            sql.append("select ");
            sql.append("SEQNO").append(',');
            sql.append("PARAM_INDEX").append(',');
            sql.append("PARAM_NAME").append(',');
            sql.append("PARAM_TYPE").append(',');
            sql.append("PARAM_LENGTH").append(',');
            sql.append("PARAM");
            sql.append(" from ").append(this.getTransactionParamTableName());
            sql.append(" order by ").append("SEQNO");
            Statement selectTransactionParamsLog = sourceConnection1.createStatement();
            ResultSet rsTransactionParamsLog = selectTransactionParamsLog.executeQuery(sql.toString());
            sql.setLength(0);
            sql.append("delete from ").append(this.getTransactionTableName());
            sql.append(" where ").append("SEQNO").append("=?");
            String deleteTransactionQuery = sql.toString();
            sql.setLength(0);
            sql.append("delete from ").append(this.getTransactionParamTableName());
            sql.append(" where ").append("SEQNO").append("=?");
            String deleteTransactionParamsQuery = sql.toString();
            Transaction transaction = oldTransaction = transactionManager == null ? null : transactionManager.getTransaction();
            if (transactionManager != null && oldTransaction != null) {
                transactionManager.suspend();
            }
            try {
                String preQuery = null;
                int preQueryType = 0;
                Statement preTransactionQuery = null;
                int batchCount = 0;
                Connection destConnection = null;
                Connection sourceConnection2 = null;
                PreparedStatement deleteTransaction = null;
                PreparedStatement deleteTransactionParams = null;
                String paramSeqNo = null;
                try {
                    while (rsTransactionLog.next()) {
                        boolean isTransactionCommit;
                        String seqNo = rsTransactionLog.getString("SEQNO");
                        String query = rsTransactionLog.getString("QUERY");
                        int queryType = rsTransactionLog.getInt("QUERY_TYPE");
                        if (transactionManager != null) {
                            if (transactionManager.getTransaction() == null) {
                                transactionManager.begin();
                                destConnection = this.destinationConnectionFactory.getConnection();
                                sourceConnection2 = this.sourceConnectionFactory.getConnection();
                                deleteTransaction = sourceConnection2.prepareStatement(deleteTransactionQuery);
                                deleteTransactionParams = sourceConnection2.prepareStatement(deleteTransactionParamsQuery);
                            }
                        } else {
                            if (destConnection == null) {
                                destConnection = this.destinationConnectionFactory.getConnection();
                            }
                            if (sourceConnection2 == null) {
                                sourceConnection2 = this.sourceConnectionFactory.getConnection();
                                deleteTransaction = sourceConnection2.prepareStatement(deleteTransactionQuery);
                                deleteTransactionParams = sourceConnection2.prepareStatement(deleteTransactionParamsQuery);
                            }
                        }
                        deleteTransaction.setString(1, seqNo);
                        deleteTransactionParams.setString(1, seqNo);
                        Statement transactionQuery = null;
                        if (query.equals(preQuery) && queryType == preQueryType) {
                            transactionQuery = preTransactionQuery;
                        } else {
                            switch (queryType) {
                                case 2: 
                                case 3: {
                                    if (batchCount > 0) {
                                        isTransactionCommit = this.executeBatch(transactionManager, destConnection, sourceConnection2, preTransactionQuery, deleteTransactionParams, deleteTransaction);
                                        if (isTransactionCommit) {
                                            preTransactionQuery = null;
                                            preQuery = null;
                                            preQueryType = 0;
                                            transactionQuery = null;
                                            deleteTransactionParams = null;
                                            deleteTransaction = null;
                                            destConnection = null;
                                            sourceConnection2 = null;
                                            transactionManager.begin();
                                            destConnection = this.destinationConnectionFactory.getConnection();
                                            sourceConnection2 = this.sourceConnectionFactory.getConnection();
                                            deleteTransaction = sourceConnection2.prepareStatement(deleteTransactionQuery);
                                            deleteTransaction.setString(1, seqNo);
                                            deleteTransactionParams = sourceConnection2.prepareStatement(deleteTransactionParamsQuery);
                                            deleteTransactionParams.setString(1, seqNo);
                                        }
                                        executeLogCount += batchCount;
                                        batchCount = 0;
                                    }
                                    if (queryType == 3) {
                                        transactionQuery = destConnection.prepareCall(query);
                                        break;
                                    }
                                    transactionQuery = destConnection.prepareStatement(query);
                                    break;
                                }
                                default: {
                                    if (preQueryType != 1) {
                                        if (batchCount > 0) {
                                            isTransactionCommit = this.executeBatch(transactionManager, destConnection, sourceConnection2, preTransactionQuery, deleteTransactionParams, deleteTransaction);
                                            if (isTransactionCommit) {
                                                preTransactionQuery = null;
                                                preQuery = null;
                                                preQueryType = 0;
                                                transactionQuery = null;
                                                deleteTransactionParams = null;
                                                deleteTransaction = null;
                                                destConnection = null;
                                                sourceConnection2 = null;
                                                transactionManager.begin();
                                                destConnection = this.destinationConnectionFactory.getConnection();
                                                sourceConnection2 = this.sourceConnectionFactory.getConnection();
                                                deleteTransaction = sourceConnection2.prepareStatement(deleteTransactionQuery);
                                                deleteTransaction.setString(1, seqNo);
                                                deleteTransactionParams = sourceConnection2.prepareStatement(deleteTransactionParamsQuery);
                                                deleteTransactionParams.setString(1, seqNo);
                                            }
                                            executeLogCount += batchCount;
                                            batchCount = 0;
                                        }
                                        transactionQuery = destConnection.createStatement();
                                        break;
                                    }
                                    transactionQuery = preTransactionQuery;
                                }
                            }
                        }
                        if (queryType == 1) {
                            transactionQuery.addBatch(query);
                        } else {
                            while ((paramSeqNo != null || rsTransactionParamsLog.next()) && seqNo.equals(paramSeqNo = rsTransactionParamsLog.getString("SEQNO"))) {
                                paramSeqNo = null;
                                int paramIndex = rsTransactionParamsLog.getInt("PARAM_INDEX");
                                String paramName = rsTransactionParamsLog.getString("PARAM_NAME");
                                if (rsTransactionParamsLog.wasNull()) {
                                    paramName = null;
                                }
                                int paramType = rsTransactionParamsLog.getInt("PARAM_TYPE");
                                if (rsTransactionParamsLog.wasNull()) {
                                    paramType = Integer.MIN_VALUE;
                                }
                                int paramLength = rsTransactionParamsLog.getInt("PARAM_LENGTH");
                                InputStream paramIs = rsTransactionParamsLog.getBinaryStream("PARAM");
                                if (!rsTransactionParamsLog.wasNull()) {
                                    ObjectInputStream ois = null;
                                    Calendar cal = null;
                                    switch (paramType) {
                                        case -4: 
                                        case -3: 
                                        case -2: 
                                        case 2004: {
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setBinaryStream(paramIndex, paramIs, paramLength);
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setBinaryStream(paramName, paramIs, paramLength);
                                            break;
                                        }
                                        case -1: 
                                        case 2005: {
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setAsciiStream(paramIndex, paramIs, paramLength);
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setAsciiStream(paramName, paramIs, paramLength);
                                            break;
                                        }
                                        case 91: {
                                            ois = new ObjectInputStream(paramIs);
                                            cal = (Calendar)ois.readObject();
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setDate(paramIndex, new Date(cal.getTimeInMillis()));
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setDate(paramName, new Date(cal.getTimeInMillis()));
                                            break;
                                        }
                                        case 92: {
                                            ois = new ObjectInputStream(paramIs);
                                            cal = (Calendar)ois.readObject();
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setTime(paramIndex, new Time(cal.getTimeInMillis()));
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setTime(paramName, new Time(cal.getTimeInMillis()));
                                            break;
                                        }
                                        case 93: {
                                            ois = new ObjectInputStream(paramIs);
                                            cal = (Calendar)ois.readObject();
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setTimestamp(paramIndex, new Timestamp(cal.getTimeInMillis()));
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setTimestamp(paramName, new Timestamp(cal.getTimeInMillis()));
                                            break;
                                        }
                                        default: {
                                            ois = new ObjectInputStream(paramIs);
                                            if (paramType != Integer.MIN_VALUE) {
                                                if (paramName == null) {
                                                    ((PreparedStatement)transactionQuery).setObject(paramIndex, ois.readObject(), paramType);
                                                    break;
                                                }
                                                ((CallableStatement)transactionQuery).setObject(paramName, ois.readObject(), paramType);
                                                break;
                                            }
                                            if (paramName == null) {
                                                ((PreparedStatement)transactionQuery).setObject(paramIndex, ois.readObject());
                                                break;
                                            }
                                            ((CallableStatement)transactionQuery).setObject(paramName, ois.readObject());
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (paramType != Integer.MIN_VALUE) {
                                    if (paramName == null) {
                                        ((PreparedStatement)transactionQuery).setNull(paramIndex, paramType);
                                        continue;
                                    }
                                    ((CallableStatement)transactionQuery).setNull(paramName, paramType);
                                    continue;
                                }
                                if (paramName == null) {
                                    ((PreparedStatement)transactionQuery).setObject(paramIndex, null);
                                    continue;
                                }
                                ((CallableStatement)transactionQuery).setObject(paramName, null);
                            }
                            ((PreparedStatement)transactionQuery).addBatch();
                        }
                        deleteTransaction.addBatch();
                        deleteTransactionParams.addBatch();
                        if (++batchCount >= this.maxBatchCount) {
                            isTransactionCommit = this.executeBatch(transactionManager, destConnection, sourceConnection2, transactionQuery, deleteTransactionParams, deleteTransaction);
                            if (isTransactionCommit) {
                                preTransactionQuery = null;
                                preQuery = null;
                                preQueryType = 0;
                                transactionQuery = null;
                                deleteTransactionParams = null;
                                deleteTransaction = null;
                                destConnection = null;
                                sourceConnection2 = null;
                            }
                            executeLogCount += batchCount;
                            batchCount = 0;
                            continue;
                        }
                        preQuery = query;
                        preQueryType = queryType;
                        preTransactionQuery = transactionQuery;
                    }
                    if (batchCount > 0) {
                        this.executeBatch(transactionManager, destConnection, sourceConnection2, preTransactionQuery, deleteTransactionParams, deleteTransaction);
                        executeLogCount += batchCount;
                    }
                }
                catch (RollbackException e) {
                    throw e;
                }
                catch (HeuristicMixedException e) {
                    throw e;
                }
                catch (HeuristicRollbackException e) {
                    throw e;
                }
                catch (SystemException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (transactionManager != null && transactionManager.getTransaction() != null) {
                        transactionManager.rollback();
                    }
                    throw e;
                }
                catch (Error err) {
                    if (transactionManager != null && transactionManager.getTransaction() != null) {
                        transactionManager.rollback();
                    }
                    throw err;
                }
                finally {
                    if (destConnection != null) {
                        try {
                            destConnection.close();
                        }
                        catch (SQLException e) {}
                        destConnection = null;
                    }
                    if (sourceConnection2 != null) {
                        try {
                            sourceConnection2.close();
                        }
                        catch (SQLException e) {}
                        sourceConnection2 = null;
                    }
                }
            }
            finally {
                if (transactionManager != null && oldTransaction != null) {
                    transactionManager.resume(oldTransaction);
                }
            }
        }
        finally {
            try {
                sourceConnection1.close();
            }
            catch (SQLException e) {}
            sourceConnection1 = null;
        }
        return executeLogCount;
    }

    private boolean executeBatch(TransactionManager transactionManager, Connection destConnection, Connection sourceConnection, Statement transactionQuery, PreparedStatement deleteTransactionParams, PreparedStatement deleteTransaction) throws SQLException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        boolean isTransactionCommit = false;
        transactionQuery.executeBatch();
        deleteTransactionParams.executeBatch();
        deleteTransaction.executeBatch();
        if (transactionManager != null && transactionManager.getTransaction() != null) {
            transactionManager.commit();
            isTransactionCommit = true;
            deleteTransactionParams.close();
            deleteTransaction.close();
            transactionQuery.close();
            try {
                destConnection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                sourceConnection.close();
            }
            catch (SQLException e) {}
        } else {
            if (!destConnection.getAutoCommit()) {
                try {
                    destConnection.commit();
                }
                catch (SQLException e) {
                    if (!sourceConnection.getAutoCommit()) {
                        try {
                            sourceConnection.rollback();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
            if (!sourceConnection.getAutoCommit()) {
                sourceConnection.commit();
            }
        }
        return isTransactionCommit;
    }
}

