/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextTransactionException;
import jp.ossc.nimbus.service.context.SharedContextTransactionManager;
import jp.ossc.nimbus.service.context.SharedContextTransactionManagerServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;

public class SharedContextTransactionManagerService
extends ServiceBase
implements SharedContextTransactionManager,
SharedContextTransactionManagerServiceMBean {
    private static final long serialVersionUID = 2481222542126691783L;
    protected ThreadLocal transactionLocal;
    protected long transactionTimeout;
    protected Timer timer;
    protected int defaultLockMode = 1;

    @Override
    public void setTransactionTimeout(long timeout) {
        this.transactionTimeout = timeout;
    }

    @Override
    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public void setDefaultLockMode(int lockMode) {
        this.defaultLockMode = lockMode;
    }

    @Override
    public int getDefaultLockMode() {
        return this.defaultLockMode;
    }

    @Override
    public void createService() throws Exception {
        this.transactionLocal = new ThreadLocal();
    }

    @Override
    public void startService() throws Exception {
        this.timer = new Timer();
    }

    @Override
    public void stopService() throws Exception {
        this.timer.cancel();
        this.timer = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.transactionLocal = null;
    }

    @Override
    public void begin() {
        this.begin(this.defaultLockMode);
    }

    @Override
    public void begin(int lockMode) {
        if (this.transactionLocal.get() == null) {
            SharedContextTransactionImpl transaction = new SharedContextTransactionImpl();
            transaction.setLockMode(lockMode);
            this.transactionLocal.set(transaction);
            if (this.transactionTimeout > 0L) {
                this.timer.schedule((TimerTask)transaction, this.transactionTimeout);
            }
        }
    }

    @Override
    public void commit() throws SharedContextTransactionException {
        SharedContextTransactionManager.SharedContextTransaction transaction = (SharedContextTransactionManager.SharedContextTransaction)this.transactionLocal.get();
        if (transaction == null) {
            throw new SharedContextTransactionException("Transaction is null.", 0);
        }
        transaction.commit();
    }

    @Override
    public void rollback() throws SharedContextTransactionException {
        SharedContextTransactionManager.SharedContextTransaction transaction = (SharedContextTransactionManager.SharedContextTransaction)this.transactionLocal.get();
        if (transaction == null) {
            throw new SharedContextTransactionException("Transaction is null.", 0);
        }
        transaction.rollback();
    }

    @Override
    public SharedContextTransactionManager.SharedContextTransaction getTransaction() {
        return (SharedContextTransactionManager.SharedContextTransaction)this.transactionLocal.get();
    }

    protected class SharedContextTransactionImpl
    extends TimerTask
    implements SharedContextTransactionManager.SharedContextTransaction {
        protected Map contextViewMap = new HashMap();
        protected List transactionEventList = new ArrayList();
        protected int commitTransactionEventCount = 0;
        protected int lockMode = 1;
        protected int state = 1;

        protected SharedContextTransactionImpl() {
        }

        protected void setLockMode(int mode) {
            this.lockMode = mode;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public boolean containsKey(SharedContext context, Object key) {
            Map contextView = (Map)this.contextViewMap.get(context);
            return contextView == null ? false : contextView.containsKey(key);
        }

        @Override
        public Object get(SharedContext context, Object key) {
            Map contextView = (Map)this.contextViewMap.get(context);
            return contextView == null ? null : contextView.get(key);
        }

        @Override
        public Object put(SharedContext context, Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            long curTimeout = timeout;
            long start = System.currentTimeMillis();
            HashMap<Object, Object> contextView = (HashMap<Object, Object>)this.contextViewMap.get(context);
            if (contextView == null) {
                contextView = new HashMap<Object, Object>();
                this.contextViewMap.put(context, contextView);
            }
            if (this.lockMode == 1) {
                context.lock(key, curTimeout);
            }
            if (timeout > 0L && (curTimeout = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            Object old = context.get(key, curTimeout);
            if (timeout > 0L && (curTimeout = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            contextView.put(key, value);
            this.transactionEventList.add(new PutTransactionEvent(context, key, value, curTimeout, old));
            return old;
        }

        @Override
        public void update(SharedContext context, Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            this.update(context, key, diff, timeout, false);
        }

        @Override
        public void updateIfExists(SharedContext context, Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            this.update(context, key, diff, timeout, true);
        }

        protected void update(SharedContext context, Object key, SharedContextValueDifference diff, long timeout, boolean ifExists) throws SharedContextSendException, SharedContextTimeoutException {
            long curTimeout = timeout;
            long start = System.currentTimeMillis();
            HashMap<Object, Object> contextView = (HashMap<Object, Object>)this.contextViewMap.get(context);
            if (contextView == null) {
                contextView = new HashMap<Object, Object>();
                this.contextViewMap.put(context, contextView);
            }
            if (this.lockMode == 1) {
                context.lock(key, curTimeout);
            }
            if (timeout > 0L && (curTimeout = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            Object value = context.get(key, curTimeout);
            Object old = null;
            if (value == null) {
                if (!ifExists) {
                    throw new SharedContextUpdateException("Current value is null. key=" + key);
                }
            } else if (value instanceof SharedContextValueDifferenceSupport) {
                old = ((SharedContextValueDifferenceSupport)value).clone();
                if (!((SharedContextValueDifferenceSupport)(value = ((SharedContextValueDifferenceSupport)value).clone())).update(diff)) {
                    throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)value).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                }
            } else {
                throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + value);
            }
            contextView.put(key, value);
            this.transactionEventList.add(new UpdateTransactionEvent(context, key, diff, curTimeout, old, ifExists));
        }

        @Override
        public Object remove(SharedContext context, Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            long curTimeout = timeout;
            long start = System.currentTimeMillis();
            HashMap<Object, Object> contextView = (HashMap<Object, Object>)this.contextViewMap.get(context);
            if (contextView == null) {
                contextView = new HashMap<Object, Object>();
                this.contextViewMap.put(context, contextView);
            }
            if (this.lockMode == 1) {
                context.lock(key, curTimeout);
            }
            if (timeout > 0L && (curTimeout = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            Object old = context.get(key, curTimeout);
            if (timeout > 0L && (curTimeout = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                throw new SharedContextTimeoutException();
            }
            contextView.put(key, null);
            this.transactionEventList.add(new RemoveTransactionEvent(context, key, curTimeout, old));
            return old;
        }

        @Override
        public void commit() throws SharedContextTransactionException {
            int index;
            if (this.state == 5 || this.state == 6 || this.state == 7) {
                return;
            }
            this.state = 2;
            this.cancel();
            try {
                int imax = this.transactionEventList.size();
                for (index = 0; index < imax; ++index) {
                    ++this.commitTransactionEventCount;
                    ((TransactionEvent)this.transactionEventList.get(index)).commit();
                }
                this.state = 5;
            }
            catch (Throwable th) {
                this.state = 3;
                boolean isSuccess = true;
                while (index >= 0) {
                    try {
                        ((TransactionEvent)this.transactionEventList.get(index)).rollback();
                    }
                    catch (SharedContextSendException e) {
                        isSuccess = false;
                    }
                    catch (SharedContextTimeoutException e) {
                        isSuccess = false;
                    }
                    --index;
                }
                this.state = isSuccess ? 6 : 7;
                throw new SharedContextTransactionException(th, this.state);
            }
            finally {
                if (this.lockMode == 1) {
                    for (Map.Entry entry : this.contextViewMap.entrySet()) {
                        SharedContext context = (SharedContext)entry.getKey();
                        Map contextView = (Map)entry.getValue();
                        Iterator keys = contextView.keySet().iterator();
                        while (keys.hasNext()) {
                            try {
                                context.unlock(keys.next());
                            }
                            catch (SharedContextSendException e) {}
                        }
                    }
                }
                SharedContextTransactionManagerService.this.transactionLocal.set(null);
            }
        }

        @Override
        public synchronized void rollback() throws SharedContextTransactionException {
            int index;
            if (this.state == 5 || this.state == 6 || this.state == 7) {
                return;
            }
            this.state = 3;
            this.cancel();
            try {
                int imax = this.commitTransactionEventCount;
                for (index = this.commitTransactionEventCount; index < imax; ++index) {
                    ((TransactionEvent)this.transactionEventList.get(index)).rollback();
                }
                this.state = 6;
            }
            catch (Throwable th) {
                int imax = this.commitTransactionEventCount;
                while (++index < imax) {
                    try {
                        ((TransactionEvent)this.transactionEventList.get(index)).rollback();
                    }
                    catch (SharedContextSendException e) {
                    }
                    catch (SharedContextTimeoutException e) {}
                }
                this.state = 7;
                throw new SharedContextTransactionException(th, this.state);
            }
            finally {
                if (this.lockMode == 1) {
                    for (Map.Entry entry : this.contextViewMap.entrySet()) {
                        SharedContext context = (SharedContext)entry.getKey();
                        Map contextView = (Map)entry.getValue();
                        Iterator keys = contextView.keySet().iterator();
                        while (keys.hasNext()) {
                            try {
                                context.unlock(keys.next());
                            }
                            catch (SharedContextSendException e) {}
                        }
                    }
                }
                SharedContextTransactionManagerService.this.transactionLocal.set(null);
            }
        }

        @Override
        public void run() {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected class RemoveTransactionEvent
        extends TransactionEvent {
            protected Object key;
            protected long timeout;
            protected Object oldValue;

            public RemoveTransactionEvent(SharedContext context, Object key, long timeout, Object old) {
                super(context);
                this.key = key;
                this.timeout = timeout;
                this.oldValue = old;
            }

            @Override
            public void commit() throws SharedContextSendException, SharedContextTimeoutException {
                this.context.remove(this.key, this.timeout);
            }

            @Override
            public void rollback() throws SharedContextSendException, SharedContextTimeoutException {
                this.context.put(this.key, this.oldValue, this.timeout);
            }
        }

        protected class UpdateTransactionEvent
        extends TransactionEvent {
            protected Object key;
            protected SharedContextValueDifference diff;
            protected long timeout;
            protected Object oldValue;
            protected boolean ifExists;

            public UpdateTransactionEvent(SharedContext context, Object key, SharedContextValueDifference diff, long timeout, Object old, boolean ifExists) {
                super(context);
                this.key = key;
                this.diff = diff;
                this.timeout = timeout;
                this.oldValue = old;
                this.ifExists = ifExists;
            }

            @Override
            public void commit() throws SharedContextSendException, SharedContextTimeoutException {
                if (this.ifExists) {
                    this.context.updateIfExists(this.key, this.diff, this.timeout);
                } else {
                    this.context.update(this.key, this.diff, this.timeout);
                }
            }

            @Override
            public void rollback() throws SharedContextSendException, SharedContextTimeoutException {
                if (!this.ifExists || this.oldValue != null) {
                    this.context.put(this.key, this.oldValue, this.timeout);
                }
            }
        }

        protected class PutTransactionEvent
        extends TransactionEvent {
            protected Object key;
            protected Object value;
            protected long timeout;
            protected Object oldValue;

            public PutTransactionEvent(SharedContext context, Object key, Object value, long timeout, Object old) {
                super(context);
                this.key = key;
                this.value = value;
                this.timeout = timeout;
                this.oldValue = old;
            }

            @Override
            public void commit() throws SharedContextSendException, SharedContextTimeoutException {
                this.context.put(this.key, this.value, this.timeout);
            }

            @Override
            public void rollback() throws SharedContextSendException, SharedContextTimeoutException {
                if (this.oldValue == null) {
                    this.context.remove(this.key, this.timeout);
                } else {
                    this.context.put(this.key, this.oldValue, this.timeout);
                }
            }
        }

        protected abstract class TransactionEvent {
            public static final int EVENT_PUT = 1;
            public static final int EVENT_UPDATE = 2;
            public static final int EVENT_REMOVE = 3;
            protected SharedContext context;

            public TransactionEvent(SharedContext context) {
                this.context = context;
            }

            public abstract void commit() throws SharedContextSendException, SharedContextTimeoutException;

            public abstract void rollback() throws SharedContextSendException, SharedContextTimeoutException;
        }
    }
}

