/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;

public class HttpResponse {
    private static final String HEADER_NAME_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_NAME_CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    private static final String CONTENT_ENCODING_ALL = "*";
    private static final String CHARSET = "charset";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO8859_1";
    private static final String DEFAULT_HTTP_VERSION = "HTTP/1.1";
    private static final int DEFAULT_HTTP_STATUS = 200;
    private static final String DEFAULT_HTTP_STATUS_MESSAGE = "OK";
    private String version = "HTTP/1.1";
    private int statusCode = 200;
    private String statusMessage = "OK";
    private Map headerMap = new LinkedHashMap();
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setHeader(String name, String val) {
        String[] vals = (String[])this.headerMap.get(name);
        if (vals == null) {
            vals = new String[]{val};
            this.headerMap.put(name, vals);
        } else {
            String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = val;
            this.headerMap.put(name, newVals);
        }
    }

    public void setHeaders(String name, String[] vals) {
        this.headerMap.put(name, vals);
    }

    public Set getHeaderNameSet() {
        return this.headerMap.keySet();
    }

    public String getHeader(String name) {
        String[] vals = (String[])this.headerMap.get(name);
        return vals == null ? null : vals[0];
    }

    public String[] getHeaders(String name) {
        return (String[])this.headerMap.get(name);
    }

    public void removeHeader(String name) {
        this.headerMap.remove(name);
    }

    public int getContentLength() {
        String contentLengthStr = this.getHeader(HEADER_NAME_CONTENT_LENGTH);
        if (contentLengthStr == null) {
            return -1;
        }
        int contentLength = -1;
        try {
            contentLength = Integer.parseInt(contentLengthStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return contentLength;
    }

    public String getCharacterEncoding() {
        String characterEncoding = DEFAULT_CHARACTER_ENCODING;
        String contentType = this.getHeader(HEADER_NAME_CONTENT_TYPE);
        if (contentType == null) {
            return characterEncoding;
        }
        StringTokenizer tokens = new StringTokenizer(contentType, ";");
        while (tokens.hasMoreTokens()) {
            String charset;
            int index;
            String token = tokens.nextToken();
            if (token.indexOf(CHARSET) == -1 || (index = token.indexOf(61)) <= 0 || index == token.length() - 1 || (charset = token.substring(index + 1).trim()).length() == 0) continue;
            characterEncoding = charset;
            break;
        }
        return characterEncoding;
    }

    public String getContentEncoding() {
        String contentEncoding = this.getHeader(HEADER_NAME_CONTENT_ENCODING);
        return contentEncoding;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected boolean isAppropriateEncoding(String contentEncoding, String acceptEncoding) {
        if (acceptEncoding == null) {
            return false;
        }
        if (acceptEncoding.indexOf(59) == -1) {
            return acceptEncoding.indexOf(contentEncoding) != -1 || acceptEncoding.indexOf(CONTENT_ENCODING_ALL) != -1;
        }
        String[] encodes = acceptEncoding.split(",");
        for (int i = 0; i < encodes.length; ++i) {
            String encode = encodes[i].trim();
            if (!encode.startsWith(contentEncoding) && !encode.startsWith(CONTENT_ENCODING_ALL)) continue;
            int index = encode.indexOf(59);
            double qValue = 1.0;
            if (index == -1) {
                return true;
            }
            String qValueStr = encode.substring(index + 1);
            encode = encode.substring(0, index).trim();
            index = qValueStr.indexOf(61);
            if (index != -1) {
                qValueStr = qValueStr.substring(index + 1);
                try {
                    qValue = Double.parseDouble(qValueStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (qValue != 0.0) {
                return true;
            }
            if (!contentEncoding.equals(encode)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(HttpRequest request, OutputStream os) throws IOException {
        byte[] bodyBytes = this.outputStream.toByteArray();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, this.getCharacterEncoding()));
        try {
            pw.print(this.version + ' ' + this.statusCode + ' ' + this.statusMessage + '\r' + '\n');
            String contentEncoding = this.getContentEncoding();
            if (contentEncoding != null) {
                if (bodyBytes.length == 0) {
                    this.removeHeader(HEADER_NAME_CONTENT_ENCODING);
                } else {
                    String acceptEncoding = request.header.getAcceptEncoding();
                    if (!this.isAppropriateEncoding(contentEncoding, acceptEncoding)) {
                        this.removeHeader(HEADER_NAME_CONTENT_ENCODING);
                    }
                }
            }
            for (String name : this.getHeaderNameSet()) {
                String[] vals = this.getHeaders(name);
                for (int i = 0; i < vals.length; ++i) {
                    pw.print(name + ": " + vals[i] + '\r' + '\n');
                }
            }
            if (bodyBytes.length != 0) {
                bodyBytes = this.compress(bodyBytes, this.getContentEncoding());
            }
            if (this.getContentLength() == -1) {
                int contentLength = 0;
                if (bodyBytes != null) {
                    contentLength = bodyBytes.length;
                }
                pw.print("Content-Length: " + contentLength + '\r' + '\n');
            }
            pw.print('\r');
            pw.print('\n');
            pw.flush();
            os.write(bodyBytes);
        }
        finally {
            pw.close();
        }
    }

    protected byte[] compress(byte[] bytes, String contentEncoding) throws IOException {
        if (contentEncoding == null) {
            return bytes;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream out = baos;
        if (contentEncoding.indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
            out = new DeflaterOutputStream(out);
        } else if (contentEncoding.indexOf(CONTENT_ENCODING_GZIP) != -1 || contentEncoding.indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
            out = new GZIPOutputStream(out);
        } else {
            throw new IOException("Can not compress. [" + contentEncoding + "]");
        }
        out.write(bytes);
        out.flush();
        ((DeflaterOutputStream)out).finish();
        out.close();
        return baos.toByteArray();
    }
}

