/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class EvaluateException
extends RuntimeException
implements Externalizable {
    private static final long serialVersionUID = 2527297536258573314L;
    private String message;

    public EvaluateException() {
    }

    public EvaluateException(String message) {
        this.message = message;
    }

    public EvaluateException(Throwable cause) {
        super(cause);
    }

    public EvaluateException(String message, Throwable cause) {
        super(cause);
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getCause() == null) {
            out.writeObject(null);
            out.writeObject(this.message);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this.getCause());
                oos.flush();
                out.writeObject(this.getCause());
                out.writeObject(this.message);
            }
            catch (NotSerializableException e) {
                out.writeObject(null);
                out.writeObject(this.message == null ? this.getCause().toString() : this.message + " : " + this.getCause().toString());
            }
            finally {
                oos.close();
            }
        }
        out.writeObject(this.getStackTrace());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initCause((Throwable)in.readObject());
        this.message = (String)in.readObject();
        this.setStackTrace((StackTraceElement[])in.readObject());
    }
}

