/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class DefaultScheduleMaster
implements ScheduleMaster,
Serializable,
Comparable {
    private static final long serialVersionUID = -4016419359156060172L;
    protected String id;
    protected String[] groupIds;
    protected String taskName;
    protected String scheduleType;
    protected Object input;
    protected Date startTime;
    protected Date endTime;
    protected long repeatInterval;
    protected long retryInterval;
    protected Date retryEndTime;
    protected long maxDelayTime;
    protected boolean isEnabled = true;
    protected String[] depends;
    protected String executorKey;
    protected String executorType;
    protected boolean isTemplate;

    public DefaultScheduleMaster() {
    }

    public DefaultScheduleMaster(String id, String[] groupIds, String taskName, String scheduleType, Object input, Date startTime, boolean isEnabled, String[] depends, String executorKey, String executorType, boolean isTemplate) {
        this(id, groupIds, taskName, scheduleType, input, startTime, null, 0L, 0L, null, 0L, isEnabled, depends, executorKey, executorType, isTemplate);
    }

    public DefaultScheduleMaster(String id, String[] groupIds, String taskName, String scheduleType, Object input, Date startTime, long retryInterval, Date retryEndTime, long maxDelayTime, boolean isEnabled, String[] depends, String executorKey, String executorType, boolean isTemplate) {
        this(id, groupIds, taskName, scheduleType, input, startTime, null, 0L, retryInterval, retryEndTime, maxDelayTime, isEnabled, depends, executorKey, executorType, isTemplate);
    }

    public DefaultScheduleMaster(String id, String[] groupIds, String taskName, String scheduleType, Object input, Date startTime, Date endTime, long repeatInterval, long retryInterval, Date retryEndTime, long maxDelayTime, boolean isEnabled, String[] depends, String executorKey, String executorType, boolean isTemplate) {
        this.setId(id);
        this.setGroupIds(groupIds);
        this.setTaskName(taskName);
        this.setScheduleType(scheduleType);
        this.setInput(input);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatInterval(repeatInterval);
        this.setRetryInterval(retryInterval);
        this.setRetryEndTime(retryEndTime);
        this.setMaxDelayTime(maxDelayTime);
        this.setEnabled(isEnabled);
        this.setDepends(depends);
        this.setExecutorKey(executorKey);
        this.setExecutorType(executorType);
        this.setTemplate(isTemplate);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String[] getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(String[] id) {
        this.groupIds = id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String type) {
        this.scheduleType = type;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    @Override
    public void setInput(Object data) {
        this.input = data;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date time) {
        this.startTime = time;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date time) {
        this.endTime = time;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    @Override
    public void setRepeatInterval(long interval) {
        this.repeatInterval = interval;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    @Override
    public Date getRetryEndTime() {
        return this.retryEndTime;
    }

    @Override
    public void setRetryEndTime(Date time) {
        this.retryEndTime = time;
    }

    @Override
    public long getMaxDelayTime() {
        return this.maxDelayTime;
    }

    @Override
    public void setMaxDelayTime(long time) {
        this.maxDelayTime = time;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] ids) {
        this.depends = ids;
    }

    @Override
    public void setExecutorKey(String key) {
        this.executorKey = key;
    }

    @Override
    public String getExecutorKey() {
        return this.executorKey;
    }

    @Override
    public void setExecutorType(String type) {
        this.executorType = type;
    }

    @Override
    public String getExecutorType() {
        return this.executorType;
    }

    @Override
    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Override
    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    @Override
    public void applyDate(Date date) {
        Calendar cal = Calendar.getInstance();
        if (this.startTime != null) {
            this.startTime = this.applyDateToTime(date, this.startTime, cal);
        }
        if (this.endTime != null) {
            this.endTime = this.applyDateToTime(date, this.endTime, cal);
        }
        if (this.retryEndTime != null) {
            this.retryEndTime = this.applyDateToTime(date, this.retryEndTime, cal);
        }
    }

    protected Date applyDateToTime(Date date, Date time, Calendar work) {
        work.clear();
        work.setTime(date);
        int year = work.get(1);
        int day = work.get(6);
        work.clear();
        work.setTime(time);
        work.set(1, year);
        work.set(6, day + (work.get(6) - 1));
        return work.getTime();
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScheduleMaster)) {
            return false;
        }
        ScheduleMaster cmp = (ScheduleMaster)obj;
        return this.id == null && cmp.getId() == null || this.id != null && this.id.equals(cmp.getId());
    }

    public int compareTo(Object o) {
        int result;
        if (o == null || !(o instanceof ScheduleMaster)) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        ScheduleMaster cmp = (ScheduleMaster)o;
        if (this.startTime != null && cmp.getStartTime() == null) {
            return -1;
        }
        if (this.startTime == null && cmp.getStartTime() != null) {
            return 1;
        }
        if (this.startTime != null && cmp.getStartTime() != null && (result = this.startTime.compareTo(cmp.getStartTime())) != 0) {
            return result;
        }
        if (this.id == null && cmp.getId() == null) {
            return 0;
        }
        if (this.id != null && cmp.getId() == null) {
            return -1;
        }
        if (this.id == null && cmp.getId() != null) {
            return 1;
        }
        return this.id.compareTo(cmp.getId());
    }

    public String toString() {
        int i;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(",groupIds=");
        if (this.groupIds == null || this.groupIds.length == 0) {
            buf.append((Object)null);
        } else {
            buf.append('[');
            for (i = 0; i < this.groupIds.length; ++i) {
                buf.append(this.groupIds[i]);
                if (i == this.groupIds.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",taskName=").append(this.taskName);
        buf.append(",scheduleType=").append(this.scheduleType);
        buf.append(",input=").append(this.input);
        buf.append(",startTime=").append(this.startTime == null ? null : format.format(this.startTime));
        buf.append(",endTime=").append(this.endTime == null ? null : format.format(this.endTime));
        buf.append(",repeatInterval=").append(this.repeatInterval);
        buf.append(",retryInterval=").append(this.retryInterval);
        buf.append(",retryEndTime=").append(this.retryEndTime == null ? null : format.format(this.retryEndTime));
        buf.append(",maxDelayTime=").append(this.maxDelayTime);
        buf.append(",isEnabled=").append(this.isEnabled);
        buf.append(",depends=");
        if (this.depends == null || this.depends.length == 0) {
            buf.append((Object)null);
        } else {
            buf.append('[');
            for (i = 0; i < this.depends.length; ++i) {
                buf.append(this.depends[i]);
                if (i == this.depends.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",executorKey=").append(this.executorKey);
        buf.append(",executorType=").append(this.executorType);
        buf.append(",isTemplate=").append(this.isTemplate);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Object clone() {
        DefaultScheduleMaster master = null;
        try {
            master = (DefaultScheduleMaster)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        master.startTime = this.startTime == null ? null : (Date)this.startTime.clone();
        master.endTime = this.endTime == null ? null : (Date)this.endTime.clone();
        master.retryEndTime = this.retryEndTime == null ? null : (Date)this.retryEndTime.clone();
        return master;
    }
}

