/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.Scheduler;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.DateFormatConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class ScheduleManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = 620443131672065496L;
    protected static final String INIT_PARAM_NAME_SCHEDULE_MANAGER_SERVICE_NAME = "ScheduleManagerServiceName";
    protected static final String INIT_PARAM_NAME_SCHEDULER_SERVICE_NAME = "SchedulerServiceName";
    protected static final String INIT_PARAM_NAME_MAKE_ENABLED = "MakeEnabled";
    protected static final String INIT_PARAM_NAME_ADD_ENABLED = "AddEnabled";
    protected static final String INIT_PARAM_NAME_RESCHEDULE_ENABLED = "RescheduleEnabled";
    protected static final String INIT_PARAM_NAME_REMOVE_ENABLED = "RemoveEnabled";
    protected static final String INIT_PARAM_NAME_REMOVE_ALL_ENABLED = "RemoveAllEnabled";
    protected static final String INIT_PARAM_NAME_CHANGE_STATE_ENABLED = "ChangeStateEnabled";
    protected static final String INIT_PARAM_NAME_CHANGE_CONTROL_STATE_ENABLED = "ChangeControlStateEnabled";
    protected static final String INIT_PARAM_NAME_CHANGE_EXECUTOR_KEY_ENABLED = "ChangeExecutorKeyEnabled";
    protected static final String INIT_PARAM_NAME_CHANGE_RETRY_END_TIME_ENABLED = "ChangeRetryEndTimeEnabled";
    protected static final String INIT_PARAM_NAME_CHANGE_MAX_DELAY_TIME_ENABLED = "ChangeMaxDelayTimeEnabled";
    protected static final String INIT_PARAM_NAME_STOP_ENTRY_ENABLED = "StopEntryEnabled";
    protected static final String INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME = "JSONConverterServiceName";
    protected static final String INIT_PARAM_NAME_UNICODE_ESCAPE = "UnicodeEscape";
    private static final int HEADER_OTHER = -1;
    private static final int HEADER_SCHEDULE = 0;
    private static final int HEADER_SCHEDULE_MASTER = 1;
    private ScheduleManager scheduleManager;
    private Scheduler scheduler;
    private BeanJSONConverter jsonConverter;
    private StringStreamConverter toStringConverter;

    private ServiceName getScheduleManagerServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_SCHEDULE_MANAGER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private ServiceName getSchedulerServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_SCHEDULER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isMakeEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_MAKE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isAddEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_ADD_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isRescheduleEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_RESCHEDULE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isRemoveEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_REMOVE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isRemoveAllEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_REMOVE_ALL_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isChangeStateEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CHANGE_STATE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isChangeControlStateEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CHANGE_CONTROL_STATE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isChangeExecutorKeyEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CHANGE_EXECUTOR_KEY_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isChangeRetryEndTimeEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CHANGE_RETRY_END_TIME_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isChangeMaxDelayTimeEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CHANGE_MAX_DELAY_TIME_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isStopEntryEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_STOP_ENTRY_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private ServiceName getJSONConverterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isUnicodeEscape() {
        ServletConfig config = this.getServletConfig();
        String isEscape = config.getInitParameter(INIT_PARAM_NAME_UNICODE_ESCAPE);
        return isEscape == null ? true : Boolean.valueOf(isEscape);
    }

    public synchronized void init() throws ServletException {
        ServiceName jsonConverterServiceName = this.getJSONConverterServiceName();
        if (jsonConverterServiceName == null) {
            this.jsonConverter = new BeanJSONConverter();
            DateFormatConverter dateFormatConverter = new DateFormatConverter(1, "yyyyMMddHHmmssSSS");
            dateFormatConverter.setNullString(null);
            this.jsonConverter.setFormatConverter(Date.class, (Converter)dateFormatConverter);
        } else {
            this.jsonConverter = (BeanJSONConverter)ServiceManagerFactory.getServiceObject(jsonConverterServiceName);
        }
        this.jsonConverter.setCharacterEncodingToStream("UTF-8");
        this.jsonConverter.setUnicodeEscape(this.isUnicodeEscape());
        this.toStringConverter = new StringStreamConverter(2);
        this.toStringConverter.setCharacterEncodingToObject("UTF-8");
        ServiceName scheduleManagerServiceName = this.getScheduleManagerServiceName();
        if (scheduleManagerServiceName == null) {
            throw new ServletException("ScheduleManagerServiceName is null.");
        }
        this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(scheduleManagerServiceName);
        ServiceName schedulerServiceName = this.getSchedulerServiceName();
        if (schedulerServiceName != null) {
            this.scheduler = (Scheduler)ServiceManagerFactory.getServiceObject(schedulerServiceName);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        if (this.scheduleManager == null) {
            resp.sendError(503);
            return;
        }
        String action = this.getParameter(req, "action");
        String responseType = this.getParameter(req, "responseType");
        if (action == null || action.equals("schedule")) {
            this.processScheduleResponse(req, resp, responseType);
        } else if (action.equals("executableSchedule")) {
            this.processExecutableScheduleResponse(req, resp, responseType);
        } else if (action.equals("depends")) {
            this.processDependsResponse(req, resp, responseType);
        } else if (action.equals("depended")) {
            this.processDependedResponse(req, resp, responseType);
        } else if (action.equals("scheduleMaster")) {
            this.processScheduleMasterResponse(req, resp, responseType);
        } else if (action.equals("changeState")) {
            if (!this.isChangeStateEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processChangeStateResponse(req, resp, responseType);
        } else if (action.equals("changeControlState")) {
            if (!this.isChangeControlStateEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processChangeControlStateResponse(req, resp, responseType);
        } else if (action.equals("reschedule")) {
            if (!this.isRescheduleEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processRescheduleResponse(req, resp, responseType);
        } else if (action.equals("remove")) {
            if (!this.isRemoveEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processRemoveResponse(req, resp, responseType);
        } else if (action.equals("changeExecutorKey")) {
            if (!this.isChangeExecutorKeyEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processChangeExecutorKeyResponse(req, resp, responseType);
        } else if (action.equals("changeRetryEndTime")) {
            if (!this.isChangeRetryEndTimeEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processChangeRetryEndTimeResponse(req, resp, responseType);
        } else if (action.equals("changeMaxDelayTime")) {
            if (!this.isChangeMaxDelayTimeEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processChangeMaxDelayTimeResponse(req, resp, responseType);
        } else if (action.equals("add")) {
            if (!this.isAddEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processAddResponse(req, resp, responseType);
        } else if (action.equals("addFromMaster")) {
            if (!this.isAddEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processAddFromMasterResponse(req, resp, responseType);
        } else if (action.equals("scheduleType")) {
            this.processScheduleTypeResponse(req, resp, responseType);
        } else if (action.equals("makeSchedule")) {
            if (!this.isMakeEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processMakeScheduleResponse(req, resp, responseType);
        } else if (action.equals("isMakeSchedule")) {
            this.processIsMakeScheduleResponse(req, resp, responseType);
        } else if (action.equals("executorType")) {
            if (this.scheduler == null) {
                resp.sendError(503);
                return;
            }
            this.processExecutorTypeResponse(req, resp, responseType);
        } else if (action.equals("stopEntry")) {
            if (this.scheduler == null) {
                resp.sendError(503);
                return;
            }
            if (!this.isStopEntryEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processStopEntryResponse(req, resp, responseType);
        } else if (action.equals("startEntry")) {
            if (this.scheduler == null) {
                resp.sendError(503);
                return;
            }
            if (!this.isStopEntryEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processStartEntryResponse(req, resp, responseType);
        } else if (action.equals("isStartEntry")) {
            if (this.scheduler == null) {
                resp.sendError(503);
                return;
            }
            this.processIsStartEntryResponse(req, resp, responseType);
        } else {
            resp.sendError(404);
        }
    }

    private String getCurrentPath(HttpServletRequest req) {
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            return "." + (req.getPathInfo() == null ? "" : req.getPathInfo());
        }
        return "." + path;
    }

    private boolean isNullParameter(HttpServletRequest req, String name) {
        String param = req.getParameter(name);
        if (param == null) {
            return false;
        }
        return "null".equals(param);
    }

    private String getParameter(HttpServletRequest req, String name) throws NumberFormatException {
        String param = req.getParameter(name);
        if (param == null || param.length() == 0 || "null".equals(param)) {
            return null;
        }
        return param;
    }

    private Long getLongParameter(HttpServletRequest req, String name) throws NumberFormatException {
        String param = this.getParameter(req, name);
        if (param == null) {
            return null;
        }
        return Long.valueOf(param);
    }

    private long[] getLongParameterValues(HttpServletRequest req, String name) throws NumberFormatException {
        String[] params = this.getParameterValues(req, name);
        if (params == null) {
            return null;
        }
        long[] result = new long[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? 0L : Long.parseLong(params[i]);
        }
        return result;
    }

    private Date getDateParameter(HttpServletRequest req, String name, String format, boolean defaultIsNow) throws ParseException {
        String param = this.getParameter(req, name);
        if (param == null) {
            return defaultIsNow ? new Date() : null;
        }
        return new SimpleDateFormat(format).parse(param);
    }

    private Date[] getDateParameterValues(HttpServletRequest req, String name, String format, boolean defaultIsNow, int length) throws ParseException {
        String[] params = this.getParameterValues(req, name);
        if (params == null) {
            if (defaultIsNow) {
                Date[] result = new Date[length];
                Date now = new Date();
                for (int i = 0; i < result.length; ++i) {
                    result[i] = now;
                }
                return result;
            }
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date now = new Date();
        Date[] result = new Date[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? (defaultIsNow ? now : null) : dateFormat.parse(params[i]);
        }
        return result;
    }

    private int[] getIntParameterValues(HttpServletRequest req, String name) throws NumberFormatException {
        String[] params = this.getParameterValues(req, name);
        if (params == null) {
            return null;
        }
        int[] result = new int[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? 0 : Integer.parseInt(params[i]);
        }
        return result;
    }

    private String[] getParameterValues(HttpServletRequest req, String name) {
        return this.getParameterValues(req, name, true);
    }

    private String[] getParameterValues(HttpServletRequest req, String name, boolean nullReplace) {
        String[] params = req.getParameterValues(name);
        if (params == null || params.length == 0) {
            return params;
        }
        if (params.length == 1) {
            if (params[0].length() == 0) {
                return new String[1];
            }
            return CSVReader.toArray(params[0], ',', '\\', '\"', nullReplace ? "null" : null, null, true, false, true, true);
        }
        for (int i = 0; i < params.length; ++i) {
            if ((params[i] == null || params[i].length() != 0) && (!"null".equals(params[i]) || !nullReplace)) continue;
            params[i] = null;
        }
        return params;
    }

    protected void processExecutableScheduleResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Date time = null;
        try {
            time = this.getDateParameter(req, "time", "yyyyMMddHHmmssSSS", true);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'time' is illegal." + e.toString());
            return;
        }
        String[] executorTypes = this.getParameterValues(req, "executorType");
        String executorKey = this.getParameter(req, "executorKey");
        List schedules = null;
        ScheduleManageException exception = null;
        try {
            schedules = this.scheduleManager.findExecutableSchedules(time, executorTypes, executorKey);
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(0));
                buf.append("<body>");
                buf.append(this.scheduleSearchCondition(this.getCurrentPath(req), "", "", "", "", null, null, null));
                buf.append(this.schedules(this.getCurrentPath(req), schedules));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processScheduleResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String id = this.getParameter(req, "id");
        String groupId = this.getParameter(req, "groupId");
        String masterId = this.getParameter(req, "masterId");
        String masterGroupId = this.getParameter(req, "masterGroupId");
        Date from = null;
        try {
            from = this.getDateParameter(req, "from", "yyyyMMddHHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'from' is illegal." + e.toString());
            return;
        }
        Date to = null;
        try {
            to = this.getDateParameter(req, "to", "yyyyMMddHHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'to' is illegal." + e.toString());
            return;
        }
        int[] states = null;
        try {
            states = this.getIntParameterValues(req, "state");
        }
        catch (NumberFormatException e) {
            resp.sendError(400, "Parameter 'state' is illegal." + e.toString());
            return;
        }
        ScheduleManageException exception = null;
        List<Schedule> schedules = null;
        if (id != null && id.length() != 0) {
            try {
                Schedule schedule = this.scheduleManager.findSchedule(id);
                schedules = new ArrayList<Schedule>(1);
                schedules.add(schedule);
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        } else {
            String action = this.getParameter(req, "action");
            if (action == null && from == null && to == null && states == null && masterId == null && masterGroupId == null && groupId == null) {
                states = new int[]{1, 8};
            }
            try {
                schedules = this.scheduleManager.findSchedules(from, to, states, masterId, masterGroupId, groupId);
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(0));
                buf.append("<body>");
                buf.append(this.scheduleSearchCondition(this.getCurrentPath(req), id, groupId, masterId, masterGroupId, from, to, states));
                buf.append(this.schedules(this.getCurrentPath(req), schedules));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processDependsResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String id = this.getParameter(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        ScheduleManageException exception = null;
        List schedules = null;
        try {
            schedules = this.scheduleManager.findDependsSchedules(id);
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(-1));
                buf.append("<body>");
                buf.append(this.schedules(this.getCurrentPath(req), schedules));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processDependedResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String id = this.getParameter(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        ScheduleManageException exception = null;
        List schedules = null;
        try {
            schedules = this.scheduleManager.findDependedSchedules(id);
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(-1));
                buf.append("<body>");
                buf.append(this.schedules(this.getCurrentPath(req), schedules));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processScheduleMasterResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String masterId = this.getParameter(req, "masterId");
        String masterGroupId = this.getParameter(req, "masterGroupId");
        ScheduleManageException exception = null;
        ArrayList<ScheduleMaster> scheduleMasters = null;
        if (masterId != null && masterId.length() != 0) {
            try {
                ScheduleMaster scheduleMaster = this.scheduleManager.findScheduleMaster(masterId);
                if (scheduleMaster != null) {
                    scheduleMasters = new ArrayList<ScheduleMaster>(1);
                    scheduleMasters.add(scheduleMaster);
                }
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        } else if (masterGroupId != null && masterGroupId.length() != 0) {
            try {
                scheduleMasters = this.scheduleManager.findScheduleMasters(masterGroupId);
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        } else {
            try {
                scheduleMasters = this.scheduleManager.findAllScheduleMasters();
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("scheduleMasters", scheduleMasters);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(1));
                buf.append("<body>");
                buf.append(this.scheduleMasterSearchCondition(this.getCurrentPath(req), masterId, masterGroupId));
                buf.append(this.scheduleMasters(this.getCurrentPath(req), scheduleMasters));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processChangeStateResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        int[] oldState = this.getIntParameterValues(req, "oldState");
        int[] newState = this.getIntParameterValues(req, "newState");
        if (newState == null) {
            resp.sendError(400, "Parameter 'newState' is null.");
            return;
        }
        String[] output = this.getParameterValues(req, "output", false);
        LinkedHashMap<String, Boolean> isChanged = new LinkedHashMap<String, Boolean>();
        ScheduleManageException exception = null;
        try {
            int i;
            if (oldState == null) {
                for (i = 0; i < id.length; ++i) {
                    if (output == null || output[i] == null) {
                        if (this.scheduleManager.changeState(id[i], newState[i])) {
                            isChanged.put(id[i], Boolean.TRUE);
                            continue;
                        }
                        isChanged.put(id[i], Boolean.FALSE);
                        continue;
                    }
                    if (this.scheduleManager.changeState(id[i], newState[i], "null".equals(output[i]) ? null : output[i])) {
                        isChanged.put(id[i], Boolean.TRUE);
                        continue;
                    }
                    isChanged.put(id[i], Boolean.FALSE);
                }
            } else {
                for (i = 0; i < id.length; ++i) {
                    if (output == null || output[i] == null) {
                        if (this.scheduleManager.changeState(id[i], oldState[i], newState[i])) {
                            isChanged.put(id[i], Boolean.TRUE);
                            continue;
                        }
                        isChanged.put(id[i], Boolean.FALSE);
                        continue;
                    }
                    if (this.scheduleManager.changeState(id[i], oldState[i], newState[i], "null".equals(output[i]) ? null : output[i])) {
                        isChanged.put(id[i], Boolean.TRUE);
                        continue;
                    }
                    isChanged.put(id[i], Boolean.FALSE);
                }
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                ArrayList result = new ArrayList();
                for (Map.Entry entry : isChanged.entrySet()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("id", entry.getKey());
                    map.put("result", entry.getValue());
                    result.add(map);
                }
                jsonMap.put("result", result);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processChangeControlStateResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        int[] oldState = this.getIntParameterValues(req, "oldState");
        int[] newState = this.getIntParameterValues(req, "newState");
        if (newState == null) {
            resp.sendError(400, "Parameter 'newState' is null.");
            return;
        }
        LinkedHashMap<String, Boolean> isChanged = new LinkedHashMap<String, Boolean>();
        ScheduleManageException exception = null;
        try {
            int i;
            if (oldState == null) {
                for (i = 0; i < id.length; ++i) {
                    if (this.scheduleManager.changeControlState(id[i], newState[i])) {
                        isChanged.put(id[i], Boolean.TRUE);
                        continue;
                    }
                    isChanged.put(id[i], Boolean.FALSE);
                }
            } else {
                for (i = 0; i < id.length; ++i) {
                    if (this.scheduleManager.changeControlState(id[i], oldState[i], newState[i])) {
                        isChanged.put(id[i], Boolean.TRUE);
                        continue;
                    }
                    isChanged.put(id[i], Boolean.FALSE);
                }
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                ArrayList result = new ArrayList();
                for (Map.Entry entry : isChanged.entrySet()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("id", entry.getKey());
                    map.put("result", entry.getValue());
                    result.add(map);
                }
                jsonMap.put("result", result);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processRescheduleResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        Date[] time = null;
        try {
            time = this.getDateParameterValues(req, "time", "yyyyMMddHHmmssSSS", true, id.length);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'time' is illegal." + e.toString());
            return;
        }
        String[] output = this.getParameterValues(req, "output");
        LinkedHashMap<String, Boolean> isChanged = new LinkedHashMap<String, Boolean>();
        ScheduleManageException exception = null;
        try {
            for (int i = 0; i < id.length; ++i) {
                if (this.scheduleManager.reschedule(id[i], time[i], output[i])) {
                    isChanged.put(id[i], Boolean.TRUE);
                    continue;
                }
                isChanged.put(id[i], Boolean.FALSE);
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                ArrayList result = new ArrayList();
                for (Map.Entry entry : isChanged.entrySet()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("id", entry.getKey());
                    map.put("result", entry.getValue());
                    result.add(map);
                }
                jsonMap.put("result", result);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processRemoveResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        String masterId = this.getParameter(req, "masterId");
        String masterGroupId = this.getParameter(req, "masterGroupId");
        String groupId = this.getParameter(req, "groupId");
        Date from = null;
        try {
            from = this.getDateParameter(req, "from", "yyyyMMddHHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'from' is illegal." + e.toString());
            return;
        }
        Date to = null;
        try {
            to = this.getDateParameter(req, "to", "yyyyMMddHHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'to' is illegal." + e.toString());
            return;
        }
        int[] states = null;
        try {
            states = this.getIntParameterValues(req, "state");
        }
        catch (NumberFormatException e) {
            resp.sendError(400, "Parameter 'state' is illegal." + e.toString());
            return;
        }
        boolean isChanged = false;
        ScheduleManageException exception = null;
        if (id != null) {
            try {
                for (int i = 0; i < id.length; ++i) {
                    isChanged |= this.scheduleManager.removeSchedule(id[i]);
                }
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        } else {
            if (!(this.isRemoveAllEnabled() || from != null || to != null || states != null && states.length != 0 || masterId != null)) {
                resp.sendError(406);
                return;
            }
            try {
                isChanged = this.scheduleManager.removeSchedule(from, to, states, masterId, masterGroupId, groupId);
            }
            catch (ScheduleManageException e) {
                exception = e;
            }
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("result", isChanged ? Boolean.TRUE : Boolean.FALSE);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processChangeExecutorKeyResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        String[] executorKey = this.getParameterValues(req, "executorKey");
        ScheduleManageException exception = null;
        try {
            for (int i = 0; i < id.length; ++i) {
                this.scheduleManager.setExecutorKey(id[i], executorKey[i]);
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processChangeRetryEndTimeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        Date[] time = null;
        try {
            time = this.getDateParameterValues(req, "time", "yyyyMMddHHmmssSSS", false, id.length);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'time' is illegal." + e.toString());
            return;
        }
        if (time == null) {
            resp.sendError(400, "Parameter 'time' is null.");
            return;
        }
        ScheduleManageException exception = null;
        try {
            for (int i = 0; i < id.length; ++i) {
                this.scheduleManager.setRetryEndTime(id[i], time[i]);
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processChangeMaxDelayTimeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String[] id = this.getParameterValues(req, "id");
        if (id == null) {
            resp.sendError(400, "Parameter 'id' is null.");
            return;
        }
        long[] time = null;
        try {
            time = this.getLongParameterValues(req, "time");
        }
        catch (NumberFormatException e) {
            resp.sendError(400, "Parameter 'time' is illegal." + e.toString());
            return;
        }
        ScheduleManageException exception = null;
        try {
            for (int i = 0; i < id.length; ++i) {
                this.scheduleManager.setMaxDelayTime(id[i], time[i]);
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processAddResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String masterId = this.getParameter(req, "masterId");
        String groupId = this.getParameter(req, "groupId");
        Date time = null;
        try {
            time = this.getDateParameter(req, "time", "yyyyMMddHHmmssSSS", true);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'time' is illegal." + e.toString());
            return;
        }
        String taskName = this.getParameter(req, "taskName");
        String input = this.getParameter(req, "input");
        String[] depends = this.getParameterValues(req, "depends");
        String executorKey = this.getParameter(req, "executorKey");
        String executorType = this.getParameter(req, "executorType");
        Long retryInterval = this.getLongParameter(req, "retryInterval");
        Date retryEndTime = null;
        try {
            retryEndTime = this.getDateParameter(req, "retryEndTime", "yyyyMMddHHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'retryEndTime' is illegal." + e.toString());
            return;
        }
        Long maxDelayTime = this.getLongParameter(req, "maxDelayTime");
        ScheduleManageException exception = null;
        DefaultSchedule schedule = null;
        try {
            schedule = new DefaultSchedule(masterId, null, time, taskName, input, depends, executorKey, executorType, retryInterval == null ? 0L : retryInterval, retryEndTime, maxDelayTime == null ? 0L : maxDelayTime);
            schedule.setGroupId(groupId);
            this.scheduleManager.addSchedule(schedule);
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedule", schedule);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processAddFromMasterResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String masterId = this.getParameter(req, "masterId");
        String masterGroupId = this.getParameter(req, "masterGroupId");
        if (masterId == null && masterGroupId == null) {
            resp.sendError(400, "Parameter 'masterId' and 'masterGroupId' is null.");
            return;
        }
        String groupId = this.getParameter(req, "groupId");
        boolean isNullInput = this.isNullParameter(req, "input");
        String input = this.getParameter(req, "input");
        Date date = null;
        try {
            date = this.getDateParameter(req, "date", "yyyyMMdd", true);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'date' is illegal." + e.toString());
            return;
        }
        Date startTime = null;
        try {
            startTime = this.getDateParameter(req, "startTime", "HHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'startTime' is illegal." + e.toString());
            return;
        }
        Date endTime = null;
        try {
            endTime = this.getDateParameter(req, "endTime", "HHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'endTime' is illegal." + e.toString());
            return;
        }
        Date retryEndTime = null;
        try {
            retryEndTime = this.getDateParameter(req, "retryEndTime", "HHmmssSSS", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'retryEndTime' is illegal." + e.toString());
            return;
        }
        boolean isNullExecutorKey = this.isNullParameter(req, "executorKey");
        String executorKey = this.getParameter(req, "executorKey");
        Exception exception = null;
        List schedules = null;
        try {
            List<ScheduleMaster> scheduleMasters = null;
            if (masterId != null) {
                scheduleMasters = new ArrayList();
                ScheduleMaster scheduleMaster = this.scheduleManager.findScheduleMaster(masterId);
                if (scheduleMaster == null) {
                    exception = new Exception("ScheduleMaster not found. masterId=" + masterId);
                } else {
                    scheduleMasters.add(scheduleMaster);
                }
            } else {
                scheduleMasters = this.scheduleManager.findScheduleMasters(masterGroupId);
                if (scheduleMasters == null || scheduleMasters.size() == 0) {
                    exception = new Exception("ScheduleMaster not found. masterGroupId=" + masterGroupId);
                }
            }
            for (int i = 0; i < scheduleMasters.size(); ++i) {
                ScheduleMaster scheduleMaster = (ScheduleMaster)scheduleMasters.get(i);
                if (isNullInput) {
                    scheduleMaster.setInput(null);
                } else if (input != null) {
                    scheduleMaster.setInput(input);
                }
                if (startTime != null) {
                    scheduleMaster.setStartTime(startTime);
                }
                if (endTime != null) {
                    scheduleMaster.setEndTime(endTime);
                }
                if (retryEndTime != null) {
                    scheduleMaster.setRetryEndTime(retryEndTime);
                }
                if (isNullExecutorKey) {
                    scheduleMaster.setExecutorKey(null);
                } else if (executorKey != null) {
                    scheduleMaster.setExecutorKey(executorKey);
                }
                scheduleMaster.setTemplate(false);
            }
            if (scheduleMasters.size() != 0) {
                schedules = this.scheduleManager.makeSchedule(date, scheduleMasters, groupId);
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req) + "?action=scheduleMaster");
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processScheduleTypeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        ScheduleManageException exception = null;
        Map typeMap = null;
        try {
            typeMap = this.scheduleManager.getScheduleMakerMap();
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                Object[] types;
                Object[] objectArray = types = typeMap == null ? null : typeMap.keySet().toArray();
                if (types != null) {
                    Arrays.sort(types);
                }
                jsonMap.put("scheduleType", types);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processMakeScheduleResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Date date = null;
        try {
            date = this.getDateParameter(req, "date", "yyyyMMdd", true);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'date' is illegal." + e.toString());
            return;
        }
        ScheduleManageException exception = null;
        List schedules = null;
        try {
            schedules = this.scheduleManager.makeSchedule(date);
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("schedules", schedules);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else if (exception != null) {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append(this.exception(exception));
        } else {
            resp.sendRedirect(this.getCurrentPath(req) + "?action=scheduleMaster");
            return;
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processIsMakeScheduleResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String masterId = this.getParameter(req, "masterId");
        Date date = null;
        try {
            date = this.getDateParameter(req, "date", "yyyyMMdd", true);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'date' is illegal." + e.toString());
            return;
        }
        Date from = null;
        try {
            from = this.getDateParameter(req, "from", "yyyyMMdd", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'from' is illegal." + e.toString());
            return;
        }
        Date to = null;
        try {
            to = this.getDateParameter(req, "to", "yyyyMMdd", false);
        }
        catch (ParseException e) {
            resp.sendError(400, "Parameter 'to' is illegal." + e.toString());
            return;
        }
        Exception exception = null;
        boolean isMake = false;
        TreeMap masterIdDayMap = new TreeMap();
        try {
            if (masterId != null) {
                ScheduleMaker scheduleMaker;
                ScheduleMaster scheduleMaster = this.scheduleManager.findScheduleMaster(masterId);
                ScheduleMaker scheduleMaker2 = scheduleMaker = scheduleMaster != null ? this.scheduleManager.getScheduleMaker(scheduleMaster.getScheduleType()) : null;
                if (scheduleMaster == null) {
                    exception = new Exception("scheduleMaster not found. masterId=" + masterId);
                } else {
                    TreeMap<Date, Boolean> dayMap = new TreeMap<Date, Boolean>();
                    masterIdDayMap.put(scheduleMaster.getId(), dayMap);
                    if (from == null && to == null) {
                        isMake = scheduleMaker.isMakeSchedule(date, scheduleMaster);
                        dayMap.put(date, isMake ? Boolean.TRUE : Boolean.FALSE);
                    } else {
                        if (to == null) {
                            to = date;
                        } else if (from == null) {
                            from = date;
                        }
                        Calendar current = Calendar.getInstance();
                        current.setTime(from);
                        Calendar toCal = Calendar.getInstance();
                        toCal.setTime(to);
                        while (current.before(toCal) || current.equals(toCal)) {
                            Date today;
                            isMake = scheduleMaker.isMakeSchedule(today = current.getTime(), scheduleMaster);
                            dayMap.put(today, isMake ? Boolean.TRUE : Boolean.FALSE);
                            current.add(6, 1);
                        }
                    }
                }
            } else {
                List scheduleMasters = this.scheduleManager.findAllScheduleMasters();
                if (from == null && to == null) {
                    for (int i = 0; i < scheduleMasters.size(); ++i) {
                        ScheduleMaster scheduleMaster = (ScheduleMaster)scheduleMasters.get(i);
                        ScheduleMaker scheduleMaker = this.scheduleManager.getScheduleMaker(scheduleMaster.getScheduleType());
                        isMake = scheduleMaker.isMakeSchedule(date, scheduleMaster);
                        TreeMap<Date, Boolean> map = (TreeMap<Date, Boolean>)masterIdDayMap.get(scheduleMaster.getId());
                        if (map == null) {
                            map = new TreeMap<Date, Boolean>();
                            masterIdDayMap.put(scheduleMaster.getId(), map);
                        }
                        map.put(date, isMake ? Boolean.TRUE : Boolean.FALSE);
                    }
                } else {
                    if (to == null) {
                        to = date;
                    } else if (from == null) {
                        from = date;
                    }
                    Calendar current = Calendar.getInstance();
                    current.setTime(from);
                    Calendar toCal = Calendar.getInstance();
                    toCal.setTime(to);
                    while (current.before(toCal) || current.equals(toCal)) {
                        Date today = current.getTime();
                        for (int i = 0; i < scheduleMasters.size(); ++i) {
                            ScheduleMaster scheduleMaster = (ScheduleMaster)scheduleMasters.get(i);
                            ScheduleMaker scheduleMaker = this.scheduleManager.getScheduleMaker(scheduleMaster.getScheduleType());
                            isMake = scheduleMaker.isMakeSchedule(today, scheduleMaster);
                            TreeMap<Date, Boolean> map = (TreeMap<Date, Boolean>)masterIdDayMap.get(scheduleMaster.getId());
                            if (map == null) {
                                map = new TreeMap<Date, Boolean>();
                                masterIdDayMap.put(scheduleMaster.getId(), map);
                            }
                            map.put(today, isMake ? Boolean.TRUE : Boolean.FALSE);
                        }
                        current.add(6, 1);
                    }
                }
            }
        }
        catch (ScheduleManageException e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                ArrayList result = new ArrayList();
                for (Map.Entry entry : masterIdDayMap.entrySet()) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
                    resultMap.put("masterId", entry.getKey());
                    ArrayList resultList = new ArrayList();
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        HashMap<String, Object> resultMap2 = new HashMap<String, Object>(2);
                        resultMap2.put("date", entry2.getKey());
                        resultMap2.put("isMake", entry2.getValue());
                        resultList.add(resultMap2);
                    }
                    resultMap.put("result", resultList);
                    result.add(resultMap);
                }
                jsonMap.put("result", result);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            if (exception != null) {
                buf.append(this.exception(exception));
            } else {
                buf.append("<html>");
                buf.append(this.header(-1));
                buf.append("<body>");
                buf.append(this.scheduleMasterIsMakeCondition(this.getCurrentPath(req), masterId, from, to));
                buf.append(this.scheduleMasterIsMake(this.getCurrentPath(req), masterIdDayMap));
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processExecutorTypeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Map typeMap = this.scheduler.getScheduleExecutors();
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            Object[] types;
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object[]> jsonMap = new HashMap<String, Object[]>();
            Object[] objectArray = types = typeMap == null ? null : typeMap.keySet().toArray();
            if (types != null) {
                Arrays.sort(types);
            }
            jsonMap.put("executorType", types);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processStopEntryResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        this.scheduler.stopEntry();
        StringBuffer buf = new StringBuffer();
        if (!"json".equals(responseType)) {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.setContentType("application/json;charset=UTF-8");
        HashMap jsonMap = new HashMap();
        buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        resp.getWriter().println(buf.toString());
    }

    protected void processStartEntryResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        this.scheduler.startEntry();
        StringBuffer buf = new StringBuffer();
        if (!"json".equals(responseType)) {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.setContentType("application/json;charset=UTF-8");
        HashMap jsonMap = new HashMap();
        buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        resp.getWriter().println(buf.toString());
    }

    protected void processIsStartEntryResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        boolean isStartEntry = this.scheduler.isStartEntry();
        StringBuffer buf = new StringBuffer();
        if (!"json".equals(responseType)) {
            resp.sendRedirect(this.getCurrentPath(req));
            return;
        }
        resp.setContentType("application/json;charset=UTF-8");
        HashMap<String, Boolean> jsonMap = new HashMap<String, Boolean>();
        jsonMap.put("result", isStartEntry ? Boolean.TRUE : Boolean.FALSE);
        buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        resp.getWriter().println(buf.toString());
    }

    private String exception(Exception exception) {
        StringBuffer buf = new StringBuffer();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        pw.flush();
        buf.append("<html>");
        buf.append(this.header(-1));
        buf.append("<body>");
        buf.append("<pre>");
        buf.append(sw.toString());
        buf.append("</pre>");
        buf.append("</body>");
        buf.append("</html>");
        return buf.toString();
    }

    private String header(int mode) {
        StringBuffer buf = new StringBuffer();
        buf.append("<head>");
        buf.append("<title>Nimbus Schedule</title>");
        buf.append("<style type=\"text/css\">");
        buf.append("th { background-color: #cccccc; }");
        buf.append("table { margin: 3px; }");
        buf.append("</style>");
        buf.append("<script type=\"text/javascript\">");
        if (mode == 0) {
            buf.append("var stateCheckFlg=false;");
            buf.append("var tableCheckFlg=false;");
            if (this.isChangeStateEnabled()) {
                buf.append("function changeStateOne(id, old, newId){");
                buf.append("_changeState(\"changeState\", id, old, document.getElementById(newId).options[document.getElementById(newId).selectedIndex].value);");
                buf.append("}");
                buf.append("function changeStateMulti(){");
                buf.append("_changeStateMulti(\"changeState\", \"state_\", \"newState\");");
                buf.append("}");
            }
            if (this.isChangeControlStateEnabled()) {
                buf.append("function changeControlStateOne(id, old, newId){");
                buf.append("_changeState(\"changeControlState\", id, old, document.getElementById(newId).options[document.getElementById(newId).selectedIndex].value);");
                buf.append("}");
                buf.append("function changeControlStateMulti(){");
                buf.append("_changeStateMulti(\"changeControlState\", \"controlState_\", \"newControlState\");");
                buf.append("}");
            }
            if (this.isChangeStateEnabled() || this.isChangeControlStateEnabled()) {
                buf.append("function _changeStateMulti(target, stateId, newId){");
                buf.append("var checks=document.getElementsByName(\"check\");");
                buf.append("var newState=document.getElementById(newId).options[document.getElementById(newId).selectedIndex].value;");
                buf.append("var ids = new Array();");
                buf.append("var oldStates = new Array();");
                buf.append("var newStates = new Array();");
                buf.append("for(var i=0; i<checks.length; i++) {");
                buf.append("if(checks.item(i).checked) {");
                buf.append("ids.push(document.getElementById(\"id_\" + i).value);");
                buf.append("oldStates.push(document.getElementById(stateId + i).value);");
                buf.append("newStates.push(newState);");
                buf.append("}");
                buf.append("}");
                buf.append("if(ids.length == 0){");
                buf.append("return;");
                buf.append("}");
                buf.append("_changeState(target, ids.toString(), oldStates.toString(), newStates.toString());");
                buf.append("}");
                buf.append("function _changeState(target, id, old, _new){");
                buf.append("var f=document.getElementById(target);");
                buf.append("f.id.value=id;");
                buf.append("f.oldState.value=old;");
                buf.append("f.newState.value=_new;");
                buf.append("f.submit();");
                buf.append("}");
            }
            if (this.isRemoveEnabled()) {
                buf.append("function removeOne(id){");
                buf.append("_remove(id);");
                buf.append("}");
                buf.append("function _removeMulti(){");
                buf.append("var checks=document.getElementsByName(\"check\");");
                buf.append("var ids = new Array();");
                buf.append("for(var i=0; i<checks.length; i++) {");
                buf.append("if(checks.item(i).checked) {");
                buf.append("ids.push(document.getElementById(\"id_\" + i).value);");
                buf.append("}");
                buf.append("}");
                buf.append("if(ids.length == 0){");
                buf.append("return;");
                buf.append("}");
                buf.append("_remove(ids.toString());");
                buf.append("}");
                buf.append("function _remove(id){");
                buf.append("var f=document.getElementById(\"removeSchedule\");");
                buf.append("f.id.value=id;");
                buf.append("f.submit();");
                buf.append("}");
            }
            if (this.isChangeExecutorKeyEnabled()) {
                buf.append("function changeExecutorKeyOne(id, newId){");
                buf.append("_changeExecutorKey(id, document.getElementById(newId).value);");
                buf.append("}");
                buf.append("function changeExecutorKeyMulti(){");
                buf.append("var checks=document.getElementsByName(\"check\");");
                buf.append("var executorKey=document.getElementById(\"executorKey\").value;");
                buf.append("var ids = new Array();");
                buf.append("var executorKeys = new Array();");
                buf.append("for(var i=0; i<checks.length; i++) {");
                buf.append("if(checks.item(i).checked) {");
                buf.append("ids.push(document.getElementById(\"id_\" + i).value);");
                buf.append("executorKeys.push(executorKey);");
                buf.append("}");
                buf.append("}");
                buf.append("if(ids.length == 0){");
                buf.append("return;");
                buf.append("}");
                buf.append("_changeExecutorKey(ids.toString(),executorKeys.toString());");
                buf.append("}");
                buf.append("function _changeExecutorKey(id, _new){");
                buf.append("var f=document.getElementById(\"changeExecutorKey\");");
                buf.append("f.id.value=id;");
                buf.append("f.executorKey.value=_new;");
                buf.append("f.submit();");
                buf.append("}");
            }
            if (this.isRescheduleEnabled()) {
                buf.append("function rescheduleOne(id,timeId,outputId){");
                buf.append("var time=document.getElementById(timeId).value;");
                buf.append("var output=document.getElementById(outputId).value;");
                buf.append("_reschedule(id,time,output);");
                buf.append("}");
                buf.append("function _rescheduleMulti(){");
                buf.append("var checks=document.getElementsByName(\"check\");");
                buf.append("var time=document.getElementById(\"time\").value;");
                buf.append("var output=document.getElementById(\"output\").value;");
                buf.append("var ids = new Array();");
                buf.append("var times = new Array();");
                buf.append("var outputs = new Array();");
                buf.append("for(var i=0; i<checks.length; i++) {");
                buf.append("if(checks.item(i).checked) {");
                buf.append("ids.push(document.getElementById(\"id_\" + i).value);");
                buf.append("times.push(time);");
                buf.append("outputs.push(output);");
                buf.append("}");
                buf.append("}");
                buf.append("if(ids.length == 0){");
                buf.append("return;");
                buf.append("}");
                buf.append("_reschedule(ids.toString(),times.toString(),outputs.toString());");
                buf.append("}");
                buf.append("function _reschedule(id,time,output){");
                buf.append("var f=document.getElementById(\"reschedule\");");
                buf.append("f.id.value=id;");
                buf.append("f.time.value=time;");
                buf.append("f.output.value=output;");
                buf.append("f.submit();");
                buf.append("}");
                buf.append("function showDepends(id){");
                buf.append("var f=document.getElementById(\"depends\");");
                buf.append("f.id.value=id;");
                buf.append("f.submit();");
                buf.append("}");
                buf.append("function showDepended(id){");
                buf.append("var f=document.getElementById(\"depended\");");
                buf.append("f.id.value=id;");
                buf.append("f.submit();");
                buf.append("}");
                buf.append("function allCheckState(){");
                buf.append("if(stateCheckFlg){");
                buf.append("stateCheckFlg=false;");
                buf.append("}else{");
                buf.append("stateCheckFlg=true;");
                buf.append("}");
                buf.append("allCheck('state', stateCheckFlg);");
                buf.append("}");
                buf.append("function allCheckTable(){");
                buf.append("if(tableCheckFlg){");
                buf.append("tableCheckFlg=false;");
                buf.append("}else{");
                buf.append("tableCheckFlg=true;");
                buf.append("}");
                buf.append("allCheck('check', tableCheckFlg);");
                buf.append("}");
                buf.append("function allCheck(id, checkFlag){");
                buf.append("var checks=document.getElementsByName(id);");
                buf.append("for(var i=0; i<checks.length; i++) {");
                buf.append("checks.item(i).checked=checkFlag");
                buf.append("}");
                buf.append("}");
            }
        }
        if (mode == 1 && this.isAddEnabled()) {
            buf.append("function addScheduleOne(masterId, inputId, dateId, startTimeId, endTimeId, retryEndTimeId, executorKeyId){");
            buf.append("var f=document.getElementById(\"addFromMaster\");");
            buf.append("f.masterId.value=masterId;");
            buf.append("f.input.value=document.getElementById(inputId).value;");
            buf.append("f.date.value=document.getElementById(dateId).value;");
            buf.append("f.startTime.value=document.getElementById(startTimeId).value;");
            buf.append("f.endTime.value=document.getElementById(endTimeId).value;");
            buf.append("f.retryEndTime.value=document.getElementById(retryEndTimeId).value;");
            buf.append("f.executorKey.value=document.getElementById(executorKeyId).value;");
            buf.append("f.submit();");
            buf.append("}");
        }
        buf.append("</script>");
        buf.append("</head>");
        return buf.toString();
    }

    private String scheduleSearchCondition(String action, String id, String groupId, String masterId, String masterGroupId, Date from, Date to, int[] states) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form name=\"schedule\" id=\"scheduleSearch\" action=\"" + action + "\" method=\"post\">");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append(this.th("Id", "left"));
        buf.append(this.td(this.text("id", null, this.format(id), 30)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("GroupId", "left"));
        buf.append(this.td(this.text("groupId", null, this.format(groupId), 30)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("MasterId", "left"));
        buf.append(this.td(this.text("masterId", null, this.format(masterId), 30)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("MasterGroupId", "left"));
        buf.append(this.td(this.text("masterGroupId", null, this.format(masterGroupId), 30)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("From [yyyyMMddHHmmssSSS]", "left"));
        buf.append(this.td(this.text("from", null, this.formatDateTime(from), 30)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("To [yyyyMMddHHmmssSSS]", "left"));
        buf.append(this.td(this.text("to", null, this.formatDateTime(to), 30)));
        buf.append("</tr>");
        buf.append(this.th("State [ <a href=\"#\" onclick=\"allCheckState();return false;\">all</a> ]", "left"));
        buf.append(this.td(this.stateCheckbox(states)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.td(this.button("ScheduleSearch", "document.getElementById('scheduleSearch').submit();"), null, 2));
        buf.append("</tr>");
        buf.append("</table>");
        buf.append(this.hidden("action", null, "schedule"));
        buf.append("</form>");
        buf.append("<form name=\"scheduleMaster\" id=\"scheduleMaster\" action=\"" + action + "\" target=\"_blank\" method=\"post\">");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append(this.th("MasterId", "left"));
        buf.append(this.td(this.text("masterId", null, "", 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("MasterGroupId", "left"));
        buf.append(this.td(this.text("masterGroupId", null, "", 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.td(this.button("ScheduleMasterSearch", "document.getElementById('scheduleMaster').submit();"), null, 2));
        buf.append("</tr>");
        buf.append("</table>");
        buf.append(this.hidden("action", null, "scheduleMaster"));
        buf.append("</form>");
        if (this.isChangeStateEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("State", "left"));
            buf.append(this.td(this.stateSelect("newState", "newState", -1)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("ChangeState", "javascript:changeStateMulti();"), null, 2));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("</table>");
        }
        if (this.isChangeControlStateEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("ControlState", "left"));
            buf.append(this.td(this.controlStateSelect("newControlState", "newControlState", -1)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("ChangeControlState", "javascript:changeControlStateMulti();"), null, 2));
            buf.append("</tr>");
            buf.append("</table>");
        }
        if (this.isChangeExecutorKeyEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("ExecutorKey", "left"));
            buf.append(this.td(this.text("executorKey", "executorKey", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("ChangeExecutorKey", "javascript:changeExecutorKeyMulti();"), null, 2));
            buf.append("</tr>");
            buf.append("</table>");
        }
        if (this.isRescheduleEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("Time", "left"));
            buf.append(this.td(this.text("time", "time", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Output", "left"));
            buf.append(this.td(this.textarea("output", "output", "", 50, 3, false)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("Reschedule", "javascript:_rescheduleMulti();"), null, 2));
            buf.append("</tr>");
            buf.append("</table>");
        }
        if (this.isRemoveEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("Remove", "left"));
            buf.append(this.td(this.button("RemoveSchedules", "javascript:_removeMulti();")));
            buf.append("</tr>");
            buf.append("</table>");
        }
        if (this.isStopEntryEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<tr>");
            buf.append(this.th("Entry", "left"));
            if (this.scheduler.isStartEntry()) {
                buf.append(this.td("StartEntry"));
                buf.append("</tr>");
                buf.append("<tr>");
                buf.append(this.td(this.button("StopEntry", "javascript:document.getElementById('stopEntry').submit();"), null, 2));
            } else {
                buf.append(this.td("StopEntry"));
                buf.append("</tr>");
                buf.append("<tr>");
                buf.append(this.td(this.button("StartEntry", "javascript:document.getElementById('startEntry').submit();"), null, 2));
            }
            buf.append("</tr>");
            buf.append("</table><br clear=\"left\">");
        }
        if (this.isAddEnabled()) {
            buf.append("<form name=\"addSchedule\" id=\"addSchedule\" action=\"" + action + "\" method=\"post\">");
            buf.append("<table border=\"1\">");
            buf.append("<tr>");
            buf.append(this.th("MasterId", "left"));
            buf.append(this.td(this.text("masterId", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("GroupId", "left"));
            buf.append(this.td(this.text("groupId", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Time", "left"));
            buf.append(this.td(this.text("time", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("TaskName", "left"));
            buf.append(this.td(this.text("taskName", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Input", "left"));
            buf.append(this.td(this.textarea("input", "", "", 50, 3, false)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Depends", "left"));
            buf.append(this.td(this.text("depends", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("ExecutorKey", "left"));
            buf.append(this.td(this.text("executorKey", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("ExecutorType", "left"));
            buf.append(this.td(this.text("executorType", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("RetryInterval", "left"));
            buf.append(this.td(this.text("retryInterval", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("RetryEndTime", "left"));
            buf.append(this.td(this.text("retryEndTime", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("MaxDelayTime", "left"));
            buf.append(this.td(this.text("maxDelayTime", "", "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("AddSchedule", "javascript:document.getElementById('addSchedule').submit();"), null, 2));
            buf.append("</tr>");
            buf.append("</table>");
            buf.append(this.hidden("action", null, "add"));
            buf.append("</form>");
        }
        return buf.toString();
    }

    private String schedules(String action, List schedules) {
        StringBuffer buf = new StringBuffer();
        buf.append("<table border=\"1\"><tr>");
        buf.append(this.th("Legend"));
        buf.append("<td bgcolor=\"#ffadad\">FAILED</td>");
        buf.append("<td bgcolor=\"#ffffad\">RUN</td>");
        buf.append("<td bgcolor=\"#ffadff\">TIMEOVER</td>");
        buf.append("<td bgcolor=\"#a9a9a9\">END</td>");
        buf.append("<td bgcolor=\"#add6ff\">DISABLE</td>");
        buf.append("<td bgcolor=\"#ffd6ad\">PAUSE or ABORT</td>");
        buf.append("</tr></table>");
        buf.append("<br>");
        buf.append("<table border=\"1\">");
        buf.append("<tr bgcolor=\"#cccccc\">");
        buf.append(this.th("<a href=\"#\" onclick=\"allCheckTable();return false;\">#</a>"));
        buf.append(this.th("Id"));
        buf.append(this.th("GroupId"));
        buf.append(this.th("MasterId"));
        buf.append(this.th("MasterGroupIds"));
        buf.append(this.th("Time"));
        buf.append(this.th("TaskName"));
        buf.append(this.th("Input"));
        buf.append(this.th("Depends"));
        buf.append(this.th("Depended"));
        buf.append(this.th("Output"));
        buf.append(this.th("InitialTime"));
        buf.append(this.th("RetryInterval"));
        buf.append(this.th("RetryEndTime"));
        buf.append(this.th("Retry"));
        buf.append(this.th("MaxDelayTime"));
        buf.append(this.th("State"));
        buf.append(this.th("ControlState"));
        buf.append(this.th("CheckState"));
        buf.append(this.th("ExecutorKey"));
        buf.append(this.th("ExecutorType"));
        buf.append(this.th("ExecuteStartTime"));
        buf.append(this.th("ExecuteEndTime"));
        if (this.isRescheduleEnabled()) {
            buf.append(this.th("Reschedule"));
        }
        if (this.isRemoveEnabled()) {
            buf.append(this.th("Remove"));
        }
        buf.append("</tr>");
        int count = 0;
        if (schedules != null) {
            for (int i = 0; i < schedules.size(); ++i) {
                Schedule schedule = (Schedule)schedules.get(i);
                int state = schedule.getState();
                int controlState = schedule.getControlState();
                int checkState = schedule.getCheckState();
                String name = null;
                String tr = "<tr>";
                switch (state) {
                    case 3: {
                        tr = "<tr bgcolor=\"#ffffad\" title=\"RUN\">";
                        break;
                    }
                    case 4: {
                        tr = "<tr bgcolor=\"#a9a9a9\" title=\"END\">";
                        break;
                    }
                    case 5: {
                        tr = "<tr bgcolor=\"#ffadad\" title=\"FAILED\">";
                        break;
                    }
                    case 9: {
                        tr = "<tr bgcolor=\"#add6ff\" title=\"DISABLE\">";
                        break;
                    }
                    case 6: 
                    case 7: {
                        tr = "<tr bgcolor=\"#ffd6ad\" title=\"PAUSE or ABORT\">";
                    }
                }
                buf.append(tr);
                String id = schedule.getId();
                buf.append(this.td(this.checkbox("check", count, null) + this.hidden("id", "id_" + count, id) + this.hidden("state", "state_" + count, String.valueOf(state)) + this.hidden("controlState", "controlState_" + count, String.valueOf(controlState))));
                buf.append(this.td(this.format(id)));
                buf.append(this.td(this.format(schedule.getGroupId())));
                buf.append(this.td(this.format(schedule.getMasterId())));
                buf.append(this.td(this.format(schedule.getMasterGroupIds())));
                String time = this.formatDateTime(schedule.getTime());
                buf.append(this.td(time));
                buf.append(this.td(this.format(schedule.getTaskName())));
                buf.append(this.td(this.textarea(this.format(schedule.getInput()), 50, 3)));
                buf.append(this.td(this.button("ShowDepends", "javascript:showDepends('" + id + "');")));
                buf.append(this.td(this.button("ShowDepended", "javascript:showDepended('" + id + "');")));
                String output = this.format(schedule.getOutput());
                buf.append(this.td(this.textarea(output, 50, 3)));
                buf.append(this.td(this.formatDateTime(schedule.getInitialTime())));
                buf.append(this.td(schedule.getRetryInterval()));
                buf.append(this.td(this.formatDateTime(schedule.getRetryEndTime())));
                buf.append(this.td(schedule.isRetry()));
                buf.append(this.td(schedule.getMaxDelayTime()));
                StringBuffer tdBuf = new StringBuffer();
                tdBuf.append(this.getScheduleStateString(state));
                if (this.isChangeStateEnabled()) {
                    name = "newState_" + count;
                    tdBuf.append("&nbsp:&nbsp" + this.stateSelect(name, name, state));
                    tdBuf.append(this.button("ChangeState", "javascript:changeStateOne('" + id + "','" + state + "','" + name + "');"));
                }
                buf.append(this.td(tdBuf.toString()));
                tdBuf.setLength(0);
                tdBuf.append(this.getScheduleControlStateString(controlState));
                if (this.isChangeControlStateEnabled()) {
                    name = "newControlState_" + count;
                    tdBuf.append("&nbsp:&nbsp" + this.controlStateSelect(name, name, controlState));
                    tdBuf.append(this.button("ChangeControlState", "javascript:changeControlStateOne('" + id + "','" + controlState + "','" + name + "');"));
                }
                buf.append(this.td(tdBuf.toString()));
                tdBuf.setLength(0);
                buf.append("<td nowrap");
                if (2 == checkState) {
                    buf.append(" bgcolor=\"#ffadff\" title=\"TIMEOVER\"");
                }
                buf.append(">" + this.getScheduleCheckStateString(checkState) + "</td>");
                String executorKey = this.format(schedule.getExecutorKey());
                tdBuf.append(executorKey);
                if (this.isChangeExecutorKeyEnabled()) {
                    name = "newExecutorKey_" + count;
                    tdBuf.append("&nbsp:&nbsp" + this.text(name, name, executorKey, 10));
                    tdBuf.append(this.button("ChangeExecutorKey", "javascript:changeExecutorKeyOne('" + id + "','" + name + "');"));
                }
                buf.append(this.td(tdBuf.toString()));
                tdBuf.setLength(0);
                buf.append(this.td(this.format(schedule.getExecutorType())));
                buf.append(this.td(this.formatDateTime(schedule.getExecuteStartTime())));
                buf.append(this.td(this.formatDateTime(schedule.getExecuteEndTime())));
                if (this.isRescheduleEnabled()) {
                    String timeName = "time_" + count;
                    tdBuf.append("Time:" + this.text(timeName, timeName, time, 15) + "&nbsp");
                    String outputName = "output_" + count;
                    tdBuf.append("Output:" + this.textarea(outputName, outputName, output, 50, 3, false));
                    buf.append(this.td(tdBuf.toString() + "&nbsp" + this.button("Reschedule", "javascript:rescheduleOne('" + id + "','" + timeName + "','" + outputName + "');")));
                }
                if (this.isRemoveEnabled()) {
                    buf.append(this.td(this.button("Remove", "javascript:removeOne('" + id + "');")));
                }
                buf.append("</tr>");
                ++count;
            }
        }
        buf.append("</table>");
        if (this.isChangeStateEnabled()) {
            buf.append("<form name=\"changeState\" id=\"changeState\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "changeState"));
            buf.append(this.hidden("oldState", null, ""));
            buf.append(this.hidden("newState", null, ""));
            buf.append(this.hidden("id", null, ""));
            buf.append("</form>");
        }
        if (this.isChangeControlStateEnabled()) {
            buf.append("<form name=\"changeControlState\" id=\"changeControlState\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "changeControlState"));
            buf.append(this.hidden("oldState", null, ""));
            buf.append(this.hidden("newState", null, ""));
            buf.append(this.hidden("id", null, ""));
            buf.append("</form>");
        }
        if (this.isRemoveEnabled()) {
            buf.append("<form name=\"removeSchedule\" id=\"removeSchedule\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "remove"));
            buf.append(this.hidden("id", null, ""));
            buf.append("</form>");
        }
        if (this.isRescheduleEnabled()) {
            buf.append("<form name=\"reschedule\" id=\"reschedule\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "reschedule"));
            buf.append(this.hidden("id", null, ""));
            buf.append(this.hidden("time", null, ""));
            buf.append(this.hidden("output", null, ""));
            buf.append("</form>");
        }
        if (this.isChangeExecutorKeyEnabled()) {
            buf.append("<form name=\"changeExecutorKey\" id=\"changeExecutorKey\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "changeExecutorKey"));
            buf.append(this.hidden("id", null, ""));
            buf.append(this.hidden("executorKey", null, ""));
            buf.append("</form>");
        }
        if (this.isStopEntryEnabled()) {
            buf.append("<form name=\"stopEntry\" id=\"stopEntry\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "stopEntry"));
            buf.append("</form>");
            buf.append("<form name=\"startEntry\" id=\"startEntry\" action=\"" + action + "\" method=\"post\"  style=\"display: inline\">");
            buf.append(this.hidden("action", null, "startEntry"));
            buf.append("</form>");
        }
        buf.append("<form name=\"depends\" id=\"depends\" action=\"" + action + "\" method=\"post\" target=\"_blank\" style=\"display: inline\">");
        buf.append(this.hidden("action", null, "depends"));
        buf.append(this.hidden("id", null, ""));
        buf.append("</form>");
        buf.append("<form name=\"depended\" id=\"depended\" action=\"" + action + "\" method=\"post\" target=\"_blank\" style=\"display: inline\">");
        buf.append(this.hidden("action", null, "depended"));
        buf.append(this.hidden("id", null, ""));
        buf.append("</form>");
        return buf.toString();
    }

    private String scheduleMasterSearchCondition(String action, String masterId, String masterGroupId) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form name=\"scheduleMaster\" id=\"scheduleMaster\" action=\"" + action + "\" method=\"post\">");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append(this.th("MasterId", "left"));
        buf.append(this.td(this.text("masterId", null, this.format(masterId), 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("MasterGroupId", "left"));
        buf.append(this.td(this.text("masterGroupId", null, this.format(masterGroupId), 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.td(this.button("ScheduleMasterSearch", "document.getElementById('scheduleMaster').submit();"), null, 2));
        buf.append("</tr>");
        buf.append("</table>");
        buf.append(this.hidden("action", null, "scheduleMaster"));
        buf.append("</form>");
        if (this.isAddEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<form name=\"addFromMaster\" id=\"addFromMaster\" action=\"" + action + "\" method=\"post\">");
            buf.append("<tr>");
            buf.append(this.th("MasterId", "left"));
            buf.append(this.td(this.text("masterId", null, "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("MasterGroupId", "left"));
            buf.append(this.td(this.text("masterGroupId", null, "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("groupId", "left"));
            buf.append(this.td(this.text("groupId", null, "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Input", "left"));
            buf.append(this.td(this.textarea("input", "", "", 50, 3, false)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("Date [yyyyMMdd]", "left"));
            buf.append(this.td(this.text("date", null, "", 10)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("StartTime [HHmmssSSS]", "left"));
            buf.append(this.td(this.text("startTime", null, "", 10)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("EndTime [HHmmssSSS]", "left"));
            buf.append(this.td(this.text("endTime", null, "", 10)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("RetryEndTime [HHmmssSSS]", "left"));
            buf.append(this.td(this.text("retryEndTime", null, "", 10)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.th("ExecutorKey", "left"));
            buf.append(this.td(this.text("executorKey", null, "", 20)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("AddSchedule", "javascript:document.getElementById('addFromMaster').submit();"), null, 2));
            buf.append("</tr>");
            buf.append(this.hidden("action", null, "addFromMaster"));
            buf.append("</form>");
            buf.append("</table>");
        }
        if (this.isMakeEnabled()) {
            buf.append("<table border=\"1\" align=\"left\">");
            buf.append("<form name=\"makeSchedule\" id=\"makeSchedule\" action=\"" + action + "\" method=\"post\">");
            buf.append("<tr>");
            buf.append(this.th("Date [yyyyMMdd]", "left"));
            buf.append(this.td(this.text("date", null, "", 10)));
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append(this.td(this.button("MakeSchedule", "javascript:document.getElementById('makeSchedule').submit();"), null, 2));
            buf.append("</tr>");
            buf.append(this.hidden("action", null, "makeSchedule"));
            buf.append("</form>");
            buf.append("</table>");
        }
        buf.append("<table border=\"1\" align=\"left\">");
        buf.append("<form name=\"isMakeSchedule\" id=\"isMakeSchedule\" action=\"" + action + "\" target=\"_blank\" method=\"post\">");
        buf.append("<tr>");
        buf.append(this.th("MasterId", "left"));
        buf.append(this.td(this.text("masterId", null, "", 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("From [yyyyMMdd]", "left"));
        buf.append(this.td(this.text("from", null, "", 10)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("To [yyyyMMdd]", "left"));
        buf.append(this.td(this.text("to", null, "", 10)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.td(this.button("IsMakeSchedule", "javascript:document.getElementById('isMakeSchedule').submit();"), null, 2));
        buf.append("</tr>");
        buf.append(this.hidden("action", null, "isMakeSchedule"));
        buf.append("</form>");
        buf.append("</table><br clear=\"left\">");
        return buf.toString();
    }

    private String scheduleMasters(String action, List scheduleMasters) {
        StringBuffer buf = new StringBuffer();
        buf.append("<table border=\"1\">");
        buf.append("<tr bgcolor=\"#cccccc\">");
        buf.append(this.th("MasterId"));
        buf.append(this.th("MasterGroupIds"));
        buf.append(this.th("TaskName"));
        buf.append(this.th("ScheduleType"));
        buf.append(this.th("Input"));
        buf.append(this.th("StartTime"));
        buf.append(this.th("EndTime"));
        buf.append(this.th("RepeatInterval"));
        buf.append(this.th("RetryInterval"));
        buf.append(this.th("RetryEndTime"));
        buf.append(this.th("MaxDelayTime"));
        buf.append(this.th("Enable"));
        buf.append(this.th("ExecutorKey"));
        buf.append(this.th("ExecutorType"));
        buf.append(this.th("Template"));
        buf.append(this.th("addSchedule"));
        buf.append("</tr>");
        if (scheduleMasters != null) {
            int count = 0;
            for (int i = 0; i < scheduleMasters.size(); ++i) {
                ScheduleMaster scheduleMaster = (ScheduleMaster)scheduleMasters.get(i);
                buf.append("<tr>");
                String masterId = this.format(scheduleMaster.getId());
                buf.append(this.td(masterId));
                buf.append(this.td(this.format(scheduleMaster.getGroupIds())));
                buf.append(this.td(this.format(scheduleMaster.getTaskName())));
                buf.append(this.td(this.format(scheduleMaster.getScheduleType())));
                String input = this.format(scheduleMaster.getInput());
                buf.append(this.td(this.textarea(input, 50, 3)));
                String startTime = this.formatTime(scheduleMaster.getStartTime());
                buf.append(this.td(startTime));
                String endTime = this.formatTime(scheduleMaster.getEndTime());
                buf.append(this.td(endTime));
                buf.append(this.td(scheduleMaster.getRepeatInterval()));
                buf.append(this.td(scheduleMaster.getRetryInterval()));
                String retryEndTime = this.formatTime(scheduleMaster.getRetryEndTime());
                buf.append(this.td(retryEndTime));
                buf.append(this.td(scheduleMaster.getMaxDelayTime()));
                buf.append(this.td(scheduleMaster.isEnabled()));
                String executorKey = this.format(scheduleMaster.getExecutorKey());
                buf.append(this.td(executorKey));
                buf.append(this.td(this.format(scheduleMaster.getExecutorType())));
                buf.append(this.td(scheduleMaster.isTemplate()));
                StringBuffer tdBuf = new StringBuffer();
                if (this.isAddEnabled()) {
                    String dateName = "date_" + count;
                    tdBuf.append("Date[yyyyMMdd]:" + this.text(dateName, dateName, "", 10) + "&nbsp");
                    String startTimeName = "startTime_" + count;
                    tdBuf.append("StartTime[HHmmssSSS]:" + this.text(startTimeName, startTimeName, startTime, 10) + "&nbsp");
                    String endTimeName = "endTime_" + count;
                    tdBuf.append("EndTime[HHmmssSSS]:" + this.text(endTimeName, endTimeName, endTime, 10) + "<br>");
                    String retryEndTimeName = "retryEndTime_" + count;
                    tdBuf.append("RetryEndTime[HHmmssSSS]:" + this.text(retryEndTimeName, retryEndTimeName, retryEndTime, 10) + "&nbsp");
                    String inputName = "input_" + count;
                    tdBuf.append("Input:" + this.textarea(inputName, inputName, input, 50, 3, false) + "&nbsp");
                    String executorKeyName = "executorKey_" + count;
                    tdBuf.append("ExecutorKey:" + this.text(executorKeyName, executorKeyName, executorKey, 10) + "&nbsp");
                    buf.append(this.td(tdBuf.toString() + "&nbsp" + this.button("AddSchedule", "javascript:addScheduleOne('" + masterId + "','" + inputName + "','" + dateName + "','" + startTimeName + "','" + endTimeName + "','" + retryEndTimeName + "','" + executorKeyName + "');")));
                }
                buf.append("</tr>");
                ++count;
            }
        }
        buf.append("</table>");
        return buf.toString();
    }

    private String scheduleMasterIsMakeCondition(String action, String masterId, Date from, Date to) {
        StringBuffer buf = new StringBuffer();
        buf.append("<form name=\"isMakeSchedule\" id=\"isMakeSchedule\" action=\"" + action + "\" method=\"post\">");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append(this.th("MasterId", "left"));
        buf.append(this.td(this.text("masterId", null, this.format(masterId), 20)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("From [yyyyMMdd]", "left"));
        buf.append(this.td(this.text("from", null, this.formatDate(from), 10)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.th("To [yyyyMMdd]", "left"));
        buf.append(this.td(this.text("to", null, this.formatDate(to), 10)));
        buf.append("</tr>");
        buf.append("<tr>");
        buf.append(this.td(this.button("IsMakeSchedule", "javascript:document.getElementById('isMakeSchedule').submit();"), null, 2));
        buf.append("</tr>");
        buf.append("</table>");
        buf.append(this.hidden("action", null, "isMakeSchedule"));
        buf.append("</form>");
        return buf.toString();
    }

    private String scheduleMasterIsMake(String action, Map masterIdDayMap) {
        StringBuffer buf = new StringBuffer();
        buf.append("<table border=\"1\">");
        buf.append("<tr bgcolor=\"#cccccc\">");
        buf.append(this.th("MasterId"));
        Iterator entries = masterIdDayMap.entrySet().iterator();
        if (entries.hasNext()) {
            Map.Entry e = entries.next();
            Map map = (Map)e.getValue();
            for (Date date : map.keySet()) {
                buf.append(this.th(this.formatDate(date)));
            }
        }
        buf.append("</tr>");
        if (masterIdDayMap != null) {
            for (Map.Entry e : masterIdDayMap.entrySet()) {
                buf.append("<tr>");
                String masterId = (String)e.getKey();
                buf.append(this.th(this.format(masterId)));
                Map map = (Map)e.getValue();
                for (Boolean isMake : map.values()) {
                    StringBuffer tdBuf = new StringBuffer();
                    tdBuf.append(isMake);
                    buf.append(this.td(tdBuf.toString()));
                }
                buf.append("</tr>");
            }
        }
        buf.append("</table>");
        return buf.toString();
    }

    private String th(String data) {
        return this.th(data, null);
    }

    private String th(String data, String align) {
        return this.th(data, align, 0);
    }

    private String th(String data, String align, int colspan) {
        StringBuffer buf = new StringBuffer();
        buf.append("<th");
        if (align != null && align.length() != 0) {
            buf.append(" align=\"" + align + "\"");
        }
        if (colspan > 1) {
            buf.append(" colspan=\"" + colspan + "\"");
        }
        buf.append(">" + data + "</th>");
        return buf.toString();
    }

    private String td(long data) {
        return this.td(String.valueOf(data), "right");
    }

    private String td(boolean data) {
        return this.td(String.valueOf(data), null);
    }

    private String td(String data) {
        return this.td(data, null);
    }

    private String td(String data, String align) {
        return this.td(data, align, 0);
    }

    private String td(String data, String align, int colspan) {
        StringBuffer buf = new StringBuffer();
        buf.append("<td valign=\"middle\"");
        if (align != null && align.length() != 0) {
            buf.append(" align=\"" + align + "\"");
        }
        if (colspan > 1) {
            buf.append(" colspan=\"" + colspan + "\"");
        }
        buf.append(" nowrap>" + data + "</td>");
        return buf.toString();
    }

    private String text(String name, String id, String value, int size) {
        return this.input("text", name, id, value, size);
    }

    private String hidden(String name, String id, String value) {
        return this.input("hidden", name, id, value, 0);
    }

    private String input(String type, String name, String id, String value, int size) {
        StringBuffer buf = new StringBuffer();
        buf.append("<input type=\"" + type + "\" name=\"" + name + "\" value=\"" + value + "\"");
        if (id != null) {
            buf.append(" id=\"" + id + "\"");
        }
        if (size > 0) {
            buf.append(" size=\"" + size + "\"");
        }
        buf.append(">");
        return buf.toString();
    }

    private String textarea(String value, int cols, int rows) {
        return this.textarea(null, null, value, cols, rows, true);
    }

    private String textarea(String name, String id, String value, int cols, int rows, boolean readOnly) {
        StringBuffer buf = new StringBuffer();
        buf.append("<textarea ");
        if (readOnly) {
            buf.append("readonly ");
        }
        if (name != null) {
            buf.append("name=\"" + name + "\" ");
        }
        if (id != null) {
            buf.append("id=\"" + id + "\" ");
        }
        buf.append("cols=" + cols + " rows=" + rows + " style=\"vertical-align:middle\">");
        buf.append(value);
        buf.append("</textarea>");
        return buf.toString();
    }

    private String button(String value, String onClick) {
        return "<input type=\"button\" value=\"" + value + "\" onclick=\"" + onClick + "\">";
    }

    private String stateCheckbox(int[] states) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.checkbox("state", 1, states) + "<label for=\"state" + 1 + "\">" + this.getScheduleStateString(1) + "</label>&nbsp");
        buf.append(this.checkbox("state", 2, states) + "<label for=\"state" + 2 + "\">" + this.getScheduleStateString(2) + "</label>&nbsp");
        buf.append(this.checkbox("state", 3, states) + "<label for=\"state" + 3 + "\">" + this.getScheduleStateString(3) + "</label>&nbsp");
        buf.append(this.checkbox("state", 4, states) + "<label for=\"state" + 4 + "\">" + this.getScheduleStateString(4) + "</label>&nbsp");
        buf.append(this.checkbox("state", 5, states) + "<label for=\"state" + 5 + "\">" + this.getScheduleStateString(5) + "</label>&nbsp");
        buf.append(this.checkbox("state", 6, states) + "<label for=\"state" + 6 + "\">" + this.getScheduleStateString(6) + "</label>&nbsp");
        buf.append(this.checkbox("state", 7, states) + "<label for=\"state" + 7 + "\">" + this.getScheduleStateString(7) + "</label>&nbsp");
        buf.append(this.checkbox("state", 8, states) + "<label for=\"state" + 8 + "\">" + this.getScheduleStateString(8) + "</label>&nbsp");
        buf.append(this.checkbox("state", 9, states) + "<label for=\"state" + 9 + "\">" + this.getScheduleStateString(9) + "</label>&nbsp");
        return buf.toString();
    }

    private String checkbox(String name, int value, int[] states) {
        StringBuffer buf = new StringBuffer();
        buf.append("<input type=\"checkbox\" name=\"" + name + "\" value=\"" + value + "\" id=\"" + name + value + "\"");
        if (states != null) {
            for (int i = 0; i < states.length; ++i) {
                if (value != states[i]) continue;
                buf.append("checked=\"checked\"");
            }
        }
        buf.append(">");
        return buf.toString();
    }

    private String stateSelect(String name, String id, int state) {
        StringBuffer buf = new StringBuffer();
        buf.append("<select name=\"" + name + "\" id=\"" + id + "\" >");
        buf.append(this.option(1, state, 0));
        buf.append(this.option(4, state, 0));
        buf.append(this.option(5, state, 0));
        buf.append(this.option(9, state, 0));
        buf.append("</select>");
        return buf.toString();
    }

    private String controlStateSelect(String name, String id, int state) {
        StringBuffer buf = new StringBuffer();
        buf.append("<select name=\"" + name + "\" id=\"" + id + "\" >");
        buf.append(this.option(1, state, 1));
        buf.append(this.option(2, state, 1));
        buf.append(this.option(3, state, 1));
        buf.append(this.option(4, state, 1));
        buf.append("</select>");
        return buf.toString();
    }

    private String option(int value, int state, int mode) {
        StringBuffer buf = new StringBuffer();
        buf.append("<option value=\"" + value + "\"");
        if (value == state) {
            buf.append(" selected");
        }
        buf.append(">");
        if (mode == 0) {
            buf.append(this.getScheduleStateString(value));
        } else {
            buf.append(this.getScheduleControlStateString(value));
        }
        buf.append("</option>");
        return buf.toString();
    }

    private String format(Object val) {
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    private String format(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }

    private String formatDateTime(Date date) {
        return this.format(date, "yyyyMMddHHmmssSSS");
    }

    private String formatTime(Date date) {
        return this.format(date, "HHmmssSSS");
    }

    private String formatDate(Date date) {
        return this.format(date, "yyyyMMdd");
    }

    private String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(format).format(date);
    }

    private String format(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringArrayEditor editor = new StringArrayEditor();
        editor.setValue(array);
        return editor.getAsText();
    }

    private String getScheduleStateString(int state) {
        switch (state) {
            case 1: {
                return this.padding("INITIAL", 7);
            }
            case 2: {
                return this.padding("ENTRY", 7);
            }
            case 3: {
                return this.padding("RUN", 7);
            }
            case 4: {
                return this.padding("END", 7);
            }
            case 5: {
                return this.padding("FAILED", 7);
            }
            case 6: {
                return this.padding("PAUSE", 7);
            }
            case 7: {
                return this.padding("ABORT", 7);
            }
            case 8: {
                return this.padding("RETRY", 7);
            }
            case 9: {
                return this.padding("DISABLE", 7);
            }
        }
        return this.padding("UNKNOWN", 7);
    }

    private String getScheduleControlStateString(int state) {
        switch (state) {
            case 1: {
                return this.padding("INITIAL", 7);
            }
            case 2: {
                return this.padding("PAUSE", 7);
            }
            case 3: {
                return this.padding("RESUME", 7);
            }
            case 4: {
                return this.padding("ABORT", 7);
            }
            case 5: {
                return this.padding("FAILED", 7);
            }
        }
        return this.padding("UNKNOWN", 7);
    }

    private String getScheduleCheckStateString(int state) {
        switch (state) {
            case 1: {
                return "INITIAL";
            }
            case 2: {
                return "TIMEOVER";
            }
        }
        return "UNKNOWN";
    }

    private String padding(String val, int length) {
        StringBuffer buf = new StringBuffer();
        if (val != null) {
            buf.append(val);
        }
        while (buf.length() < length) {
            buf.append("&nbsp");
        }
        return buf.toString();
    }
}

