/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.lang.reflect.Field;
import jp.ossc.nimbus.beans.Utility;

public class StringEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -6687819269846555560L;

    @Override
    public void setAsText(String text) {
        int index;
        if (text == null) {
            this.setValue(null);
            return;
        }
        String tmp = Utility.replaceSystemProperty(text);
        if (tmp.indexOf(92) != -1) {
            tmp = Utility.unicodeConvert(tmp);
        }
        if (tmp != null && tmp.length() > 1 && tmp.charAt(0) == '\"' && tmp.charAt(tmp.length() - 1) == '\"') {
            tmp = tmp.substring(1, tmp.length() - 1);
        }
        if ((index = tmp.lastIndexOf(".")) > 0 && index != tmp.length() - 1) {
            String className = tmp.substring(0, index);
            String fieldName = tmp.substring(index + 1);
            try {
                Class clazz = Utility.convertStringToClass(className);
                Field field = clazz.getField(fieldName);
                if (String.class.equals(field.getType())) {
                    tmp = (String)field.get(null);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        this.setValue(tmp);
    }

    @Override
    public String getAsText() {
        Object val = this.getValue();
        return val == null ? null : val.toString();
    }
}

