/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.ossc.nimbus.beans.BeanTableIndexKeyFactory;
import jp.ossc.nimbus.beans.BeanTableIndexManager;
import jp.ossc.nimbus.beans.BeanTableView;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RecordList
implements Externalizable,
List,
Cloneable,
PartUpdate {
    private static final long serialVersionUID = 6399184480196775369L;
    public static final String PRIMARY_KEY_INDEX_NAME = "$PRIMARY_KEY";
    protected String name;
    protected String schema;
    protected Class recordClass;
    protected RecordSchema recordSchema;
    protected List records = Collections.synchronizedList(new ArrayList());
    protected BeanTableIndexManager indexManager;
    protected int modCount = 0;
    protected int[] partUpdateOrderBy;
    protected boolean[] partUpdateIsAsc;
    protected boolean isSynchronized = true;

    public RecordList() {
        this(true);
    }

    public RecordList(boolean isSynch) {
        this(null, isSynch);
    }

    public RecordList(String name) {
        this(name, true);
    }

    public RecordList(String name, boolean isSynch) {
        this.name = name;
        this.isSynchronized = isSynch;
        this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        this.setRecordClass(Record.class);
    }

    public RecordList(String name, String schema) throws PropertySchemaDefineException {
        this(name, schema, true);
    }

    public RecordList(String name, String schema, boolean isSynch) throws PropertySchemaDefineException {
        this(name, RecordSchema.getInstance(schema), isSynch);
    }

    public RecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        this(name, schema, true);
    }

    public RecordList(String name, RecordSchema schema, boolean isSynch) throws PropertySchemaDefineException {
        this.name = name;
        this.isSynchronized = isSynch;
        this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        this.setRecordClass(Record.class);
        this.setRecordSchema(schema);
    }

    public RecordList(String name, Class clazz) throws PropertySchemaDefineException {
        this(name, clazz, true);
    }

    public RecordList(String name, Class clazz, boolean isSynch) throws PropertySchemaDefineException {
        this.name = name;
        this.isSynchronized = isSynch;
        this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        this.setRecordClass(clazz);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordSchema(RecordSchema.getInstance(schema));
    }

    public String getSchema() {
        return this.schema;
    }

    public void setRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.size() != 0) {
            throw new PropertySchemaDefineException("Record already exists.");
        }
        this.recordSchema = schema;
        this.schema = schema == null ? null : schema.getSchema();
        ArrayList<String> primaryKeyNames = null;
        PropertySchema[] primaryKeys = this.recordSchema.getPrimaryKeyPropertySchemata();
        if (primaryKeys != null) {
            for (int i = 0; i < primaryKeys.length; ++i) {
                if (primaryKeyNames == null) {
                    primaryKeyNames = new ArrayList<String>();
                }
                primaryKeyNames.add(primaryKeys[i].getName());
            }
        }
        if (primaryKeyNames == null) {
            this.removeIndex(PRIMARY_KEY_INDEX_NAME);
        } else {
            this.setIndex(PRIMARY_KEY_INDEX_NAME, primaryKeyNames.toArray(new String[primaryKeyNames.size()]));
        }
    }

    public void replaceSchema(String schema) throws PropertySchemaDefineException {
        this.replaceRecordSchema(RecordSchema.getInstance(schema));
    }

    public void replaceRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.recordSchema != null && schema != null && this.size() != 0) {
            int imax = this.records.size();
            for (int i = 0; i < imax; ++i) {
                Record record = (Record)this.records.get(i);
                record.replaceRecordSchema(schema);
            }
        }
        this.setRecordSchema(schema);
    }

    public void appendSchema(String schema) throws PropertySchemaDefineException {
        if (this.recordSchema == null) {
            this.setSchema(schema);
        } else {
            this.replaceRecordSchema(this.recordSchema.appendSchema(schema));
        }
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    public void setRecordClass(Class clazz) throws PropertySchemaDefineException {
        if (Record.class.equals((Object)clazz)) {
            this.indexManager = new BeanTableIndexManager(clazz, this.isSynchronized);
        } else {
            Record record = null;
            try {
                record = (Record)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new PropertySchemaDefineException(null, e);
            }
            catch (IllegalAccessException e) {
                throw new PropertySchemaDefineException(null, e);
            }
            catch (ClassCastException e) {
                throw new PropertySchemaDefineException(null, e);
            }
            this.recordClass = clazz;
            this.indexManager = new BeanTableIndexManager(clazz, this.isSynchronized);
            if (record.getRecordSchema() != null) {
                this.setRecordSchema(record.getRecordSchema());
            }
        }
    }

    public Class getRecordClass() {
        return this.recordClass == null ? Record.class : this.recordClass;
    }

    public Record createRecord() {
        if (this.recordClass == null) {
            return new Record(this.recordSchema);
        }
        try {
            return (Record)this.recordClass.newInstance();
        }
        catch (Exception e) {
            return new Record(this.recordSchema);
        }
    }

    public Record getRecord(int index) {
        return (Record)this.get(index);
    }

    public void addRecord(Record r) {
        this.add(r);
    }

    public void addRecord(int index, Record r) {
        this.add(index, r);
    }

    public Record setRecord(int index, Record r) {
        return (Record)this.set(index, r);
    }

    public void removeRecord(Record r) {
        this.remove(r);
    }

    public Record removeRecord(int index) {
        return (Record)this.remove(index);
    }

    public void setIndex(String name, String[] props) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        for (int i = 0; i < props.length; ++i) {
            if (this.recordSchema.getPropertySchema(props[i]) != null) continue;
            throw new PropertyGetException(null, "No such property : " + props[i]);
        }
        try {
            this.indexManager.setIndex(name, props);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyGetException(null, "No such property", e);
        }
    }

    public void setIndex(String name, BeanTableIndexKeyFactory keyFactory) {
        this.indexManager.setIndex(name, keyFactory);
    }

    public void removeIndex(String name) {
        this.indexManager.removeIndex(name);
    }

    public void analyzeIndex() {
        this.indexManager.clear();
        this.indexManager.addAll(this.records);
    }

    public BeanTableView createView() {
        return new BeanTableView(this.indexManager);
    }

    public Record searchByPrimaryKey(Record key) throws IndexNotFoundException, IndexPropertyAccessException {
        return (Record)this.indexManager.searchByPrimaryElement(key, PRIMARY_KEY_INDEX_NAME, null);
    }

    public RecordList searchByKey(Record key, String[] propertyNames) {
        if (this.size() == 0) {
            return this.cloneSchema();
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int[] propertyIndexes = new int[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(propertyNames[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + propertyNames[i]);
        }
        return this.searchByKey(key, propertyIndexes);
    }

    public RecordList searchByKey(Record key, int[] propertyIndexes) {
        RecordList result = this.cloneSchema();
        if (this.size() == 0) {
            return result;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int imax = this.size();
        for (int i = 0; i < imax; ++i) {
            Record rd = this.getRecord(i);
            boolean isMatch = true;
            for (int j = 0; j < propertyIndexes.length; ++j) {
                Object val1 = key.getProperty(propertyIndexes[j]);
                Object val2 = rd.getProperty(propertyIndexes[j]);
                if (val1 == null && val2 == null || !(val1 == null && val2 != null || val1 != null && val2 == null) && val1.equals(val2)) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            result.add(rd);
        }
        return result;
    }

    public RecordList realSearch(String condition, Map valueMap) throws DataSetException {
        RecordList result = this.cloneSchema();
        if (this.size() == 0) {
            return result;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            JexlContext context = JexlHelper.createContext();
            int imax = this.size();
            for (int i = 0; i < imax; ++i) {
                Boolean ret;
                Record rd = this.getRecord(i);
                int jmax = this.recordSchema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(j);
                    String propName = prop.getName();
                    context.getVars().put(propName, rd.getProperty(propName));
                }
                if (valueMap != null) {
                    context.getVars().putAll(valueMap);
                }
                if ((ret = (Boolean)exp.evaluate(context)) == null || !ret.booleanValue()) continue;
                result.add(rd);
            }
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        return result;
    }

    public void sort(String[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, String[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public static void sort(List records, String[] orderBy) {
        RecordList.sort(records, orderBy, (boolean[])null);
    }

    public void sort(int[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, int[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public static void sort(List records, int[] orderBy) {
        RecordList.sort(records, orderBy, (boolean[])null);
    }

    public void sort(int[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(this.recordSchema, orderBy, isAsc));
    }

    public static void sort(Record[] records, int[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(records[0].getRecordSchema(), orderBy, isAsc));
    }

    public static void sort(List records, int[] orderBy, boolean[] isAsc) {
        if (records == null || records.size() < 2) {
            return;
        }
        Collections.sort(records, new RecordComparator(((Record)records.get(0)).getRecordSchema(), orderBy, isAsc));
    }

    public void sort(String[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(orderBy, isAsc));
    }

    public static void sort(Record[] records, String[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(orderBy, isAsc));
    }

    public static void sort(List records, String[] orderBy, boolean[] isAsc) {
        if (records == null || records.size() < 2) {
            return;
        }
        Collections.sort(records, new RecordComparator(orderBy, isAsc));
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.records.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new RecordIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new RecordListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.records.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.records.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Record)) {
            throw new DataSetException("Not record : " + o);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.addInternal((Record)o);
            }
        }
        return this.addInternal((Record)o);
    }

    private boolean addInternal(Record rec) {
        if (this.indexManager.getIndex(PRIMARY_KEY_INDEX_NAME) != null && this.indexManager.searchByPrimaryElement(rec, PRIMARY_KEY_INDEX_NAME, null) != null) {
            throw new DataSetException("Duplicate primary key. " + rec);
        }
        rec.setIndex(this.size());
        rec.setRecordList(this);
        boolean isAdd = this.records.add(rec);
        if (isAdd) {
            this.indexManager.add(rec);
            ++this.modCount;
        }
        return isAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.addInternal(index, (Record)element);
            }
        } else {
            this.addInternal(index, (Record)element);
        }
    }

    private void addInternal(int index, Record rec) {
        if (this.indexManager.getIndex(PRIMARY_KEY_INDEX_NAME) != null && this.indexManager.searchByPrimaryElement(rec, PRIMARY_KEY_INDEX_NAME, null) != null) {
            throw new DataSetException("Duplicate primary key. " + rec);
        }
        rec.setIndex(index);
        rec.setRecordList(this);
        this.records.add(index, rec);
        int imax = this.size();
        for (int i = index + 1; i < imax; ++i) {
            Record record = (Record)this.get(i);
            if (record == null) continue;
            record.setIndex(record.getIndex() + 1);
        }
        this.indexManager.add(rec);
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        if (element != null && !(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.setInternal(index, (Record)element);
            }
        }
        return this.setInternal(index, (Record)element);
    }

    private Object setInternal(int index, Record rec) {
        Record old;
        if (this.indexManager.getIndex(PRIMARY_KEY_INDEX_NAME) != null && (old = (Record)this.indexManager.searchByPrimaryElement(rec, PRIMARY_KEY_INDEX_NAME, null)) != null && old.getIndex() != index) {
            throw new DataSetException("Duplicate primary key. " + rec);
        }
        rec.setIndex(index);
        rec.setRecordList(this);
        old = this.records.set(index, rec);
        this.indexManager.remove(old);
        this.indexManager.add(rec);
        old.setIndex(-1);
        old.setRecordList(null);
        return old;
    }

    public Object get(int index) {
        return this.records.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.records.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.records.lastIndexOf(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.removeInternal(o);
            }
        }
        return this.removeInternal(o);
    }

    private boolean removeInternal(Object o) {
        boolean isRemoved = this.records.remove(o);
        if (isRemoved) {
            this.indexManager.remove((Record)o);
            int oldIndex = ((Record)o).getIndex();
            ((Record)o).setIndex(-1);
            ((Record)o).setRecordList(null);
            int imax = this.size();
            for (int i = oldIndex; i < imax; ++i) {
                Record record = (Record)this.get(i);
                if (record == null) continue;
                record.setIndex(i);
            }
            ++this.modCount;
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.removeInternal(index);
            }
        }
        return this.removeInternal(index);
    }

    private Object removeInternal(int index) {
        Object old = this.records.remove(index);
        if (old != null) {
            this.indexManager.remove(old);
            ((Record)old).setIndex(-1);
            ((Record)old).setRecordList(null);
            int imax = this.size();
            for (int i = index; i < imax; ++i) {
                Record record = (Record)this.get(i);
                if (record == null) continue;
                record.setIndex(record.getIndex() - 1);
            }
            ++this.modCount;
        }
        return old;
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.records.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        boolean result = false;
        for (int i = 0; i < vals.length; ++i) {
            result |= this.add(vals[i]);
        }
        if (result) {
            ++this.modCount;
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        int i = vals.length;
        while (--i >= 0) {
            this.add(index, vals[i]);
        }
        ++this.modCount;
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            isRemoved |= this.remove(itr.next());
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Object record = itr.next();
            if (c.contains(record)) continue;
            itr.remove();
            isRemoved = true;
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.clearInternal();
            }
        } else {
            this.clearInternal();
        }
    }

    private void clearInternal() {
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.remove(0);
            if (record == null) continue;
            record.setIndex(-1);
            record.setRecordList(null);
        }
        this.indexManager.clear();
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.Collections$SynchronizedCollection");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Object mutex = this.records;
        try {
            Field field = clazz.getDeclaredField("mutex");
            field.setAccessible(true);
            mutex = field.get(this.records);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        ArrayList list = null;
        try {
            Field field = clazz.getDeclaredField("c");
            field.setAccessible(true);
            list = (ArrayList)field.get(this.records);
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (SecurityException e) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            list.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() throws PropertyGetException, PropertyValidateException {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                return this.validateInternal();
            }
        }
        return this.validateInternal();
    }

    private boolean validateInternal() throws PropertyGetException, PropertyValidateException {
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            if (record.validate()) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this.cloneRecordList();
    }

    public RecordList cloneSchema() {
        RecordList clone = null;
        try {
            clone = (RecordList)super.clone();
            clone.modCount = 0;
            List list = clone.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
            if (this.partUpdateOrderBy != null) {
                clone.partUpdateOrderBy = new int[this.partUpdateOrderBy.length];
                System.arraycopy(this.partUpdateOrderBy, 0, clone.partUpdateOrderBy, 0, this.partUpdateOrderBy.length);
            }
            if (this.partUpdateIsAsc != null) {
                clone.partUpdateIsAsc = new boolean[this.partUpdateIsAsc.length];
                System.arraycopy(this.partUpdateIsAsc, 0, clone.partUpdateIsAsc, 0, this.partUpdateIsAsc.length);
            }
            clone.indexManager = this.indexManager.cloneEmpty(this.isSynchronized);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordList cloneRecordList() {
        RecordList recList = this.cloneSchema();
        if (this.size() == 0) {
            return recList;
        }
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                for (int i = 0; i < this.records.size(); ++i) {
                    Record rec = ((Record)this.records.get(i)).cloneRecord();
                    recList.addRecord(rec);
                }
            }
        } else {
            for (int i = 0; i < this.records.size(); ++i) {
                Record rec = ((Record)this.records.get(i)).cloneRecord();
                recList.addRecord(rec);
            }
        }
        return recList;
    }

    public void setPartUpdateSort(String[] orderBy, boolean[] isAsc) {
        int[] propertyIndexes = new int[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(orderBy[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.setPartUpdateSort(propertyIndexes, isAsc);
    }

    public void setPartUpdateSort(int[] orderBy, boolean[] isAsc) {
        if (orderBy == null || orderBy.length == 0) {
            throw new DataSetException("Property index array is empty.");
        }
        if (isAsc != null && orderBy.length != isAsc.length) {
            throw new DataSetException("Length of property index array and sort flag array is unmatch.");
        }
        int fieldSize = this.recordSchema.getPropertySize();
        for (int i = 0; i < orderBy.length; ++i) {
            if (orderBy[i] < fieldSize) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.partUpdateOrderBy = orderBy;
        this.partUpdateIsAsc = isAsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartUpdateRecords createPartUpdateRecords(PartUpdateRecords records, int updateType, boolean containsValue) throws DataSetException {
        if (this.isSynchronized) {
            PartUpdateRecords partUpdateRecords = records;
            synchronized (partUpdateRecords) {
                return this.createPartUpdateRecordsInternal(records, updateType, containsValue);
            }
        }
        return this.createPartUpdateRecordsInternal(records, updateType, containsValue);
    }

    private PartUpdateRecords createPartUpdateRecordsInternal(PartUpdateRecords records, int updateType, boolean containsValue) throws DataSetException {
        if (records == null) {
            records = new PartUpdateRecords();
        }
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            CodeMasterUpdateKey key = record.createCodeMasterUpdateKey();
            key.setUpdateType(updateType);
            if (containsValue) {
                records.addRecord(key, record);
                continue;
            }
            records.addRecord(key);
        }
        return records;
    }

    public PartUpdateRecords fillPartUpdateRecords(CodeMasterUpdateKey key) {
        PartUpdateRecords records = new PartUpdateRecords();
        records.addRecord(key);
        return this.fillPartUpdateRecords(records);
    }

    public PartUpdateRecords fillPartUpdateRecords(PartUpdateRecords records) {
        if (records == null || records.size() == 0 || !records.containsAdd() && !records.containsUpdate()) {
            return records;
        }
        records.setFilledRecord(true);
        Record rec = this.createRecord();
        CodeMasterUpdateKey[] keys = records.getKeyArray();
        for (int i = 0; i < keys.length; ++i) {
            CodeMasterUpdateKey key = keys[i];
            int updateType = key.getUpdateType();
            records.removeRecord(key);
            rec.setCodeMasterUpdateKey(key);
            key = rec.createCodeMasterUpdateKey(key);
            key.setUpdateType(updateType);
            if (key.isRemove()) {
                records.addRecord(key);
                continue;
            }
            Record searchRec = this.searchByPrimaryKey(rec);
            records.addRecord(key, searchRec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartUpdate cloneAndUpdate(PartUpdateRecords records) {
        if (this.isSynchronized) {
            PartUpdateRecords partUpdateRecords = records;
            synchronized (partUpdateRecords) {
                return this.cloneAndUpdateInternal(records);
            }
        }
        return this.cloneAndUpdateInternal(records);
    }

    private PartUpdate cloneAndUpdateInternal(PartUpdateRecords records) {
        RecordList newRecList = this.cloneSchema();
        CodeMasterUpdateKey tmpKey = new CodeMasterUpdateKey();
        CodeMasterUpdateKey key = null;
        int imax = this.records.size();
        block6: for (int i = 0; i < imax; ++i) {
            Record oldRecord = (Record)this.records.get(i);
            tmpKey = oldRecord.createCodeMasterUpdateKey(tmpKey);
            key = records == null ? null : records.getKey(tmpKey);
            Record newRecord = null;
            if (key == null) {
                newRecord = oldRecord.cloneRecord();
            } else {
                switch (key.getUpdateType()) {
                    case 1: 
                    case 2: {
                        newRecord = (Record)records.removeRecord(key);
                        break;
                    }
                    default: {
                        records.removeRecord(key);
                        continue block6;
                    }
                }
            }
            if (newRecord == null) continue;
            newRecList.addRecord(newRecord);
        }
        if (records != null && records.size() != 0) {
            for (Map.Entry entry : records.getRecords().entrySet()) {
                switch (((CodeMasterUpdateKey)entry.getKey()).getUpdateType()) {
                    case 1: 
                    case 2: {
                        Record record = (Record)entry.getValue();
                        if (record == null) break;
                        newRecList.addRecord(record);
                        break;
                    }
                }
            }
        }
        if (this.partUpdateOrderBy != null && this.partUpdateOrderBy.length != 0) {
            newRecList.sort(this.partUpdateOrderBy, this.partUpdateIsAsc);
        }
        return newRecList;
    }

    protected static void writeInt(ObjectOutput out, int val) throws IOException {
        if (val >= -128 && val <= 127) {
            out.writeByte(1);
            out.writeByte((byte)val);
        } else if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            out.writeByte(2);
            out.writeShort((short)val);
        } else {
            out.writeByte(3);
            out.writeInt(val);
        }
    }

    protected static int readInt(ObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return in.readByte();
            }
            case 2: {
                return in.readShort();
            }
        }
        return in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.isSynchronized) {
            List list = this.records;
            synchronized (list) {
                this.writeExternalInternal(out);
            }
        } else {
            this.writeExternalInternal(out);
        }
    }

    protected void writeExternalInternal(ObjectOutput out) throws IOException {
        this.writeSchema(out);
        this.indexManager.writeExternal(out, false);
        out.writeObject(this.partUpdateOrderBy);
        out.writeObject(this.partUpdateIsAsc);
        RecordList.writeInt(out, this.records.size());
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            record.writeExternalValues(out);
        }
    }

    protected void writeSchema(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.schema);
        out.writeObject(this.recordClass);
        out.writeBoolean(this.isSynchronized);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readSchema(in);
        this.indexManager = new BeanTableIndexManager();
        this.indexManager.readExternal(in, false);
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
        this.partUpdateOrderBy = (int[])in.readObject();
        this.partUpdateIsAsc = (boolean[])in.readObject();
        int recSize = RecordList.readInt(in);
        List list = this.records = this.isSynchronized ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        if (this.recordSchema != null) {
            for (int i = 0; i < recSize; ++i) {
                Record record = this.createRecord();
                record.readExternalValues(in);
                record.setIndex(i);
                record.setRecordList(this);
                this.records.add(record);
                this.indexManager.add(record);
            }
        }
    }

    protected void readSchema(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.recordClass = (Class)in.readObject();
        this.isSynchronized = in.readBoolean();
    }

    public static class RecordComparator
    implements Comparator {
        private String[] propNames;
        private boolean[] isAsc;

        public RecordComparator(String[] propNames) {
            this(propNames, null);
        }

        public RecordComparator(String[] propNames, boolean[] isAsc) {
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of property index array and sort flag array is unmatch.");
            }
            this.propNames = propNames;
            this.isAsc = isAsc;
        }

        public RecordComparator(RecordSchema recordSchema, String[] propNames) {
            this(recordSchema, propNames, null);
        }

        public RecordComparator(RecordSchema recordSchema, String[] propNames, boolean[] isAsc) {
            if (recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            for (int i = 0; i < propNames.length; ++i) {
                if (recordSchema.getPropertySchema(propNames[i]) != null) continue;
                throw new IllegalArgumentException("Property not found : " + propNames[i]);
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.isAsc = isAsc;
        }

        public RecordComparator(RecordSchema recordSchema, int[] propIndexes) {
            this(recordSchema, propIndexes, null);
        }

        public RecordComparator(RecordSchema recordSchema, int[] propIndexes, boolean[] isAsc) {
            if (recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propIndexes == null || propIndexes.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propIndexes.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.propNames = new String[propIndexes.length];
            for (int i = 0; i < propIndexes.length; ++i) {
                this.propNames[i] = recordSchema.getPropertyName(propIndexes[i]);
                if (this.propNames != null) continue;
                throw new IllegalArgumentException("Property not found : " + propIndexes[i]);
            }
            if (this.propNames == null || this.propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Record rd1 = (Record)o1;
            Record rd2 = (Record)o2;
            if (rd1 == null && rd2 == null) {
                return 0;
            }
            if (rd1 != null && rd2 == null) {
                return 1;
            }
            if (rd1 == null && rd2 != null) {
                return -1;
            }
            for (int i = 0; i < this.propNames.length; ++i) {
                Object val1 = rd1.getProperty(this.propNames[i]);
                Object val2 = rd2.getProperty(this.propNames[i]);
                if (val1 != null && val2 == null) {
                    return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                }
                if (val1 == null && val2 != null) {
                    return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                }
                if (val1 == null || val2 == null) continue;
                int comp = 0;
                comp = val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.hashCode() - val2.hashCode();
                if (comp == 0) continue;
                return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
            }
            return 0;
        }
    }

    protected class RecordListIterator
    extends RecordIterator
    implements ListIterator {
        private static final long serialVersionUID = 1979810413080499078L;

        public RecordListIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = RecordList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.set(this.lastRet, o);
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                RecordList.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class RecordIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 200743372396432511L;
        protected int cursor = 0;
        protected int lastRet = -1;
        protected int expectedModCount;

        protected RecordIterator() {
            this.expectedModCount = RecordList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != RecordList.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object next = RecordList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (RecordList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

