/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class SelectiveIntegerGene
extends AbstractGene {
    public static final int CROSSOVER_AVERAGE = 1;
    public static final int CROSSOVER_RANDOM_RANGE = 2;
    public static final int MUTATE_UNIFORM = 1;
    protected int[] selectiveValues;
    protected float randomRangeMargin = 0.0f;

    public SelectiveIntegerGene() {
        this.crossoverType = 2;
        this.mutateType = 1;
    }

    public void setSelectiveValues(int[] values) {
        this.selectiveValues = values;
        Arrays.sort(this.selectiveValues);
    }

    public int[] getSelectiveValues() {
        return this.selectiveValues;
    }

    public void setRandomRangeMargin(float margin) {
        this.randomRangeMargin = margin;
    }

    public float getRandomRangeMargin() {
        return this.randomRangeMargin;
    }

    @Override
    public void random(Random random) {
        this.setValue(new Integer(this.randomValue(random)));
    }

    protected int randomValue(Random random) {
        return this.selectiveValues[random.nextInt(this.selectiveValues.length)];
    }

    @Override
    public void crossover(Random random, Gene gene) {
        int result = 0;
        switch (this.crossoverType) {
            case 1: {
                result = this.crossoverByAverage(random, gene);
                break;
            }
            default: {
                result = this.crossoverByRandomRange(random, gene);
            }
        }
        this.setValue(new Integer(this.mutate(random, result)));
        this.setCrossover(true);
    }

    protected int crossoverByAverage(Random random, Gene gene) {
        int val2;
        int val1 = (Integer)this.value;
        int average = (int)Math.round((double)(val1 + (val2 = ((Integer)gene.getValue()).intValue())) / 2.0);
        int index = Arrays.binarySearch(this.selectiveValues, average);
        if (index >= 0) {
            return this.selectiveValues[index];
        }
        if ((index = -index - 1) == 0) {
            return this.selectiveValues[0];
        }
        if (index > this.selectiveValues.length - 1) {
            return this.selectiveValues[this.selectiveValues.length - 1];
        }
        val1 = this.selectiveValues[index - 1];
        int diff1 = average - val1;
        val2 = this.selectiveValues[index];
        int diff2 = val2 - average;
        if (diff1 < diff2) {
            return val1;
        }
        if (diff1 == diff2) {
            return diff1 % 2 == 0 ? val1 : val2;
        }
        return val2;
    }

    protected int crossoverByRandomRange(Random random, Gene gene) {
        int margin;
        int index2;
        int val1 = (Integer)this.value;
        int val2 = (Integer)gene.getValue();
        int index1 = Arrays.binarySearch(this.selectiveValues, val1);
        int range = Math.abs(index1 - (index2 = Arrays.binarySearch(this.selectiveValues, val2)));
        if (range == 0) {
            return val1;
        }
        int offset = Math.min(index1, index2);
        int n = margin = this.randomRangeMargin == 0.0f ? 0 : Math.round((float)range * this.randomRangeMargin);
        if (margin < 2) {
            margin = 0;
        } else {
            if ((margin = (int)Math.round((double)margin / 2.0) * 2) / 2 > offset) {
                margin = offset * 2;
            }
            if (margin != 0) {
                offset -= margin / 2;
            }
        }
        if ((range += margin) == 1) {
            return this.selectiveValues[offset + random.nextInt(range + 1)];
        }
        if (range == 2) {
            return this.selectiveValues[offset + 1];
        }
        return this.selectiveValues[offset + 1 + random.nextInt(range - 1)];
    }

    protected int mutate(Random random, int val) {
        int result = val;
        if (this.isMutate(random)) {
            switch (this.mutateType) {
                default: 
            }
            result = this.mutateByUniform(random, val);
            this.setMutate(true);
        }
        return result;
    }

    protected int mutateByUniform(Random random, int val) {
        return this.randomValue(random);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.selectiveValues == null ? -1 : this.selectiveValues.length);
        if (this.selectiveValues != null) {
            for (int i = 0; i < this.selectiveValues.length; ++i) {
                out.writeInt(this.selectiveValues[i]);
            }
        }
        out.writeFloat(this.randomRangeMargin);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        if (length >= 0) {
            this.selectiveValues = new int[length];
            for (int i = 0; i < length; ++i) {
                this.selectiveValues[i] = in.readInt();
            }
        }
        this.randomRangeMargin = in.readFloat();
    }
}

