/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.Interceptor;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChain;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.ioccall.interceptor.JournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;

public class JournalInterceptorService
extends ServiceBase
implements JournalInterceptorServiceMBean,
Interceptor,
jp.ossc.nimbus.service.aop.Interceptor {
    private static final long serialVersionUID = -5639122310302405874L;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName contextServiceName;
    protected Context context;
    protected ServiceName stepEditorFinderServiceName;
    protected EditorFinder stepEditorFinder;
    protected ServiceName inputEditorFinderServiceName;
    protected EditorFinder inputEditorFinder;
    protected ServiceName outputEditorFinderServiceName;
    protected EditorFinder outputEditorFinder;
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected String stepJournalKey = "Step";
    protected String inputJournalKey = "Input";
    protected String outputJournalKey = "Output";
    protected String exceptionJournalKey = "Exception";
    protected String requestIdKey = "REQUEST_ID";

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setStepEditorFinderServiceName(ServiceName name) {
        this.stepEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getStepEditorFinderServiceName() {
        return this.stepEditorFinderServiceName;
    }

    @Override
    public void setInputEditorFinderServiceName(ServiceName name) {
        this.inputEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getInputEditorFinderServiceName() {
        return this.inputEditorFinderServiceName;
    }

    @Override
    public void setOutputEditorFinderServiceName(ServiceName name) {
        this.outputEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getOutputEditorFinderServiceName() {
        return this.outputEditorFinderServiceName;
    }

    @Override
    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setRequestIDKey(String key) {
        this.requestIdKey = key;
    }

    @Override
    public String getRequestIDKey() {
        return this.requestIdKey;
    }

    @Override
    public void setStepJournalKey(String key) {
        this.stepJournalKey = key;
    }

    @Override
    public String getStepJournalKey() {
        return this.stepJournalKey;
    }

    @Override
    public void setInputJournalKey(String key) {
        this.inputJournalKey = key;
    }

    @Override
    public String getInputJournalKey() {
        return this.inputJournalKey;
    }

    @Override
    public void setOutputJournalKey(String key) {
        this.outputJournalKey = key;
    }

    @Override
    public String getOutputJournalKey() {
        return this.outputJournalKey;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName == null) {
            throw new IllegalArgumentException("journalServiceName must be specified.");
        }
        this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        if (this.stepEditorFinderServiceName != null) {
            this.stepEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.stepEditorFinderServiceName);
        }
        if (this.inputEditorFinderServiceName != null) {
            this.inputEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.inputEditorFinderServiceName);
        }
        if (this.outputEditorFinderServiceName != null) {
            this.outputEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.outputEditorFinderServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.contextServiceName != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }
    }

    @Override
    public Object invokeChain(Object inputObj, InterceptorChain interceptChain) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        try {
            return this.invokeInternal(inputObj, interceptChain, null);
        }
        catch (InterceptorException e) {
            throw e;
        }
        catch (TargetCheckedException e) {
            throw e;
        }
        catch (TargetUncheckedException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new InterceptorException(th);
        }
    }

    @Override
    public Object invoke(InvocationContext context, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        return this.invokeInternal(context, null, chain);
    }

    protected Object invokeInternal(Object inputObj, InterceptorChain interceptChain, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        Object input = inputObj;
        if (chain != null) {
            input = ((MethodInvocationContext)input).getParameters()[0];
        }
        if (this.getState() == 3) {
            try {
                this.journal.startJournal(this.stepJournalKey, this.stepEditorFinder);
                if (this.sequence != null) {
                    this.journal.setRequestId(this.sequence.increment());
                } else if (this.context != null) {
                    this.journal.setRequestId((String)this.context.get(this.requestIdKey));
                }
                Object ret = null;
                this.journal.addInfo(this.inputJournalKey, input, this.inputEditorFinder);
                ret = interceptChain != null ? interceptChain.invokeChain(input) : chain.invokeNext((InvocationContext)inputObj);
                this.journal.addInfo(this.outputJournalKey, ret, this.outputEditorFinder);
                Object object = ret;
                return object;
            }
            catch (Throwable th) {
                this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
                throw th;
            }
            finally {
                this.journal.endJournal();
            }
        }
        if (interceptChain != null) {
            return interceptChain.invokeChain(input);
        }
        return chain.invokeNext((InvocationContext)inputObj);
    }
}

