/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.websocket;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.publish.websocket.AbstractJMSMessageDispatcherServiceMBean;
import jp.ossc.nimbus.service.publish.websocket.AbstractPublishMessageDispatcherService;

public abstract class AbstractJMSMessageDispatcherService
extends AbstractPublishMessageDispatcherService
implements MessageListener,
AbstractJMSMessageDispatcherServiceMBean {
    protected ServiceName[] jmsMessageConsumerFactoryServiceNames;
    protected boolean isStartReceiveOnStart = true;
    protected JMSMessageConsumerFactory[] jmsMessageConsumerFactory;

    @Override
    public ServiceName[] getJmsMessageConsumerFactoryServiceNames() {
        return this.jmsMessageConsumerFactoryServiceNames;
    }

    @Override
    public void setJmsMessageConsumerFactoryServiceNames(ServiceName[] names) {
        this.jmsMessageConsumerFactoryServiceNames = names;
    }

    @Override
    public boolean isStartReceiveOnStart() {
        return this.isStartReceiveOnStart;
    }

    @Override
    public void setStartReceiveOnStart(boolean isStart) {
        this.isStartReceiveOnStart = isStart;
    }

    @Override
    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.jmsMessageConsumerFactoryServiceNames == null) {
            throw new IllegalArgumentException("JmsMessageConsumerFactoryServiceNames is null.");
        }
        this.jmsMessageConsumerFactory = new JMSMessageConsumerFactory[this.jmsMessageConsumerFactoryServiceNames.length];
        for (i = 0; i < this.jmsMessageConsumerFactoryServiceNames.length; ++i) {
            this.jmsMessageConsumerFactory[i] = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsMessageConsumerFactoryServiceNames[i]);
        }
        for (i = 0; i < this.jmsMessageConsumerFactory.length; ++i) {
            MessageConsumer consumer = this.jmsMessageConsumerFactory[i].createConsumer();
            consumer.setMessageListener((MessageListener)this);
            if (!this.isStartReceiveOnStart) continue;
            Connection con = this.jmsMessageConsumerFactory[i].getSessionFactory().getConnection();
            con.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.stopReceive();
        super.stopService();
    }

    @Override
    public void startReceive() throws Exception {
        for (int i = 0; i < this.jmsMessageConsumerFactory.length; ++i) {
            Connection con = this.jmsMessageConsumerFactory[i].getSessionFactory().getConnection();
            con.start();
        }
    }

    @Override
    public void stopReceive() throws Exception {
        for (int i = 0; i < this.jmsMessageConsumerFactory.length; ++i) {
            Connection con = this.jmsMessageConsumerFactory[i].getSessionFactory().getConnection();
            con.stop();
        }
    }

    public void onMessage(Message msg) {
        this.onMessageProcess(msg);
    }
}

