/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.websocket;

import java.util.ArrayList;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.websocket.AbstractPublishMessageHandlerFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.websocket.MessageDispatcher;
import jp.ossc.nimbus.service.publish.websocket.MessageSender;
import jp.ossc.nimbus.service.websocket.AbstractMessageHandlerFactoryService;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public abstract class AbstractPublishMessageHandlerFactoryService
extends AbstractMessageHandlerFactoryService
implements AbstractPublishMessageHandlerFactoryServiceMBean {
    protected ServiceName messageDispatcherServiceName;
    protected long bufferingMaxTime = -1L;
    protected int bufferingMaxSize = -1;
    protected MessageDispatcher dispatcher;

    @Override
    public ServiceName getMessageDispatcherServiceName() {
        return this.messageDispatcherServiceName;
    }

    @Override
    public void setMessageDispatcherServiceName(ServiceName name) {
        this.messageDispatcherServiceName = name;
    }

    @Override
    public long getBufferingMaxTime() {
        return this.bufferingMaxTime;
    }

    @Override
    public void setBufferingMaxTime(long time) {
        this.bufferingMaxTime = time;
    }

    @Override
    public int getBufferingMaxSize() {
        return this.bufferingMaxSize;
    }

    @Override
    public void setBufferingMaxSize(int size) {
        this.bufferingMaxSize = size;
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        if (this.messageDispatcherServiceName == null) {
            throw new IllegalArgumentException("MessageDispatcherServiceName is null.");
        }
        this.dispatcher = (MessageDispatcher)ServiceManagerFactory.getServiceObject(this.messageDispatcherServiceName);
    }

    @Override
    protected abstract Service createServiceInstance() throws Exception;

    public abstract class AbstractPublishMessageHandlerService
    extends AbstractMessageHandlerFactoryService.AbstractMessageHandlerService
    implements MessageSender {
        protected List poolList;

        public AbstractPublishMessageHandlerService() {
            super(AbstractPublishMessageHandlerFactoryService.this);
        }

        @Override
        public void createService() throws Exception {
            super.createService();
            this.poolList = new ArrayList();
        }

        @Override
        protected void onOpenProcess(Session session, EndpointConfig config) {
            AbstractPublishMessageHandlerFactoryService.this.dispatcher.addMessageSender(this);
        }

        @Override
        protected void onCloseProcess(Session session, CloseReason closeReason) {
            AbstractPublishMessageHandlerFactoryService.this.dispatcher.removeMessageSender(this);
        }

        @Override
        protected void onErrorProcess(Session session, Throwable thr) {
        }

        @Override
        protected abstract void onMessageProcess(String var1);

        @Override
        public void sendMessage(Object msg) throws Exception {
            this.sendMessageProcess(msg);
            SessionProperties.getSessionProperty(this.session).addSendMessageCount();
        }

        public abstract void sendMessageProcess(Object var1) throws Exception;

        @Override
        public Session getSession() {
            return this.session;
        }
    }
}

