/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.context.SharedContextService;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextTransactionManager;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.SharedQueueServiceMBean;
import jp.ossc.nimbus.service.sequence.StringSequenceService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedQueueService
extends SharedContextService
implements Queue,
SharedQueueServiceMBean {
    private static final long serialVersionUID = -3323923547429465815L;
    protected static final EmptyElement EMPTY = new EmptyElement();
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected final Object lock = "lock";
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = false;
    protected boolean isMultiThreadGet = false;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;
    protected StringSequenceService sequence;
    protected String sequenceTimestampFormat = "yyyyMMddHHmmssSSS";
    protected int sequenceDigit = 5;

    @Override
    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    @Override
    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    @Override
    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    @Override
    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    @Override
    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    @Override
    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    @Override
    public boolean isMultiThreadGet() {
        return this.isMultiThreadGet;
    }

    @Override
    public void setMultiThreadGet(boolean isSafe) {
        this.isMultiThreadGet = isSafe;
    }

    @Override
    public void setSequenceTimestampFormat(String format) {
        this.sequenceTimestampFormat = format;
    }

    @Override
    public String getSequenceTimestampFormat() {
        return this.sequenceTimestampFormat;
    }

    @Override
    public void setSequenceDigit(int digit) {
        this.sequenceDigit = digit;
    }

    @Override
    public int getSequenceDigit() {
        return this.sequenceDigit;
    }

    @Override
    public void startService() throws Exception {
        this.sequence = new StringSequenceService();
        this.sequence.create();
        this.sequence.setFormat("TIME_SEQ(" + this.sequenceTimestampFormat + "," + this.sequenceDigit + ")");
        this.sequence.start();
        if (!WaitSynchronizeMonitor.class.equals((Object)this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        super.startService();
        this.accept();
    }

    @Override
    public void stopService() throws Exception {
        this.release();
        super.stopService();
    }

    @Override
    protected Map createContext() {
        return Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    protected void onPut(SharedContextService.SharedContextEvent event) {
        super.onPut(event);
        this.pushAfter();
    }

    @Override
    public void push(Object item) {
        this.push(item, -1L);
    }

    @Override
    public boolean push(Object item, long timeout) {
        return this.pushElement(item, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushElement(Object element, long timeout) {
        SharedContextTransactionManager.SharedContextTransaction transaction;
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        long startTime = System.currentTimeMillis();
        while (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                if (timeout == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (timeout < 0L) {
                    this.pushMonitor.initAndWaitMonitor();
                    continue;
                }
                if (this.pushMonitor.initAndWaitMonitor(timeout)) continue;
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
            return false;
        }
        String id = this.sequence.increment() + this.getId();
        boolean hasTransaction = false;
        if (this.sharedContextTransactionManager != null && (transaction = this.sharedContextTransactionManager.getTransaction()) != null && transaction.getState() == 1) {
            hasTransaction = true;
        }
        if (hasTransaction) {
            this.put(id, element, timeout);
        } else {
            this.putAsynch(id, element);
        }
        this.pushAfter();
        return true;
    }

    protected void pushAfter() {
        if (!this.isClient) {
            int size = this.size();
            if ((long)size > this.maxDepth) {
                this.maxDepth = size;
            }
            ++this.count;
            ++this.countDelta;
            this.lastPushedTime = System.currentTimeMillis();
        }
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
        }
    }

    @Override
    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        if (this.isClient) {
            throw new UnsupportedOperationException();
        }
        long processTime = 0L;
        try {
            Object ret;
            if (isRemove) {
                this.getMonitor.initMonitor();
            } else {
                this.peekMonitor.initMonitor();
            }
            while (!this.fourceEndFlg) {
                if (this.size() > 0) {
                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                        ret = this.getQueueElement(isRemove);
                        if (ret == EMPTY) continue;
                        if (isRemove) {
                            this.getMonitor.releaseMonitor();
                            if (this.size() > 0 && this.getMonitor.isWait()) {
                                if (this.isSafeGetOrder) {
                                    this.getMonitor.notifyMonitor();
                                } else {
                                    this.getMonitor.notifyAllMonitor();
                                }
                            }
                            if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                                this.pushMonitor.notifyMonitor();
                            }
                        }
                        Object object = ret;
                        return object;
                    }
                    if (this.getMonitor.isWait()) {
                        this.getMonitor.notifyMonitor();
                    }
                }
                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                long proc = 0L;
                if (timeOutMs >= 0L) {
                    proc = System.currentTimeMillis();
                }
                try {
                    long curSleepTime;
                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                    if (curSleepTime > 0L && (this.size() == 0 || !isRemove || this.isSafeGetOrder && !this.getMonitor.isFirst())) {
                        if (isRemove) {
                            this.getMonitor.initAndWaitMonitor(curSleepTime);
                        } else {
                            this.peekMonitor.initAndWaitMonitor(curSleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Object var9_11 = null;
                    if (isRemove) {
                        this.getMonitor.releaseMonitor();
                    } else {
                        this.peekMonitor.releaseMonitor();
                    }
                    return var9_11;
                }
                if (timeOutMs < 0L) continue;
                proc = System.currentTimeMillis() - proc;
                processTime += proc;
            }
            if (this.fourceEndFlg) {
                ret = this.getQueueElement(isRemove);
                if (ret == EMPTY) {
                    Object var7_9 = null;
                    return var7_9;
                }
                Object object = ret;
                return object;
            }
            if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                if (this.isSafeGetOrder) {
                    this.getMonitor.notifyMonitor();
                } else {
                    this.getMonitor.notifyAllMonitor();
                }
            }
            Object var6_4 = null;
            return var6_4;
        }
        finally {
            if (isRemove) {
                this.getMonitor.releaseMonitor();
            } else {
                this.peekMonitor.releaseMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.context == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.context == null) {
                return null;
            }
            if (this.size() == 0) {
                return EMPTY;
            }
            Object element = null;
            while (true) {
                String id = null;
                try {
                    id = (String)((SortedMap)this.context).firstKey();
                    if (this.isMultiThreadGet) {
                        this.lock(id);
                    }
                    if (this.containsKey(id)) {
                        if (isRemove) {
                            element = this.remove(id);
                            break;
                        }
                        element = this.get(id);
                        break;
                    }
                    id = null;
                    continue;
                }
                catch (SharedContextTimeoutException e) {
                    continue;
                }
                catch (NoSuchElementException e) {
                    EmptyElement emptyElement = EMPTY;
                    return emptyElement;
                }
                finally {
                    if (id == null || !this.isMultiThreadGet) continue;
                    this.unlock(id);
                    continue;
                }
                break;
            }
            if (element == null) {
                return null;
            }
            return element;
        }
    }

    @Override
    public Object get() {
        return this.get(-1L);
    }

    @Override
    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    @Override
    public Object peek() {
        return this.peek(-1L);
    }

    @Override
    public Object remove(Object item) {
        return super.remove(item);
    }

    @Override
    public void accept() {
        this.fourceEndFlg = false;
    }

    @Override
    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
    }

    @Override
    public List elements() {
        if (this.context == null) {
            return new ArrayList();
        }
        return new ArrayList(this.values());
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    @Override
    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    @Override
    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    @Override
    public long getDepth() {
        return this.size();
    }

    @Override
    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    @Override
    public long getMaxDepth() {
        return this.maxDepth;
    }

    protected static class EmptyElement {
        protected EmptyElement() {
        }
    }
}

