/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.validator;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.recset.RecordSet;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.PersistentException;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.validator.MasterValidatorServiceMBean;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public class MasterValidatorService
extends ServiceBase
implements Validator,
MasterValidatorServiceMBean {
    private static final long serialVersionUID = 3833661471756025996L;
    private ServiceName connectionFactoryServiceName;
    private ConnectionFactory connectionFactory;
    private ServiceName persistentManagerServiceName;
    private PersistentManager persistentManager;
    private String query;
    private RecordSet templateRecordSet;
    private List bindDataList;
    private ServiceName codeMasterFinderServiceName;
    private CodeMasterFinder codeMasterFinder;
    private ServiceName threadContextServiceName;
    private Context threadContext;
    private String codeMasterThreadContextKey = "CODE_MASTER";
    private String codeMasterName;
    private String searchCondition;
    private Map bindDataMap;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    @Override
    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setRecordSet(RecordSet recset) {
        this.templateRecordSet = recset;
    }

    @Override
    public RecordSet getRecordSet() {
        return this.templateRecordSet;
    }

    @Override
    public void setBindData(int index, String valueKey) {
        if (this.bindDataList == null) {
            this.bindDataList = new ArrayList();
        }
        for (int i = this.bindDataList.size(); i <= index; ++i) {
            this.bindDataList.add(null);
        }
        if (!valueKey.startsWith("VALUE")) {
            throw new IllegalArgumentException("ValueKey must start with 'VALUE'.");
        }
        if (!valueKey.equals("VALUE")) {
            if ((valueKey = valueKey.substring("VALUE".length())).charAt(0) == '.') {
                valueKey = valueKey.substring(1);
            }
            this.bindDataList.set(index, PropertyFactory.createProperty(valueKey));
        }
    }

    @Override
    public String getBindData(int index) {
        if (this.bindDataList == null || this.bindDataList.size() <= index) {
            return null;
        }
        Property prop = (Property)this.bindDataList.get(index);
        return prop == null ? "VALUE" : "VALUE." + prop.getPropertyName();
    }

    @Override
    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    @Override
    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setCodeMasterThreadContextKey(String key) {
        this.codeMasterThreadContextKey = key;
    }

    @Override
    public String getCodeMasterThreadContextKey() {
        return this.codeMasterThreadContextKey;
    }

    @Override
    public void setCodeMasterName(String name) {
        this.codeMasterName = name;
    }

    @Override
    public String getCodeMasterName() {
        return this.codeMasterName;
    }

    @Override
    public void setRecordSetSearchCondition(String condition) {
        this.searchCondition = condition;
    }

    @Override
    public String getRecordSetSearchCondition() {
        return this.searchCondition;
    }

    @Override
    public void setSearchCondition(String condition) {
        this.searchCondition = condition;
    }

    @Override
    public String getSearchCondition() {
        return this.searchCondition;
    }

    @Override
    public void setBindDataMap(String key, String valueKey) {
        if (this.bindDataMap == null) {
            this.bindDataMap = new HashMap();
        }
        if (!valueKey.startsWith("VALUE")) {
            throw new IllegalArgumentException("ValueKey must start with 'VALUE'.");
        }
        if (valueKey.equals("VALUE")) {
            this.bindDataMap.put(key, null);
        } else {
            if ((valueKey = valueKey.substring("VALUE".length())).charAt(0) == '.') {
                valueKey = valueKey.substring(1);
            }
            this.bindDataMap.put(key, PropertyFactory.createProperty(valueKey));
        }
    }

    @Override
    public String getBindDataMap(String key) {
        if (this.bindDataMap == null) {
            return null;
        }
        Property prop = (Property)this.bindDataMap.get(key);
        return prop == null ? "VALUE" : "VALUE." + prop.getPropertyName();
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
            if (this.persistentManagerServiceName == null) {
                if (this.templateRecordSet == null) {
                    throw new IllegalArgumentException("RecordSet must be specified.");
                }
                if (this.bindDataList == null) {
                    throw new IllegalArgumentException("BindData must be specified.");
                }
            } else {
                this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
                if (this.query == null) {
                    throw new IllegalArgumentException("Query must be specified.");
                }
            }
        } else {
            if (this.codeMasterFinderServiceName != null) {
                this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
            }
            if (this.threadContextServiceName != null) {
                this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
            }
            if (this.codeMasterFinder == null && this.threadContext == null) {
                throw new IllegalArgumentException("It is necessary to set either of CodeMasterFinder or ThreadContext.");
            }
            if (this.codeMasterName == null) {
                throw new IllegalArgumentException("CodeMasterName must be specified.");
            }
            if (this.searchCondition != null && (this.bindDataMap == null || this.bindDataMap.size() == 0)) {
                throw new IllegalArgumentException("BindDataMap must be specified.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate(Object obj) throws ValidateException {
        RecordList recordList;
        block71: {
            HashMap<String, Object> params;
            HashMap<String, Object> params2;
            RecordSet recset;
            if (this.connectionFactory != null) {
                if (this.persistentManager != null) {
                    Connection con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                        List result = (List)this.persistentManager.loadQuery(con, this.query, obj, null);
                        if (result.size() == 0) {
                            boolean bl = false;
                            return bl;
                        }
                        Collection values = ((Map)result.get(0)).values();
                        if (values.size() == 0) {
                            boolean e = false;
                            return e;
                        }
                        if (values.size() == 1) {
                            Object value = values.iterator().next();
                            if (value instanceof Boolean) {
                                boolean e = (Boolean)value;
                                return e;
                            }
                            if (!(value instanceof Number)) {
                                boolean e = true;
                                return e;
                            }
                            boolean e = ((Number)value).intValue() != 0;
                            return e;
                        }
                        boolean value = true;
                        return value;
                    }
                    catch (ConnectionFactoryException e) {
                        throw new ValidateException(e);
                    }
                    catch (PersistentException e) {
                        throw new ValidateException(e);
                    }
                    finally {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
                RecordSet recset2 = this.templateRecordSet.cloneEmpty();
                Connection con = null;
                try {
                    int i;
                    con = this.connectionFactory.getConnection();
                    recset2.setConnection(con);
                    recset2.setLogger(this.getLogger());
                    int imax = this.bindDataList.size();
                    for (i = 0; i < imax; ++i) {
                        Property prop = (Property)this.bindDataList.get(i);
                        if (prop == null) {
                            recset2.setBindData(i, obj);
                            continue;
                        }
                        recset2.setBindData(i, prop.getProperty(obj));
                    }
                    i = recset2.search() != 0 ? 1 : 0;
                    return i != 0;
                }
                catch (ConnectionFactoryException e) {
                    throw new ValidateException(e);
                }
                catch (NoSuchPropertyException e) {
                    throw new ValidateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ValidateException(e.getCause());
                }
                catch (SQLException e) {
                    throw new ValidateException(e);
                }
                finally {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
            Map codeMaster = null;
            if (this.threadContext != null) {
                codeMaster = (Map)this.threadContext.get(this.codeMasterThreadContextKey);
            }
            if (codeMaster == null && this.codeMasterFinder != null) {
                codeMaster = this.codeMasterFinder.getCodeMasters();
            }
            if (codeMaster == null) {
                throw new ValidateException("CodeMaster is not found.");
            }
            Object master = codeMaster.get(this.codeMasterName);
            if (master == null) {
                throw new ValidateException("Master '" + this.codeMasterName + "' is not found.");
            }
            if (master instanceof RecordSet) {
                recset = (RecordSet)master;
                if (this.searchCondition != null) {
                    params2 = new HashMap<String, Object>();
                    Iterator entries = this.bindDataMap.entrySet().iterator();
                    try {
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            String key = (String)entry.getKey();
                            Property prop = (Property)entry.getValue();
                            if (prop == null) {
                                params2.put(key, obj);
                                continue;
                            }
                            params2.put(key, prop.getProperty(obj));
                        }
                    }
                    catch (NoSuchPropertyException e) {
                        throw new ValidateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ValidateException(e.getCause());
                    }
                } else {
                    if (recset.get(obj == null ? null : obj.toString()) == null) return false;
                    return true;
                }
            }
            if (!(master instanceof RecordList)) throw new ValidateException("Master '" + this.codeMasterName + "' is not supported type. type=" + master.getClass().getName());
            recordList = (RecordList)master;
            if (this.searchCondition != null) {
                params = new HashMap<String, Object>();
                Iterator entries = this.bindDataMap.entrySet().iterator();
                try {
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        String key = (String)entry.getKey();
                        Property prop = (Property)entry.getValue();
                        if (prop == null) {
                            params.put(key, obj);
                            continue;
                        }
                        params.put(key, prop.getProperty(obj));
                    }
                }
                catch (NoSuchPropertyException e) {
                    throw new ValidateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ValidateException(e.getCause());
                }
            }
            break block71;
            try {
                if (recset.searchDynamicConditionReal(this.searchCondition, params2).size() == 0) return false;
                return true;
            }
            catch (Exception e) {
                throw new ValidateException(e);
            }
            try {
                if (recordList.realSearch(this.searchCondition, params).size() == 0) return false;
                return true;
            }
            catch (Exception e) {
                throw new ValidateException(e);
            }
        }
        PropertySchema[] schemata = recordList.getRecordSchema().getPrimaryKeyPropertySchemata();
        if (schemata == null) throw new ValidateException("Size of primary key property not equal 1.");
        if (schemata.length != 1) {
            throw new ValidateException("Size of primary key property not equal 1.");
        }
        Record key = recordList.createRecord();
        key.setProperty(schemata[0].getName(), obj);
        if (recordList.searchByPrimaryKey(key) == null) return false;
        return true;
    }
}

