/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.websocket.AbstractMessageHandlerFactoryServiceMBean;
import jp.ossc.nimbus.service.websocket.SessionMessageHandler;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public abstract class AbstractMessageHandlerFactoryService
extends ServiceFactoryServiceBase
implements AbstractMessageHandlerFactoryServiceMBean {
    protected ServiceName webSocketAccessJournalServiceName;
    protected ServiceName editorFinderServiceName;
    protected ServiceName sequenceServiceName;
    protected String accessJournalKey = "Access";
    protected String idJournalKey = "Id";
    protected String ticketJournalKey = "Ticket";
    protected String webSocketSessionIdJournalKey = "WebSocketSessionId";
    protected String httpSessionIdJournalKey = "HttpSessionId";
    protected String pathJournalKey = "Path";
    protected String ipJournalKey = "Ip";
    protected String portJournalKey = "Port";
    protected String requestMessageJournalKey = "Message";
    protected String pingSendErrorMessageId = "WS___00005";
    protected String clientPingMessage;
    protected String returnPongMessage;
    protected Journal accessJournal;
    protected EditorFinder editorFinder;
    protected Sequence sequence;
    protected String messageEncoding = "UTF-8";

    @Override
    public ServiceName getWebSocketAccessJournalServiceName() {
        return this.webSocketAccessJournalServiceName;
    }

    @Override
    public void setWebSocketAccessJournalServiceName(ServiceName name) {
        this.webSocketAccessJournalServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public void setAccessJournalKey(String key) {
        this.accessJournalKey = key;
    }

    @Override
    public String getAccessJournalKey() {
        return this.accessJournalKey;
    }

    @Override
    public void setIdJournalKey(String key) {
        this.idJournalKey = key;
    }

    @Override
    public String getIdJournalKey() {
        return this.idJournalKey;
    }

    @Override
    public void setTicketJournalKey(String key) {
        this.ticketJournalKey = key;
    }

    @Override
    public String getTicketJournalKey() {
        return this.ticketJournalKey;
    }

    @Override
    public void setWebSocketSessionIdJournalKey(String key) {
        this.webSocketSessionIdJournalKey = key;
    }

    @Override
    public String getWebSocketSessionIdJournalKey() {
        return this.webSocketSessionIdJournalKey;
    }

    @Override
    public String getHttpSessionIdJournalKey() {
        return this.httpSessionIdJournalKey;
    }

    @Override
    public void setHttpSessionIdJournalKey(String key) {
        this.httpSessionIdJournalKey = key;
    }

    @Override
    public String getPathJournalKey() {
        return this.pathJournalKey;
    }

    @Override
    public void setPathJournalKey(String key) {
        this.pathJournalKey = key;
    }

    @Override
    public String getIpJournalKey() {
        return this.ipJournalKey;
    }

    @Override
    public void setIpJournalKey(String key) {
        this.ipJournalKey = key;
    }

    @Override
    public String getPortJournalKey() {
        return this.portJournalKey;
    }

    @Override
    public void setPortJournalKey(String key) {
        this.portJournalKey = key;
    }

    @Override
    public void setRequestMessageJournalKey(String key) {
        this.requestMessageJournalKey = key;
    }

    @Override
    public String getRequestMessageJournalKey() {
        return this.requestMessageJournalKey;
    }

    @Override
    public String getMessageEncoding() {
        return this.messageEncoding;
    }

    @Override
    public void setMessageEncoding(String encoding) {
        this.messageEncoding = encoding;
    }

    @Override
    public String getClientPingMessage() {
        return this.clientPingMessage;
    }

    @Override
    public void setClientPingMessage(String message) {
        this.clientPingMessage = message;
    }

    @Override
    public String getReturnPongMessage() {
        return this.returnPongMessage;
    }

    @Override
    public void setReturnPongMessage(String message) {
        this.returnPongMessage = message;
    }

    @Override
    public String getPingSendErrorMessageId() {
        return this.pingSendErrorMessageId;
    }

    @Override
    public void setPingSendErrorMessageId(String messageId) {
        this.pingSendErrorMessageId = messageId;
    }

    @Override
    public void startService() throws Exception {
        if (!Charset.isSupported(this.messageEncoding)) {
            throw new IllegalArgumentException(this.messageEncoding + " is not supported .");
        }
        if (this.webSocketAccessJournalServiceName != null) {
            this.accessJournal = (Journal)ServiceManagerFactory.getServiceObject(this.webSocketAccessJournalServiceName);
            if (this.editorFinderServiceName != null) {
                this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
            }
            if (this.sequenceServiceName != null) {
                this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
            } else {
                throw new IllegalArgumentException("SequenceServiceName is null.");
            }
        }
    }

    @Override
    protected abstract Service createServiceInstance() throws Exception;

    public abstract class AbstractMessageHandlerService
    extends ServiceBase
    implements MessageHandler.Whole<ByteBuffer>,
    SessionMessageHandler {
        protected Session session;

        @Override
        public void onOpen(Session session, EndpointConfig config) {
            this.session = session;
            this.onOpenProcess(session, config);
        }

        @Override
        public void onClose(Session session, CloseReason closeReason) {
            this.onCloseProcess(session, closeReason);
            try {
                super.stopService();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onError(Session session, Throwable thr) {
            this.onErrorProcess(session, thr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void onMessage(ByteBuffer msg) {
            block14: {
                String message;
                block12: {
                    block13: {
                        message = null;
                        if (AbstractMessageHandlerFactoryService.this.accessJournal != null) {
                            SessionProperties prop = SessionProperties.getSessionProperty(this.session);
                            AbstractMessageHandlerFactoryService.this.accessJournal.startJournal(AbstractMessageHandlerFactoryService.this.accessJournalKey, AbstractMessageHandlerFactoryService.this.editorFinder);
                            AbstractMessageHandlerFactoryService.this.accessJournal.setRequestId(AbstractMessageHandlerFactoryService.this.sequence.increment());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.idJournalKey, prop.getId());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.ticketJournalKey, prop.getTicket());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.webSocketSessionIdJournalKey, prop.getWebSocketSessionId());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.httpSessionIdJournalKey, prop.getHttpSessionId());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.pathJournalKey, prop.getPath());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.ipJournalKey, prop.getIp());
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.portJournalKey, prop.getPort());
                        }
                        byte[] byteArray = new byte[msg.remaining()];
                        msg.get(byteArray);
                        message = new String(byteArray, AbstractMessageHandlerFactoryService.this.messageEncoding);
                        if (AbstractMessageHandlerFactoryService.this.clientPingMessage == null || AbstractMessageHandlerFactoryService.this.returnPongMessage == null || !AbstractMessageHandlerFactoryService.this.clientPingMessage.equals(message)) break block12;
                        try {
                            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(AbstractMessageHandlerFactoryService.this.returnPongMessage.getBytes(AbstractMessageHandlerFactoryService.this.messageEncoding)));
                        }
                        catch (IOException e) {
                            if (!this.session.isOpen()) break block13;
                            this.getLogger().write(AbstractMessageHandlerFactoryService.this.pingSendErrorMessageId, SessionProperties.getSessionProperty(this.session), (Throwable)e);
                        }
                    }
                    if (AbstractMessageHandlerFactoryService.this.accessJournal != null) {
                        AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.requestMessageJournalKey, message);
                        AbstractMessageHandlerFactoryService.this.accessJournal.endJournal();
                    }
                    return;
                }
                try {
                    this.onMessageProcess(message);
                    if (AbstractMessageHandlerFactoryService.this.accessJournal != null) {
                        AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.requestMessageJournalKey, message);
                        AbstractMessageHandlerFactoryService.this.accessJournal.endJournal();
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (AbstractMessageHandlerFactoryService.this.accessJournal != null) {
                        AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.requestMessageJournalKey, message);
                        AbstractMessageHandlerFactoryService.this.accessJournal.endJournal();
                    }
                    break block14;
                    catch (Throwable throwable) {
                        if (AbstractMessageHandlerFactoryService.this.accessJournal != null) {
                            AbstractMessageHandlerFactoryService.this.accessJournal.addInfo(AbstractMessageHandlerFactoryService.this.requestMessageJournalKey, message);
                            AbstractMessageHandlerFactoryService.this.accessJournal.endJournal();
                        }
                        throw throwable;
                    }
                }
            }
        }

        protected abstract void onOpenProcess(Session var1, EndpointConfig var2);

        protected abstract void onCloseProcess(Session var1, CloseReason var2);

        protected abstract void onErrorProcess(Session var1, Throwable var2);

        protected abstract void onMessageProcess(String var1);
    }
}

