/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import javax.servlet.http.HttpServletRequest;

public class AuthResult {
    private String id;
    private String ticket;
    private boolean result;
    private String urlSchema;
    private String host;
    private int port = -1;
    private String contextPath;
    private String url;
    private String webSocketPath;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setUrlSchema(String urlSchema) {
        this.urlSchema = urlSchema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setWebSocketPath(String webSocketPath) {
        this.webSocketPath = webSocketPath;
    }

    public String getUrl() {
        if (this.result) {
            return this.url;
        }
        return null;
    }

    public void setUrl(HttpServletRequest req, String paramWebsocketPath) {
        this.urlSchema = AuthResult.removeSlashAndColon(this.urlSchema);
        if (this.urlSchema == null || this.urlSchema.length() == 0) {
            this.urlSchema = "ws";
        }
        this.host = AuthResult.removeSlashAndColon(this.host);
        if (this.host == null || this.host.length() == 0) {
            this.host = AuthResult.removeSlashAndColon(req.getLocalAddr());
        }
        if (this.port == -1) {
            this.port = req.getLocalPort();
        }
        this.contextPath = AuthResult.removeSlashAndColon(this.contextPath);
        if (this.contextPath == null || this.contextPath.length() == 0) {
            this.contextPath = AuthResult.removeSlashAndColon(req.getContextPath());
        }
        this.webSocketPath = AuthResult.removeSlashAndColon(this.webSocketPath);
        if (this.webSocketPath == null || this.webSocketPath.length() == 0) {
            this.webSocketPath = AuthResult.removeSlashAndColon(paramWebsocketPath);
        }
        this.url = this.urlSchema + "://" + this.host + ":" + this.port + "/" + this.contextPath + "/" + this.webSocketPath;
    }

    private static String removeSlashAndColon(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        String slash = "/";
        String colon = ":";
        while (str.startsWith("/") || str.endsWith("/") || str.startsWith(":") || str.endsWith(":")) {
            if (str.startsWith("/") || str.startsWith(":")) {
                str = str.substring(1);
            }
            if (!str.endsWith("/") && !str.endsWith(":")) continue;
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String toString() {
        return "[id:" + this.id + ", ticket:" + this.ticket + ", result:" + this.result + ", url:" + this.getUrl() + "]";
    }
}

