/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.util.List;
import javax.servlet.http.HttpSession;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.websocket.DefaultConfiguratorServiceMBean;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public class DefaultConfiguratorService
extends ServerEndpointConfig.Configurator
implements ServiceBaseSupport,
DefaultConfiguratorServiceMBean {
    protected ServiceName endpointServiceName;
    protected ServiceName threadContextServiceName;
    protected String path;
    protected String idKey = "id";
    protected String ticketKey = "ticket";
    protected String contextIpKey = "WebSocket-Remote-IP";
    protected String contextPortKey = "WebSocket-Remote-Port";
    protected ServiceBase service;
    protected Context threadContext;

    @Override
    public ServiceName getEndpointServiceName() {
        return this.endpointServiceName;
    }

    @Override
    public void setEndpointServiceName(ServiceName name) {
        this.endpointServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getIdKey() {
        return this.idKey;
    }

    @Override
    public void setIdKey(String key) {
        this.idKey = key;
    }

    @Override
    public String getTicketKey() {
        return this.ticketKey;
    }

    @Override
    public void setTicketKey(String key) {
        this.ticketKey = key;
    }

    @Override
    public String getContextIpKey() {
        return this.contextIpKey;
    }

    @Override
    public void setContextIpKey(String key) {
        this.contextIpKey = key;
    }

    @Override
    public String getContextPortKey() {
        return this.contextPortKey;
    }

    @Override
    public void setContextPortKey(String key) {
        this.contextPortKey = key;
    }

    @Override
    public Class getEndpointClass() throws ClassNotFoundException {
        ServiceMetaData metaData = ServiceManagerFactory.getServiceMetaData(this.getEndpointServiceName());
        return Utility.convertStringToClass(metaData.getCode());
    }

    @Override
    public void setServiceBase(ServiceBase service) {
        this.service = service;
    }

    @Override
    public void createService() throws Exception {
    }

    @Override
    public void startService() throws Exception {
        if (this.path == null || "".equals(this.path)) {
            throw new IllegalArgumentException("Path is null or Empty.");
        }
        if (this.endpointServiceName == null) {
            throw new IllegalArgumentException("EndpointServiceName is null.");
        }
        if (this.threadContextServiceName == null) {
            throw new IllegalArgumentException("ThreadContextServiceName is null.");
        }
        this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public void destroyService() throws Exception {
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        return (T)ServiceManagerFactory.getServiceObject(this.endpointServiceName);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        String id = null;
        String ticket = null;
        String ip = null;
        String port = null;
        List list = null;
        if (request.getHeaders().containsKey(this.idKey) && request.getHeaders().containsKey(this.ticketKey)) {
            list = (List)request.getHeaders().get(this.idKey);
            if (list != null && list.size() > 0) {
                id = (String)list.get(0);
            }
            if ((list = (List)request.getHeaders().get(this.ticketKey)) != null && list.size() > 0) {
                ticket = (String)list.get(0);
            }
        } else {
            list = (List)request.getParameterMap().get(this.idKey);
            if (list != null && list.size() > 0) {
                id = (String)list.get(0);
            }
            if ((list = (List)request.getParameterMap().get(this.ticketKey)) != null && list.size() > 0) {
                ticket = (String)list.get(0);
            }
        }
        if (this.threadContext.containsKey(this.contextIpKey)) {
            ip = (String)this.threadContext.get(this.contextIpKey);
        }
        if (this.threadContext.containsKey(this.contextPortKey)) {
            port = String.valueOf((Integer)this.threadContext.get(this.contextPortKey));
        }
        SessionProperties prop = new SessionProperties();
        prop.setId(id);
        prop.setTicket(ticket);
        prop.setIp(ip);
        prop.setPort(port);
        prop.setPath(this.path);
        prop.setHeaders(request.getHeaders());
        prop.setParameterMap(request.getParameterMap());
        Object httpSession = request.getHttpSession();
        if (httpSession != null && httpSession instanceof HttpSession) {
            prop.setHttpSessionId(((HttpSession)httpSession).getId());
        }
        sec.getUserProperties().put("SessionProperty", prop);
    }
}

