/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.websocket.AuthenticateException;
import jp.ossc.nimbus.service.websocket.Authenticator;
import jp.ossc.nimbus.service.websocket.CustomCloseReason;
import jp.ossc.nimbus.service.websocket.DefaultEndpointServiceMBean;
import jp.ossc.nimbus.service.websocket.ExceptionHandlerMappingService;
import jp.ossc.nimbus.service.websocket.SessionMessageHandler;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public class DefaultEndpointService
extends Endpoint
implements ServiceBaseSupport,
DefaultEndpointServiceMBean {
    protected ServiceName[] messageHandlerServiceNames;
    protected ServiceName authenticatorServiceName;
    protected ServiceName exceptionHandlerMappingServiceName;
    protected ServiceName webSocketAccessJournalServiceName;
    protected ServiceName editorFinderServiceName;
    protected ServiceName sequenceServiceName;
    protected int maxClientSize = -1;
    protected long maxIdleTimeout = -1L;
    protected int maxTextMessageBufferSize = -1;
    protected int maxBinaryMessageBufferSize = -1;
    protected String accessJournalKey = "Access";
    protected String idJournalKey = "Id";
    protected String ticketJournalKey = "Ticket";
    protected String webSocketSessionIdJournalKey = "WebSocketSessionId";
    protected String httpSessionIdJournalKey = "HttpSessionId";
    protected String pathJournalKey = "Path";
    protected String ipJournalKey = "Ip";
    protected String portJournalKey = "Port";
    protected String headerJournalKey = "Header";
    protected String parameterJournalKey = "Parameter";
    protected String requestMessageJournalKey = "Message";
    protected String closeReasonJournalKey = "CloseReason";
    protected String authResultJournalKey = "AuthResult";
    protected String exceptionJournalKey = "Exception";
    protected String illegalRequestMessageId = "WS___00002";
    protected String maxClientSizeOverMessageId = "WS___00003";
    protected String abnormalCloseMessageId = "WS___00004";
    protected Authenticator authenticator;
    protected ExceptionHandlerMappingService exceptionHandler;
    protected Journal accessJournal;
    protected EditorFinder editorFinder;
    protected Sequence sequence;
    protected Set sessionSet;
    protected ServiceBase service;

    @Override
    public ServiceName[] getMessageHandlerServiceNames() {
        return this.messageHandlerServiceNames;
    }

    @Override
    public void setMessageHandlerServiceNames(ServiceName[] names) {
        this.messageHandlerServiceNames = names;
    }

    @Override
    public ServiceName getAuthenticatorServiceName() {
        return this.authenticatorServiceName;
    }

    @Override
    public void setAuthenticatorServiceName(ServiceName name) {
        this.authenticatorServiceName = name;
    }

    @Override
    public ServiceName getExceptionHandlerMappingServiceName() {
        return this.exceptionHandlerMappingServiceName;
    }

    @Override
    public void setExceptionHandlerMappingServiceName(ServiceName name) {
        this.exceptionHandlerMappingServiceName = name;
    }

    @Override
    public ServiceName getWebSocketAccessJournalServiceName() {
        return this.webSocketAccessJournalServiceName;
    }

    @Override
    public void setWebSocketAccessJournalServiceName(ServiceName name) {
        this.webSocketAccessJournalServiceName = name;
    }

    @Override
    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    @Override
    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public void setAccessJournalKey(String key) {
        this.accessJournalKey = key;
    }

    @Override
    public String getAccessJournalKey() {
        return this.accessJournalKey;
    }

    @Override
    public void setIdJournalKey(String key) {
        this.idJournalKey = key;
    }

    @Override
    public String getIdJournalKey() {
        return this.idJournalKey;
    }

    @Override
    public void setTicketJournalKey(String key) {
        this.ticketJournalKey = key;
    }

    @Override
    public String getTicketJournalKey() {
        return this.ticketJournalKey;
    }

    @Override
    public void setWebSocketSessionIdJournalKey(String key) {
        this.webSocketSessionIdJournalKey = key;
    }

    @Override
    public String getWebSocketSessionIdJournalKey() {
        return this.webSocketSessionIdJournalKey;
    }

    @Override
    public String getHttpSessionIdJournalKey() {
        return this.httpSessionIdJournalKey;
    }

    @Override
    public void setHttpSessionIdJournalKey(String key) {
        this.httpSessionIdJournalKey = key;
    }

    @Override
    public String getPathJournalKey() {
        return this.pathJournalKey;
    }

    @Override
    public void setPathJournalKey(String key) {
        this.pathJournalKey = key;
    }

    @Override
    public String getIpJournalKey() {
        return this.ipJournalKey;
    }

    @Override
    public void setIpJournalKey(String key) {
        this.ipJournalKey = key;
    }

    @Override
    public String getPortJournalKey() {
        return this.portJournalKey;
    }

    @Override
    public void setPortJournalKey(String key) {
        this.portJournalKey = key;
    }

    @Override
    public String getHeaderJournalKey() {
        return this.headerJournalKey;
    }

    @Override
    public void setHeaderJournalKey(String key) {
        this.headerJournalKey = key;
    }

    @Override
    public String getParameterJournalKey() {
        return this.parameterJournalKey;
    }

    @Override
    public void setParameterJournalKey(String key) {
        this.parameterJournalKey = key;
    }

    @Override
    public void setRequestMessageJournalKey(String key) {
        this.requestMessageJournalKey = key;
    }

    @Override
    public String getRequestMessageJournalKey() {
        return this.requestMessageJournalKey;
    }

    @Override
    public void setCloseReasonJournalKey(String key) {
        this.closeReasonJournalKey = key;
    }

    @Override
    public String getCloseReasonJournalKey() {
        return this.closeReasonJournalKey;
    }

    @Override
    public void setAuthResultJournalKey(String key) {
        this.authResultJournalKey = key;
    }

    @Override
    public String getAuthResultJournalKey() {
        return this.authResultJournalKey;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public int getMaxClientSize() {
        return this.maxClientSize;
    }

    @Override
    public void setMaxClientSize(int size) {
        this.maxClientSize = size;
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    @Override
    public void setMaxIdleTimeout(long time) {
        this.maxIdleTimeout = time;
    }

    @Override
    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setMaxTextMessageBufferSize(int size) {
        this.maxTextMessageBufferSize = size;
    }

    @Override
    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setMaxBinaryMessageBufferSize(int size) {
        this.maxBinaryMessageBufferSize = size;
    }

    @Override
    public String getIllegalRequestMessageId() {
        return this.illegalRequestMessageId;
    }

    @Override
    public void setIllegalRequestMessageId(String id) {
        this.illegalRequestMessageId = id;
    }

    @Override
    public String getMaxClientSizeOverMessageId() {
        return this.maxClientSizeOverMessageId;
    }

    @Override
    public void setMaxClientSizeOverMessageId(String id) {
        this.maxClientSizeOverMessageId = id;
    }

    @Override
    public String getAbnormalCloseMessageId() {
        return this.abnormalCloseMessageId;
    }

    @Override
    public void setAbnormalCloseMessageId(String id) {
        this.abnormalCloseMessageId = id;
    }

    @Override
    public int getClientSize() {
        return this.sessionSet.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAllClientSessionProperties() {
        HashSet<SessionProperties> result = new HashSet<SessionProperties>();
        Set set = this.sessionSet;
        synchronized (set) {
            for (Session session : this.sessionSet) {
                result.add(SessionProperties.getSessionProperty(session));
            }
        }
        return ((Object)result).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set findClientSessionPropertiesFromSessionId(String sessionId) {
        HashSet<SessionProperties> result = new HashSet<SessionProperties>();
        if (sessionId != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!sessionId.equals(prop.getWebSocketSessionId())) continue;
                    result.add(prop);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClientSessionFromSessionId(String id) {
        if (id != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!id.equals(prop.getWebSocketSessionId())) continue;
                    CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.SYSTEM_FORCED_DISCONNECTION, "Forced disconnection");
                    try {
                        session.close((CloseReason)reason);
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set findClientSessionPropertiesFromIp(String ip) {
        HashSet<SessionProperties> result = new HashSet<SessionProperties>();
        if (ip != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!ip.equals(prop.getIp())) continue;
                    result.add(prop);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClientSessionFromIp(String ip) {
        if (ip != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!ip.equals(prop.getIp())) continue;
                    CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.SYSTEM_FORCED_DISCONNECTION, "Forced disconnection");
                    try {
                        session.close((CloseReason)reason);
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set findClientSessionPropertiesFromId(String id) {
        HashSet<SessionProperties> result = new HashSet<SessionProperties>();
        if (id != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!id.equals(prop.getId())) continue;
                    result.add(prop);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClientSessionFromId(String id) {
        if (id != null) {
            Set set = this.sessionSet;
            synchronized (set) {
                for (Session session : this.sessionSet) {
                    SessionProperties prop = SessionProperties.getSessionProperty(session);
                    if (!id.equals(prop.getId())) continue;
                    CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.SYSTEM_FORCED_DISCONNECTION, "Forced disconnection");
                    try {
                        session.close((CloseReason)reason);
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    @Override
    public void setServiceBase(ServiceBase service) {
        this.service = service;
    }

    @Override
    public void createService() throws Exception {
        this.sessionSet = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        if (this.messageHandlerServiceNames == null || this.messageHandlerServiceNames.length == 0) {
            throw new IllegalArgumentException("MessageHandlerServiceNames is null or empty.");
        }
        if (this.authenticatorServiceName != null) {
            this.authenticator = (Authenticator)ServiceManagerFactory.getServiceObject(this.authenticatorServiceName);
        }
        if (this.exceptionHandlerMappingServiceName != null) {
            this.exceptionHandler = (ExceptionHandlerMappingService)ServiceManagerFactory.getServiceObject(this.exceptionHandlerMappingServiceName);
        }
        if (this.webSocketAccessJournalServiceName != null) {
            this.accessJournal = (Journal)ServiceManagerFactory.getServiceObject(this.webSocketAccessJournalServiceName);
            if (this.editorFinderServiceName != null) {
                this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
            }
            if (this.sequenceServiceName != null) {
                this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
            } else {
                throw new IllegalArgumentException("SequenceServiceName is null.");
            }
        }
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public void destroyService() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig config) {
        try {
            SessionProperties prop = (SessionProperties)config.getUserProperties().get("SessionProperty");
            prop.setWebSocketSessionId(session.getId());
            if (this.accessJournal != null) {
                this.accessJournal.startJournal(this.accessJournalKey, this.editorFinder);
                this.accessJournal.setRequestId(this.sequence.increment());
                this.accessJournal.addInfo(this.idJournalKey, prop.getId());
                this.accessJournal.addInfo(this.ticketJournalKey, prop.getTicket());
                this.accessJournal.addInfo(this.webSocketSessionIdJournalKey, prop.getWebSocketSessionId());
                this.accessJournal.addInfo(this.httpSessionIdJournalKey, prop.getHttpSessionId());
                this.accessJournal.addInfo(this.pathJournalKey, prop.getPath());
                this.accessJournal.addInfo(this.ipJournalKey, prop.getIp());
                this.accessJournal.addInfo(this.portJournalKey, prop.getPort());
                this.accessJournal.addInfo(this.headerJournalKey, prop.getHeaders());
                this.accessJournal.addInfo(this.parameterJournalKey, prop.getParameterMap());
            }
            if (prop.getId() == null && prop.getTicket() == null) {
                CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.SERVER_ACCESS_DENIED, "Server access denied");
                try {
                    session.close((CloseReason)reason);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.service.getLogger().write(this.illegalRequestMessageId, (Object)prop.getIp());
                return;
            }
            if (this.maxClientSize != -1 && this.sessionSet.size() >= this.maxClientSize) {
                CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.MAX_CLIENT_SIZE_OVER, "MaxClientSizeOver");
                try {
                    session.close((CloseReason)reason);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.service.getLogger().write(this.maxClientSizeOverMessageId, prop);
                return;
            }
            if (this.authenticator != null) {
                boolean result = false;
                try {
                    result = this.authenticator.handshake(prop.getId(), prop.getTicket());
                }
                catch (AuthenticateException e) {
                    this.handleException(session, e);
                }
                if (!result) {
                    CustomCloseReason reason = new CustomCloseReason(CustomCloseReason.CloseCodes.HANDSHAKE_AUTH_FAILED, "handshakeAuthFailed");
                    try {
                        session.close((CloseReason)reason);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            SessionProperties.put(session, prop);
            if (this.maxIdleTimeout != -1L) {
                session.setMaxIdleTimeout(this.maxIdleTimeout);
            }
            if (this.maxTextMessageBufferSize != -1) {
                session.setMaxTextMessageBufferSize(this.maxTextMessageBufferSize);
            }
            if (this.maxBinaryMessageBufferSize != -1) {
                session.setMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize);
            }
            for (ServiceName handlerName : this.messageHandlerServiceNames) {
                Object service = ServiceManagerFactory.getServiceObject(handlerName);
                if (service instanceof MessageHandler) {
                    session.addMessageHandler((MessageHandler)service);
                }
                if (!(service instanceof SessionMessageHandler)) continue;
                ((SessionMessageHandler)service).onOpen(session, config);
            }
            Set set = this.sessionSet;
            synchronized (set) {
                this.sessionSet.add(session);
            }
        }
        finally {
            if (this.accessJournal != null && this.accessJournal.isStartJournal()) {
                this.accessJournal.endJournal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        try {
            SessionProperties prop;
            boolean isNormalClose;
            Object handler2;
            if (this.accessJournal != null) {
                SessionProperties prop2 = SessionProperties.getSessionProperty(session);
                this.accessJournal.startJournal(this.accessJournalKey, this.editorFinder);
                this.accessJournal.setRequestId(this.sequence.increment());
                if (prop2 != null) {
                    this.accessJournal.addInfo(this.idJournalKey, prop2.getId());
                    this.accessJournal.addInfo(this.ticketJournalKey, prop2.getTicket());
                    this.accessJournal.addInfo(this.webSocketSessionIdJournalKey, prop2.getWebSocketSessionId());
                    this.accessJournal.addInfo(this.httpSessionIdJournalKey, prop2.getHttpSessionId());
                    this.accessJournal.addInfo(this.pathJournalKey, prop2.getPath());
                    this.accessJournal.addInfo(this.ipJournalKey, prop2.getIp());
                    this.accessJournal.addInfo(this.portJournalKey, prop2.getPort());
                }
                this.accessJournal.addInfo(this.closeReasonJournalKey, closeReason);
            }
            Set messageHandlers = session.getMessageHandlers();
            for (Object handler2 : messageHandlers) {
                if (!(handler2 instanceof SessionMessageHandler)) continue;
                ((SessionMessageHandler)handler2).onClose(session, closeReason);
            }
            handler2 = this.sessionSet;
            synchronized (handler2) {
                this.sessionSet.remove(session);
            }
            boolean bl = isNormalClose = closeReason.getCloseCode().getCode() == CloseReason.CloseCodes.NORMAL_CLOSURE.getCode();
            if (this.authenticator != null && closeReason.getCloseCode().getCode() != CustomCloseReason.CloseCodes.HANDSHAKE_AUTH_FAILED.getCode() && (prop = SessionProperties.getSessionProperty(session)) != null) {
                String id = prop.getId();
                String ticket = prop.getTicket();
                try {
                    this.authenticator.logout(id, ticket, !isNormalClose);
                }
                catch (AuthenticateException e) {
                    this.handleException(session, e);
                }
            }
            if (!isNormalClose) {
                this.service.getLogger().write(this.abnormalCloseMessageId, new Object[]{SessionProperties.getSessionProperty(session), closeReason});
            }
        }
        finally {
            if (this.accessJournal != null && this.accessJournal.isStartJournal()) {
                this.accessJournal.endJournal();
            }
        }
    }

    public void onError(Session session, Throwable thr) {
        Set messageHandlers = session.getMessageHandlers();
        for (Object handler : messageHandlers) {
            if (!(handler instanceof SessionMessageHandler)) continue;
            ((SessionMessageHandler)handler).onError(session, thr);
        }
        this.handleException(session, thr);
    }

    protected void handleException(Session session, Throwable thr) {
        if (this.exceptionHandler != null) {
            try {
                this.exceptionHandler.handleException(session, thr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

