/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import javax.websocket.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.websocket.DefaultExceptionHandlerServiceMBean;
import jp.ossc.nimbus.service.websocket.ExceptionHandler;
import jp.ossc.nimbus.service.websocket.SessionProperties;

public class DefaultExceptionHandlerService
extends ServiceBase
implements DefaultExceptionHandlerServiceMBean,
ExceptionHandler {
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected String logMessageCode;
    protected String[] logMessageArguments;
    protected boolean isOutputStackTraceLog = true;
    protected boolean isOutputSessionProperty = false;
    protected String exceptionJournalKey = "Exception";
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected boolean isThrowException;

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setLogMessageCode(String code) {
        this.logMessageCode = code;
    }

    @Override
    public String getLogMessageCode() {
        return this.logMessageCode;
    }

    @Override
    public void setLogMessageArguments(String[] args) {
        this.logMessageArguments = args;
    }

    @Override
    public String[] getLogMessageArguments() {
        return this.logMessageArguments;
    }

    @Override
    public void setOutputStackTraceLog(boolean isOutput) {
        this.isOutputStackTraceLog = isOutput;
    }

    @Override
    public boolean isOutputStackTraceLog() {
        return this.isOutputStackTraceLog;
    }

    @Override
    public boolean isOutputSessionProperty() {
        return this.isOutputSessionProperty;
    }

    @Override
    public void setOutputSessionProperty(boolean isOutput) {
        this.isOutputSessionProperty = isOutput;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    @Override
    public void setThrowException(boolean isThrow) {
        this.isThrowException = isThrow;
    }

    @Override
    public boolean isThrowException() {
        return this.isThrowException;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    @Override
    public void handleException(Session session, Throwable th) throws Throwable {
        if (this.logMessageCode != null) {
            Logger log = super.getLogger();
            if (this.isOutputStackTraceLog) {
                if (session != null && this.isOutputSessionProperty) {
                    log.write(this.logMessageCode, SessionProperties.getSessionProperty(session), th);
                } else {
                    log.write(this.logMessageCode, this.logMessageArguments, th);
                }
            } else if (session != null && this.isOutputSessionProperty) {
                log.write(this.logMessageCode, SessionProperties.getSessionProperty(session));
            } else {
                log.write(this.logMessageCode, this.logMessageArguments);
            }
        }
        if (this.journal != null && this.journal.isStartJournal()) {
            this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
        }
        if (this.isThrowException) {
            throw th;
        }
    }
}

