/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.websocket.NimbusConfigurator;

public class NimbusServerApplicationConfig
implements ServerApplicationConfig {
    public static final String SERVICE_DEFINITION_LIST = "service-definition.list";

    public NimbusServerApplicationConfig() throws IOException, DeploymentException {
        String[] serviceDefinitionFiles = NimbusServerApplicationConfig.getLoadTargetFileNames();
        for (int i = 0; i < serviceDefinitionFiles.length; ++i) {
            boolean result = ServiceManagerFactory.loadManager(serviceDefinitionFiles[i], true, true);
            if (result) continue;
            throw new DeploymentException("Service load faild. load file is " + serviceDefinitionFiles[i]);
        }
        boolean isCompleted = ServiceManagerFactory.checkLoadManagerCompleted();
        if (!isCompleted) {
            throw new DeploymentException("Service load faild. ServiceManagerFactory.checkLoadManagerCompleted is false.");
        }
    }

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        HashSet<ServerEndpointConfig> result = new HashSet<ServerEndpointConfig>();
        ServiceManager[] managers = ServiceManagerFactory.findManagers();
        for (int i = 0; i < managers.length; ++i) {
            Set serviceNameSet = managers[i].serviceNameSet();
            for (Object name : serviceNameSet) {
                ServiceMetaData metaData = null;
                try {
                    metaData = managers[i].getServiceMetaData((String)name);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
                if (metaData == null) continue;
                try {
                    Object config;
                    Class endpoint;
                    Class serviceClass = Utility.convertStringToClass(metaData.getCode());
                    if (!NimbusConfigurator.class.isAssignableFrom(serviceClass) || !ServerEndpointConfig.Configurator.class.isAssignableFrom(serviceClass) || !scanned.contains(endpoint = ((NimbusConfigurator)(config = managers[i].getServiceObject((String)name))).getEndpointClass())) continue;
                    String path = ((NimbusConfigurator)config).getPath();
                    ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create((Class)endpoint, (String)path);
                    builder.configurator((ServerEndpointConfig.Configurator)config);
                    result.add(builder.build());
                }
                catch (ClassNotFoundException e) {}
            }
        }
        return result;
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLoadTargetFileNames() throws IOException {
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream is = NimbusServerApplicationConfig.class.getClassLoader().getResourceAsStream(SERVICE_DEFINITION_LIST);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            String serviceFile = null;
            while ((serviceFile = br.readLine()) != null) {
                resultList.add(serviceFile.trim());
            }
        }
        finally {
            br.close();
            isr.close();
            is.close();
        }
        return resultList.toArray(new String[0]);
    }
}

