/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.websocket.AuthResult;
import jp.ossc.nimbus.service.websocket.AuthenticateException;
import jp.ossc.nimbus.service.websocket.Authenticator;
import jp.ossc.nimbus.service.websocket.ExceptionHandlerMappingService;
import jp.ossc.nimbus.service.websocket.NimbusConfigurator;
import jp.ossc.nimbus.service.websocket.NimbusServerApplicationConfig;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class WebSocketAuthServlet
extends HttpServlet {
    protected static final String INIT_PARAM_NAME_AUTHENTICATOR_SERVICE_NAME = "AuthenticatorServiceName";
    protected static final String INIT_PARAM_NAME_CONFIGURATOR_SERVICE_NAME = "ConfiguratorServiceName";
    protected static final String INIT_PARAM_NAME_ACCESS_JOURNAL_SERVICE_NAME = "WebSocketAccessJournalServiceName";
    protected static final String INIT_PARAM_NAME_SEQUENCE_SERVICE_NAME = "SequenceServiceName";
    protected static final String INIT_PARAM_NAME_EXCEPTION_HANDLER_MAPPING_SERVICE_NAME = "ExceptionHandlerMappingServiceName";
    protected static final String INIT_PARAM_NAME_EDITOR_FINDER_SERVICE_NAME = "EditorFinderServiceName";
    protected static final String INIT_PARAM_NAME_CONVERTER_MAP_DEF = "ConverterMapDefinition";
    protected static final String INIT_PARAM_NAME_FORWARD_PATH_MAP_DEF = "ForwardPathMapDefinition";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_KEY = "AuthRsultKey";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_ID = "ResponseHeaderWebSocketIdKey";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_TICKET = "ResponseHeaderWebSocketTicketKey";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_AUTH_RESULT = "ResponseHeaderWebSocketAuthResultKey";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_URL = "ResponseHeaderWebSocketURLKey";
    protected static final String INIT_PARAM_NAME_ACCESS_JOURNAL_KEY = "AccessJournalKey";
    protected static final String INIT_PARAM_NAME_HTTP_SESSION_ID_JOURNAL_KEY = "HttpSessionIdJournalKey";
    protected static final String INIT_PARAM_NAME_PATH_JOURNAL_KEY = "PathJournalKey";
    protected static final String INIT_PARAM_NAME_IP_JOURNAL_KEY = "IpJournalKey";
    protected static final String INIT_PARAM_NAME_PORT_JOURNAL_KEY = "PortJournalKey";
    protected static final String INIT_PARAM_NAME_HEADER_JOURNAL_KEY = "HeaderJournalKey";
    protected static final String INIT_PARAM_NAME_PARAMETER_JOURNAL_KEY = "ParameterJournalKey";
    protected static final String INIT_PARAM_NAME_AUTH_RESULT_JOURNAL_KEY = "AuthResultJournalKey";
    protected static final String INIT_PARAM_NAME_EXCEPTION_JOURNAL_KEY = "ExceptionJournalKey";
    protected static final String DEFAULT_AUTH_RESULT_KEY = "AuthRsult";
    protected static final String DEFAULT_AUTH_RESULT_ID_HEADER_KEY = "X-nimbus-websocket-id";
    protected static final String DEFAULT_AUTH_RESULT_TICKET_HEADER_KEY = "X-nimbus-websocket-ticket";
    protected static final String DEFAULT_AUTH_RESULT_AUTH_RESULT_HEADER_KEY = "X-nimbus-websocket-auth-result";
    protected static final String DEFAULT_AUTH_RESULT_URL_HEADER_KEY = "X-nimbus-websocket-url";
    protected static final String DEFAULT_ACCESS_JOURNAL_KEY = "Access";
    protected static final String DEFAULT_HTTP_SESSION_ID_JOURNAL_KEY = "HttpSessionId";
    protected static final String DEFAULT_PATH_JOURNAL_KEY = "Path";
    protected static final String DEFAULT_IP_JOURNAL_KEY = "Ip";
    protected static final String DEFAULT_PORT_JOURNAL_KEY = "Port";
    protected static final String DEFAULT_HEADER_JOURNAL_KEY = "Header";
    protected static final String DEFAULT_PARAMETER_JOURNAL_KEY = "Parameter";
    protected static final String DEFAULT_AUTH_RESULT_JOURNAL_KEY = "AuthResult";
    protected static final String DEFAULT_EXCEPTION_JOURNAL_KEY = "Exception";
    protected static final String HTTP_HEADER_NAME_ACCEPT = "Accept";
    protected static final String HTTP_HEADER_NAME_ACCEPT_CHARSET = "Accept-Charset";
    protected Authenticator authenticator;
    protected Journal accessJournal;
    protected EditorFinder editorFinder;
    protected Sequence sequence;
    protected ExceptionHandlerMappingService exceptionHandler;
    protected String configWebsocketPath;
    protected String responseHeaderWebSocketIdKey = "X-nimbus-websocket-id";
    protected String responseHeaderWebSocketTicketKey = "X-nimbus-websocket-ticket";
    protected String responseHeaderWebSocketAuthResultKey = "X-nimbus-websocket-auth-result";
    protected String responseHeaderWebSocketURLKey = "X-nimbus-websocket-url";
    protected String accessJournalKey = "Access";
    protected String httpSessionIdJournalKey = "HttpSessionId";
    protected String pathJournalKey = "Path";
    protected String ipJournalKey = "Ip";
    protected String portJournalKey = "Port";
    protected String headerJournalKey = "Header";
    protected String parameterJournalKey = "Parameter";
    protected String authResultJournalKey = "AuthResult";
    protected String exceptionJournalKey = "Exception";
    protected String authRsultKey = "AuthRsult";
    protected Map responseConverterMap;
    protected Map forwardPathMap;

    public void init() throws ServletException {
        String initExceptionJournalKey;
        String initAuthResultJournalKey;
        String initParameterJournalKey;
        String initHeaderJournalKey;
        String initPortJournalKey;
        String initIpJournalKey;
        String initPathJournalKey;
        String initHttpSessionIdJournalKey;
        String initAccessJournalKey;
        String initResponseHeaderWebSocketURLKey;
        String initResponseHeaderWebSocketAuthResultKey;
        String initResponseHeaderWebSocketTicketKey;
        String initResponseHeaderWebSocketIdKey;
        String initAuthRsultKey;
        String forwardPathMapDefStr;
        String converterMapDefStr;
        ServiceName exceptionHandlerMappingServiceName;
        ServiceName configratorServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_CONFIGURATOR_SERVICE_NAME);
        if (configratorServiceName == null) {
            throw new ServletException("ConfigratorServiceName is null.");
        }
        NimbusConfigurator configrator = (NimbusConfigurator)ServiceManagerFactory.getServiceObject(configratorServiceName);
        this.configWebsocketPath = configrator.getPath();
        ServiceName authenticatorServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_AUTHENTICATOR_SERVICE_NAME);
        if (authenticatorServiceName == null) {
            throw new ServletException("AuthenticatorServiceName is null.");
        }
        this.authenticator = (Authenticator)ServiceManagerFactory.getServiceObject(authenticatorServiceName);
        ServiceName accessJournalServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_ACCESS_JOURNAL_SERVICE_NAME);
        if (accessJournalServiceName != null) {
            ServiceName sequenceServiceName;
            this.accessJournal = (Journal)ServiceManagerFactory.getServiceObject(accessJournalServiceName);
            ServiceName editorFinderServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_EDITOR_FINDER_SERVICE_NAME);
            if (editorFinderServiceName != null) {
                this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(editorFinderServiceName);
            }
            if ((sequenceServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_SEQUENCE_SERVICE_NAME)) != null) {
                this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(sequenceServiceName);
            } else {
                throw new ServletException("SequenceServiceName is null.");
            }
        }
        if ((exceptionHandlerMappingServiceName = this.getInitialParameterServiceName(INIT_PARAM_NAME_EXCEPTION_HANDLER_MAPPING_SERVICE_NAME)) != null) {
            this.exceptionHandler = (ExceptionHandlerMappingService)ServiceManagerFactory.getServiceObject(exceptionHandlerMappingServiceName);
        }
        if ((converterMapDefStr = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_CONVERTER_MAP_DEF)) != null && converterMapDefStr.length() != 0) {
            this.createResponseConverterMap(converterMapDefStr);
        }
        if ((forwardPathMapDefStr = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_FORWARD_PATH_MAP_DEF)) != null && forwardPathMapDefStr.length() != 0) {
            this.createForwardPathMap(forwardPathMapDefStr);
        }
        if ((initAuthRsultKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_KEY)) != null && initAuthRsultKey.length() > 0) {
            this.authRsultKey = initAuthRsultKey;
        }
        if ((initResponseHeaderWebSocketIdKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_ID)) != null && initResponseHeaderWebSocketIdKey.length() > 0) {
            this.responseHeaderWebSocketIdKey = initResponseHeaderWebSocketIdKey;
        }
        if ((initResponseHeaderWebSocketTicketKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_TICKET)) != null && initResponseHeaderWebSocketTicketKey.length() > 0) {
            this.responseHeaderWebSocketTicketKey = initResponseHeaderWebSocketTicketKey;
        }
        if ((initResponseHeaderWebSocketAuthResultKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_AUTH_RESULT)) != null && initResponseHeaderWebSocketAuthResultKey.length() > 0) {
            this.responseHeaderWebSocketAuthResultKey = initResponseHeaderWebSocketAuthResultKey;
        }
        if ((initResponseHeaderWebSocketURLKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_URL)) != null && initResponseHeaderWebSocketURLKey.length() > 0) {
            this.responseHeaderWebSocketURLKey = initResponseHeaderWebSocketURLKey;
        }
        if ((initAccessJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_ACCESS_JOURNAL_KEY)) != null && initAccessJournalKey.length() > 0) {
            this.accessJournalKey = initAccessJournalKey;
        }
        if ((initHttpSessionIdJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_HTTP_SESSION_ID_JOURNAL_KEY)) != null && initHttpSessionIdJournalKey.length() > 0) {
            this.httpSessionIdJournalKey = initHttpSessionIdJournalKey;
        }
        if ((initPathJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_PATH_JOURNAL_KEY)) != null && initPathJournalKey.length() > 0) {
            this.pathJournalKey = initPathJournalKey;
        }
        if ((initIpJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_IP_JOURNAL_KEY)) != null && initIpJournalKey.length() > 0) {
            this.ipJournalKey = initIpJournalKey;
        }
        if ((initPortJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_PORT_JOURNAL_KEY)) != null && initPortJournalKey.length() > 0) {
            this.portJournalKey = initPortJournalKey;
        }
        if ((initHeaderJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_HEADER_JOURNAL_KEY)) != null && initHeaderJournalKey.length() > 0) {
            this.headerJournalKey = initHeaderJournalKey;
        }
        if ((initParameterJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_PARAMETER_JOURNAL_KEY)) != null && initParameterJournalKey.length() > 0) {
            this.parameterJournalKey = initParameterJournalKey;
        }
        if ((initAuthResultJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_AUTH_RESULT_JOURNAL_KEY)) != null && initAuthResultJournalKey.length() > 0) {
            this.authResultJournalKey = initAuthResultJournalKey;
        }
        if ((initExceptionJournalKey = this.getServletConfig().getInitParameter(INIT_PARAM_NAME_EXCEPTION_JOURNAL_KEY)) != null && initExceptionJournalKey.length() > 0) {
            this.exceptionJournalKey = initExceptionJournalKey;
        }
    }

    public void destroy() {
        String[] serviceDefinitionFiles = null;
        try {
            serviceDefinitionFiles = NimbusServerApplicationConfig.getLoadTargetFileNames();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (serviceDefinitionFiles != null) {
            for (String file : serviceDefinitionFiles) {
                ServiceManagerFactory.unloadManager(file);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.auth(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.auth(req, res);
    }

    protected void auth(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            AuthResult result;
            block31: {
                if (this.accessJournal != null) {
                    this.accessJournal.startJournal(this.accessJournalKey, this.editorFinder);
                    this.accessJournal.setRequestId(this.sequence.increment());
                    HashMap paramMap = new HashMap();
                    for (Map.Entry entry : req.getParameterMap().entrySet()) {
                        String[] values = (String[])entry.getValue();
                        StringBuffer value = new StringBuffer();
                        for (int i = 0; i < values.length; ++i) {
                            if (value.length() > 0) {
                                value.append(", ");
                            }
                            value.append(values[i]);
                        }
                        paramMap.put(entry.getKey(), value.toString());
                    }
                    this.accessJournal.addInfo(this.parameterJournalKey, paramMap);
                    if (req.getSession(false) != null) {
                        this.accessJournal.addInfo(this.httpSessionIdJournalKey, req.getSession().getId());
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    Enumeration e = req.getHeaderNames();
                    while (e.hasMoreElements()) {
                        String headerName = (String)e.nextElement();
                        headers.put(headerName, req.getHeader(headerName));
                    }
                    this.accessJournal.addInfo(this.headerJournalKey, headers);
                    this.accessJournal.addInfo(this.ipJournalKey, req.getRemoteAddr());
                    this.accessJournal.addInfo(this.portJournalKey, req.getRemotePort());
                    this.accessJournal.addInfo(this.pathJournalKey, req.getRequestURI());
                }
                result = new AuthResult();
                try {
                    result = this.authenticator.login(req, res);
                }
                catch (AuthenticateException e) {
                    result.setResult(false);
                    if (this.accessJournal == null) break block31;
                    this.accessJournal.addInfo(this.exceptionJournalKey, e);
                }
            }
            result.setUrl(req, this.configWebsocketPath);
            if (this.accessJournal != null) {
                this.accessJournal.addInfo(this.authResultJournalKey, result);
            }
            if (this.forwardPathMap != null && this.forward(req, res, result)) {
                return;
            }
            if (this.responseConverterMap != null) {
                this.setAcceptCharset(req, res);
                if (this.writeResponseBody(req, res, result)) {
                    return;
                }
            }
            res.setHeader(this.responseHeaderWebSocketIdKey, result.getId());
            res.setHeader(this.responseHeaderWebSocketTicketKey, result.getTicket());
            res.setHeader(this.responseHeaderWebSocketAuthResultKey, String.valueOf(result.isResult()));
            res.setHeader(this.responseHeaderWebSocketURLKey, result.getUrl());
        }
        catch (ServletException e) {
            if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.handleException(null, e);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (IOException e) {
            if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.handleException(null, e);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.handleException(null, e);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            if (this.accessJournal != null) {
                this.accessJournal.endJournal();
            }
        }
    }

    protected void setAcceptCharset(HttpServletRequest req, HttpServletResponse res) {
        String acceptCharsetStr = req.getHeader(HTTP_HEADER_NAME_ACCEPT_CHARSET);
        if (acceptCharsetStr != null) {
            AcceptCharset acceptCharset = null;
            try {
                acceptCharset = new AcceptCharset(acceptCharsetStr);
            }
            catch (IllegalArgumentException e) {
                ServiceManagerFactory.getLogger().write("WSSV_00003", (Object)acceptCharsetStr, (Throwable)e);
                return;
            }
            boolean isSupported = false;
            for (int i = 0; i < acceptCharset.charsetRanges.size(); ++i) {
                CharsetRange cr = (CharsetRange)acceptCharset.charsetRanges.get(i);
                if (!Charset.isSupported(cr.getCharset())) continue;
                isSupported = true;
                res.setCharacterEncoding(Charset.forName(cr.getCharset()).name());
                break;
            }
            if (!isSupported) {
                ServiceManagerFactory.getLogger().write("WSSV_00004", (Object)acceptCharsetStr);
            }
        }
    }

    protected boolean forward(HttpServletRequest req, HttpServletResponse res, AuthResult result) throws ServletException, IOException {
        MediaRange mr;
        String acceptStr = req.getHeader(HTTP_HEADER_NAME_ACCEPT);
        String forwardPath = null;
        Accept accept = null;
        try {
            accept = new Accept(acceptStr);
        }
        catch (IllegalArgumentException e) {
            ServiceManagerFactory.getLogger().write("WSSV_00002", (Object)acceptStr, (Throwable)e);
            return false;
        }
        for (int i = 0; i < accept.mediaRanges.size() && (forwardPath = (String)this.forwardPathMap.get((mr = (MediaRange)accept.mediaRanges.get(i)).getMediaType())) == null; ++i) {
        }
        if (acceptStr == null || forwardPath == null) {
            return false;
        }
        if (result.isResult()) {
            req.setAttribute(this.authRsultKey, (Object)result);
            RequestDispatcher dispatch = req.getRequestDispatcher(forwardPath);
            dispatch.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            res.setStatus(403);
        }
        return true;
    }

    protected boolean writeResponseBody(HttpServletRequest req, HttpServletResponse res, AuthResult result) throws IOException {
        String acceptStr = req.getHeader(HTTP_HEADER_NAME_ACCEPT);
        StreamConverter responseConverter = null;
        String mediaType = null;
        if (acceptStr == null) {
            return false;
        }
        Accept accept = null;
        try {
            accept = new Accept(acceptStr);
        }
        catch (IllegalArgumentException e) {
            ServiceManagerFactory.getLogger().write("WSSV_00002", (Object)acceptStr, (Throwable)e);
            return false;
        }
        for (int i = 0; i < accept.mediaRanges.size(); ++i) {
            MediaRange mr = (MediaRange)accept.mediaRanges.get(i);
            responseConverter = (StreamConverter)this.responseConverterMap.get(mr.getMediaType());
            if (responseConverter == null) continue;
            mediaType = mr.getMediaType();
            break;
        }
        if (mediaType == null) {
            return false;
        }
        if (responseConverter instanceof StreamStringConverter && res.getCharacterEncoding() != null && !res.getCharacterEncoding().equals(((StreamStringConverter)responseConverter).getCharacterEncodingToStream())) {
            responseConverter = ((StreamStringConverter)responseConverter).cloneCharacterEncodingToStream(res.getCharacterEncoding());
        }
        res.setContentType(new ContentType(mediaType, res.getCharacterEncoding()).toString());
        InputStream is = responseConverter.convertToStream(result);
        ServletOutputStream sos = res.getOutputStream();
        byte[] bytes = new byte[2048];
        int readLen = 0;
        while ((readLen = is.read(bytes)) != -1) {
            sos.write(bytes, 0, readLen);
        }
        return true;
    }

    private ServiceName getInitialParameterServiceName(String name) {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(name);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private void createResponseConverterMap(String initialParam) {
        this.responseConverterMap = new HashMap();
        StringArrayEditor arrayEditor = new StringArrayEditor();
        arrayEditor.setAsText(initialParam);
        String[] converters = (String[])arrayEditor.getValue();
        for (int i = 0; i < converters.length; ++i) {
            String[] converter = converters[i].split("=");
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setAsText(converter[1]);
            this.responseConverterMap.put(converter[0], ServiceManagerFactory.getServiceObject((ServiceName)editor.getValue()));
        }
    }

    private void createForwardPathMap(String initialParam) {
        this.forwardPathMap = new HashMap();
        StringArrayEditor arrayEditor = new StringArrayEditor();
        arrayEditor.setAsText(initialParam);
        String[] converters = (String[])arrayEditor.getValue();
        for (int i = 0; i < converters.length; ++i) {
            String[] converter = converters[i].split("=");
            this.forwardPathMap.put(converter[0], converter[1]);
        }
    }

    protected static class AcceptCharset {
        public final List charsetRanges;

        public AcceptCharset(String header) throws IllegalArgumentException {
            String[] charsetRangeArray = header.split(",");
            this.charsetRanges = new ArrayList(charsetRangeArray.length);
            for (int i = 0; i < charsetRangeArray.length; ++i) {
                this.charsetRanges.add(new CharsetRange(charsetRangeArray[i]));
            }
            Collections.sort(this.charsetRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((CharsetRange)o1).q == ((CharsetRange)o2).q ? 0 : (((CharsetRange)o1).q > ((CharsetRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class Accept {
        public final List mediaRanges;

        public Accept(String header) throws IllegalArgumentException {
            String[] mediaRangeArray = header.split(",");
            this.mediaRanges = new ArrayList(mediaRangeArray.length);
            for (int i = 0; i < mediaRangeArray.length; ++i) {
                this.mediaRanges.add(new MediaRange(mediaRangeArray[i]));
            }
            Collections.sort(this.mediaRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MediaRange)o1).q == ((MediaRange)o2).q ? 0 : (((MediaRange)o1).q > ((MediaRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class CharsetRange
    extends HeaderValue {
        protected float q = 1.0f;

        public CharsetRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }

        public String getCharset() {
            return this.getValue();
        }

        public void setCharset(String charset) {
            this.setValue(charset);
        }
    }

    protected static class MediaRange
    extends MediaType {
        protected float q = 1.0f;

        public MediaRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }
    }

    protected static class ContentType
    extends MediaType {
        public ContentType(String mediaType, String charset) {
            this.setMediaType(mediaType);
            this.setCharset(charset);
        }

        public String getCharset() {
            return this.getParameter("charset");
        }

        public void setCharset(String charset) {
            this.setParameter("charset", charset);
        }
    }

    protected static class MediaType
    extends HeaderValue {
        public MediaType() {
        }

        public MediaType(String header) {
            super(header);
        }

        public String getMediaType() {
            return this.getValue();
        }

        public void setMediaType(String type) {
            this.setValue(type);
        }
    }

    protected static class HeaderValue {
        protected String value;
        protected Map parameters;
        protected int hashCode;

        public HeaderValue() {
        }

        public HeaderValue(String header) {
            String[] types = header.split(";");
            this.value = types[0].trim();
            this.hashCode = this.value.hashCode();
            if (types.length > 1) {
                this.parameters = new HashMap();
                for (int i = 1; i < types.length; ++i) {
                    String parameter = types[i].trim();
                    int index = parameter.indexOf(61);
                    if (index != -1) {
                        this.parameters.put(parameter.substring(0, index).toLowerCase(), parameter.substring(index + 1).toLowerCase());
                        continue;
                    }
                    this.parameters.put(parameter.toLowerCase(), null);
                }
                this.hashCode += this.parameters.hashCode();
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public String getParameter(String name) {
            return this.parameters == null ? null : (String)this.parameters.get(name);
        }

        public void setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            this.parameters.put(name, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.value);
            if (this.parameters != null) {
                for (Map.Entry entry : this.parameters.entrySet()) {
                    buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
                }
            }
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderValue)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HeaderValue cmp = (HeaderValue)obj;
            if (!this.value.equals(cmp.value)) {
                return false;
            }
            return !(this.parameters == null && cmp.parameters != null || this.parameters != null && cmp.parameters == null) && (this.parameters == null || this.parameters.equals(cmp.parameters));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

