/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordListPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordPropertySchema;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.beans.dataset.XpathPropertySchema;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataSetXpathConverter
implements BindingStreamConverter,
StreamStringConverter,
Cloneable {
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isSynchronizedDomParse;
    protected String documentBuilderFactoryClass;

    public void setDocumentBuilderFactoryClassName(String clazz) {
        this.documentBuilderFactoryClass = clazz;
    }

    @Override
    public void setConvertType(int convertType) {
        this.convertType = convertType;
    }

    @Override
    public void setCharacterEncodingToObject(String characterEncodingToObject) {
        this.characterEncodingToObject = characterEncodingToObject;
    }

    @Override
    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    @Override
    public void setCharacterEncodingToStream(String characterEncodingToStream) {
        this.characterEncodingToStream = characterEncodingToStream;
    }

    @Override
    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    @Override
    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        if (encoding == null && this.characterEncodingToStream == null || encoding != null && encoding.equals(this.characterEncodingToStream)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToStream(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        if (encoding == null && this.characterEncodingToObject == null || encoding != null && encoding.equals(this.characterEncodingToObject)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToObject(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setSynchronizedDomParse(boolean isSync) {
        this.isSynchronizedDomParse = isSync;
    }

    public boolean isSynchronizedDomParse() {
        return this.isSynchronizedDomParse;
    }

    @Override
    public Object convertToObject(InputStream inputStream, Object returnObject) throws ConvertException {
        DataSet result = null;
        if (returnObject != null) {
            if (!DataSet.class.isAssignableFrom(returnObject.getClass())) {
                throw new ConvertException("A return object is not a sub-class of DataSet.");
            }
        } else {
            throw new ConvertException("A return object is not specified.");
        }
        result = ((DataSet)returnObject).cloneDataSet();
        Document document = this.parseXml(inputStream);
        this.validateXml(document);
        for (Header header : result.getHeaderMap().values()) {
            this.createRecord(document, result, header, header.getRecordSchema());
        }
        for (RecordList recordList : result.getRecordListMap().values()) {
            this.createRecord(document, result, recordList, recordList.getRecordSchema());
        }
        return result;
    }

    private void createRecord(Document document, DataSet dataSet, Object target, RecordSchema recordSchema) {
        PropertySchema[] propertySchemata = recordSchema.getPropertySchemata();
        for (int i = 0; i < propertySchemata.length; ++i) {
            RecordSchema nestedRecordSchema;
            if (propertySchemata[i] instanceof XpathPropertySchema) {
                int j;
                XpathPropertySchema xmlBindingPropertySchema = (XpathPropertySchema)propertySchemata[i];
                XPathExpression expression = xmlBindingPropertySchema.getXpathExpression();
                NodeList nodeList = null;
                try {
                    nodeList = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    throw new ConvertException("The converter failed to evaluate a XML. ", e);
                }
                int length = nodeList.getLength();
                if (target instanceof Record) {
                    if (length <= 0) continue;
                    String nodeValue = nodeList.item(0).getNodeValue();
                    ((Record)target).setParseProperty(xmlBindingPropertySchema.getName(), (Object)nodeValue);
                    continue;
                }
                if (!(target instanceof RecordList)) continue;
                RecordList targetRecordList = (RecordList)target;
                int offset = length - targetRecordList.size();
                if (offset > 0) {
                    for (j = 0; j < offset; ++j) {
                        Record record = targetRecordList.createRecord();
                        targetRecordList.addRecord(record);
                    }
                }
                for (j = 0; j < length; ++j) {
                    String nodeValue = nodeList.item(j).getNodeValue();
                    Record record = targetRecordList.getRecord(j);
                    record.setParseProperty(xmlBindingPropertySchema.getName(), (Object)nodeValue);
                }
                continue;
            }
            if (propertySchemata[i] instanceof RecordPropertySchema) {
                RecordPropertySchema recordPropertySchema = (RecordPropertySchema)propertySchemata[i];
                nestedRecordSchema = dataSet.getNestedRecordSchema(recordPropertySchema.getName());
                Record nestedRecord = dataSet.createNestedRecord(recordPropertySchema.getRecordName());
                this.createRecord(document, dataSet, target, nestedRecordSchema);
                ((Record)target).setProperty(recordPropertySchema.getName(), (Object)nestedRecord);
                continue;
            }
            if (!(propertySchemata[i] instanceof RecordListPropertySchema)) continue;
            RecordListPropertySchema recordListPropertySchema = (RecordListPropertySchema)propertySchemata[i];
            nestedRecordSchema = dataSet.getNestedRecordListSchema(recordListPropertySchema.getRecordListName());
            RecordList nestedRecordList = dataSet.createNestedRecordList(recordListPropertySchema.getRecordListName());
            this.createRecord(document, dataSet, nestedRecordList, nestedRecordSchema);
            ((Record)target).setProperty(recordListPropertySchema.getName(), (Object)nestedRecordList);
        }
    }

    @Override
    public Object convertToObject(InputStream inputStream) throws ConvertException {
        return this.convertToObject(inputStream, null);
    }

    @Override
    public InputStream convertToStream(Object object) throws ConvertException {
        throw new IllegalAccessError("The convertToStream method is not supported yet.");
    }

    @Override
    public Object convert(Object object) throws ConvertException {
        if (this.convertType == 1) {
            return this.convertToStream(object);
        }
        if (this.convertType == 2) {
            return this.convertToObject((InputStream)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document parseXml(InputStream inputStream) throws ConvertException {
        Document document;
        block15: {
            DocumentBuilderFactory factory = null;
            if (this.documentBuilderFactoryClass == null) {
                factory = DocumentBuilderFactory.newInstance();
            } else {
                try {
                    factory = (DocumentBuilderFactory)Class.forName(this.documentBuilderFactoryClass, true, NimbusClassLoader.getInstance()).newInstance();
                }
                catch (InstantiationException e) {
                    throw new ConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConvertException(e);
                }
            }
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new ConvertException("XML document builder could not be instanced.", e);
            }
            document = null;
            try {
                if (this.isSynchronizedDomParse) {
                    Class<?> lock;
                    Class<?> clazz = lock = builder.getClass();
                    synchronized (clazz) {
                        document = builder.parse(inputStream);
                        break block15;
                    }
                }
                document = builder.parse(inputStream);
            }
            catch (SAXException e) {
                throw new ConvertException("The XML could not be parsed.", e);
            }
            catch (IOException e) {
                throw new ConvertException("The XML could not be parsed.", e);
            }
        }
        return document;
    }

    protected void validateXml(Document document) throws ConvertException {
    }
}

